/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-02-17 11:54:40 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1227 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=5538 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2766 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `data` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=19972 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=35148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=3264 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=1669 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1211 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1669 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1897 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `idx_date_paid_status_parent` (`date_paid`,`status`,`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`),
  KEY `idx_user_email` (`user_email`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=MyISAM AUTO_INCREMENT=312 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("779", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-26 12:03:31", "2023-05-26 12:03:31", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685102611;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685102611;}", "5", "1", "2023-05-26 12:03:44", "2023-05-26 15:33:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1171", "woocommerce_cleanup_draft_orders", "complete", "2026-02-01 23:40:00", "2026-02-02 03:10:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769989200;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769989200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-02 04:25:18", "2026-02-02 07:55:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1170", "woocommerce_cleanup_draft_orders", "complete", "2026-01-31 23:09:35", "2026-02-01 02:39:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769900975;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769900975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-01-31 23:40:00", "2026-02-01 03:10:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1169", "woocommerce_cleanup_draft_orders", "complete", "2026-01-30 12:51:31", "2026-01-30 16:21:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769777491;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769777491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-01-30 23:09:35", "2026-01-31 02:39:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1172", "woocommerce_cleanup_draft_orders", "complete", "2026-02-03 04:25:18", "2026-02-03 07:55:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770092718;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770092718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-03 04:29:35", "2026-02-03 07:59:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1173", "woocommerce_cleanup_draft_orders", "complete", "2026-02-04 04:29:35", "2026-02-04 07:59:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770179375;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770179375;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-04 11:10:14", "2026-02-04 14:40:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1177", "woocommerce_cleanup_draft_orders", "complete", "2026-02-11 17:14:59", "2026-02-11 20:44:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770830099;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770830099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-11 20:27:03", "2026-02-11 23:57:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1174", "woocommerce_cleanup_draft_orders", "complete", "2026-02-05 11:10:14", "2026-02-05 14:40:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770289814;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770289814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-05 13:02:10", "2026-02-05 16:32:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1176", "woocommerce_cleanup_draft_orders", "complete", "2026-02-07 14:20:47", "2026-02-07 17:50:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770474047;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770474047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-10 17:14:58", "2026-02-10 20:44:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1175", "woocommerce_cleanup_draft_orders", "complete", "2026-02-06 13:02:10", "2026-02-06 16:32:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770382930;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770382930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-06 14:20:47", "2026-02-06 17:50:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1178", "woocommerce_cleanup_draft_orders", "complete", "2026-02-12 20:27:03", "2026-02-12 23:57:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770928023;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770928023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-13 01:49:46", "2026-02-13 05:19:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1168", "woocommerce_cleanup_draft_orders", "complete", "2026-01-29 09:39:40", "2026-01-29 13:09:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769679580;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769679580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-01-29 12:51:31", "2026-01-29 16:21:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1167", "woocommerce_cleanup_draft_orders", "complete", "2026-01-09 11:37:23", "2026-01-09 15:07:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767958643;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767958643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-01-28 09:39:40", "2026-01-28 13:09:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1179", "woocommerce_cleanup_draft_orders", "complete", "2026-02-14 01:49:47", "2026-02-14 05:19:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771033787;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771033787;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-14 06:00:29", "2026-02-14 09:30:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1180", "woocommerce_cleanup_draft_orders", "complete", "2026-02-15 06:00:29", "2026-02-15 09:30:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771135229;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771135229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-15 16:49:57", "2026-02-15 20:19:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1181", "woocommerce_cleanup_draft_orders", "complete", "2026-02-16 16:49:57", "2026-02-16 20:19:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771260597;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771260597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-16 22:43:07", "2026-02-17 02:13:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1182", "woocommerce_cleanup_draft_orders", "pending", "2026-02-17 22:43:07", "2026-02-18 02:13:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771368187;s:18:\"\0*\0first_timestamp\";i:1685102616;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771368187;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1183", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:10", "2026-02-17 15:16:10", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328770;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1184", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:11", "2026-02-17 15:16:11", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328771;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1185", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:12", "2026-02-17 15:16:12", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328772;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328772;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1186", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:13", "2026-02-17 15:16:13", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328773;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328773;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1187", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:14", "2026-02-17 15:16:14", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328774;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328774;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1188", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:15", "2026-02-17 15:16:15", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328775;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328775;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1189", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:16", "2026-02-17 15:16:16", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328776;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1190", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:17", "2026-02-17 15:16:17", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328777;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328777;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1191", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:18", "2026-02-17 15:16:18", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328778;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328778;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1192", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:19", "2026-02-17 15:16:19", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328779;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328779;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1193", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:20", "2026-02-17 15:16:20", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328780;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328780;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1194", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:21", "2026-02-17 15:16:21", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328781;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328781;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1195", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:22", "2026-02-17 15:16:22", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328782;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328782;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1196", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:23", "2026-02-17 15:16:23", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328783;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328783;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1197", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:24", "2026-02-17 15:16:24", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328784;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328784;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1198", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:25", "2026-02-17 15:16:25", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328785;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328785;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1199", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:26", "2026-02-17 15:16:26", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328786;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328786;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1200", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:27", "2026-02-17 15:16:27", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328787;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328787;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1201", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:28", "2026-02-17 15:16:28", "{\"update_callback\":\"wc_update_1000_multisite_visibility_setting\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328788;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328788;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1202", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:29", "2026-02-17 15:16:29", "{\"update_callback\":\"wc_update_1000_remove_patterns_toolkit_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328789;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328789;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1203", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:30", "2026-02-17 15:16:30", "{\"update_callback\":\"wc_update_1020_add_old_refunded_order_items_to_product_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328790;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328790;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1204", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:31", "2026-02-17 15:16:31", "{\"update_callback\":\"wc_update_1030_add_comments_date_type_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328791;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1205", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:32", "2026-02-17 15:16:32", "{\"update_callback\":\"wc_update_1040_add_idx_date_paid_status_parent\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328792;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328792;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1206", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:33", "2026-02-17 15:16:33", "{\"update_callback\":\"wc_update_1040_cleanup_legacy_ptk_patterns_fetching\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328793;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328793;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1207", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:34", "2026-02-17 15:16:34", "{\"update_callback\":\"wc_update_1050_migrate_brand_permalink_setting\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328794;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328794;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5525", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1208", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:35", "2026-02-17 15:16:35", "{\"update_callback\":\"wc_update_1050_enable_autoload_options\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328795;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328795;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5525", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1209", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:36", "2026-02-17 15:16:36", "{\"update_callback\":\"wc_update_1050_add_idx_user_email\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328796;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328796;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5525", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1210", "woocommerce_run_update_callback", "complete", "2026-02-17 11:46:37", "2026-02-17 15:16:37", "{\"update_callback\":\"wc_update_1050_remove_deprecated_marketplace_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328797;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328797;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5525", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1211", "woocommerce_update_db_to_current_version", "complete", "2026-02-17 11:46:38", "2026-02-17 15:16:38", "{\"version\":\"10.5.1\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328798;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328798;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5525", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1212", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2026-02-17 11:46:11", "2026-02-17 15:16:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328771;}", "3", "1", "2026-02-17 11:47:20", "2026-02-17 15:17:20", "5524", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1213", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-02-17 11:48:16", "2026-02-17 15:18:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771328896;s:18:\"\0*\0first_timestamp\";i:1771328896;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771328896;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2026-02-17 11:48:17", "2026-02-17 15:18:17", "5527", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("1214", "woocommerce_scheduled_sales", "pending", "2026-02-17 21:00:00", "2026-02-18 00:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771362000;s:18:\"\0*\0first_timestamp\";i:1771362000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771362000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1215", "woocommerce_cancel_unpaid_orders", "pending", "2026-02-17 12:48:17", "2026-02-17 16:18:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771332497;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771332497;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1216", "woocommerce_cleanup_personal_data", "complete", "2026-02-17 11:48:27", "2026-02-17 15:18:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771328907;s:18:\"\0*\0first_timestamp\";i:1771328907;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771328907;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-02-17 11:49:00", "2026-02-17 15:19:00", "5531", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1217", "woocommerce_cleanup_logs", "pending", "2026-02-18 00:00:00", "2026-02-18 03:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771372800;s:18:\"\0*\0first_timestamp\";i:1771372800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771372800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1218", "woocommerce_cleanup_sessions", "pending", "2026-02-18 03:00:00", "2026-02-18 06:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771383600;s:18:\"\0*\0first_timestamp\";i:1771383600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771383600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1219", "woocommerce_geoip_updater", "pending", "2026-02-18 03:00:00", "2026-02-18 06:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771383600;s:18:\"\0*\0first_timestamp\";i:1771383600;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771383600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1220", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2026-02-18 00:00:00", "2026-02-18 03:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771372800;s:18:\"\0*\0first_timestamp\";i:1771372800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771372800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1221", "wc_admin_daily_wrapper", "complete", "2026-02-17 11:48:17", "2026-02-17 15:18:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771328897;s:18:\"\0*\0first_timestamp\";i:1771328897;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771328897;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2026-02-17 11:48:18", "2026-02-17 15:18:18", "5528", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1222", "generate_category_lookup_table_wrapper", "complete", "2026-02-17 11:48:27", "2026-02-17 15:18:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771328907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771328907;}", "8", "1", "2026-02-17 11:49:00", "2026-02-17 15:19:00", "5531", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1223", "woocommerce_refresh_order_count_cache", "pending", "2026-02-17 23:48:17", "2026-02-18 03:18:17", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771372097;s:18:\"\0*\0first_timestamp\";i:1771372097;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771372097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1224", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2026-02-18 11:48:17", "2026-02-18 15:18:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771415297;s:18:\"\0*\0first_timestamp\";i:1771328896;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771415297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("1225", "wc_admin_daily_wrapper", "pending", "2026-02-18 11:48:18", "2026-02-18 15:18:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771415298;s:18:\"\0*\0first_timestamp\";i:1771328897;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771415298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1226", "woocommerce_cleanup_personal_data", "pending", "2026-02-18 11:49:00", "2026-02-18 15:19:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771415340;s:18:\"\0*\0first_timestamp\";i:1771328907;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771415340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "woocommerce");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "count");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1442", "779", "ایجاد فعالیت", "2023-05-26 12:03:31", "2023-05-26 12:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1444", "779", "عملیات توسط Async Request شروع شد", "2023-05-26 12:03:44", "2023-05-26 12:03:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1445", "779", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-26 12:03:44", "2023-05-26 12:03:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2624", "1172", "عملیات توسط WP Cron شروع شد", "2026-02-03 04:29:35", "2026-02-03 07:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2626", "1173", "ایجاد فعالیت", "2026-02-03 04:29:35", "2026-02-03 07:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2638", "1177", "ایجاد فعالیت", "2026-02-10 17:14:59", "2026-02-10 20:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2625", "1172", "عملیات توسط WP Cron کامل شد", "2026-02-03 04:29:35", "2026-02-03 07:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2614", "1169", "ایجاد فعالیت", "2026-01-29 12:51:31", "2026-01-29 16:21:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2619", "1170", "عملیات توسط WP Cron کامل شد", "2026-01-31 23:40:00", "2026-02-01 03:10:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2620", "1171", "ایجاد فعالیت", "2026-01-31 23:40:00", "2026-02-01 03:10:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2615", "1169", "عملیات توسط WP Cron شروع شد", "2026-01-30 23:09:35", "2026-01-31 02:39:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2618", "1170", "عملیات توسط WP Cron شروع شد", "2026-01-31 23:39:59", "2026-02-01 03:09:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2616", "1169", "عملیات توسط WP Cron کامل شد", "2026-01-30 23:09:35", "2026-01-31 02:39:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2617", "1170", "ایجاد فعالیت", "2026-01-30 23:09:36", "2026-01-31 02:39:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2611", "1168", "ایجاد فعالیت", "2026-01-28 09:39:40", "2026-01-28 13:09:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2609", "1167", "عملیات توسط WP Cron شروع شد", "2026-01-28 09:39:40", "2026-01-28 13:09:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2610", "1167", "عملیات توسط WP Cron کامل شد", "2026-01-28 09:39:40", "2026-01-28 13:09:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2641", "1178", "ایجاد فعالیت", "2026-02-11 20:27:03", "2026-02-11 23:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2612", "1168", "عملیات توسط WP Cron شروع شد", "2026-01-29 12:51:31", "2026-01-29 16:21:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2613", "1168", "عملیات توسط WP Cron کامل شد", "2026-01-29 12:51:31", "2026-01-29 16:21:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2629", "1174", "ایجاد فعالیت", "2026-02-04 11:10:14", "2026-02-04 14:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2628", "1173", "عملیات توسط WP Cron کامل شد", "2026-02-04 11:10:14", "2026-02-04 14:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2630", "1174", "عملیات توسط WP Cron شروع شد", "2026-02-05 13:02:10", "2026-02-05 16:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2631", "1174", "عملیات توسط WP Cron کامل شد", "2026-02-05 13:02:10", "2026-02-05 16:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2635", "1176", "ایجاد فعالیت", "2026-02-06 14:20:47", "2026-02-06 17:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2632", "1175", "ایجاد فعالیت", "2026-02-05 13:02:10", "2026-02-05 16:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2621", "1171", "عملیات توسط WP Cron شروع شد", "2026-02-02 04:25:18", "2026-02-02 07:55:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2622", "1171", "عملیات توسط WP Cron کامل شد", "2026-02-02 04:25:18", "2026-02-02 07:55:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2623", "1172", "ایجاد فعالیت", "2026-02-02 04:25:18", "2026-02-02 07:55:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2637", "1176", "عملیات توسط WP Cron کامل شد", "2026-02-10 17:14:58", "2026-02-10 20:44:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2627", "1173", "عملیات توسط WP Cron شروع شد", "2026-02-04 11:10:14", "2026-02-04 14:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2633", "1175", "عملیات توسط WP Cron شروع شد", "2026-02-06 14:20:47", "2026-02-06 17:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2634", "1175", "عملیات توسط WP Cron کامل شد", "2026-02-06 14:20:47", "2026-02-06 17:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2608", "1167", "ایجاد فعالیت", "2026-01-08 11:37:23", "2026-01-08 15:07:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2640", "1177", "عملیات توسط WP Cron کامل شد", "2026-02-11 20:27:03", "2026-02-11 23:57:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2639", "1177", "عملیات توسط WP Cron شروع شد", "2026-02-11 20:27:02", "2026-02-11 23:57:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2636", "1176", "عملیات توسط WP Cron شروع شد", "2026-02-10 17:14:58", "2026-02-10 20:44:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2642", "1178", "عملیات توسط WP Cron شروع شد", "2026-02-13 01:49:46", "2026-02-13 05:19:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2643", "1178", "عملیات توسط WP Cron کامل شد", "2026-02-13 01:49:46", "2026-02-13 05:19:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2644", "1179", "ایجاد فعالیت", "2026-02-13 01:49:47", "2026-02-13 05:19:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2645", "1179", "عملیات توسط WP Cron شروع شد", "2026-02-14 06:00:29", "2026-02-14 09:30:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2646", "1179", "عملیات توسط WP Cron کامل شد", "2026-02-14 06:00:29", "2026-02-14 09:30:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2647", "1180", "ایجاد فعالیت", "2026-02-14 06:00:29", "2026-02-14 09:30:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2648", "1180", "عملیات توسط WP Cron شروع شد", "2026-02-15 16:49:57", "2026-02-15 20:19:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2649", "1180", "عملیات توسط WP Cron کامل شد", "2026-02-15 16:49:57", "2026-02-15 20:19:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2650", "1181", "ایجاد فعالیت", "2026-02-15 16:49:57", "2026-02-15 20:19:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2651", "1181", "عملیات توسط WP Cron شروع شد", "2026-02-16 22:43:07", "2026-02-17 02:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2652", "1181", "عملیات توسط WP Cron کامل شد", "2026-02-16 22:43:07", "2026-02-17 02:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2653", "1182", "ایجاد فعالیت", "2026-02-16 22:43:07", "2026-02-17 02:13:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2654", "1183", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2655", "1184", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2656", "1185", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2657", "1186", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2658", "1187", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2659", "1188", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2660", "1189", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2661", "1190", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2662", "1191", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2663", "1192", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2664", "1193", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2665", "1194", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2666", "1195", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2667", "1196", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2668", "1197", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2669", "1198", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2670", "1199", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2671", "1200", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2672", "1201", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2673", "1202", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2674", "1203", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2675", "1204", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2676", "1205", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2677", "1206", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2678", "1207", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2679", "1208", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2680", "1209", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2681", "1210", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2682", "1211", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2683", "1212", "ایجاد فعالیت", "2026-02-17 11:46:10", "2026-02-17 15:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2684", "1183", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:19", "2026-02-17 15:17:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2685", "1183", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2686", "1184", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2687", "1184", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2688", "1212", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2689", "1212", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2690", "1185", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2691", "1185", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2692", "1186", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2693", "1186", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2694", "1187", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2695", "1187", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2696", "1188", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2697", "1188", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2698", "1189", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2699", "1189", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2700", "1190", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2701", "1190", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2702", "1191", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2703", "1191", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2704", "1192", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2705", "1192", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2706", "1193", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2707", "1193", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2708", "1194", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2709", "1194", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2710", "1195", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2711", "1195", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2712", "1196", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2713", "1196", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2714", "1197", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2715", "1197", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2716", "1198", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2717", "1198", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2718", "1199", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2719", "1199", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2720", "1200", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2721", "1200", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2722", "1201", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2723", "1201", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2724", "1202", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2725", "1202", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2726", "1203", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2727", "1203", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2728", "1204", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2729", "1204", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2730", "1205", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2731", "1205", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2732", "1206", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2733", "1206", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2734", "1207", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2735", "1207", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2736", "1208", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2737", "1208", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2738", "1209", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2739", "1209", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2740", "1210", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2741", "1210", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2742", "1211", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2743", "1211", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:47:20", "2026-02-17 15:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2744", "1213", "ایجاد فعالیت", "2026-02-17 11:48:16", "2026-02-17 15:18:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2745", "1213", "عملیات توسط Async Request شروع شد", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2746", "1214", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2747", "1215", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2748", "1216", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2749", "1217", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2750", "1218", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2751", "1219", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2752", "1220", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2753", "1221", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2754", "1222", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2755", "1223", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2756", "1213", "عملیات توسط Async Request کامل شد", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2757", "1224", "ایجاد فعالیت", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2758", "1221", "عملیات توسط Async Request شروع شد", "2026-02-17 11:48:17", "2026-02-17 15:18:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2759", "1221", "عملیات توسط Async Request کامل شد", "2026-02-17 11:48:18", "2026-02-17 15:18:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2760", "1225", "ایجاد فعالیت", "2026-02-17 11:48:18", "2026-02-17 15:18:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2761", "1216", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:48:59", "2026-02-17 15:18:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2762", "1216", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:49:00", "2026-02-17 15:19:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2763", "1226", "ایجاد فعالیت", "2026-02-17 11:49:00", "2026-02-17 15:19:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2764", "1222", "عملیات توسط WP Cron شروع شد", "2026-02-17 11:49:00", "2026-02-17 15:19:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2765", "1222", "عملیات توسط WP Cron کامل شد", "2026-02-17 11:49:00", "2026-02-17 15:19:00");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "یک نویسندهٔ دیدگاه در وردپرس", "wapuu@wordpress.example", "https://wordpress.org/", "", "2022-03-15 20:51:32", "2022-03-15 17:21:32", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "site_moving_xtra_56_toswpir", "684ddb98a815f9b82866_20260217115419", "20", "2026-02-17 11:54:40", "toswp", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-02-17 11:54:19\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.9.1\";s:9:\"VersionDB\";s:7:\"11.4.10\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:27:\"site_moving_xtra_56_toswpir\";s:4:\"Hash\";s:35:\"684ddb98a815f9b82866_20260217115419\";s:8:\"NameHash\";s:63:\"site_moving_xtra_56_toswpir_684ddb98a815f9b82866_20260217115419\";s:4:\"Type\";i:0;s:5:\"Notes\";s:62:\"toswp.ir\r\nسایت آماده المنتوری اثاث کشی\";s:8:\"ScanFile\";s:73:\"site_moving_xtra_56_toswpir_684ddb98a815f9b82866_20260217115419_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:5:\"toswp\";s:7:\"Archive\";O:11:\"DUP_Archive\":27:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:75:\"site_moving_xtra_56_toswpir_684ddb98a815f9b82866_20260217115419_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"/home/toswpir/xtra-moving.tooswp.ir\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2849;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:18002;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":7:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-02-17 11:54:19\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.9.1\";s:9:\"VersionDB\";s:7:\"11.4.10\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:27:\"site_moving_xtra_56_toswpir\";s:4:\"Hash\";s:35:\"684ddb98a815f9b82866_20260217115419\";s:8:\"NameHash\";s:63:\"site_moving_xtra_56_toswpir_684ddb98a815f9b82866_20260217115419\";s:4:\"Type\";i:0;s:5:\"Notes\";s:62:\"toswp.ir\r\nسایت آماده المنتوری اثاث کشی\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:81:\"site_moving_xtra_56_toswpir_684ddb98a815f9b82866_20260217115419_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:66;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:49:\"/home/toswpir/xtra-moving.tooswp.ir/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:76:\"site_moving_xtra_56_toswpir_684ddb98a815f9b82866_20260217115419_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:144:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content/backups-dup-lite/tmp/site_moving_xtra_56_toswpir_684ddb98a815f9b82866_20260217115419_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:66;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:44:\"/home/toswpir/xtra-moving.tooswp.ir/wp-admin\";i:1;s:47:\"/home/toswpir/xtra-moving.tooswp.ir/wp-includes\";i:2;s:56:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:35:\"/home/toswpir/xtra-moving.tooswp.ir\";i:1;s:35:\"/home/toswpir/xtra-moving.tooswp.ir\";i:2;s:46:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content\";i:3;s:54:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content/uploads\";i:4;s:54:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content/plugins\";i:5;s:57:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content/mu-plugins\";i:6;s:53:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:3:{i:0;s:67:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";i:2;s:18:\"duplicator-backups\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;s:38:\"\0DUP_Archive\0wpContentDirNormalizePath\";N;}s:9:\"Installer\";r:87;s:8:\"Database\";r:106;s:13:\"BuildProgress\";r:145;}");

/* INSERT TABLE DATA: wp_duplicator_pro_entities */
INSERT INTO `wp_duplicator_pro_entities` VALUES("1", "DUP_PRO_Global_Entity", "{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"uninstall_tables\": true,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/xtra-moving.tooswp.ir\\/wp-admin\\/admin-ajax.php\",\n    \"server_kick_off_sslverify\": true,\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"cron_parser_lib\": \"csd-parser\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"gdrive_transfer_mode\": 0,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1648581835,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": true,\n    \"lkp\": \"\",\n    \"license_limit\": 800,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1705715968,\n    \"initial_activation_timestamp\": 1647365468,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"trace_profiler_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"import_custom_path\": \"\",\n    \"notices\": {\n        \"dupArchiveSwitch\": false\n    }\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("2", "DUP_PRO_Secure_Global_Entity", "{\n    \"basic_auth_password\": null,\n    \"lkp\": \"\",\n    \"type\": \"DUP_PRO_Secure_Global_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("3", "DUP_PRO_System_Global_Entity", "{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1705733669,\n    \"type\": \"DUP_PRO_System_Global_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("4", "DUP_PRO_Package_Template_Entity", "{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"type\": \"DUP_PRO_Package_Template_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("5", "DUP_PRO_Package_Template_Entity", "{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"TOSWP.IR\\u0633\\u0627\\u06cc\\u062a \\u0622\\u0645\\u0627\\u062f\\u0647 \\u0627\\u062b\\u0627\\u062b \\u06a9\\u0634\\u06cc\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"type\": \"DUP_PRO_Package_Template_Entity\"\n}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://xtra-moving.tooswp.ir", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://xtra-moving.tooswp.ir", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "سایت آماده المنتوری اثاث کشی | توس وردپرس", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "aref.dariavi@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "4", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:308:{s:11:\"projects/?$\";s:29:\"index.php?post_type=portfolio\";s:41:\"projects/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:36:\"projects/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:28:\"projects/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:53:\"projects/cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_cat=$matches[1]&feed=$matches[2]\";s:48:\"projects/cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_cat=$matches[1]&feed=$matches[2]\";s:29:\"projects/cat/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_cat=$matches[1]&embed=true\";s:41:\"projects/cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_cat=$matches[1]&paged=$matches[2]\";s:23:\"projects/cat/([^/]+)/?$\";s:35:\"index.php?portfolio_cat=$matches[1]\";s:54:\"projects/tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:49:\"projects/tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:30:\"projects/tags/([^/]+)/embed/?$\";s:47:\"index.php?portfolio_tags=$matches[1]&embed=true\";s:42:\"projects/tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:24:\"projects/tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:36:\"projects/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"projects/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"projects/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"projects/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"projects/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"projects/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"projects/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:29:\"projects/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:49:\"projects/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:44:\"projects/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:37:\"projects/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:44:\"projects/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:45:\"projects/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"projects/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:51:\"projects/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"projects/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"projects/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"projects/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:33:\"projects/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:25:\"projects/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"projects/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"projects/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"projects/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"projects/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"projects/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"elementor_component/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"elementor_component/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"elementor_component/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"elementor_component/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"elementor_component/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"elementor_component/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"elementor_component/([^/]+)/embed/?$\";s:52:\"index.php?elementor_component=$matches[1]&embed=true\";s:40:\"elementor_component/([^/]+)/trackback/?$\";s:46:\"index.php?elementor_component=$matches[1]&tb=1\";s:48:\"elementor_component/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementor_component=$matches[1]&paged=$matches[2]\";s:55:\"elementor_component/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementor_component=$matches[1]&cpage=$matches[2]\";s:56:\"elementor_component/([^/]+)/wc/file/transient(/(.*))?/?$\";s:71:\"index.php?elementor_component=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"elementor_component/([^/]+)/wc-api(/(.*))?/?$\";s:60:\"index.php?elementor_component=$matches[1]&wc-api=$matches[3]\";s:62:\"elementor_component/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:73:\"elementor_component/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:51:\"elementor_component/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:62:\"elementor_component/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:44:\"elementor_component/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementor_component=$matches[1]&page=$matches[2]\";s:36:\"elementor_component/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"elementor_component/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"elementor_component/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"elementor_component/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"elementor_component/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"elementor_component/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"product-size-guide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"product-size-guide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"product-size-guide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"product-size-guide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"product-size-guide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"product-size-guide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"product-size-guide/([^/]+)/embed/?$\";s:50:\"index.php?codevz_size_guide=$matches[1]&embed=true\";s:39:\"product-size-guide/([^/]+)/trackback/?$\";s:44:\"index.php?codevz_size_guide=$matches[1]&tb=1\";s:47:\"product-size-guide/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?codevz_size_guide=$matches[1]&paged=$matches[2]\";s:54:\"product-size-guide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?codevz_size_guide=$matches[1]&cpage=$matches[2]\";s:55:\"product-size-guide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:69:\"index.php?codevz_size_guide=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"product-size-guide/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?codevz_size_guide=$matches[1]&wc-api=$matches[3]\";s:61:\"product-size-guide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"product-size-guide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"product-size-guide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"product-size-guide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"product-size-guide/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?codevz_size_guide=$matches[1]&page=$matches[2]\";s:35:\"product-size-guide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product-size-guide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product-size-guide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product-size-guide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product-size-guide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product-size-guide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"product-faq/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"product-faq/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"product-faq/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"product-faq/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"product-faq/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"product-faq/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"product-faq/([^/]+)/embed/?$\";s:43:\"index.php?codevz_faq=$matches[1]&embed=true\";s:32:\"product-faq/([^/]+)/trackback/?$\";s:37:\"index.php?codevz_faq=$matches[1]&tb=1\";s:40:\"product-faq/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?codevz_faq=$matches[1]&paged=$matches[2]\";s:47:\"product-faq/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?codevz_faq=$matches[1]&cpage=$matches[2]\";s:48:\"product-faq/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?codevz_faq=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"product-faq/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?codevz_faq=$matches[1]&wc-api=$matches[3]\";s:54:\"product-faq/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"product-faq/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"product-faq/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"product-faq/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"product-faq/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?codevz_faq=$matches[1]&page=$matches[2]\";s:28:\"product-faq/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"product-faq/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"product-faq/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"product-faq/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"product-faq/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"product-faq/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"product-brand/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?codevz_brands=$matches[1]&feed=$matches[2]\";s:49:\"product-brand/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?codevz_brands=$matches[1]&feed=$matches[2]\";s:30:\"product-brand/([^/]+)/embed/?$\";s:46:\"index.php?codevz_brands=$matches[1]&embed=true\";s:42:\"product-brand/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?codevz_brands=$matches[1]&paged=$matches[2]\";s:24:\"product-brand/([^/]+)/?$\";s:35:\"index.php?codevz_brands=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=907&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:73:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc/file/transient(/(.*))?/?$\";s:110:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc/file/transient=$matches[6]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:84:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:27:\"(.?.+?)/tracking(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&tracking=$matches[3]\";s:27:\"(.?.+?)/wishlist(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&wishlist=$matches[3]\";s:25:\"(.?.+?)/viewed(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&viewed=$matches[3]\";s:26:\"(.?.+?)/reviews(/(.*))?/?$\";s:50:\"index.php?pagename=$matches[1]&reviews=$matches[3]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:7:{i:0;s:27:\"codevz-plus/codevz-plus.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:23:\"elementor/elementor.php\";i:4;s:23:\"revslider/revslider.php\";i:5;s:27:\"woocommerce/woocommerce.php\";i:6;s:29:\"wp-parsidate/wp-parsidate.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "xtra", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "xtra-child", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "60717", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:15:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:4;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:5;a:8:{s:5:\"title\";s:10:\"Categories\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:6;a:9:{s:5:\"title\";s:0:\"\";s:5:\"count\";s:2:\"on\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:7;a:11:{s:5:\"title\";s:22:\"دسته بندی ها\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:8;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:9;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:10;a:9:{s:5:\"title\";s:0:\"\";s:5:\"count\";s:2:\"on\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:11;a:11:{s:5:\"title\";s:22:\"دسته بندی ها\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:12;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:13;a:11:{s:5:\"title\";s:22:\"دسته بندی ها\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:14;a:9:{s:5:\"title\";s:0:\"\";s:5:\"count\";s:2:\"on\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:15;a:6:{s:5:\"title\";s:22:\"دسته بندی ها\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:15:{i:1;a:10:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:6:\"<hr />\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:65:\"text-align:center;width:600px;margin-right:auto;margin-left:auto;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:2;a:10:{s:5:\"title\";s:7:\"CONTACT\";s:4:\"text\";s:39:\"info@xtraflower.com\r\n+1 (800) 345 - 678\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:16:\"margin-top:60px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:3;a:10:{s:5:\"title\";s:7:\"ADDRESS\";s:4:\"text\";s:38:\"1079 Terry Lane,\r\nWinter Park, Florida\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:16:\"margin-top:30px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:4;a:10:{s:5:\"title\";s:13:\"WORKING HOURS\";s:4:\"text\";s:30:\"Mon-Fri 9 ~ 18\r\nSat-Sun 10~ 20\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:16:\"margin-top:30px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:5;a:10:{s:5:\"title\";s:18:\"تماس با ما\";s:4:\"text\";s:38:\"info@xtraflower.ir\r\n22 33 44 55 21 98+\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:16:\"margin-top:60px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:6;a:10:{s:5:\"title\";s:8:\"آدرس\";s:4:\"text\";s:61:\"تهران، اتوبان ستاری\r\nباغ گل و گیاه\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:16:\"margin-top:30px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:7;a:10:{s:5:\"title\";s:17:\"ساعت کاری\";s:4:\"text\";s:70:\"شنبه-چهارشنبه ۸ ~ ۲۰\r\nپنجشنبه-جمعه ۸ ~ ۱۸\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:16:\"margin-top:30px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:8;a:11:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:425:\"<img class=\"alignnone wp-image-888 size-medium\" src=\"http://xtratheme.ir/wp-content/uploads/2018/07/logon2-300x95.png\" alt=\"\" width=\"300\" height=\"95\" />\r\n\r\nHome automation or domotics is building automation for a home, called a smart home or smart house.\r\n<ul>\r\n 	<li>Tel: <strong>+1 (800) 3456789</strong></li>\r\n 	<li>Fax: <strong>+1 (800) 3456789</strong></li>\r\n 	<li>Email: <strong>info@xtra-theme.com</strong></li>\r\n</ul>\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:36:\"margin-bottom:0px;border-style:none;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:9;a:11:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:15:\"Copyright 2018.\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:18:\"border-style:none;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:10;a:9:{s:5:\"title\";s:14:\"Business Hours\";s:4:\"text\";s:160:\"Our support available to help you <span style=\"color: #dc4c46;\">24 hours</span> a day, seven days a week, <span style=\"color: #dc4c46;\">365 days</span> in year.\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:4:\"czsk\";s:37:\"padding-bottom:0px;margin-bottom:0px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:11;a:9:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"text\";s:339:\"یک شرکت هر موجودیتی است که به تجارت مشغول است. شرکت ها را می توان به روش های مختلف ساخت. به عنوان مثال ، شرکت شما می تواند یک مالکیت شخصی ، مشارکت یا یک شرکت باشد.\r\n<h3 style=\"color: #fff;\">021123456789</h3>\r\n&nbsp;\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:12;a:9:{s:5:\"title\";s:19:\"ساعات کاری\";s:4:\"text\";s:206:\"پیشتیبانی آنلاین ما همیشه در <span style=\"color: #dc4c46;\">۲۴ ساعت</span> در روز، هفت روز هفته و <span style=\"color: #dc4c46;\">۳۶۵ روز</span>در سال.\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:4:\"czsk\";s:37:\"padding-bottom:0px;margin-bottom:0px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:13;a:11:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:435:\"<img class=\"alignnone wp-image-888 size-medium\" src=\"https://xtra-moving.tooswp.ir/wp-content/uploads/2018/07/logon2-300x95.png\" alt=\"\" width=\"300\" height=\"95\" />\r\n\r\nHome automation or domotics is building automation for a home, called a smart home or smart house.\r\n<ul>\r\n 	<li>Tel: <strong>+1 (800) 3456789</strong></li>\r\n 	<li>Fax: <strong>+1 (800) 3456789</strong></li>\r\n 	<li>Email: <strong>info@xtra-theme.com</strong></li>\r\n</ul>\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:36:\"margin-bottom:0px;border-style:none;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:14;a:11:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:15:\"Copyright 2018.\";s:6:\"filter\";s:2:\"on\";s:6:\"visual\";s:2:\"on\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:18:\"border-style:none;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:33:\"duplicator-pro/duplicator-pro.php\";a:2:{i:0;s:24:\"Duplicator\\Core\\Unistall\";i:1;s:8:\"unistall\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "58", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "907", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "admin_email_lifespan", "1786880937", "yes");
INSERT INTO `wp_options` VALUES("94", "initial_db_version", "45805", "yes");
INSERT INTO `wp_options` VALUES("95", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("96", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("97", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_search", "a:23:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:6:{s:5:\"title\";s:0:\"\";s:4:\"czsk\";s:17:\"padding-top:50px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:5;a:1:{s:5:\"title\";s:0:\"\";}i:6;a:1:{s:5:\"title\";s:0:\"\";}i:7;a:8:{s:5:\"title\";s:0:\"\";s:11:\"czsk_button\";s:107:\"font-size:14px;color:#ffffff;font-weight:400;background-color:#7f44c9;padding-right:20px;padding-left:20px;\";s:17:\"czsk_button_hover\";s:39:\"color:#7f44c9;background-color:#ffffff;\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:8;a:6:{s:5:\"title\";s:0:\"\";s:4:\"czsk\";s:17:\"padding-top:50px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:9;a:1:{s:5:\"title\";s:0:\"\";}i:10;a:8:{s:5:\"title\";s:0:\"\";s:11:\"czsk_button\";s:25:\"background-color:#372e29;\";s:17:\"czsk_button_hover\";s:39:\"color:#372e29;background-color:#ffffff;\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:11;a:8:{s:5:\"title\";s:0:\"\";s:11:\"czsk_button\";s:70:\"font-size:13px;color:#e5deda;font-weight:600;background-color:#2c313a;\";s:17:\"czsk_button_hover\";s:39:\"color:#2c313a;background-color:#e5deda;\";s:4:\"czsk\";s:60:\"background-color:transparent;padding:0px;margin-bottom:30px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:12;a:8:{s:5:\"title\";s:0:\"\";s:11:\"czsk_button\";s:0:\"\";s:17:\"czsk_button_hover\";s:25:\"background-color:#5cbe2d;\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:36:\"margin-top:-20px;border-radius:10px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:13;a:7:{s:5:\"title\";s:0:\"\";s:11:\"czsk_button\";s:76:\"color:#243344;background-color:#f4c03b;padding-top:18px;padding-bottom:18px;\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:14;a:1:{s:5:\"title\";s:0:\"\";}i:15;a:1:{s:5:\"title\";s:0:\"\";}i:16;a:1:{s:5:\"title\";s:0:\"\";}i:17;a:1:{s:5:\"title\";s:0:\"\";}i:18;a:1:{s:5:\"title\";s:0:\"\";}i:19;a:1:{s:5:\"title\";s:0:\"\";}i:20;a:1:{s:5:\"title\";s:0:\"\";}i:21;a:1:{s:5:\"title\";s:0:\"\";}i:22;a:1:{s:5:\"title\";s:0:\"\";}i:23;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_archives", "a:3:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:213:{i:0;s:10:\"calendar-2\";i:1;s:10:\"archives-2\";i:2;s:10:\"archives-3\";i:3;s:6:\"meta-2\";i:4;s:8:\"search-2\";i:5;s:8:\"search-3\";i:6;s:8:\"search-4\";i:7;s:8:\"search-5\";i:8;s:8:\"search-6\";i:9;s:8:\"search-7\";i:10;s:8:\"search-8\";i:11;s:8:\"search-9\";i:12;s:9:\"search-10\";i:13;s:9:\"search-11\";i:14;s:9:\"search-12\";i:15;s:9:\"search-13\";i:16;s:9:\"search-14\";i:17;s:9:\"search-15\";i:18;s:9:\"search-16\";i:19;s:9:\"search-17\";i:20;s:9:\"search-18\";i:21;s:9:\"search-19\";i:22;s:9:\"search-20\";i:23;s:9:\"search-21\";i:24;s:9:\"search-22\";i:25;s:6:\"text-2\";i:26;s:6:\"text-3\";i:27;s:6:\"text-4\";i:28;s:6:\"text-5\";i:29;s:6:\"text-6\";i:30;s:6:\"text-7\";i:31;s:6:\"text-8\";i:32;s:6:\"text-9\";i:33;s:7:\"text-10\";i:34;s:7:\"text-11\";i:35;s:7:\"text-12\";i:36;s:7:\"text-13\";i:37;s:7:\"text-14\";i:38;s:12:\"categories-2\";i:39;s:12:\"categories-3\";i:40;s:12:\"categories-4\";i:41;s:12:\"categories-5\";i:42;s:12:\"categories-6\";i:43;s:12:\"categories-7\";i:44;s:12:\"categories-8\";i:45;s:12:\"categories-9\";i:46;s:13:\"categories-10\";i:47;s:13:\"categories-11\";i:48;s:13:\"categories-12\";i:49;s:13:\"categories-13\";i:50;s:13:\"categories-14\";i:51;s:13:\"categories-15\";i:52;s:14:\"recent-posts-2\";i:53;s:17:\"recent-comments-2\";i:54;s:11:\"tag_cloud-2\";i:55;s:11:\"tag_cloud-3\";i:56;s:11:\"tag_cloud-4\";i:57;s:11:\"tag_cloud-5\";i:58;s:11:\"tag_cloud-6\";i:59;s:11:\"tag_cloud-7\";i:60;s:11:\"tag_cloud-8\";i:61;s:11:\"tag_cloud-9\";i:62;s:12:\"tag_cloud-10\";i:63;s:12:\"tag_cloud-11\";i:64;s:22:\"codevz_working_hours-2\";i:65;s:21:\"codevz_stylish_list-2\";i:66;s:21:\"codevz_stylish_list-3\";i:67;s:21:\"codevz_stylish_list-4\";i:68;s:21:\"codevz_stylish_list-5\";i:69;s:21:\"codevz_stylish_list-6\";i:70;s:25:\"codevz_custom_menu_list-2\";i:71;s:25:\"codevz_custom_menu_list-3\";i:72;s:25:\"codevz_custom_menu_list-4\";i:73;s:25:\"codevz_custom_menu_list-5\";i:74;s:25:\"codevz_custom_menu_list-6\";i:75;s:25:\"codevz_custom_menu_list-7\";i:76;s:25:\"codevz_custom_menu_list-8\";i:77;s:25:\"codevz_custom_menu_list-9\";i:78;s:26:\"codevz_custom_menu_list-10\";i:79;s:26:\"codevz_custom_menu_list-11\";i:80;s:26:\"codevz_custom_menu_list-12\";i:81;s:26:\"codevz_custom_menu_list-13\";i:82;s:26:\"codevz_custom_menu_list-14\";i:83;s:26:\"codevz_custom_menu_list-15\";i:84;s:26:\"codevz_custom_menu_list-16\";i:85;s:26:\"codevz_custom_menu_list-17\";i:86;s:26:\"codevz_custom_menu_list-18\";i:87;s:26:\"codevz_custom_menu_list-19\";i:88;s:14:\"codevz_about-2\";i:89;s:14:\"codevz_about-3\";i:90;s:14:\"codevz_about-4\";i:91;s:14:\"codevz_about-5\";i:92;s:14:\"codevz_about-6\";i:93;s:14:\"codevz_about-7\";i:94;s:14:\"codevz_about-8\";i:95;s:14:\"codevz_about-9\";i:96;s:15:\"codevz_about-10\";i:97;s:15:\"codevz_about-11\";i:98;s:15:\"codevz_about-12\";i:99;s:15:\"codevz_about-13\";i:100;s:15:\"codevz_about-14\";i:101;s:15:\"codevz_about-15\";i:102;s:15:\"codevz_about-16\";i:103;s:15:\"codevz_about-17\";i:104;s:15:\"codevz_about-18\";i:105;s:15:\"codevz_about-19\";i:106;s:14:\"codevzflickr-2\";i:107;s:14:\"codevzflickr-3\";i:108;s:14:\"codevzflickr-4\";i:109;s:14:\"codevzflickr-5\";i:110;s:22:\"codevzcustommenulist-2\";i:111;s:22:\"codevzcustommenulist-3\";i:112;s:23:\"codevzcustommenulist2-2\";i:113;s:23:\"codevzcustommenulist2-3\";i:114;s:23:\"codevzcustommenulist2-4\";i:115;s:23:\"codevzcustommenulist2-5\";i:116;s:23:\"codevzcustommenulist2-6\";i:117;s:23:\"codevzcustommenulist2-7\";i:118;s:23:\"codevzcustommenulist2-8\";i:119;s:23:\"codevzcustommenulist2-9\";i:120;s:24:\"codevzcustommenulist2-10\";i:121;s:24:\"codevzcustommenulist2-11\";i:122;s:24:\"codevzcustommenulist2-12\";i:123;s:24:\"codevzcustommenulist2-13\";i:124;s:17:\"codevzpostslist-2\";i:125;s:17:\"codevzpostslist-3\";i:126;s:17:\"codevzpostslist-4\";i:127;s:17:\"codevzpostslist-5\";i:128;s:17:\"codevzpostslist-6\";i:129;s:17:\"codevzpostslist-7\";i:130;s:17:\"codevzpostslist-8\";i:131;s:17:\"codevzpostslist-9\";i:132;s:18:\"codevzpostslist-10\";i:133;s:17:\"codevzsimpleads-2\";i:134;s:17:\"codevzsimpleads-3\";i:135;s:17:\"codevzsimpleads-4\";i:136;s:17:\"codevzsimpleads-5\";i:137;s:17:\"codevzsimpleads-6\";i:138;s:17:\"codevzsimpleads-7\";i:139;s:17:\"codevzsimpleads-8\";i:140;s:17:\"codevzsimpleads-9\";i:141;s:18:\"codevzsimpleads-10\";i:142;s:18:\"codevzsimpleads-11\";i:143;s:17:\"codevzsubscribe-2\";i:144;s:17:\"codevzsubscribe-3\";i:145;s:17:\"codevzsubscribe-4\";i:146;s:17:\"codevzsubscribe-5\";i:147;s:17:\"codevzsubscribe-6\";i:148;s:17:\"codevzsubscribe-7\";i:149;s:17:\"codevzsubscribe-8\";i:150;s:17:\"codevzsubscribe-9\";i:151;s:18:\"codevzsubscribe-10\";i:152;s:18:\"codevzsubscribe-11\";i:153;s:18:\"codevzsubscribe-12\";i:154;s:19:\"codevzpagecontent-2\";i:155;s:17:\"codevzportfolio-2\";i:156;s:17:\"codevzportfolio-3\";i:157;s:17:\"codevzportfolio-4\";i:158;s:17:\"codevzportfolio-5\";i:159;s:17:\"codevzportfolio-6\";i:160;s:17:\"codevzportfolio-7\";i:161;s:17:\"codevzportfolio-8\";i:162;s:17:\"codevzportfolio-9\";i:163;s:25:\"woocommerce_widget_cart-2\";i:164;s:25:\"woocommerce_widget_cart-3\";i:165;s:25:\"woocommerce_widget_cart-4\";i:166;s:26:\"woocommerce_price_filter-2\";i:167;s:26:\"woocommerce_price_filter-3\";i:168;s:26:\"woocommerce_price_filter-4\";i:169;s:26:\"woocommerce_price_filter-5\";i:170;s:26:\"woocommerce_price_filter-6\";i:171;s:26:\"woocommerce_price_filter-7\";i:172;s:32:\"woocommerce_product_categories-2\";i:173;s:32:\"woocommerce_product_categories-3\";i:174;s:32:\"woocommerce_product_categories-4\";i:175;s:32:\"woocommerce_product_categories-5\";i:176;s:32:\"woocommerce_product_categories-6\";i:177;s:32:\"woocommerce_product_categories-7\";i:178;s:32:\"woocommerce_product_categories-8\";i:179;s:32:\"woocommerce_product_categories-9\";i:180;s:31:\"woocommerce_product_tag_cloud-2\";i:181;s:31:\"woocommerce_product_tag_cloud-3\";i:182;s:31:\"woocommerce_product_tag_cloud-4\";i:183;s:31:\"woocommerce_product_tag_cloud-5\";i:184;s:31:\"woocommerce_product_tag_cloud-6\";i:185;s:31:\"woocommerce_product_tag_cloud-7\";i:186;s:22:\"woocommerce_products-2\";i:187;s:22:\"woocommerce_products-3\";i:188;s:22:\"woocommerce_products-4\";i:189;s:22:\"woocommerce_products-5\";i:190;s:22:\"woocommerce_products-6\";i:191;s:22:\"woocommerce_products-7\";i:192;s:22:\"woocommerce_products-8\";i:193;s:22:\"woocommerce_products-9\";i:194;s:23:\"woocommerce_products-10\";i:195;s:23:\"woocommerce_products-11\";i:196;s:23:\"woocommerce_products-12\";i:197;s:23:\"woocommerce_products-13\";i:198;s:23:\"woocommerce_products-14\";i:199;s:23:\"woocommerce_products-15\";i:200;s:23:\"woocommerce_products-16\";i:201;s:38:\"woocommerce_recently_viewed_products-2\";i:202;s:38:\"woocommerce_recently_viewed_products-3\";i:203;s:38:\"woocommerce_recently_viewed_products-4\";i:204;s:38:\"woocommerce_recently_viewed_products-5\";i:205;s:38:\"woocommerce_recently_viewed_products-6\";i:206;s:38:\"woocommerce_recently_viewed_products-7\";i:207;s:32:\"woocommerce_top_rated_products-2\";i:208;s:32:\"woocommerce_top_rated_products-3\";i:209;s:32:\"woocommerce_top_rated_products-4\";i:210;s:27:\"woocommerce_rating_filter-2\";i:211;s:27:\"woocommerce_rating_filter-3\";i:212;s:27:\"woocommerce_rating_filter-4\";}s:7:\"primary\";a:3:{i:0;s:9:\"search-23\";i:1;s:12:\"tag_cloud-12\";i:2;s:18:\"codevzsimpleads-12\";}s:9:\"secondary\";a:0:{}s:8:\"footer-1\";a:1:{i:0;s:15:\"codevz_about-20\";}s:8:\"footer-2\";a:1:{i:0;s:15:\"codevz_about-21\";}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:8:\"footer-6\";a:0:{}s:14:\"offcanvas_area\";a:0:{}s:15:\"product-primary\";a:0:{}s:17:\"product-secondary\";a:0:{}s:17:\"portfolio-primary\";a:0:{}s:19:\"portfolio-secondary\";a:0:{}s:13:\"array_version\";i:3;}", "no");
INSERT INTO `wp_options` VALUES("104", "cron", "a:20:{i:1771329296;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1771329498;a:1:{s:30:\"wp_1_wc_regenerate_images_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:39:\"wp_1_wc_regenerate_images_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1771330163;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771330399;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771330893;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771331331;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771331337;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771343384;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771348892;a:3:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771348893;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771348897;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771348899;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771349243;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771349331;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771372096;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771398799;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771435713;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1771657974;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1771828057;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("19689", "woocommerce_feature_cart_checkout_blocks_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("19690", "_transient_timeout__woocommerce_helper_subscriptions", "1771329740", "off");
INSERT INTO `wp_options` VALUES("19691", "_transient__woocommerce_helper_subscriptions", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("19692", "_site_transient_timeout_theme_roots", "1771330640", "off");
INSERT INTO `wp_options` VALUES("19693", "_site_transient_theme_roots", "a:2:{s:10:\"xtra-child\";s:7:\"/themes\";s:4:\"xtra\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_calendar", "a:3:{i:1;a:8:{s:5:\"title\";s:10:\"تقویم\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:2;a:8:{s:5:\"title\";s:10:\"تقویم\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_tag_cloud", "a:13:{i:1;a:9:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:2;a:8:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:3;a:9:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:4;a:9:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:5;a:8:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:6;a:8:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:7;a:8:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:8;a:8:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:9;a:8:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:10;a:8:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:11;a:7:{s:5:\"title\";s:15:\"برچسب ها\";s:8:\"taxonomy\";s:8:\"post_tag\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:12;a:7:{s:5:\"title\";s:15:\"برچسب ها\";s:8:\"taxonomy\";s:8:\"post_tag\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("119", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1647365186;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:8:\"search-3\";i:1;s:10:\"archives-3\";i:2;s:12:\"categories-3\";}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "no");
INSERT INTO `wp_options` VALUES("137", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"aref.dariavi@gmail.com\";s:7:\"version\";s:5:\"6.4.7\";s:9:\"timestamp\";i:1759311180;}", "no");
INSERT INTO `wp_options` VALUES("144", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("19785", "duplicator_version_plugin", "1.5.15", "auto");
INSERT INTO `wp_options` VALUES("159", "current_theme", "Xtra Child", "yes");
INSERT INTO `wp_options` VALUES("160", "theme_mods_xtra-child", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:1668;s:9:\"secondary\";i:1242;s:6:\"footer\";i:1161;}s:18:\"custom_css_post_id\";i:-1;}", "no");
INSERT INTO `wp_options` VALUES("161", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("162", "RTL-CareUnit-PIL", "q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB", "no");
INSERT INTO `wp_options` VALUES("165", "CzXL1o5wdSsPLMlMNQrUrygpMs90TLe1BQA", "DdHHomtAAADQD7IQncVbKMEQokXbTWZE7xHl6-87v3CEqi-ZPk4obU5o-4J54XLIvX2IhAH0b2SiBvqO6ju9oKnkFrUduicq0L_akpaYbTSFC5Zcj3pEXFyb5NyTtlpW4mOfMtMz0rR7hcb845Thvksvb1i2WL4-mY45ceBC56LA2Errqy36m0mJijyoh9AlOlnupDPKBzewEap9JoIIGFGNxgA9rqBCnEWoC_MwvyM2kSVxwq2LzbPVGzp2xH5lHhMDhplgUAWdj1PcWDbyyOx3MF0fs_Dl8SFtzL0LBG8oKCHxjSRScmtaYCOF9Iw_ucAm6kT4nDOz5w9L7uEPqqrhNRUqSG-ag9MPOW0NfXPeXNPtof8sFvE53iPq3RdvpQTM-xOJdOBtuYlZEQGk2KImfPV5z5ca_xrfEmR5xTFZpmM9ZJkXPira5HVveYKdL4u-cqIBBzu3k-sPofZ8fJ8AStIPJmPtZfIhAAu6E45bwyZizLtlovi6hZX9q4s6uNdcyrb8ejVBWBnNx19POC2bj6b6ZCr_d4yvdj3MtIDiUQtG-FRfiyxfQ8Nczq2xmeydZuyXJq4TXLPitbvodFQgNbQ5drW7UxaXe-pAddRJBXC0LdnO_TIEeNkbpUKASew4dI37_f_WWXulib9qURo2zr8Fec3eXhVi1iqb-CjTKnGIoXTPKFoNyLeHQij7zaSrjp_vGYXNlEIMDYT1DBP7KPGEfecVju55JwpLVeA4OZulvFe562wuoFXevmHI5H2Kro1rNV7FND9BksDg3x8", "no");
INSERT INTO `wp_options` VALUES("166", "877a8fb02ed2490fc1f6e7c15bd1bb0fc34a996d", "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", "no");
INSERT INTO `wp_options` VALUES("167", "RTL-CareUnit-FPA", "1", "yes");
INSERT INTO `wp_options` VALUES("19675", "codevz_theme_options_migration_backup_5_5", "a:291:{s:6:\"layout\";s:5:\"right\";s:7:\"primary\";s:7:\"primary\";s:9:\"secondary\";s:9:\"secondary\";s:10:\"responsive\";b:1;s:23:\"responsive_breakpoint_2\";s:5:\"960px\";s:23:\"responsive_breakpoint_3\";s:5:\"420px\";s:11:\"description\";s:40:\"Xtra premium all purpose WordPress theme\";s:8:\"keywords\";s:110:\"xtra,unlimited,ultimate,pro,premium,wp,WordPress,site,site builder, website builder, drag and drop,all purpose\";s:8:\"lazyload\";b:1;s:17:\"remove_query_args\";b:1;s:3:\"css\";s:90:\"/* Do Not Remove This CSS */\nheader .services div.service_text {\n    white-space: nowrap\n}\";s:10:\"site_color\";s:7:\"#ffdd00\";s:14:\"site_color_sec\";s:7:\"#1c7e68\";s:5:\"boxed\";b:0;s:12:\"_css_buttons\";s:78:\"font-weight:700;background-color:#1c7e68;border-style:solid;border-radius:5px;\";s:18:\"_css_buttons_hover\";s:39:\"color:#000000;background-color:#ffdd00;\";s:12:\"_css_widgets\";s:76:\"color:#ffffff;background-color:#1c7e68;margin-bottom:25px;border-radius:5px;\";s:18:\"_css_widgets_links\";s:14:\"color:#ffffff;\";s:21:\"_css_widgets_headline\";s:167:\"font-size:16px;color:#000000;background-color:#ffdd00;padding:10px 40px;margin-right:-45px;margin-bottom:30px;margin-left:-45px;border-radius:5px;display:inline-block;\";s:19:\"_css_input_textarea\";s:51:\"color:#000000;border-style:solid;border-radius:5px;\";s:4:\"logo\";s:65:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2023/05/logo.png\";s:6:\"social\";a:3:{i:0;a:3:{s:5:\"title\";s:12:\"فیسبوک\";s:4:\"icon\";s:14:\"fa fa-facebook\";s:4:\"link\";s:1:\"#\";}i:1;a:3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:16:\"fab fa-instagram\";s:4:\"link\";s:1:\"#\";}i:2;a:3:{s:5:\"title\";s:12:\"آپارات\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}}s:15:\"social_hover_fx\";s:14:\"cz_social_fx_2\";s:19:\"social_inline_title\";b:0;s:13:\"_css_social_a\";s:132:\"font-size:18px;color:#1c7e68;background-color:rgba(255,221,0,0.04);padding:4px;margin-left:3px;border-style:solid;border-radius:5px;\";s:19:\"_css_social_a_hover\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:13:\"header_1_left\";a:1:{i:0;a:13:{s:7:\"element\";s:4:\"icon\";s:10:\"element_id\";s:13:\"header_1_left\";s:13:\"menu_location\";s:7:\"primary\";s:7:\"it_icon\";s:10:\"fa fa-bolt\";s:7:\"it_text\";s:44:\"Hello, Welcome to Xtra Construnction website\";s:5:\"sk_it\";s:29:\"font-size:14px;color:#f2f2f2;\";s:10:\"sk_it_icon\";s:14:\"color:#f2f2f2;\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:3:{s:3:\"top\";s:4:\"10px\";s:6:\"bottom\";s:4:\"10px\";s:4:\"left\";s:4:\"20px\";}}}s:14:\"header_1_right\";a:3:{i:0;a:12:{s:7:\"element\";s:4:\"icon\";s:10:\"element_id\";s:14:\"header_1_right\";s:13:\"menu_location\";s:7:\"primary\";s:7:\"it_text\";s:17:\"Free Consultation\";s:7:\"it_link\";s:6:\"#popup\";s:5:\"sk_it\";s:29:\"font-size:14px;color:#f2f2f2;\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:2:{s:3:\"top\";s:3:\"9px\";s:5:\"right\";s:4:\"25px\";}}i:1;a:9:{s:7:\"element\";s:4:\"line\";s:10:\"element_id\";s:14:\"header_1_right\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:1:{s:3:\"top\";s:4:\"10px\";}}i:2;a:9:{s:7:\"element\";s:6:\"social\";s:10:\"element_id\";s:14:\"header_1_right\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:1:{s:3:\"top\";s:4:\"11px\";}}}s:23:\"_css_container_header_1\";s:13:\"display:none;\";s:17:\"_css_row_header_1\";s:90:\"_class_shape:cz_row_shape_full_filled_left cz_row_shape_no_right;background-color:#ffdd00;\";s:20:\"_css_menu_a_header_1\";s:33:\"font-size:16px;padding: 6px  6px;\";s:26:\"_css_menu_a_hover_header_1\";s:14:\"color:#ffffff;\";s:33:\"_css_menu_a_hover_before_header_1\";s:88:\"_class_menu_fx:cz_menu_fx_fade_in;border-style:solid;border-width:0px;border-radius:4px;\";s:13:\"header_2_left\";a:1:{i:0;a:10:{s:7:\"element\";s:4:\"logo\";s:10:\"element_id\";s:13:\"header_2_left\";s:10:\"logo_width\";s:5:\"208px\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:2:{s:3:\"top\";s:4:\"42px\";s:6:\"bottom\";s:4:\"20px\";}}}s:14:\"header_2_right\";a:2:{i:0;a:19:{s:7:\"element\";s:9:\"icon_info\";s:10:\"element_id\";s:14:\"header_2_right\";s:6:\"custom\";s:24:\"Insert shortcode or HTML\";s:7:\"it_icon\";s:26:\"fa czico-081-placeholder-2\";s:7:\"it_text\";s:22:\"آدرس دفتر ما\";s:9:\"it_text_2\";s:29:\"مشهد،توس وردپرس\";s:7:\"it_link\";s:31:\"https://goo.gl/maps/oG3crkmCUcp\";s:5:\"sk_it\";s:14:\"color:#ffdd00;\";s:7:\"sk_it_2\";s:45:\"font-size:20px;color:#ffffff;font-weight:700;\";s:10:\"sk_it_icon\";s:81:\"font-size:28px;color:rgba(0,0,0,0.76);background-color:#ffdd00;border-radius:5px;\";s:16:\"sk_it_icon_hover\";s:25:\"background-color:#ffffff;\";s:11:\"search_type\";s:13:\"icon_dropdown\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:12:\"Button title\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"10px\";s:6:\"bottom\";s:4:\"28px\";s:4:\"left\";s:4:\"10px\";}}i:1;a:18:{s:7:\"element\";s:9:\"icon_info\";s:10:\"element_id\";s:14:\"header_2_right\";s:6:\"custom\";s:24:\"Insert shortcode or HTML\";s:7:\"it_icon\";s:23:\"fa czico-122-phone-call\";s:7:\"it_text\";s:19:\"شماره تماس\";s:9:\"it_text_2\";s:8:\"09350000\";s:7:\"it_link\";s:12:\"tel:09350000\";s:5:\"sk_it\";s:14:\"color:#ffdd00;\";s:7:\"sk_it_2\";s:45:\"font-size:22px;color:#ffffff;font-weight:700;\";s:10:\"sk_it_icon\";s:72:\"font-size:28px;color:#000000;background-color:#ffdd00;border-radius:5px;\";s:11:\"search_type\";s:13:\"icon_dropdown\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:12:\"Button title\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"50px\";s:6:\"bottom\";s:4:\"28px\";s:4:\"left\";s:4:\"50px\";}}}s:23:\"_css_container_header_2\";s:105:\"background-color:transparent;background-image:linear-gradient(90deg,#3f3f3f,#a1a1a1);padding-bottom:40px;\";s:20:\"_css_menu_a_header_2\";s:18:\"padding: 6px  6px;\";s:26:\"_css_menu_a_hover_header_2\";s:14:\"color:#ffffff;\";s:24:\"menus_indicator_header_2\";s:16:\"fa fa-angle-down\";s:21:\"_css_menu_ul_header_2\";s:78:\"background-color:#ffdd00;margin:1px 12px;border-style:solid;border-radius:4px;\";s:23:\"_css_menu_ul_a_header_2\";s:14:\"color:#ffffff;\";s:29:\"_css_menu_ul_a_hover_header_2\";s:14:\"color:#e2e2e2;\";s:25:\"menus_indicator2_header_2\";s:17:\"fa fa-angle-right\";s:13:\"header_3_left\";a:1:{i:0;a:9:{s:7:\"element\";s:4:\"menu\";s:10:\"element_id\";s:13:\"header_3_left\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"10px\";s:5:\"right\";s:4:\"10px\";s:6:\"bottom\";s:4:\"10px\";s:4:\"left\";s:4:\"10px\";}}}s:14:\"header_3_right\";a:2:{i:0;a:14:{s:7:\"element\";s:6:\"button\";s:10:\"element_id\";s:14:\"header_3_right\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:38:\"دریافت مشاوره رایگان\";s:8:\"btn_link\";s:141:\"https://xtra-moving.tooswp.ir/%d8%af%d8%b1%db%8c%d8%a7%d9%81%d8%aa-%d9%85%d8%b4%d8%a7%d9%88%d8%b1%d9%87-%d8%b1%d8%a7%db%8c%da%af%d8%a7%d9%86/\";s:6:\"sk_btn\";s:105:\"font-size:14px;color:#000000;font-weight:700;background-color:#ffdd00;padding:7px 25px 6px;display:block;\";s:12:\"sk_btn_hover\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"10px\";s:5:\"right\";s:4:\"10px\";s:6:\"bottom\";s:4:\"10px\";s:4:\"left\";s:4:\"10px\";}}i:1;a:12:{s:7:\"element\";s:6:\"social\";s:10:\"element_id\";s:14:\"header_3_right\";s:6:\"custom\";s:24:\"Insert shortcode or HTML\";s:7:\"it_text\";s:40:\"I am a text element and you can edit me.\";s:11:\"search_type\";s:13:\"icon_dropdown\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:12:\"Button title\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:2:{s:3:\"top\";s:4:\"10px\";s:6:\"bottom\";s:3:\"8px\";}}}s:17:\"_css_row_header_3\";s:126:\"background-color:#ffffff;margin-top:-32px;margin-bottom:-31px;border-radius:5px;box-shadow:0px 10px 60px 0px rgba(0,0,0,0.15);\";s:20:\"_css_menu_a_header_3\";s:84:\"font-size:15px;color:rgba(37,34,32,0.9);padding:6px 17px 7px;margin:0px 5px 0px 0px;\";s:26:\"_css_menu_a_hover_header_3\";s:14:\"color:#ffffff;\";s:33:\"_css_menu_a_hover_before_header_3\";s:133:\"_class_menu_fx:cz_menu_fx_fade_in;background-color:#1c7e68;width:100%;border-style:solid;border-width:0px;border-radius:5px;left:0px;\";s:24:\"menus_indicator_header_3\";s:16:\"fa fa-angle-down\";s:21:\"_css_menu_ul_header_3\";s:124:\"background-color:#ffffff;margin:1px 20px 0px;border-style:solid;border-radius:5px;box-shadow:0px 10px 60px rgba(0,0,0,0.15);\";s:23:\"_css_menu_ul_a_header_3\";s:53:\"font-size:16px;color:rgba(0,0,0,0.7);font-weight:500;\";s:29:\"_css_menu_ul_a_hover_header_3\";s:14:\"color:#000000;\";s:25:\"menus_indicator2_header_3\";s:17:\"fa fa-angle-right\";s:12:\"smart_sticky\";b:1;s:23:\"_css_container_header_5\";s:25:\"background-color:#2e2e2e;\";s:13:\"header_4_left\";a:1:{i:0;a:10:{s:7:\"element\";s:4:\"logo\";s:10:\"element_id\";s:13:\"header_4_left\";s:10:\"logo_width\";s:5:\"160px\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:2:{s:3:\"top\";s:4:\"20px\";s:6:\"bottom\";s:4:\"15px\";}}}s:14:\"header_4_right\";a:2:{i:0;a:11:{s:7:\"element\";s:4:\"menu\";s:10:\"element_id\";s:14:\"header_4_right\";s:13:\"menu_location\";s:7:\"primary\";s:9:\"menu_type\";s:20:\"offcanvas_menu_right\";s:12:\"sk_menu_icon\";s:75:\"color:#000000;background-color:#ffdd00;border-style:none;border-radius:5px;\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:3:{s:3:\"top\";s:4:\"20px\";s:5:\"right\";s:3:\"3px\";s:6:\"bottom\";s:4:\"20px\";}}i:1;a:16:{s:7:\"element\";s:4:\"icon\";s:10:\"element_id\";s:14:\"header_4_right\";s:13:\"menu_location\";s:7:\"primary\";s:9:\"menu_type\";s:20:\"offcanvas_menu_right\";s:7:\"it_icon\";s:11:\"fa fa-phone\";s:7:\"it_link\";s:12:\"tel:09350000\";s:10:\"sk_it_icon\";s:103:\"font-size:24px;color:#ffffff;background-color:#1c7e68;padding:10px;border-style:none;border-radius:5px;\";s:11:\"search_type\";s:9:\"icon_full\";s:18:\"search_placeholder\";s:10:\"Search ...\";s:15:\"sk_search_input\";s:72:\"padding-top:10px;padding-bottom:10px;margin-top:10px;border-radius:10px;\";s:11:\"ajax_search\";s:1:\"1\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"20px\";s:5:\"right\";s:3:\"6px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:3:\"8px\";}}}s:23:\"_css_container_header_4\";s:25:\"background-color:#000000;\";s:28:\"_css_menu_container_header_4\";s:60:\"background-size:cover;background-color:#1c7e68;padding:30px;\";s:20:\"_css_menu_a_header_4\";s:69:\"color:#ffffff;margin-bottom:10px;border-style:none;border-radius:5px;\";s:26:\"_css_menu_a_hover_header_4\";s:39:\"color:#000000;background-color:#ffdd00;\";s:24:\"menus_indicator_header_4\";s:16:\"fa fa-angle-down\";s:23:\"_css_menu_ul_a_header_4\";s:54:\"margin-bottom:6px;border-style:none;border-radius:5px;\";s:29:\"_css_menu_ul_a_hover_header_4\";s:39:\"color:#ffffff;background-color:#252220;\";s:25:\"menus_indicator2_header_4\";s:16:\"fa fa-angle-down\";s:10:\"page_cover\";s:5:\"title\";s:10:\"page_title\";s:1:\"6\";s:21:\"breadcrumbs_home_icon\";s:10:\"fa fa-home\";s:21:\"breadcrumbs_separator\";s:24:\"fa fa-angle-double-right\";s:15:\"_css_page_title\";s:127:\"background-color:#ffdd00;padding-top:60px;padding-bottom:15px;border-style:solid;border-width:0px 0px 1px;border-color:#f4f4f4;\";s:21:\"_css_page_title_color\";s:36:\"font-size:20px;margin:0px 26px 10px;\";s:26:\"_css_breadcrumbs_container\";N;s:32:\"_css_breadcrumbs_inner_container\";s:50:\"margin-top:0px;margin-right:20px;margin-left:10px;\";s:14:\"_css_body_typo\";s:17:\"font-family:dana;\";s:13:\"footer_layout\";s:5:\"s6,s6\";s:11:\"_css_footer\";s:38:\"padding-top:100px;padding-bottom:50px;\";s:18:\"_css_footer_widget\";s:41:\"color:#dddddd;padding:0px 10px 10px 10px;\";s:13:\"_css_footer_a\";s:28:\"color:#ffffff;line-height: 2\";s:19:\"_css_footer_a_hover\";s:14:\"color:#c6c6c6;\";s:15:\"footer_2_center\";a:1:{i:0;a:13:{s:7:\"element\";s:4:\"icon\";s:10:\"element_id\";s:15:\"footer_2_center\";s:6:\"custom\";s:24:\"Insert shortcode or HTML\";s:7:\"it_text\";s:163:\" © کپی رایت [cz_current_year] توسعه توسط مارکت <a href=\"https://toswp.ir/\" target=\"_blank\" rel=\"noopener noreferrer\">توس وردپرس</a>\";s:5:\"sk_it\";s:62:\"font-size:14px;color:rgba(255,255,255,0.37);text-align:center;\";s:11:\"search_type\";s:13:\"icon_dropdown\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:12:\"Button title\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:2:{s:3:\"top\";s:4:\"20px\";s:6:\"bottom\";s:4:\"20px\";}}}s:17:\"_css_row_footer_2\";s:75:\"border-style:solid;border-top-width:1px;border-color:rgba(255,255,255,0.1);\";s:9:\"backtotop\";s:14:\"fa fa-angle-up\";s:14:\"_css_backtotop\";s:97:\"font-size:18px;border-style:none;border-radius:55px;box-shadow:1px 8px 32px 0px rgba(0,0,0,0.08);\";s:25:\"_css_cf7_beside_backtotop\";s:92:\"font-size:18px;border-style:none;border-radius:5px;box-shadow:1px 8px 32px rgba(0,0,0,0.08);\";s:14:\"meta_data_post\";a:7:{i:0;s:5:\"image\";i:1;s:4:\"date\";i:2;s:6:\"author\";i:3;s:4:\"cats\";i:4;s:4:\"tags\";i:5;s:10:\"author_box\";i:6;s:9:\"next_prev\";}s:12:\"related_post\";s:21:\"You May Also Like ...\";s:14:\"slug_portfolio\";s:8:\"projects\";s:15:\"title_portfolio\";s:15:\"پروژه ها\";s:13:\"cat_portfolio\";s:12:\"projects/cat\";s:19:\"cat_title_portfolio\";s:22:\"دسته بندی ها\";s:14:\"tags_portfolio\";s:13:\"projects/tags\";s:20:\"tags_title_portfolio\";s:15:\"برچسب ها\";s:18:\"template_portfolio\";s:3:\"574\";s:19:\"meta_data_portfolio\";a:3:{i:0;s:4:\"date\";i:1;s:4:\"cats\";i:2;s:4:\"tags\";}s:17:\"related_portfolio\";s:21:\"You May Also Like ...\";s:16:\"layout_portfolio\";s:2:\"ws\";s:17:\"primary_portfolio\";s:7:\"primary\";s:19:\"secondary_portfolio\";s:9:\"secondary\";s:19:\"page_coverportfolio\";s:1:\"1\";s:19:\"page_titleportfolio\";s:1:\"1\";s:24:\"_css_page_titleportfolio\";N;s:30:\"_css_page_title_colorportfolio\";N;s:42:\"_css_page_title_breadcrumbs_colorportfolio\";N;s:35:\"_css_breadcrumbs_containerportfolio\";N;s:41:\"_css_breadcrumbs_inner_containerportfolio\";N;s:37:\"_css_right_br_full_containerportfolio\";N;s:23:\"_css_sidebar-1_search-2\";N;s:29:\"_css_sidebar-1_recent-posts-2\";N;s:32:\"_css_sidebar-1_recent-comments-2\";N;s:25:\"_css_sidebar-1_archives-2\";N;s:27:\"_css_sidebar-1_categories-2\";N;s:21:\"_css_sidebar-1_meta-2\";N;s:28:\"_css_footer_widget_headlines\";s:127:\"font-size:18px;color:#ffffff;border-style:solid;border-bottom-width:4px;border-color:rgba(28,126,104,0.6);display:inline-block;\";s:20:\"page_cover_portfolio\";s:1:\"1\";s:20:\"_css_backtotop_hover\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:31:\"_css_cf7_beside_backtotop_hover\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:20:\"page_title_portfolio\";s:1:\"1\";s:36:\"_css_breadcrumbs_container_portfolio\";N;s:18:\"page_cover_product\";s:1:\"1\";s:18:\"page_title_product\";s:1:\"1\";s:34:\"_css_breadcrumbs_container_product\";N;s:14:\"layout_product\";s:2:\"ws\";s:15:\"primary_product\";s:7:\"primary\";s:17:\"secondary_product\";s:9:\"secondary\";s:7:\"woo_col\";s:1:\"4\";s:18:\"woo_items_per_page\";s:1:\"8\";s:23:\"_css_woo_products_title\";s:48:\"font-size:18px;color:#000000;margin-bottom:10px;\";s:23:\"_css_woo_products_stars\";s:13:\"display:none;\";s:29:\"_css_woo_products_add_to_cart\";s:160:\"color:rgba(0,0,0,0.79);background-color:rgba(0,0,0,0.15);padding-top:20px;padding-bottom:20px;margin-top:0px;border-radius:0 0 5px 5px;display:block;float:none;\";s:24:\"_css_woo_products_onsale\";s:164:\"font-size:16px;color:#000000;line-height:2em;background-color:#ffdd00;width:2em;height:2em;padding:3px 10px;border-style:solid;border-radius:5px;top:10px;left:10px;\";s:23:\"_css_woo_products_price\";s:92:\"font-size:16px;color:#252220;background-color:#ededed;border-radius:5px;top:10px;right:10px;\";s:22:\"_css_woo_product_price\";s:29:\"font-size:26px;color:#ffdd00;\";s:16:\"_css_woo_buttons\";s:39:\"color:#ffffff;background-color:#ffdd00;\";s:22:\"_css_woo_buttons_hover\";s:51:\"color:#ffdd00;background-color:rgba(255,221,0,0.1);\";s:21:\"_css_primary_search-2\";N;s:27:\"_css_primary_recent-posts-2\";N;s:30:\"_css_primary_recent-comments-2\";N;s:23:\"_css_primary_archives-2\";N;s:25:\"_css_primary_categories-2\";N;s:19:\"_css_primary_meta-2\";N;s:24:\"_css_footer-2_nav_menu-2\";N;s:24:\"_css_footer-3_nav_menu-3\";N;s:24:\"_css_footer-4_nav_menu-4\";N;s:24:\"posts_per_page_portfolio\";s:1:\"6\";s:8:\"readmore\";s:19:\"ادامه مطلب\";s:13:\"readmore_icon\";s:19:\"fa czico-061-menu-4\";s:17:\"_css_all_img_tags\";s:18:\"border-radius:5px;\";s:20:\"_css_tags_categories\";s:112:\"background-color:rgba(255,255,255,0.1);padding-right:20px;padding-left:20px;border-style:none;border-radius:5px;\";s:26:\"_css_tags_categories_hover\";s:39:\"color:#1c7e68;background-color:#ffdd00;\";s:18:\"_css_pagination_li\";s:89:\"color:#ffffff;background-color:rgba(28,126,104,0.38);border-style:none;border-radius:5px;\";s:21:\"_css_pagination_hover\";s:39:\"color:#ffdd00;background-color:#2e2e2e;\";s:17:\"hide_br_on_mobile\";b:1;s:17:\"hide_br_on_tablet\";b:1;s:16:\"related_post_col\";s:2:\"s4\";s:16:\"related_post_ppp\";s:1:\"3\";s:13:\"_css_readmore\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:19:\"_css_readmore_hover\";s:39:\"color:#000000;background-color:#ffdd00;\";s:15:\"_css_readmore_i\";s:45:\"font-size:20px;color:#ffffff;margin-top:-1px;\";s:21:\"_css_readmore_hover_i\";N;s:17:\"columns_portfolio\";s:1:\"3\";s:12:\"woo_template\";s:1:\"2\";s:15:\"woo_related_col\";s:1:\"3\";s:26:\"_css_woo_product_thumbnail\";s:66:\"border-style:solid;border-width:1px;border-color:rgba(0,0,0,0.15);\";s:24:\"_css_primary_tag_cloud-2\";N;s:30:\"_css_primary_codevzinstagram-2\";N;s:30:\"_css_primary_codevzsimpleads-2\";N;s:33:\"_css_footer-1_codevzpagecontent-2\";N;s:37:\"_css_footer-2_codevzcustommenulist2-2\";N;s:37:\"_css_footer-3_codevzcustommenulist2-3\";N;s:37:\"_css_footer-4_codevzcustommenulist2-4\";N;s:10:\"nicescroll\";b:0;s:18:\"hide_on_mobile_brt\";a:1:{i:0;s:20:\"title_hide_on_mobile\";}s:34:\"responsive_breakpoint_2_custom_css\";s:81:\".page_title, .header_onthe_cover .page_title {\n    padding: 10px 0 0 !important\n}\";s:34:\"responsive_breakpoint_3_custom_css\";s:81:\".page_title, .header_onthe_cover .page_title {\n    padding: 10px 0 0 !important\n}\";s:24:\"_css_menu_ul_ul_header_3\";s:52:\"margin-top:-12px;margin-right:12px;margin-left:12px;\";s:28:\"_css_page_title_color_tablet\";s:15:\"margin-top:0px;\";s:39:\"_css_breadcrumbs_inner_container_tablet\";s:15:\"margin-top:4px;\";s:22:\"_css_page_title_tablet\";s:17:\"padding-top:20px;\";s:28:\"_css_page_title_color_mobile\";s:63:\"display:block;font-size:16px;margin-left:2px;CDVZwidth:100%CDVZ\";s:39:\"_css_breadcrumbs_inner_container_mobile\";s:13:\"display:none;\";s:25:\"_css_woo_products_overall\";s:92:\"border-style:solid;border-width:1px;border-color:rgba(0,0,0,0.15);border-radius:5px 5px 0 0;\";s:31:\"_css_woo_products_overall_hover\";s:44:\"box-shadow:0px 10px 50px rgba(46,46,46,0.2);\";s:17:\"row_type_footer_1\";s:4:\"page\";s:20:\"page_as_row_footer_1\";s:3:\"686\";s:14:\"template_style\";s:1:\"1\";s:14:\"posts_per_page\";s:1:\"4\";s:6:\"sticky\";b:1;s:20:\"_css_next_prev_icons\";s:57:\"color:#1c7e68;background-color:#ffdd00;border-radius:5px;\";s:26:\"_css_next_prev_icons_hover\";s:39:\"color:#1c7e68;background-color:#ffffff;\";s:18:\"_css_next_prev_con\";s:56:\"background-color:#1c7e68;padding:30px;border-radius:5px;\";s:21:\"_css_next_prev_titles\";s:14:\"color:#ffffff;\";s:18:\"related_posts_post\";s:21:\"مطالب مرتبط\";s:9:\"prev_post\";s:8:\"قبلی\";s:9:\"next_post\";s:8:\"بعدی\";s:15:\"_css_post_title\";s:17:\"padding-top:10px;\";s:13:\"wp_login_logo\";s:81:\"http://sunthemes.ir/wordpress/xtra/moving/wp-content/uploads/2017/06/logo-1-1.png\";s:14:\"_wp_login_form\";s:25:\"background-color:#191919;\";s:16:\"_wp_login_button\";s:73:\"color:#000000;background-color:#ffdd00;border-style:none;box-shadow:none;\";s:11:\"_css_select\";s:18:\"border-radius:5px;\";s:20:\"_css_select_dropdown\";s:18:\"border-radius:5px;\";s:30:\"_css_menu_indicator_a_header_3\";s:34:\"_class_indicator:fa fa-angle-down;\";s:33:\"_css_menu_ul_a_indicator_header_3\";s:35:\"_class_indicator:fa fa-angle-right;\";s:33:\"_css_menu_ul_indicator_a_header_3\";s:35:\"_class_indicator:fa fa-angle-right;\";s:14:\"social_tooltip\";s:24:\"cz_tooltip cz_tooltip_up\";s:19:\"_css_social_tooltip\";s:110:\"color:#ffffff;font-weight:500;background-color:#1c7e68;padding-right:16px;padding-left:16px;border-radius:5px;\";s:9:\"fonts_out\";a:2:{i:0;s:17:\"font-family:dana;\";i:1;s:17:\"font-family:dana;\";}s:24:\"template_style_portfolio\";s:2:\"10\";s:7:\"css_out\";s:18125:\".outofstock img {filter: grayscale(100%)}\n\n/* Theme color */a:hover, .sf-menu > .cz.current_menu > a, .sf-menu > .cz .cz.current_menu > a,.sf-menu > .current-menu-parent > a,.comment-text .star-rating span,.codevz-404 span {color: #ffdd00} \nform button, .button, #edd-purchase-button, .edd-submit, .edd-submit.button.blue, .edd-submit.button.blue:hover, .edd-submit.button.blue:focus, [type=submit].edd-submit, .sf-menu > .cz > a:before,.sf-menu > .cz > a:before,\n.post-password-form input[type=\"submit\"], .wpcf7-submit, .submit_user, \n#commentform #submit, .commentlist li.bypostauthor > .comment-body:after,.commentlist li.comment-author-admin > .comment-body:after, \n .pagination .current, .pagination > b, .pagination a:hover, .page-numbers .current, .page-numbers a:hover, .pagination .next:hover, \n.pagination .prev:hover, input[type=submit], .sticky:before, .commentlist li.comment-author-admin .fn,\ninput[type=submit],input[type=button],.cz_header_button,.cz_default_portfolio a,\n.cz_readmore, .more-link, a.cz_btn, div.cz_btn ,.woocommerce input.button.alt.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.woocommerce .woocommerce-error .button,.woocommerce .woocommerce-info .button, .woocommerce .woocommerce-message .button, .woocommerce-page .woocommerce-error .button, .woocommerce-page .woocommerce-info .button, .woocommerce-page .woocommerce-message .button,#add_payment_method table.cart input, .woocommerce-cart table.cart input:not(.input-text), .woocommerce-checkout table.cart input,.woocommerce input.button:disabled, .woocommerce input.button:disabled[disabled],#add_payment_method table.cart input, #add_payment_method .wc-proceed-to-checkout a.checkout-button, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,.woocommerce #payment #place_order, .woocommerce-page #payment #place_order,.woocommerce input.button.alt,.woocommerce #respond input#submit.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce-MyAccount-navigation a:hover, .woocommerce-MyAccount-navigation .is-active a,.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current, .widget_product_search #searchsubmit,.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce div.product form.cart .button, .xtra-product-icons,.woocommerce button.button.alt {background-color: #ffdd00}\n.cs_load_more_doing, div.wpcf7 .wpcf7-form .ajax-loader {border-right-color: #ffdd00}\ninput:focus,textarea:focus,select:focus {border-color: #ffdd00 !important}\n::selection {background-color: #ffdd00;color: #fff}\n::-moz-selection {background-color: #ffdd00;color: #fff}\n\n/* Custom *//* Do Not Remove This CSS */\nheader .services div.service_text {\n    white-space: nowrap\n}\n\n/* Dynamic  */form button,.comment-form button,a.cz_btn,div.cz_btn,a.cz_btn_half_to_fill:before,a.cz_btn_half_to_fill_v:before,a.cz_btn_half_to_fill:after,a.cz_btn_half_to_fill_v:after,a.cz_btn_unroll_v:before, a.cz_btn_unroll_h:before,a.cz_btn_fill_up:before,a.cz_btn_fill_down:before,a.cz_btn_fill_left:before,a.cz_btn_fill_right:before,.wpcf7-submit,input[type=submit],input[type=button],.button,.cz_header_button,.woocommerce a.button,.woocommerce input.button,.woocommerce #respond input#submit.alt,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, #edd-purchase-button, .edd-submit, [type=submit].edd-submit, .edd-submit.button.blue,.woocommerce #payment #place_order, .woocommerce-page #payment #place_order,.woocommerce button.button:disabled, .woocommerce button.button:disabled[disabled], .woocommerce a.button.wc-forward,.wp-block-search .wp-block-search__button{font-weight:700;background-color:#1c7e68;border-style:solid;border-radius:5px}form button:hover,.comment-form button:hover,a.cz_btn:hover,div.cz_btn:hover,a.cz_btn_half_to_fill:hover:before, a.cz_btn_half_to_fill_v:hover:before,a.cz_btn_half_to_fill:hover:after, a.cz_btn_half_to_fill_v:hover:after,a.cz_btn_unroll_v:after, a.cz_btn_unroll_h:after,a.cz_btn_fill_up:after,a.cz_btn_fill_down:after,a.cz_btn_fill_left:after,a.cz_btn_fill_right:after,.wpcf7-submit:hover,input[type=submit]:hover,input[type=button]:hover,.button:hover,.cz_header_button:hover,.woocommerce a.button:hover,.woocommerce input.button:hover,.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:hover,.woocommerce button.button.alt:hover,.woocommerce input.button.alt:hover,.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, #edd-purchase-button:hover, .edd-submit:hover, [type=submit].edd-submit:hover, .edd-submit.button.blue:hover, .edd-submit.button.blue:focus,.woocommerce #payment #place_order:hover, .woocommerce-page #payment #place_order:hover,.woocommerce div.product form.cart .button:hover,.woocommerce button.button:disabled:hover, .woocommerce button.button:disabled[disabled]:hover, .woocommerce a.button.wc-forward:hover,.wp-block-search .wp-block-search__button:hover{color:#000000;background-color:#ffdd00}.widget{color:#ffffff;background-color:#1c7e68;margin-bottom:25px;border-radius:5px}.widget a{color:#ffffff}.widget > h4, .sidebar_inner .widget_block > div > div > h2{font-size:16px;color:#000000;background-color:#ffdd00;padding:10px 40px;margin-right:-45px;margin-bottom:30px;margin-left:-45px;border-radius:5px;display:inline-block}input,textarea,select,.qty,.woocommerce-input-wrapper .select2-selection--single,#add_payment_method table.cart td.actions .coupon .input-text, .woocommerce-cart table.cart td.actions .coupon .input-text, .woocommerce-checkout table.cart td.actions .coupon .input-text{color:#000000;border-style:solid;border-radius:5px}.elms_row .cz_social a, .fixed_side .cz_social a, #xtra-social-popup [class*=\"xtra-social-type-\"] a{font-size:18px;color:#1c7e68;background-color:rgba(255,221,0,0.04);padding:4px;margin-left:3px;border-style:solid;border-radius:5px}.elms_row .cz_social a:hover, .fixed_side .cz_social a:hover, #xtra-social-popup [class*=\"xtra-social-type-\"] a:hover{color:#ffffff;background-color:#1c7e68}.header_1{display:none}.header_1 .row{background-color:#ffdd00}#menu_header_1 > .cz > a{font-size:16px;padding: 6px  6px}#menu_header_1 > .cz > a:hover,#menu_header_1 > .cz:hover > a,#menu_header_1 > .cz.current_menu > a,#menu_header_1 > .current-menu-parent > a{color:#ffffff}#menu_header_1 > .cz > a:before{border-style:solid;border-width:0px;border-radius:4px}.header_2{background-color:transparent;background-image:linear-gradient(90deg,#3f3f3f,#a1a1a1);padding-bottom:40px}#menu_header_2 > .cz > a{padding: 6px  6px}#menu_header_2 > .cz > a:hover,#menu_header_2 > .cz:hover > a,#menu_header_2 > .cz.current_menu > a,#menu_header_2 > .current-menu-parent > a{color:#ffffff}#menu_header_2 .cz .sub-menu:not(.cz_megamenu_inner_ul),#menu_header_2 .cz_megamenu_inner_ul .cz_megamenu_inner_ul{background-color:#ffdd00;margin:1px 12px;border-style:solid;border-radius:4px}#menu_header_2 .cz .cz a{color:#ffffff}#menu_header_2 .cz .cz a:hover,#menu_header_2 .cz .cz:hover > a,#menu_header_2 .cz .cz.current_menu > a,#menu_header_2 .cz .current_menu > .current_menu{color:#e2e2e2}.header_3 .row{background-color:#ffffff;margin-top:-32px;margin-bottom:-31px;border-radius:5px;box-shadow:0px 10px 60px 0px rgba(0,0,0,0.15)}#menu_header_3 > .cz > a{font-size:15px;color:rgba(37,34,32,0.9);padding:6px 17px 7px;margin:0px 5px 0px 0px}#menu_header_3 > .cz > a:hover,#menu_header_3 > .cz:hover > a,#menu_header_3 > .cz.current_menu > a,#menu_header_3 > .current-menu-parent > a{color:#ffffff}#menu_header_3 > .cz > a:before{background-color:#1c7e68;width:100%;border-style:solid;border-width:0px;border-radius:5px;left:0px}#menu_header_3 .cz .sub-menu:not(.cz_megamenu_inner_ul),#menu_header_3 .cz_megamenu_inner_ul .cz_megamenu_inner_ul{background-color:#ffffff;margin:1px 20px 0px;border-style:solid;border-radius:5px;box-shadow:0px 10px 60px rgba(0,0,0,0.15)}#menu_header_3 .cz .cz a{font-size:16px;color:rgba(0,0,0,0.7);font-weight:500}#menu_header_3 .cz .cz a:hover,#menu_header_3 .cz .cz:hover > a,#menu_header_3 .cz .cz.current_menu > a,#menu_header_3 .cz .current_menu > .current_menu{color:#000000}.onSticky{background-color:#2e2e2e !important}.header_4{background-color:#000000}#menu_header_4{background-size:cover;background-color:#1c7e68;padding:30px}#menu_header_4 > .cz > a{color:#ffffff;margin-bottom:10px;border-style:none;border-radius:5px}#menu_header_4 > .cz > a:hover,#menu_header_4 > .cz:hover > a,#menu_header_4 > .cz.current_menu > a,#menu_header_4 > .current-menu-parent > a{color:#000000;background-color:#ffdd00}#menu_header_4 .cz .cz a{margin-bottom:6px;border-style:none;border-radius:5px}#menu_header_4 .cz .cz a:hover,#menu_header_4 .cz .cz:hover > a,#menu_header_4 .cz .cz.current_menu > a,#menu_header_4 .cz .current_menu > .current_menu{color:#ffffff;background-color:#252220}.page_title,.header_onthe_cover .page_title{background-color:#ffdd00;padding-top:60px;padding-bottom:15px;border-style:solid;border-width:0px 0px 1px;border-color:#f4f4f4}.page_title .section_title{font-size:20px;margin:0px 26px 10px}.breadcrumbs{margin-top:0px;margin-right:20px;margin-left:10px}[class*=\"cz_tooltip_\"] [data-title]:after{font-family:\'dana\'}body, body.rtl, .rtl form{font-family:\'dana\'}.cz_middle_footer{padding-top:100px;padding-bottom:50px}.footer_widget{color:#dddddd;padding:0px 10px 10px 10px}.cz_middle_footer a{color:#ffffff;line-height: 2}.cz_middle_footer a:hover{color:#c6c6c6}.footer_2 .row{border-style:solid;border-top-width:1px;border-color:rgba(255,255,255,0.1)}i.backtotop{font-size:18px;border-style:none;border-radius:55px;box-shadow:1px 8px 32px 0px rgba(0,0,0,0.08)}i.fixed_contact{font-size:18px;border-style:none;border-radius:5px;box-shadow:1px 8px 32px rgba(0,0,0,0.08)}.footer_widget > h4, footer .widget_block > div > div > h2{font-size:18px;color:#ffffff;border-style:solid;border-bottom-width:4px;border-color:rgba(28,126,104,0.6);display:inline-block}i.backtotop:hover{color:#ffffff;background-color:#1c7e68}i.fixed_contact:hover{color:#ffffff;background-color:#1c7e68}.woocommerce ul.products li.product .woocommerce-loop-category__title, .woocommerce ul.products li.product .woocommerce-loop-product__title, .woocommerce ul.products li.product h3,.woocommerce.woo-template-2 ul.products li.product .woocommerce-loop-category__title, .woocommerce.woo-template-2 ul.products li.product .woocommerce-loop-product__title, .woocommerce.woo-template-2 ul.products li.product h3{font-size:18px;color:#000000;margin-bottom:10px}.woocommerce ul.products li.product .star-rating{display:none}.woocommerce ul.products li.product .button.add_to_cart_button, .woocommerce ul.products li.product .button[class*=\"product_type_\"]{color:rgba(0,0,0,0.79);background-color:rgba(0,0,0,0.15);padding-top:20px;padding-bottom:20px;margin-top:0px;border-radius:0 0 5px 5px;display:block;float:none}.woocommerce span.onsale, .woocommerce ul.products li.product .onsale,.woocommerce.single span.onsale, .woocommerce.single ul.products li.product .onsale{font-size:16px;color:#000000;line-height:2em;background-color:#ffdd00;width:2em;height:2em;padding:3px 10px;border-style:solid;border-radius:5px;top:10px;left:10px}.woocommerce ul.products li.product .price{font-size:16px;color:#252220;background-color:#ededed;border-radius:5px;top:10px;right:10px}.woocommerce div.product .summary p.price, .woocommerce div.product .summary span.price{font-size:26px;color:#ffdd00}.page_content img, a.cz_post_image img, footer img, .cz_image_in, .wp-block-gallery figcaption, .cz_grid .cz_grid_link{border-radius:5px}.tagcloud a, .widget .tagcloud a, .cz_post_cat a, .cz_post_views a{background-color:rgba(255,255,255,0.1);padding-right:20px;padding-left:20px;border-style:none;border-radius:5px}.tagcloud a:hover, .widget .tagcloud a:hover, .cz_post_cat a:hover, .cz_post_views a:hover{color:#1c7e68;background-color:#ffdd00}.pagination a, .pagination > b, .pagination span, .page-numbers a, .page-numbers span, .woocommerce nav.woocommerce-pagination ul li a, .woocommerce nav.woocommerce-pagination ul li span{color:#ffffff;background-color:rgba(28,126,104,0.38);border-style:none;border-radius:5px}.cz-cpt-post .cz_readmore, .cz-cpt-post .more-link{color:#ffffff;background-color:#1c7e68}.cz-cpt-post .cz_readmore:hover, .cz-cpt-post .more-link:hover{color:#000000;background-color:#ffdd00}.cz-cpt-post .cz_readmore i, .cz-cpt-post .more-link i{font-size:20px;color:#ffffff;margin-top:-1px}.woocommerce div.product div.images img{border-style:solid;border-width:1px;border-color:rgba(0,0,0,0.15)}#menu_header_3 .sub-menu .sub-menu:not(.cz_megamenu_inner_ul){margin-top:-12px;margin-right:12px;margin-left:12px}.woocommerce ul.products li.product .woocommerce-loop-product__link{border-style:solid;border-width:1px;border-color:rgba(0,0,0,0.15);border-radius:5px 5px 0 0}.woocommerce ul.products li.product:hover .woocommerce-loop-product__link{box-shadow:0px 10px 50px rgba(46,46,46,0.2)}.next_prev .previous i,.next_prev .next i{color:#1c7e68;background-color:#ffdd00;border-radius:5px}.next_prev .previous:hover i,.next_prev .next:hover i{color:#1c7e68;background-color:#ffffff}.next_prev{background-color:#1c7e68;padding:30px;border-radius:5px}.next_prev h4{color:#ffffff}.cz-cpt-post .cz_default_loop .cz_post_title h3{padding-top:10px}[class*=\"cz_tooltip_\"] [data-title]:after{color:#ffffff;font-weight:500;background-color:#1c7e68;padding-right:16px;padding-left:16px;border-radius:5px}.cz-cpt-portfolio article .cz_post_icon{font-size:18px;padding:15px;top:auto;right:10px;bottom:10px;left:auto}.rtl.cz-cpt-portfolio article .cz_post_icon{left:17%}.cz-cpt-portfolio .cz_default_loop .cz_post_image, .cz-cpt-portfolio .cz_post_svg{border-radius:10px}.page_footer{background-image:linear-gradient(90deg,rgba(68,66,64,0.64),rgba(68,66,64,0.64)),url(https://xtra-moving.tooswp.ir/wp-content/uploads/2019/06/bg1.jpg);border-style:solid;border-bottom-width:4px;border-color:#ffdd00}.cz-cpt-post .cz_default_loop > div{border-radius:5px}.cz-cpt-post article .cz_post_icon{color:#ffdd00;background-color:#1c7e68;border-radius:55px}.cz-cpt-post .cz_post_image, .cz-cpt-post .cz_post_svg{border-color:#ffffff;border-radius:5px}.cz-cpt-post .cz_readmore:hover i, .cz-cpt-post .more-link:hover i{color:#000000}.pagination .current, .pagination > b, .pagination a:hover, .page-numbers .current, .page-numbers a:hover, .pagination .next:hover, .pagination .prev:hover, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current{background-color:#1c7e68}#comments > h3,.content.cz_related_posts > h4,.cz_author_box h4,.related.products > h2,.upsells.products > h2,.up-sells.products > h2{color:#1c7e68;padding-bottom:22px;margin-bottom:30px;border-style:solid;border-bottom-width:2px;border-color:#1c7e68}.cz_related_posts .cz_related_post h3{color:#1c7e68;padding-top:15px;padding-bottom:5px}.xtra-comments .commentlist li article{border-radius:5px}.woocommerce ul.products li.product .button.add_to_cart_button:hover, .woocommerce ul.products li.product .button[class*=\"product_type_\"]:hover{background-color:#ffdd00;opacity:0.9}.woocommerce div.product .woocommerce-tabs .panel{margin-right:-5px}.products .product .xtra-product-icons{background-color:#1c7e68;margin-top:46%}.woocommerce.single span.onsale{right:10px}.woocommerce .cart .xtra-product-icons{font-size:20px}.quantity-down{color:#1c7e68;background-color:#ffffff;padding:5px 4px 3px;margin-left:-40px;border-radius:4px}.quantity-down:hover{background-color:#ffdd00}.quantity-up{color:#1c7e68;background-color:#ffffff;padding:5px 4px 3px;margin-right:-40px;margin-left:10px;border-radius:4px}.quantity-up:hover{background-color:#ffdd00}.woocommerce .quantity .qty{color:#ffffff;background-color:#1c7e68;width:110px;border-style:none}.woocommerce div.product form.cart .button{background-color:#1c7e68}div.xtra-share{background-color:#1c7e68;border-radius:5px}div.xtra-share a{color:#1c7e68;background-color:#ffffff;margin-right:7px;margin-left:7px;border-radius:5px;opacity:1}div.xtra-share a:hover{color:#000000;background-color:#ffdd00}div.xtra-share:before{font-size:14px;color:rgba(255,255,255,0.6);margin-right:10px}.rtl div.xtra-share:before{margin-right:0px;margin-left:10px}.xtra-fixed-mobile-nav{background-color:#1c7e68}.xtra-fixed-mobile-nav a{padding-top:20px;padding-bottom:15px}.xtra-fixed-mobile-nav a:hover,.xtra-fixed-mobile-nav .xtra-active{background-color:rgba(0,0,0,0.31)}.xtra-fixed-mobile-nav a i, .xtra-fixed-mobile-nav a img{color:#1c7e68;background-color:#ffdd00;padding:10px;border-radius:33px}.xtra-fixed-mobile-nav a span{font-size:13px;margin-right:10px;margin-left:0px}\n\n/* Responsive */@media screen and (max-width:1240px){#layout{width:100%!important}#layout.layout_1,#layout.layout_2{width:95%!important}.row{width:90% !important;padding:0}blockquote{padding:20px}footer .elms_center,footer .have_center .elms_left, footer .have_center .elms_center, footer .have_center .elms_right{float:none;display:block;text-align:center;margin:0 auto;flex:unset}}@media screen and (max-width:768px){.page_title .section_title{margin-top:0px;}.breadcrumbs{margin-top:4px;}.page_title,.header_onthe_cover .page_title{padding-top:20px;}}@media screen and (max-width:480px){.page_title .section_title{display:block;font-size:16px;margin-left:2px;width:100%}.breadcrumbs{display:none;}div.xtra-share a{margin-right:3px;margin-left:3px;}}\";s:22:\"default_featured_image\";b:1;s:25:\"_css_portfolio_hover_icon\";s:85:\"font-size:18px;padding:15px;top:auto;right:10px;bottom:10px;left:auto;RTLleft:17%;RTL\";s:20:\"_css_portfolio_image\";s:19:\"border-radius:10px;\";s:7:\"404_msg\";s:95:\"صفحه مورد نظر شما پیدا نشد! لطفا در سایت جستجو کنید ...\";s:7:\"404_btn\";s:35:\"بازگشت به صفحه اصلی\";s:12:\"custom_fonts\";a:29:{i:0;a:1:{s:4:\"font\";s:14:\"irsns-light-fa\";}i:1;a:1:{s:4:\"font\";s:16:\"irsns-regular-fa\";}i:2;a:1:{s:4:\"font\";s:13:\"irsns-bold-fa\";}i:3;a:1:{s:4:\"font\";s:7:\"Shabnam\";}i:4;a:1:{s:4:\"font\";s:12:\"Shabnam-Bold\";}i:5;a:1:{s:4:\"font\";s:15:\"Lalezar-Regular\";}i:6;a:1:{s:4:\"font\";s:12:\"scirsnsyekan\";}i:7;a:1:{s:4:\"font\";s:9:\"broyabold\";}i:8;a:1:{s:4:\"font\";s:6:\"rezvan\";}i:9;a:1:{s:4:\"font\";s:7:\"khodkar\";}i:10;a:1:{s:4:\"font\";s:9:\"DastNevis\";}i:11;a:1:{s:4:\"font\";s:9:\"BTitrBold\";}i:12;a:1:{s:4:\"font\";s:6:\"BYekan\";}i:13;a:1:{s:4:\"font\";s:4:\"BZar\";}i:14;a:1:{s:4:\"font\";s:9:\"BSinaBold\";}i:15;a:1:{s:4:\"font\";s:5:\"BZiba\";}i:16;a:1:{s:4:\"font\";s:5:\"Vazir\";}i:17;a:1:{s:4:\"font\";s:5:\"aviny\";}i:18;a:1:{s:4:\"font\";s:9:\"IRANBlack\";}i:19;a:1:{s:4:\"font\";s:9:\"iranyekan\";}i:20;a:1:{s:4:\"font\";s:10:\"iransansdn\";}i:21;a:1:{s:4:\"font\";s:18:\"mahboubeh_mehravar\";}i:22;a:1:{s:4:\"font\";s:9:\"iransharp\";}i:23;a:1:{s:4:\"font\";s:4:\"IRAN\";}i:24;a:1:{s:4:\"font\";s:13:\"Anjoman-Light\";}i:25;a:1:{s:4:\"font\";s:15:\"Anjoman-Regular\";}i:26;a:1:{s:4:\"font\";s:12:\"Anjoman-Bold\";}i:27;a:1:{s:4:\"font\";s:4:\"dana\";}i:28;a:1:{s:4:\"font\";s:8:\"IRANSans\";}}s:18:\"_css_overal_footer\";s:214:\"background-image:linear-gradient(90deg,rgba(68,66,64,0.64),rgba(68,66,64,0.64)),url(https://xtra-moving.tooswp.ir/wp-content/uploads/2019/06/bg1.jpg);border-style:solid;border-bottom-width:4px;border-color:#ffdd00;\";s:11:\"layout_post\";s:1:\"1\";s:12:\"post_excerpt\";s:2:\"20\";s:20:\"hover_icon_icon_post\";s:21:\"fa czico-107-web-link\";s:9:\"not_found\";s:27:\"موردی یافت نشد!\";s:11:\"cm_disabled\";s:55:\"امکان ارسال دیدگاه وجود ندارد!\";s:17:\"_css_overall_post\";s:18:\"border-radius:5px;\";s:20:\"_css_post_hover_icon\";s:58:\"color:#ffdd00;background-color:#1c7e68;border-radius:55px;\";s:15:\"_css_post_image\";s:39:\"border-color:#ffffff;border-radius:5px;\";s:21:\"_css_readmore_i_hover\";s:14:\"color:#000000;\";s:24:\"_css_pagination_li_hover\";s:25:\"background-color:#1c7e68;\";s:24:\"posted_by_translate_post\";s:26:\"ارسال شده توسط\";s:17:\"on_translate_post\";s:4:\"در\";s:10:\"no_comment\";s:21:\"بدون دیدگاه\";s:7:\"comment\";s:12:\"دیدگاه\";s:8:\"comments\";s:12:\"دیدگاه\";s:28:\"_css_related_posts_sec_title\";s:117:\"color:#1c7e68;padding-bottom:22px;margin-bottom:30px;border-style:solid;border-bottom-width:2px;border-color:#1c7e68;\";s:24:\"_css_related_posts_title\";s:50:\"color:#1c7e68;padding-top:15px;padding-bottom:5px;\";s:26:\"_css_single_comments_title\";s:117:\"color:#1c7e68;padding-bottom:21px;margin-bottom:30px;border-style:solid;border-bottom-width:2px;border-color:#1c7e68;\";s:23:\"_css_single_comments_li\";s:18:\"border-radius:5px;\";s:19:\"search_title_prefix\";s:31:\"نتایج جستجو برای:\";s:13:\"layout_search\";s:5:\"right\";s:22:\"post_excerpt_portfolio\";s:2:\"20\";s:25:\"hover_icon_icon_portfolio\";s:21:\"fa czico-188-arrows-2\";s:18:\"readmore_portfolio\";s:25:\"اطلاعات بیشتر\";s:23:\"readmore_icon_portfolio\";s:17:\"fa fa-angle-right\";s:29:\"posted_by_translate_portfolio\";s:26:\"ارسال شده توسط\";s:22:\"on_translate_portfolio\";s:4:\"در\";s:14:\"prev_portfolio\";s:8:\"قبلی\";s:14:\"next_portfolio\";s:8:\"بعدی\";s:21:\"related_portfolio_ppp\";s:1:\"3\";s:23:\"related_posts_portfolio\";s:68:\"ممکن است به این موارد علاقمند باشید ...\";s:21:\"related_portfolio_col\";s:2:\"s4\";s:20:\"no_comment_portfolio\";s:10:\"No comment\";s:17:\"comment_portfolio\";s:7:\"Comment\";s:18:\"comments_portfolio\";s:8:\"Comments\";s:8:\"woo_cart\";s:15:\"سبد خرید\";s:12:\"woo_checkout\";s:19:\"تسویه حساب\";s:15:\"woo_no_products\";s:45:\"سبد خرید شما خالی می باشد\";s:35:\"_css_woo_products_add_to_cart_hover\";s:37:\"background-color:#ffdd00;opacity:0.9;\";s:15:\"custom_sidebars\";a:0:{}s:28:\"_css_woo_product_tab_content\";s:18:\"margin-right:-5px;\";s:12:\"woo_wishlist\";i:3257;s:14:\"woo_quick_view\";b:1;s:22:\"woo_wishlist_qv_center\";b:1;s:23:\"_css_woo_products_icons\";s:40:\"background-color:#1c7e68;margin-top:46%;\";s:23:\"_css_woo_product_onsale\";s:11:\"right:10px;\";s:25:\"_css_woo_product_wishlist\";s:15:\"font-size:20px;\";s:25:\"_css_woo_product_qty_down\";s:95:\"color:#1c7e68;background-color:#ffffff;padding:5px 4px 3px;margin-left:-40px;border-radius:4px;\";s:31:\"_css_woo_product_qty_down_hover\";s:25:\"background-color:#ffdd00;\";s:23:\"_css_woo_product_qty_up\";s:113:\"color:#1c7e68;background-color:#ffffff;padding:5px 4px 3px;margin-right:-40px;margin-left:10px;border-radius:4px;\";s:29:\"_css_woo_product_qty_up_hover\";s:25:\"background-color:#ffdd00;\";s:20:\"_css_woo_product_qty\";s:69:\"color:#ffffff;background-color:#1c7e68;width:110px;border-style:none;\";s:28:\"_css_woo_product_add_to_cart\";s:25:\"background-color:#1c7e68;\";s:9:\"post_type\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}s:5:\"share\";a:6:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:9:\"pinterest\";i:3;s:8:\"linkedin\";i:4;s:8:\"whatsapp\";i:5;s:4:\"copy\";}s:15:\"share_box_title\";s:25:\"اشتراک گذاری :\";s:10:\"_css_share\";s:43:\"background-color:#1c7e68;border-radius:5px;\";s:12:\"_css_share_a\";s:100:\"color:#1c7e68;background-color:#ffffff;margin-right:7px;margin-left:7px;border-radius:5px;opacity:1;\";s:19:\"_css_share_a_mobile\";s:33:\"margin-right:3px;margin-left:3px;\";s:18:\"_css_share_a_hover\";s:39:\"color:#000000;background-color:#ffdd00;\";s:16:\"_css_share_title\";s:101:\"font-size:14px;color:rgba(255,255,255,0.6);margin-right:10px;RTLmargin-right:0px;margin-left:10px;RTL\";s:13:\"share_tooltip\";b:1;s:12:\"_css_tooltip\";s:17:\"font-family:dana;\";s:18:\"mobile_menu_social\";b:1;s:16:\"mobile_menu_text\";s:32:\"کپی رایت © [codevz_year]\";s:21:\"_css_mm_text_header_4\";s:33:\"color:#ffffff;margin-bottom:25px;\";s:23:\"_css_mms_icons_header_4\";s:122:\"font-size:20px;background-color:#ffdd00;padding:5px;margin-right:5px;margin-bottom:15px;margin-left:5px;border-radius:5px;\";s:23:\"mobile_fixed_navigation\";b:1;s:29:\"mobile_fixed_navigation_items\";a:2:{i:0;a:4:{s:5:\"title\";s:22:\" تماس بگیرید\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:25:\"fa czico-092-phone-call-1\";s:4:\"link\";s:12:\"tel:09350000\";}i:1;a:4:{s:5:\"title\";s:25:\"مشاوره بگیرید\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:42:\"fa czico-006-speech-bubble-with-text-lines\";s:4:\"link\";s:47:\"https://xtra-moving.tooswp.ir/get-a-free-quote/\";}}s:8:\"_css_mfn\";s:25:\"background-color:#1c7e68;\";s:10:\"_css_mfn_a\";s:37:\"padding-top:20px;padding-bottom:15px;\";s:16:\"_css_mfn_a_hover\";s:34:\"background-color:rgba(0,0,0,0.31);\";s:10:\"_css_mfn_i\";s:71:\"color:#1c7e68;background-color:#ffdd00;padding:10px;border-radius:33px;\";s:29:\"mobile_fixed_navigation_title\";s:31:\"xtra-fixed-mobile-nav-title-row\";s:14:\"_css_mfn_title\";s:49:\"font-size:13px;margin-right:10px;margin-left:0px;\";}", "no");
INSERT INTO `wp_options` VALUES("170", "auto_update_plugins", "a:1:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";}", "no");
INSERT INTO `wp_options` VALUES("171", "RTL-CareUnit-PCS", "C_QLMS5xL440STOMDPcOMPMJy7LUdoyqLDWLMtOP0nfNzjD1DC7wTK6IKC1ztfBLLU5LNXCqyMvMMS4yTvUuSs_XTzQpjcz3dDH10zYwzDcpr_C3cEkOzvF08q4IK7FMqgx2sfRPMXcKyYy0BQA", "no");
INSERT INTO `wp_options` VALUES("175", "widget_codevz_working_hours", "a:3:{i:1;a:28:{s:5:\"title\";s:0:\"\";s:5:\"items\";a:3:{i:0;O:8:\"stdClass\":5:{s:9:\"left_text\";s:16:\"Monday to Friday\";s:10:\"right_text\";s:9:\"8AM - 4PM\";s:3:\"sub\";s:0:\"\";s:5:\"badge\";s:0:\"\";s:4:\"icon\";s:0:\"\";}i:1;O:8:\"stdClass\":5:{s:9:\"left_text\";s:8:\"Saturday\";s:10:\"right_text\";s:9:\"8AM - 1PM\";s:3:\"sub\";s:0:\"\";s:5:\"badge\";s:0:\"\";s:4:\"icon\";s:0:\"\";}i:2;O:8:\"stdClass\":5:{s:9:\"left_text\";s:6:\"Sunday\";s:10:\"right_text\";s:16:\"Support by Email\";s:3:\"sub\";s:0:\"\";s:5:\"badge\";s:0:\"\";s:4:\"icon\";s:0:\"\";}}s:6:\"sk_con\";s:0:\"\";s:13:\"sk_con_tablet\";s:0:\"\";s:13:\"sk_con_mobile\";s:0:\"\";s:7:\"sk_line\";s:79:\"border-style:dashed;border-bottom-width:1px;border-color:rgba(255,255,255,0.2);\";s:14:\"sk_line_tablet\";s:0:\"\";s:14:\"sk_line_mobile\";s:0:\"\";s:7:\"sk_left\";s:0:\"\";s:14:\"sk_left_tablet\";s:0:\"\";s:14:\"sk_left_mobile\";s:0:\"\";s:8:\"sk_right\";s:0:\"\";s:15:\"sk_right_tablet\";s:0:\"\";s:15:\"sk_right_mobile\";s:0:\"\";s:8:\"sk_badge\";s:0:\"\";s:15:\"sk_badge_tablet\";s:0:\"\";s:15:\"sk_badge_mobile\";s:0:\"\";s:6:\"sk_sub\";s:0:\"\";s:13:\"sk_sub_tablet\";s:0:\"\";s:13:\"sk_sub_mobile\";s:0:\"\";s:7:\"sk_icon\";s:0:\"\";s:14:\"sk_icon_tablet\";s:0:\"\";s:14:\"sk_icon_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:2;a:29:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:0:\"\";s:5:\"items\";a:3:{i:0;O:8:\"stdClass\":5:{s:9:\"left_text\";s:30:\"شنبه تا چهارشنبه\";s:10:\"right_text\";s:9:\"8AM - 4PM\";s:3:\"sub\";s:0:\"\";s:5:\"badge\";s:0:\"\";s:4:\"icon\";s:0:\"\";}i:1;O:8:\"stdClass\":5:{s:9:\"left_text\";s:15:\"پنج شنبه\";s:10:\"right_text\";s:9:\"8AM - 1PM\";s:3:\"sub\";s:0:\"\";s:5:\"badge\";s:0:\"\";s:4:\"icon\";s:0:\"\";}i:2;O:8:\"stdClass\":5:{s:9:\"left_text\";s:8:\"جمعه\";s:10:\"right_text\";s:32:\"پشتیبانی با ایمیل\";s:3:\"sub\";s:0:\"\";s:5:\"badge\";s:0:\"\";s:4:\"icon\";s:0:\"\";}}s:6:\"sk_con\";s:0:\"\";s:13:\"sk_con_tablet\";s:0:\"\";s:13:\"sk_con_mobile\";s:0:\"\";s:7:\"sk_line\";s:79:\"border-style:dashed;border-bottom-width:1px;border-color:rgba(255,255,255,0.2);\";s:14:\"sk_line_tablet\";s:0:\"\";s:14:\"sk_line_mobile\";s:0:\"\";s:7:\"sk_left\";s:0:\"\";s:14:\"sk_left_tablet\";s:0:\"\";s:14:\"sk_left_mobile\";s:0:\"\";s:8:\"sk_right\";s:0:\"\";s:15:\"sk_right_tablet\";s:0:\"\";s:15:\"sk_right_mobile\";s:0:\"\";s:8:\"sk_badge\";s:0:\"\";s:15:\"sk_badge_tablet\";s:0:\"\";s:15:\"sk_badge_mobile\";s:0:\"\";s:6:\"sk_sub\";s:0:\"\";s:13:\"sk_sub_tablet\";s:0:\"\";s:13:\"sk_sub_mobile\";s:0:\"\";s:7:\"sk_icon\";s:0:\"\";s:14:\"sk_icon_tablet\";s:0:\"\";s:14:\"sk_icon_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("176", "widget_codevz_stylish_list", "a:7:{i:1;a:26:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:0:\"\";s:5:\"items\";a:4:{i:0;O:8:\"stdClass\":4:{s:5:\"title\";s:10:\"عطرها\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":4:{s:5:\"title\";s:17:\"درباره ما\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":4:{s:5:\"title\";s:14:\"فروشگاه\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":4:{s:5:\"title\";s:12:\"برندها\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:0:\"\";s:10:\"sk_overall\";s:79:\"text-align:center;width:500px;margin-right:auto;margin-left:auto;display:table;\";s:17:\"sk_overall_tablet\";s:0:\"\";s:17:\"sk_overall_mobile\";s:0:\"\";s:8:\"sk_lists\";s:71:\"text-align:center;width:25%;display:inline-block;box-sizing:border-box;\";s:15:\"sk_lists_tablet\";s:0:\"\";s:15:\"sk_lists_mobile\";s:0:\"\";s:14:\"sk_lists_hover\";s:0:\"\";s:11:\"sk_subtitle\";s:0:\"\";s:18:\"sk_subtitle_tablet\";s:0:\"\";s:18:\"sk_subtitle_mobile\";s:0:\"\";s:17:\"sk_subtitle_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"icon_hover_fx\";s:21:\"cz_sl_icon_hover_none\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:2;a:25:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:0:\"\";s:5:\"items\";a:1:{i:0;O:8:\"stdClass\":4:{s:5:\"title\";s:18:\"آدرس شرکت:\";s:8:\"subtitle\";s:64:\"تهران، خیابان آزادی، خیابان بهبودی\";s:4:\"icon\";s:26:\"fa czico-080-placeholder-3\";s:4:\"link\";s:0:\"\";}}s:12:\"default_icon\";s:0:\"\";s:10:\"sk_overall\";s:18:\"text-align:center;\";s:17:\"sk_overall_tablet\";s:0:\"\";s:17:\"sk_overall_mobile\";s:0:\"\";s:8:\"sk_lists\";s:44:\"font-size:14px;color:#e7a98b;display:inline;\";s:15:\"sk_lists_tablet\";s:0:\"\";s:15:\"sk_lists_mobile\";s:18:\"text-align:center;\";s:14:\"sk_lists_hover\";s:0:\"\";s:11:\"sk_subtitle\";s:78:\"font-size:24px;color:#ffffff;font-weight:700;margin-right:20px;display:inline;\";s:18:\"sk_subtitle_tablet\";s:0:\"\";s:18:\"sk_subtitle_mobile\";s:63:\"font-size:20px;text-align:center;margin-left:0px;display:block;\";s:17:\"sk_subtitle_hover\";s:0:\"\";s:8:\"sk_icons\";s:29:\"font-size:30px;color:#ffffff;\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:13:\"display:none;\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"icon_hover_fx\";s:21:\"cz_sl_icon_hover_none\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:3;a:25:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:0:\"\";s:5:\"items\";a:1:{i:0;O:8:\"stdClass\":4:{s:5:\"title\";s:20:\"شماره تماس:\";s:8:\"subtitle\";s:24:\"۰۲۱۱۲۳۴۵۶۷۸٩\";s:4:\"icon\";s:23:\"fa czico-045-smartphone\";s:4:\"link\";s:0:\"\";}}s:12:\"default_icon\";s:0:\"\";s:10:\"sk_overall\";s:18:\"text-align:center;\";s:17:\"sk_overall_tablet\";s:0:\"\";s:17:\"sk_overall_mobile\";s:0:\"\";s:8:\"sk_lists\";s:44:\"font-size:14px;color:#e7a98b;display:inline;\";s:15:\"sk_lists_tablet\";s:0:\"\";s:15:\"sk_lists_mobile\";s:18:\"text-align:center;\";s:14:\"sk_lists_hover\";s:0:\"\";s:11:\"sk_subtitle\";s:78:\"font-size:24px;color:#ffffff;font-weight:700;margin-right:20px;display:inline;\";s:18:\"sk_subtitle_tablet\";s:0:\"\";s:18:\"sk_subtitle_mobile\";s:63:\"font-size:20px;text-align:center;margin-left:0px;display:block;\";s:17:\"sk_subtitle_hover\";s:0:\"\";s:8:\"sk_icons\";s:29:\"font-size:30px;color:#ffffff;\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:13:\"display:none;\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"icon_hover_fx\";s:21:\"cz_sl_icon_hover_none\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:4;a:25:{s:5:\"title\";s:19:\"Contact Information\";s:7:\"content\";s:0:\"\";s:5:\"items\";a:4:{i:0;O:8:\"stdClass\":4:{s:5:\"title\";s:59:\"Our office address 22345, Garden Beach, California, LA, USA\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:27:\"fa czico-082-maps-and-flags\";s:4:\"link\";s:0:\"\";}i:1;O:8:\"stdClass\":4:{s:5:\"title\";s:25:\"Phone: +1 (818) 22 333 44\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:11:\"fa fa-phone\";s:4:\"link\";s:17:\"tel:0018182233344\";}i:2;O:8:\"stdClass\":4:{s:5:\"title\";s:27:\"Email: support@yoursite.com\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:36:\"fa czico-088-envelope-of-white-paper\";s:4:\"link\";s:27:\"mailto:support@yoursite.com\";}i:3;O:8:\"stdClass\":4:{s:5:\"title\";s:20:\"Instagram @xtratheme\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:15:\"fa fa-instagram\";s:4:\"link\";s:31:\"https://instagram.com/xtratheme\";}}s:12:\"default_icon\";s:0:\"\";s:10:\"sk_overall\";s:0:\"\";s:17:\"sk_overall_tablet\";s:0:\"\";s:17:\"sk_overall_mobile\";s:0:\"\";s:8:\"sk_lists\";s:19:\"margin-bottom:25px;\";s:15:\"sk_lists_tablet\";s:0:\"\";s:15:\"sk_lists_mobile\";s:0:\"\";s:14:\"sk_lists_hover\";s:14:\"color:#372e29;\";s:11:\"sk_subtitle\";s:0:\"\";s:18:\"sk_subtitle_tablet\";s:0:\"\";s:18:\"sk_subtitle_mobile\";s:0:\"\";s:17:\"sk_subtitle_hover\";s:0:\"\";s:8:\"sk_icons\";s:130:\"font-size:18px;color:#e7a98b;background-color:#ffffff;margin-right:20px;border-radius:5px;RTLmargin-left:20px;margin-right:0px;RTL\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:39:\"color:#ffffff;background-color:#372e29;\";s:13:\"icon_hover_fx\";s:25:\"cz_sl_icon_hover_absorber\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:5;a:25:{s:5:\"title\";s:8:\"دفتر\";s:7:\"content\";s:0:\"\";s:5:\"items\";a:4:{i:0;O:8:\"stdClass\":4:{s:5:\"title\";s:57:\"تهران، خیابان آزادی، ساختمان 101\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:16:\"fa fa-map-marker\";s:4:\"link\";s:0:\"\";}i:1;O:8:\"stdClass\":4:{s:5:\"title\";s:12:\"021123456789\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:11:\"fa fa-phone\";s:4:\"link\";s:0:\"\";}i:2;O:8:\"stdClass\":4:{s:5:\"title\";s:17:\"newyork@gmail.com\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:4:\"link\";s:0:\"\";}i:3;O:8:\"stdClass\":4:{s:5:\"title\";s:12:\"021123456780\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:9:\"fa fa-fax\";s:4:\"link\";s:0:\"\";}}s:12:\"default_icon\";s:0:\"\";s:10:\"sk_overall\";s:0:\"\";s:17:\"sk_overall_tablet\";s:0:\"\";s:17:\"sk_overall_mobile\";s:0:\"\";s:8:\"sk_lists\";s:0:\"\";s:15:\"sk_lists_tablet\";s:0:\"\";s:15:\"sk_lists_mobile\";s:0:\"\";s:14:\"sk_lists_hover\";s:0:\"\";s:11:\"sk_subtitle\";s:0:\"\";s:18:\"sk_subtitle_tablet\";s:0:\"\";s:18:\"sk_subtitle_mobile\";s:0:\"\";s:17:\"sk_subtitle_hover\";s:0:\"\";s:8:\"sk_icons\";s:144:\"font-size:16px;color:#ffffff;background-color:transparent;background-image:linear-gradient(0deg,#f99131,#f9b431);padding:5px;border-radius:99px;\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:99:\"color:#f99131;background-color:transparent;background-image:linear-gradient(90deg,#333333,#333333);\";s:13:\"icon_hover_fx\";s:21:\"cz_sl_icon_hover_none\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:6;a:25:{s:5:\"title\";s:23:\"اطلاعات تماس\";s:7:\"content\";s:0:\"\";s:5:\"items\";a:4:{i:0;O:8:\"stdClass\":4:{s:5:\"title\";s:109:\"آدرس دفتر ما: تهران، خیابان آزادی، خیابان بهبودی، ساختمان 101\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:27:\"fa czico-082-maps-and-flags\";s:4:\"link\";s:0:\"\";}i:1;O:8:\"stdClass\":4:{s:5:\"title\";s:22:\"تلفن: 021123456789\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:11:\"fa fa-phone\";s:4:\"link\";s:17:\"tel:0018182233344\";}i:2;O:8:\"stdClass\":4:{s:5:\"title\";s:32:\"ایمیل: support@yoursite.com\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:36:\"fa czico-088-envelope-of-white-paper\";s:4:\"link\";s:27:\"mailto:support@yoursite.com\";}i:3;O:8:\"stdClass\":4:{s:5:\"title\";s:34:\"اینستاگرام @xtratheme_ir\";s:8:\"subtitle\";s:0:\"\";s:4:\"icon\";s:15:\"fa fa-instagram\";s:4:\"link\";s:34:\"https://instagram.com/xtratheme_ir\";}}s:12:\"default_icon\";s:0:\"\";s:10:\"sk_overall\";s:0:\"\";s:17:\"sk_overall_tablet\";s:0:\"\";s:17:\"sk_overall_mobile\";s:0:\"\";s:8:\"sk_lists\";s:19:\"margin-bottom:25px;\";s:15:\"sk_lists_tablet\";s:0:\"\";s:15:\"sk_lists_mobile\";s:0:\"\";s:14:\"sk_lists_hover\";s:0:\"\";s:11:\"sk_subtitle\";s:0:\"\";s:18:\"sk_subtitle_tablet\";s:0:\"\";s:18:\"sk_subtitle_mobile\";s:0:\"\";s:17:\"sk_subtitle_hover\";s:0:\"\";s:8:\"sk_icons\";s:72:\"font-size:18px;color:#285bbb;background-color:#ffffff;border-radius:5px;\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:39:\"color:#ffffff;background-color:#1c9dbf;\";s:13:\"icon_hover_fx\";s:25:\"cz_sl_icon_hover_absorber\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("177", "widget_codevz_social_icons", "a:2:{i:1;a:26:{s:5:\"title\";s:0:\"\";s:6:\"social\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"فیس بوک\";s:4:\"icon\";s:14:\"fa fa-facebook\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"توییتر\";s:4:\"icon\";s:13:\"fa fa-twitter\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:15:\"fa fa-instagram\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"پین ترست\";s:4:\"icon\";s:17:\"fa fa-pinterest-p\";s:4:\"link\";s:1:\"#\";}}s:8:\"position\";s:3:\"tac\";s:7:\"tooltip\";s:24:\"cz_tooltip cz_tooltip_up\";s:2:\"fx\";s:14:\"cz_social_fx_0\";s:10:\"color_mode\";s:0:\"\";s:6:\"sk_con\";s:0:\"\";s:13:\"sk_con_tablet\";s:0:\"\";s:13:\"sk_con_mobile\";s:0:\"\";s:8:\"sk_icons\";s:233:\"font-size:16px;color:#7f44c9;background-color:#ffffff;padding:8px;margin-right:5px;margin-left:5px;border-style:solid;border-width:0px 0px 3px;border-color:#ff98b4;border-radius:55px;box-shadow:0px 5px 25px 0px rgba(127,68,201,0.25);\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:79:\"color:#ffffff;background-color:#7f44c9;border-style:solid;border-color:#ff98b4;\";s:13:\"sk_inner_icon\";s:0:\"\";s:20:\"sk_inner_icon_tablet\";s:0:\"\";s:20:\"sk_inner_icon_mobile\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("178", "widget_codevz_custom_menu_list", "a:20:{i:1;a:11:{s:5:\"title\";s:12:\"Useful links\";s:5:\"items\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"About Us\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"Our Services\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"Recent Projects\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"Technology\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:17:\"fa fa-angle-right\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:2;a:11:{s:5:\"title\";s:9:\"Resources\";s:5:\"items\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:5:\"Forum\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"Knowledge Base\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:9:\"Wikipedia\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:9:\"Resources\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:4:\"News\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:17:\"fa fa-angle-right\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:3;a:11:{s:5:\"title\";s:10:\"Contact Us\";s:5:\"items\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:9:\"Live Chat\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"Contact \";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"Social Networks\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:9:\"Locations\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:17:\"fa fa-angle-right\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:4;a:11:{s:5:\"title\";s:11:\"Quick Links\";s:5:\"items\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"Contact Us\";s:4:\"icon\";s:25:\"fa czico-092-phone-call-1\";s:4:\"link\";s:44:\"https://xtratheme.com/industrial/contact-us/\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:7:\"Support\";s:4:\"icon\";s:20:\"fa czico-078-support\";s:4:\"link\";s:26:\"https://codevz.ticksy.com/\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Online Documentation\";s:4:\"icon\";s:17:\"fa czico-075-news\";s:4:\"link\";s:29:\"http://theme.support/doc/xtra\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:19:\"Industrial Services\";s:4:\"icon\";s:20:\"fa czico-041-physics\";s:4:\"link\";s:41:\"https://xtratheme.com/industrial/services\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"About Our Factory\";s:4:\"icon\";s:21:\"fa czico-112-location\";s:4:\"link\";s:38:\"https://xtratheme.com/industrial/about\";}}s:12:\"default_icon\";s:0:\"\";s:8:\"sk_icons\";s:125:\"color:#ffffff;background-color:#ff7700;padding:10px;margin-bottom:8px;margin-left:20px;RTLmargin-left:0;margin-right:20px;RTL\";s:14:\"sk_icons_hover\";s:98:\"background-color:#1d1d1d;margin-bottom:8px;margin-left:30px;RTLmargin-left:0;margin-right:30px;RTL\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:5;a:12:{s:5:\"title\";s:19:\"منو سفارشی\";s:5:\"items\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"صفحه اصلی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"کتاب ها\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"مجموعه\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"دسته بندی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:6;a:12:{s:5:\"title\";s:16:\"پشتیبانی\";s:5:\"items\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"سوالات متداول\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"قوانین\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"سیاست ها و قوانین\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"گزارش\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:7;a:12:{s:5:\"title\";s:17:\"درباره ما\";s:5:\"items\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"شرکا\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"چشم اندز\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:18:\"تماس با ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:8;a:11:{s:5:\"title\";s:12:\"Useful links\";s:5:\"items\";a:9:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"Support Medical\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:16:\"Arts in Medicine\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Modern Facilities\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Simulation Center\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"Like Our Website?\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"Our Mission & Values\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:6;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"Centers of Excellence\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:7;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"Policies & Procedures\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:8;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"Health Care Professionals\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}}s:12:\"default_icon\";s:21:\"fa czico-107-web-link\";s:8:\"sk_icons\";s:14:\"color:#372e29;\";s:14:\"sk_icons_hover\";s:33:\"margin-right:8px;margin-left:8px;\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:9;a:11:{s:5:\"title\";s:21:\"درباره شرکت\";s:5:\"items\";a:6:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:16:\"پشتیبانی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:19:\"مرکز منابع\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"ابزار تجارت\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:18:\"تماس با ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"کتابخانه منابع\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:37:\"fa czico-Icon-Navigation-Chevron-Left\";s:8:\"sk_icons\";s:40:\"font-size:17px;color:rgba(44,49,58,0.3);\";s:14:\"sk_icons_hover\";s:14:\"color:#2c313a;\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:10;a:11:{s:5:\"title\";s:21:\"دسترسی سریع\";s:5:\"items\";a:6:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"حساب کاربری\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"خدمات\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:38:\"راهنمای سرمایه گذاری\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"مشاغل\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"شرکت وکلا\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"بررسی ها\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:37:\"fa czico-Icon-Navigation-Chevron-Left\";s:8:\"sk_icons\";s:40:\"font-size:17px;color:rgba(44,49,58,0.3);\";s:14:\"sk_icons_hover\";s:14:\"color:#2c313a;\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:11;a:11:{s:5:\"title\";s:18:\"تماس با ما\";s:5:\"items\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"عمومی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"خبرنامه\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"منابع\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"مشاوره رایگان\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:12;a:11:{s:5:\"title\";s:24:\"لینک های مفید\";s:5:\"items\";a:14:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:6:\"تیم\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"شبکه های اجتماعی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"نقشه ها\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"اخبار\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"مشاغل\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:6;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"تماس برگشتی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:7;O:8:\"stdClass\":3:{s:5:\"title\";s:11:\"خط مشی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:8;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"تحقیق\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:9;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"راهنمای تجارت\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:10;O:8:\"stdClass\":3:{s:5:\"title\";s:18:\"تماس با ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:11;O:8:\"stdClass\":3:{s:5:\"title\";s:16:\"رویدادها\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:12;O:8:\"stdClass\":3:{s:5:\"title\";s:24:\"شرایط و ضوابط\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:13;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"تماس\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:6:\"col s6\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:13;a:11:{s:5:\"title\";s:26:\"لینک های بیشتر\";s:5:\"items\";a:8:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:18:\"تماس با ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"مشاغل\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"سوالات متداول\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"نرخ نامه ها\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:16:\"پشتیبانی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:6;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"خدمات\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:7;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"نظرات مشتریان\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:21:\"fa czico-107-web-link\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:14;a:11:{s:5:\"title\";s:10:\"خدمات\";s:5:\"items\";a:7:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"سئوی محلی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:33:\"بازاریابی اجتماعی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:25:\"تبلیغات کلیکی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:41:\"بهینه سازی موتور جستجو\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"آنالیز رایگان سئو\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"سئوی آفلاین\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:6;O:8:\"stdClass\":3:{s:5:\"title\";s:19:\"سئوی تجاری\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:21:\"fa czico-107-web-link\";s:8:\"sk_icons\";s:15:\"font-size:14px;\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:15;a:11:{s:5:\"title\";s:24:\"لینک های مفید\";s:5:\"items\";a:8:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:37:\"ماموریت و ارزشهای ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"سیاست ها و رویه ها\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:22:\"هنر در پزشکی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:23:\"امکانات مدرن\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:31:\"مانند وب سایت ما؟\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"مرکز شبیه سازی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:6;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"مراکز رشد\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}i:7;O:8:\"stdClass\":3:{s:5:\"title\";s:49:\"متخصصان مراقبت های بهداشتی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:0:\"\";}}s:12:\"default_icon\";s:16:\"fa fa-caret-left\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:16;a:11:{s:5:\"title\";s:24:\"لینک های مفید\";s:5:\"items\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:15:\"خدمات ما\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:26:\"پروژه های اخیر\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"محصولات\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:16:\"تکنولوژی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:16:\"fa fa-angle-left\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:17;a:11:{s:5:\"title\";s:10:\"منابع\";s:5:\"items\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"فروم\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"دانش محور\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:16:\"ویکیپدیا\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"منابع\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:10:\"اخبار\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:16:\"fa fa-angle-left\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:18;a:11:{s:5:\"title\";s:18:\"تماس با ما\";s:5:\"items\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"گفتگوی زنده\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"تماس\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:30:\"شبکه های اجتماعی\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:13:\"مکان ها\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:17:\"نقشه سایت\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";}}s:12:\"default_icon\";s:16:\"fa fa-angle-left\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:19;a:11:{s:5:\"title\";s:21:\"دسترسی سریع\";s:5:\"items\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:18:\"تماس با ما\";s:4:\"icon\";s:25:\"fa czico-092-phone-call-1\";s:4:\"link\";s:41:\"https://xtra-moving.tooswp.ir/contact-us/\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:16:\"پشتیبانی\";s:4:\"icon\";s:20:\"fa czico-078-support\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:27:\"مستندات آنلاین\";s:4:\"icon\";s:17:\"fa czico-075-news\";s:4:\"link\";s:34:\"https://xtratheme.ir/documentation\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:21:\"خدمات صنعتی\";s:4:\"icon\";s:20:\"fa czico-041-physics\";s:4:\"link\";s:39:\"https://xtra-moving.tooswp.ir/services/\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:32:\"درباره کارخانه ما\";s:4:\"icon\";s:21:\"fa czico-112-location\";s:4:\"link\";s:39:\"https://xtra-moving.tooswp.ir/about-us/\";}}s:12:\"default_icon\";s:0:\"\";s:8:\"sk_icons\";s:88:\"color:#ffffff;background-color:#ee0000;padding:10px;margin-right:20px;margin-bottom:8px;\";s:14:\"sk_icons_hover\";s:61:\"background-color:#1d1d1d;margin-right:30px;margin-bottom:8px;\";s:7:\"columns\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("179", "widget_codevz_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("180", "widget_codevz_about", "a:22:{i:1;a:30:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:67:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2021/10/logo2x.png\";s:9:\"logo_size\";s:5:\"210px\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:20:\"margin-bottom:-30px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:2;a:30:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:65:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2021/10/img6.jpg\";s:9:\"logo_size\";s:5:\"400px\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:19:\"margin-bottom:20px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:3;a:29:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:67:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2021/03/logo-2.png\";s:9:\"logo_size\";s:5:\"200px\";s:7:\"content\";s:187:\"از همین الان نوبت خود را رزرو کنید! <strong><span style=\"font-family: iranyekan;\">4455 333 (800) 1</span><span style=\"font-family: iranyekan;\">+</span></strong>\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:29:\"font-size:24px;color:#7f44c9;\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:4:\"czsk\";s:36:\"margin-top:10px;margin-bottom:-35px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:4;a:31:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2021/09/logo2.png\";s:9:\"logo_size\";s:5:\"170px\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"Facebook\";s:4:\"icon\";s:17:\"fab fa-facebook-f\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:7:\"Twitter\";s:4:\"icon\";s:14:\"fab fa-twitter\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:9:\"Instagram\";s:4:\"icon\";s:16:\"fab fa-instagram\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:7:\"YouTube\";s:4:\"icon\";s:14:\"fab fa-youtube\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:134:\"font-size:16px;color:#ffffff;margin-right:5px;margin-left:5px;border-style:solid;border-width:1px;border-color:rgba(234,234,234,0.15);\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:19:\"margin-bottom:50px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:5;a:30:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tar\";s:4:\"logo\";s:75:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2021/09/logo-book-shop.png\";s:9:\"logo_size\";s:5:\"160px\";s:7:\"content\";s:178:\"\"همان باشید که هستید و آنچه را که احساس می کنید بگویید ، زیرا کسانی که اهمیت می دهند اهمیتی ندارند .\"\";s:6:\"button\";s:12:\"برنارد\";s:11:\"button_link\";s:1:\"#\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:26:\"cz_social_colored_bg_hover\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:71:\"color:#758bfd;font-weight:400;background-color:transparent;padding:0px;\";s:15:\"sk_button_hover\";s:30:\"color:#000000;font-weight:500;\";s:8:\"sk_icons\";s:125:\"font-size:20px;color:#ffffff;background-color:rgba(0,0,0,0.2);padding:8px;margin-top:20px;margin-right:4px;border-radius:3px;\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:39:\"color:#ffffff;background-color:#758bfd;\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:18:\"border-style:none;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:6;a:29:{s:5:\"title\";s:17:\"درباره ما\";s:8:\"position\";s:3:\"tal\";s:4:\"logo\";s:0:\"\";s:9:\"logo_size\";s:0:\"\";s:7:\"content\";s:6:\"تست\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:7;a:30:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tar\";s:4:\"logo\";s:65:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2020/10/logo.png\";s:9:\"logo_size\";s:5:\"220px\";s:7:\"content\";s:364:\"اینکو در حال بازتعریف بازار خریدهای تجاری توسط کشف ، یادگیری به طور چشمگیری برای خریداران آسان تر است اطلاعات بیشتر در مورد ، مقایسه و خرید محصولات و خدمات آنها نیاز به راه اندازی و رشد تجارت خود دارند.\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"فیسبوک\";s:4:\"icon\";s:17:\"fab fa-facebook-f\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"توئیتر\";s:4:\"icon\";s:14:\"fab fa-twitter\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:16:\"fab fa-instagram\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"تلگرام\";s:4:\"icon\";s:15:\"fab fa-telegram\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"آپارات\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:14:\"cz_social_fx_0\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:24:\"cz_tooltip cz_tooltip_up\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:73:\"font-size:15px;color:rgba(44,49,58,0.51);font-weight:300;line-height:1.8;\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:120:\"color:#e5deda;background-color:#2c313a;padding:5px 2px;margin-right:7px;box-shadow:0px 5px 15px 0px rgba(44,49,58,0.17);\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:39:\"color:#2c313a;background-color:#ffffff;\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:8;a:29:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:72:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2020/11/logo-crypto.png\";s:9:\"logo_size\";s:5:\"200px\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:4:\"czsk\";s:35:\"margin-top:50px;margin-bottom:60px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:15:\"margin-top:0px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:9;a:30:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:0:\"\";s:9:\"logo_size\";s:0:\"\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"فیسبوک\";s:4:\"icon\";s:16:\"fa fa-facebook-f\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"توئیتر\";s:4:\"icon\";s:13:\"fa fa-twitter\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:15:\"fa fa-instagram\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"آپارات\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:15:\"cz_social_fx_10\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:186:\"font-size:24px;color:#5cbe2d;background-color:#ffffff;padding:12px;margin-right:15px;margin-bottom:20px;margin-left:15px;border-radius:99px;box-shadow:0px 10px 30px 0px rgba(0,0,0,0.12);\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:61:\"font-size:20px;padding:10px;margin-right:8px;margin-left:8px;\";s:14:\"sk_icons_hover\";s:39:\"color:#ffffff;background-color:#5cbe2d;\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:18:\"margin-bottom:0px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:10;a:27:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:85:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2020/01/footer-logo-construction.png\";s:9:\"logo_size\";s:5:\"270px\";s:7:\"content\";s:353:\"یک شرکت هر موجودیتی است که به تجارت مشغول است.<br />Cشرکتهای مختلفی می توانند به روشهای مختلفی ساخته شوند. <br />به عنوان مثال ، شرکت شما می تواند یک مالکیت انحصاری باشد ،<br /> مشارکت یا شرکتی یا هولدینگ.\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"فیسبوک\";s:4:\"icon\";s:14:\"fa fa-facebook\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"توئیتر\";s:4:\"icon\";s:13:\"fa fa-twitter\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:15:\"fa fa-instagram\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"لینکدین\";s:4:\"icon\";s:14:\"fa fa-linkedin\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"یوتیوب\";s:4:\"icon\";s:18:\"fa fa-youtube-play\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:14:\"cz_social_fx_6\";s:10:\"color_mode\";s:26:\"cz_social_colored_bg_hover\";s:7:\"tooltip\";s:24:\"cz_tooltip cz_tooltip_up\";s:7:\"sk_logo\";s:19:\"margin-bottom:50px;\";s:10:\"sk_content\";s:34:\"font-size:20px;margin-bottom:50px;\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:133:\"font-size:20px;color:#243344;background-color:#f4c03b;padding:8px;margin-top:20px;margin-right:4px;margin-left:4px;border-radius:0px;\";s:14:\"sk_icons_hover\";s:39:\"color:#f4c03b;background-color:#243344;\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:10:\"sk_tooltip\";s:72:\"font-size:14px;color:#243344;background-color:#f4c03b;padding:10px 20px;\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:11;a:27:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tar\";s:4:\"logo\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2019/12/logo2.png\";s:9:\"logo_size\";s:5:\"140px\";s:7:\"content\";s:287:\"یک شرکت هر موجودیتی است که به تجارت مشغول است. شرکت ها را می توان به روش های مختلف ساخت. به عنوان مثال ، شرکت شما می تواند یک مالکیت شخصی ، مشارکت یا یک شرکت باشد.\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"فیسبوک\";s:4:\"icon\";s:14:\"fa fa-facebook\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"توئیتر\";s:4:\"icon\";s:13:\"fa fa-twitter\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"لینکدین\";s:4:\"icon\";s:14:\"fa fa-linkedin\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"آپارات\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:14:\"cz_social_fx_0\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:35:\"margin-top:30px;margin-bottom:40px;\";s:10:\"sk_content\";s:31:\"font-size:16px;line-height:1.4;\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:196:\"color:#ffffff;background-color:transparent;background-image:linear-gradient(0deg,#f99131,#f9b431);padding:5px;margin-right:10px;border-radius:99px;box-shadow:0px 0px 15px 0px rgba(249,145,49,0.2);\";s:14:\"sk_icons_hover\";s:115:\"color:#f99131;background-color:transparent;background-image:linear-gradient(90deg,#333333,#333333);margin-left:0px;\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:10:\"sk_tooltip\";s:0:\"\";s:4:\"czsk\";s:56:\"background-position:center center;background-size:cover;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:12;a:30:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tar\";s:4:\"logo\";s:65:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2020/11/logo.png\";s:9:\"logo_size\";s:5:\"180px\";s:7:\"content\";s:287:\"یک شرکت هر موجودیتی است که به تجارت مشغول است. شرکت ها را می توان به روش های مختلف ساخت. به عنوان مثال ، شرکت شما می تواند یک مالکیت شخصی ، مشارکت یا یک شرکت باشد.\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:6:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"فیسبوک\";s:4:\"icon\";s:14:\"fa fa-facebook\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"توئیتر\";s:4:\"icon\";s:13:\"fa fa-twitter\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:15:\"fa fa-instagram\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:14:\"لینکدین\";s:4:\"icon\";s:14:\"fa fa-linkedin\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"یوتیوب\";s:4:\"icon\";s:18:\"fa fa-youtube-play\";s:4:\"link\";s:1:\"#\";}i:5;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"آپارات\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:26:\"cz_social_colored_bg_hover\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:125:\"font-size:20px;color:#ffffff;background-color:rgba(0,0,0,0.2);padding:8px;margin-top:20px;margin-right:4px;border-radius:3px;\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:39:\"color:#ffffff;background-color:#0ca684;\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:13;a:24:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tar\";s:4:\"logo\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2019/12/logo2.png\";s:9:\"logo_size\";s:5:\"130px\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:15:\"margin-top:5px;\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:10:\"sk_tooltip\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:14;a:24:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:65:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2019/11/logo.png\";s:9:\"logo_size\";s:5:\"220px\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:16:\"margin-top:50px;\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:10:\"sk_tooltip\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:15;a:25:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:0:\"\";s:9:\"logo_size\";s:0:\"\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"Facebook\";s:4:\"icon\";s:16:\"fa fa-facebook-f\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:7:\"Twitter\";s:4:\"icon\";s:13:\"fa fa-twitter\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:8:\"Linkedin\";s:4:\"icon\";s:14:\"fa fa-linkedin\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:9:\"Instagram\";s:4:\"icon\";s:15:\"fa fa-instagram\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:15:\"cz_social_fx_10\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:186:\"font-size:24px;color:#7e32dc;background-color:#ffffff;padding:12px;margin-right:15px;margin-bottom:20px;margin-left:15px;border-radius:99px;box-shadow:0px 10px 30px 0px rgba(0,0,0,0.12);\";s:14:\"sk_icons_hover\";s:39:\"color:#ffffff;background-color:#bc44dd;\";s:8:\"sk_title\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:10:\"sk_tooltip\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:16;a:22:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tar\";s:4:\"logo\";s:79:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2019/09/medical-logo-white.png\";s:9:\"logo_size\";s:5:\"160px\";s:7:\"content\";s:335:\"قالب اکسترا وردپرس، از ویژگی های باورنکردنی و پشتیبانی دوستانه بسیار قدرتمند و آسان برای استفاده است.\r\n<br /><br />\r\nساعات کاری:<br />\r\nشنبه - چهارشنبه ………… 8AM – 7PM\r\nپنج شنبه - جمعه ………… 8AM – 13PM\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"sk_logo\";s:19:\"margin-bottom:50px;\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:17;a:31:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tar\";s:4:\"logo\";s:72:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2020/11/logo-footer.png\";s:9:\"logo_size\";s:5:\"130px\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:3:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"021123456789\";s:4:\"icon\";s:25:\"fa czico-092-phone-call-1\";s:4:\"link\";s:16:\"tel:001800123456\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"info@inco.industrial\";s:4:\"icon\";s:21:\"fa czico-094-envelope\";s:4:\"link\";s:27:\"mailto:info@inco.industrial\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:64:\"تهران، خیابان آزادی، خیابان بهبودی\";s:4:\"icon\";s:26:\"fa czico-083-placeholder-1\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:12:\"inline_title\";s:1:\"1\";s:7:\"sk_logo\";s:20:\"margin-bottom:100px;\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:112:\"font-size:26px;color:#ee0000;text-align:left;margin-bottom:5px;margin-left:-15px;display:block;text-align:right;\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:70:\"font-size:18px;color:#ffffff;font-family:sc_Anjoman;margin-right:15px;\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:4:\"czsk\";s:165:\"background-size:cover;background-image:url(https://xtra-moving.tooswp.ir/wp-content/uploads/2019/09/bg4.jpg);padding:80px 80px 160px;margin:-180px -15px -150px 50px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:46:\"padding:50px 30px 80px;margin:-150px 0px 30px;\";s:14:\"hide_on_mobile\";s:0:\"\";}i:18;a:21:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:74:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2019/09/logo-plumbing.png\";s:9:\"logo_size\";s:5:\"214px\";s:7:\"content\";s:254:\"<p style=\"margin-bottom: 6px;\"><span>شماره تماس: <a style=\"font-size:22px;color:#0a315e;font-weight: 700;\" href=\"tel:0018182333456\">021123456789</a></span></p>\r\n<p><span>تهران، خیابان آزادی، خیابان بهبودی</span></p>\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"فیسبوک\";s:4:\"icon\";s:14:\"fa fa-facebook\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"توئیتر\";s:4:\"icon\";s:13:\"fa fa-twitter\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:15:\"fa fa-instagram\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"اسکایپ\";s:4:\"icon\";s:11:\"fa fa-skype\";s:4:\"link\";s:1:\"#\";}i:4;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"آپارات\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:14:\"cz_social_fx_9\";s:10:\"color_mode\";s:23:\"cz_social_colored_hover\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:45:\"font-size:22px;color:#0a315e;font-weight:300;\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:104:\"font-size:26px;color:#0a315e;padding:8px 4px 8px 2px;margin-right:5px;margin-left:5px;border-radius:0px;\";s:14:\"sk_icons_hover\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:19;a:21:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tac\";s:4:\"logo\";s:67:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2019/07/logo-b.png\";s:9:\"logo_size\";s:5:\"180px\";s:7:\"content\";s:85:\"تهران، خیابان آزادی، خیابان بهبودی، ساختمان 101\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"فیسبوک\";s:4:\"icon\";s:14:\"fa fa-facebook\";s:4:\"link\";s:1:\"#\";}i:1;O:8:\"stdClass\":3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:15:\"fa fa-instagram\";s:4:\"link\";s:1:\"#\";}i:2;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"یوتیوب\";s:4:\"icon\";s:18:\"fa fa-youtube-play\";s:4:\"link\";s:1:\"#\";}i:3;O:8:\"stdClass\":3:{s:5:\"title\";s:12:\"آپارات\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:14:\"cz_social_fx_9\";s:10:\"color_mode\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:0:\"\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:135:\"font-size:20px;line-height:44px;background-color:rgba(255,255,255,0.2);padding:4px;margin-right:5px;margin-left:5px;border-radius:99px;\";s:14:\"sk_icons_hover\";s:39:\"color:#576999;background-color:#81d6dd;\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:20;a:33:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tar\";s:4:\"logo\";s:65:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2023/05/logo.png\";s:9:\"logo_size\";s:5:\"200px\";s:7:\"content\";s:0:\"\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:6:\"social\";a:2:{i:0;a:3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:16:\"fab fa-instagram\";s:4:\"link\";s:1:\"#\";}i:1;a:3:{s:5:\"title\";s:12:\"آپارات\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}}s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:15:\"font-size:22px;\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:95:\"margin-right:10px;border-style:solid;border-width:1px;border-color:#ffdd00;border-radius:100px;\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";s:17:\"hide_widget_title\";s:0:\"\";s:12:\"unbox_widget\";s:0:\"\";}i:21;a:32:{s:5:\"title\";s:0:\"\";s:8:\"position\";s:3:\"tal\";s:4:\"logo\";s:0:\"\";s:9:\"logo_size\";s:0:\"\";s:7:\"content\";s:75:\"تماس با ما: <b> 093500000</b>\r\n[br]\r\nمشهد-توس وردپرس\r\n\";s:6:\"button\";s:0:\"\";s:11:\"button_link\";s:0:\"\";s:2:\"fx\";s:0:\"\";s:10:\"color_mode\";s:0:\"\";s:7:\"tooltip\";s:0:\"\";s:7:\"sk_logo\";s:0:\"\";s:10:\"sk_content\";s:45:\"font-size:18px;line-height:3;margin-top:20px;\";s:9:\"sk_button\";s:0:\"\";s:15:\"sk_button_hover\";s:0:\"\";s:8:\"sk_icons\";s:0:\"\";s:15:\"sk_icons_tablet\";s:0:\"\";s:15:\"sk_icons_mobile\";s:0:\"\";s:14:\"sk_icons_hover\";s:0:\"\";s:13:\"sk_inner_icon\";s:0:\"\";s:19:\"sk_inner_icon_hover\";s:0:\"\";s:8:\"sk_title\";s:0:\"\";s:15:\"sk_title_tablet\";s:0:\"\";s:15:\"sk_title_mobile\";s:0:\"\";s:14:\"sk_title_hover\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";s:17:\"hide_widget_title\";s:0:\"\";s:12:\"unbox_widget\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("181", "widget_codevzfacebook", "a:1:{s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("182", "widget_codevzflickr", "a:6:{i:1;a:12:{s:5:\"title\";s:18:\"Flickr Photostream\";s:2:\"id\";s:11:\"7388060@N08\";s:6:\"number\";s:1:\"9\";s:4:\"type\";s:4:\"user\";s:8:\"shorting\";s:6:\"latest\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:2;a:12:{s:5:\"title\";s:10:\"فلیکر\";s:2:\"id\";s:11:\"7388060@N08\";s:6:\"number\";s:1:\"9\";s:4:\"type\";s:4:\"user\";s:8:\"shorting\";s:6:\"latest\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:3;a:12:{s:5:\"title\";s:24:\"پست های فلیکر\";s:2:\"id\";s:11:\"7388060@N08\";s:6:\"number\";s:1:\"9\";s:4:\"type\";s:4:\"user\";s:8:\"shorting\";s:6:\"latest\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:4;a:12:{s:5:\"title\";s:24:\"پست های فلیکر\";s:2:\"id\";s:11:\"7388060@N08\";s:6:\"number\";s:1:\"9\";s:4:\"type\";s:4:\"user\";s:8:\"shorting\";s:6:\"latest\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:5;a:10:{s:5:\"title\";s:24:\"پست های فلیکر\";s:2:\"id\";s:11:\"7388060@N08\";s:6:\"number\";s:1:\"9\";s:4:\"type\";s:4:\"user\";s:8:\"shorting\";s:6:\"latest\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("183", "widget_codevzcustommenulist", "a:4:{i:1;a:16:{s:5:\"title\";s:0:\"\";s:4:\"menu\";s:9:\"secondary\";s:22:\"disable_default_styles\";s:1:\"1\";s:5:\"style\";s:1:\"1\";s:12:\"sk_container\";s:18:\"text-align:center;\";s:19:\"sk_container_mobile\";s:0:\"\";s:19:\"sk_container_tablet\";s:0:\"\";s:8:\"sk_menus\";s:191:\"font-size:18px;color:rgba(0,0,0,0.5);font-weight:500;padding:2px 0px 5px;margin-top:0px;margin-right:20px;margin-left:20px;border-style:solid;border-bottom-width:2px;border-color:transparent;\";s:15:\"sk_menus_mobile\";s:66:\"font-size:16px;line-height:2.8;margin-right:10px;margin-left:10px;\";s:15:\"sk_menus_tablet\";s:0:\"\";s:14:\"sk_menus_hover\";s:54:\"color:#000000;border-style:solid;border-color:#5cbe2d;\";s:4:\"czsk\";s:19:\"margin-bottom:20px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:2;a:16:{s:5:\"title\";s:0:\"\";s:4:\"menu\";s:6:\"footer\";s:22:\"disable_default_styles\";s:1:\"1\";s:5:\"style\";s:1:\"1\";s:12:\"sk_container\";s:47:\"margin-top:20px;margin-right:-20px;float:right;\";s:19:\"sk_container_mobile\";s:0:\"\";s:19:\"sk_container_tablet\";s:0:\"\";s:8:\"sk_menus\";s:83:\"color:#443178;padding:10px 20px;margin-right:0px;margin-left:0px;border-style:none;\";s:15:\"sk_menus_mobile\";s:0:\"\";s:15:\"sk_menus_tablet\";s:0:\"\";s:14:\"sk_menus_hover\";s:60:\"color:#ffffff;background-color:#443178;border-color:#ffffff;\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:3;a:16:{s:5:\"title\";s:0:\"\";s:4:\"menu\";s:9:\"secondary\";s:22:\"disable_default_styles\";s:1:\"1\";s:5:\"style\";s:1:\"1\";s:12:\"sk_container\";s:18:\"text-align:center;\";s:19:\"sk_container_mobile\";s:0:\"\";s:19:\"sk_container_tablet\";s:0:\"\";s:8:\"sk_menus\";s:169:\"font-size:20px;font-weight:500;padding:2px 0px 5px;margin-top:0px;margin-right:20px;margin-left:20px;border-style:solid;border-bottom-width:2px;border-color:transparent;\";s:15:\"sk_menus_mobile\";s:0:\"\";s:15:\"sk_menus_tablet\";s:0:\"\";s:14:\"sk_menus_hover\";s:54:\"color:#7e32dc;border-style:solid;border-color:#bc44dd;\";s:4:\"czsk\";s:15:\"margin-top:0px;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("184", "widget_codevzcustommenulist2", "a:14:{i:1;a:18:{s:5:\"title\";s:8:\"Products\";s:7:\"title_1\";s:13:\"Control Panel\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:17:\"Dedicated Hosting\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:15:\"Domain Transfer\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:10:\"Technology\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:14:\"Shared Hosting\";s:6:\"link_5\";s:1:\"#\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:2;a:18:{s:5:\"title\";s:10:\"Contact Us\";s:7:\"title_1\";s:17:\"General enquiries\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:19:\"E-newsletter Signup\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:13:\"Get resources\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:19:\"Schedule a callback\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:3;a:42:{s:5:\"title\";s:12:\"Quick Access\";s:7:\"title_1\";s:10:\"Contact Us\";s:6:\"link_1\";s:40:\"https://codevz.com/demo/heks/contact-us/\";s:7:\"title_2\";s:7:\"Support\";s:6:\"link_2\";s:26:\"https://codevz.ticksy.com/\";s:7:\"title_3\";s:20:\"Online Documentation\";s:6:\"link_3\";s:29:\"http://theme.support/doc/heks\";s:7:\"title_4\";s:12:\"Purchase Now\";s:6:\"link_4\";s:35:\"https://themeforest.net/user/codevz\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:4;a:42:{s:5:\"title\";s:10:\"My Account\";s:7:\"title_1\";s:7:\"My Info\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:8:\"My Order\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:11:\"My Wishlist\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:6:\"Logout\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:5;a:42:{s:5:\"title\";s:8:\"Contact \";s:7:\"title_1\";s:10:\"Contact Us\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:8:\"Location\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:10:\"Help & FAQ\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:12:\"Contact Form\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:6;a:42:{s:5:\"title\";s:11:\"Information\";s:7:\"title_1\";s:8:\"About Us\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:7:\"History\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:12:\"Organization\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:11:\"Who We Are?\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:7;a:38:{s:5:\"title\";s:8:\"Products\";s:7:\"title_1\";s:13:\"Control Panel\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:17:\"Dedicated Hosting\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:15:\"Domain Transfer\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:10:\"Technology\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:8;a:38:{s:5:\"title\";s:10:\"Contact Us\";s:7:\"title_1\";s:7:\"General\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:10:\"Newsletter\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:13:\"Get resources\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:19:\"Schedule a callback\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:9;a:42:{s:5:\"title\";s:10:\"My Account\";s:7:\"title_1\";s:7:\"My Info\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:8:\"My Order\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:11:\"My Wishlist\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:6:\"Logout\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:10;a:42:{s:5:\"title\";s:8:\"Contact \";s:7:\"title_1\";s:10:\"Contact Us\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:8:\"Location\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:10:\"Help & FAQ\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:12:\"Contact Form\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:11;a:42:{s:5:\"title\";s:11:\"Information\";s:7:\"title_1\";s:8:\"About Us\";s:6:\"link_1\";s:1:\"#\";s:7:\"title_2\";s:7:\"History\";s:6:\"link_2\";s:1:\"#\";s:7:\"title_3\";s:12:\"Organization\";s:6:\"link_3\";s:1:\"#\";s:7:\"title_4\";s:11:\"Who We Are?\";s:6:\"link_4\";s:1:\"#\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:12;a:42:{s:5:\"title\";s:12:\"Quick Access\";s:7:\"title_1\";s:10:\"Contact Us\";s:6:\"link_1\";s:40:\"https://codevz.com/demo/heks/contact-us/\";s:7:\"title_2\";s:7:\"Support\";s:6:\"link_2\";s:26:\"https://codevz.ticksy.com/\";s:7:\"title_3\";s:20:\"Online Documentation\";s:6:\"link_3\";s:29:\"http://theme.support/doc/heks\";s:7:\"title_4\";s:12:\"Purchase Now\";s:6:\"link_4\";s:35:\"https://themeforest.net/user/codevz\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:13;a:41:{s:5:\"title\";s:21:\"دسترسی سریع\";s:10:\"menus_icon\";s:0:\"\";s:7:\"title_1\";s:18:\"تماس با ما\";s:6:\"link_1\";s:40:\"https://codevz.com/demo/heks/contact-us/\";s:7:\"title_2\";s:16:\"پشتیبانی\";s:6:\"link_2\";s:26:\"https://codevz.ticksy.com/\";s:7:\"title_3\";s:27:\"مستندات آنلاین\";s:6:\"link_3\";s:29:\"http://theme.support/doc/heks\";s:7:\"title_4\";s:17:\"خرید قالب\";s:6:\"link_4\";s:35:\"https://themeforest.net/user/codevz\";s:7:\"title_5\";s:0:\"\";s:6:\"link_5\";s:0:\"\";s:7:\"title_6\";s:0:\"\";s:6:\"link_6\";s:0:\"\";s:7:\"title_7\";s:0:\"\";s:6:\"link_7\";s:0:\"\";s:7:\"title_8\";s:0:\"\";s:6:\"link_8\";s:0:\"\";s:7:\"title_9\";s:0:\"\";s:6:\"link_9\";s:0:\"\";s:8:\"title_10\";s:0:\"\";s:7:\"link_10\";s:0:\"\";s:8:\"title_11\";s:0:\"\";s:7:\"link_11\";s:0:\"\";s:8:\"title_12\";s:0:\"\";s:7:\"link_12\";s:0:\"\";s:8:\"title_13\";s:0:\"\";s:7:\"link_13\";s:0:\"\";s:8:\"title_14\";s:0:\"\";s:7:\"link_14\";s:0:\"\";s:8:\"title_15\";s:0:\"\";s:7:\"link_15\";s:0:\"\";s:8:\"title_16\";s:0:\"\";s:7:\"link_16\";s:0:\"\";s:8:\"title_17\";s:0:\"\";s:7:\"link_17\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("185", "widget_codevzpostslist", "a:11:{i:1;a:25:{s:5:\"title\";s:32:\"جدیدترین نوشته ها\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:11:\"c_on_mobile\";s:1:\"1\";}i:2;a:24:{s:5:\"title\";s:27:\"جدیدترین مطالب\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:3;a:24:{s:5:\"title\";s:26:\"آخرین نوشته ها\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:4:\"czsk\";s:63:\"border-radius:10px;box-shadow:0px 5px 35px 0px rgba(0,0,0,0.1);\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:4;a:24:{s:5:\"title\";s:12:\"Recent Posts\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:5;a:24:{s:5:\"title\";s:32:\"جدیدترین نوشته ها\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:6;a:24:{s:5:\"title\";s:26:\"آخرین نوشته ها\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:7;a:24:{s:5:\"title\";s:26:\"آخرین نوشته ها\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:8;a:24:{s:5:\"title\";s:26:\"آخرین نوشته ها\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:9;a:24:{s:5:\"title\";s:32:\"جدیدترین نوشته ها\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:10;a:22:{s:5:\"title\";s:26:\"آخرین نوشته ها\";s:16:\"widgetidentifier\";s:0:\"\";s:16:\"widgetclassifier\";s:0:\"\";s:5:\"ptipe\";s:4:\"post\";s:4:\"show\";s:1:\"3\";s:9:\"pagecount\";s:1:\"3\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:5:\"catin\";s:0:\"\";s:6:\"catout\";s:0:\"\";s:5:\"taxis\";s:8:\"category\";s:7:\"taxterm\";s:0:\"\";s:7:\"metakey\";s:0:\"\";s:9:\"metavalue\";s:0:\"\";s:11:\"metacompare\";s:1:\"=\";s:13:\"readmoretitle\";s:0:\"\";s:12:\"readmorelink\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("186", "widget_codevzsimpleads", "a:13:{i:1;a:10:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2019/09/ads-1.jpg\";s:4:\"link\";s:21:\"http://xtratheme.irr/\";s:6:\"custom\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";}i:2;a:11:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:56:\"https://xtratheme.com/wp-content/uploads/2017/06/ads.jpg\";s:4:\"link\";s:18:\"http://codevz.com/\";s:6:\"custom\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:3;a:10:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2019/09/ads-1.jpg\";s:4:\"link\";s:21:\"http://xtratheme.com/\";s:6:\"custom\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";}i:4;a:12:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:56:\"https://xtratheme.com/wp-content/uploads/2017/06/ads.jpg\";s:4:\"link\";s:18:\"http://codevz.com/\";s:6:\"custom\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:5;a:11:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2017/06/ads-1.jpg\";s:4:\"link\";s:21:\"https://xtratheme.ir/\";s:6:\"custom\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:6;a:11:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2017/06/ads-1.jpg\";s:4:\"link\";s:17:\"http://suncode.ir\";s:6:\"custom\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:7;a:11:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2017/06/ads-1.jpg\";s:4:\"link\";s:17:\"http://suncode.ir\";s:6:\"custom\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:8;a:11:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2017/06/ads-1.jpg\";s:4:\"link\";s:17:\"http://suncode.ir\";s:6:\"custom\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:9;a:11:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2017/06/ads-1.jpg\";s:4:\"link\";s:17:\"http://suncode.ir\";s:6:\"custom\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:10;a:11:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2017/06/ads-1.jpg\";s:4:\"link\";s:17:\"http://suncode.ir\";s:6:\"custom\";s:0:\"\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:11;a:9:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2017/06/ads-1.jpg\";s:4:\"link\";s:18:\"http://suncode.ir/\";s:6:\"custom\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:12;a:12:{s:5:\"title\";s:14:\"تبلیغات\";s:3:\"img\";s:66:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2023/05/ads-1.png\";s:4:\"link\";s:1:\"#\";s:6:\"custom\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";s:17:\"hide_widget_title\";s:0:\"\";s:12:\"unbox_widget\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("187", "widget_codevzsubscribe", "a:13:{i:1;a:13:{s:5:\"title\";s:10:\"عضویت\";s:14:\"subscribe_text\";s:82:\"از جدیدترین بروزرسانی ها و اخبار ما مطلع شوید\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:6:\"codevz\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:11:\"c_on_mobile\";s:1:\"1\";}i:2;a:12:{s:5:\"title\";s:22:\"Subscribe to RSS Feeds\";s:14:\"subscribe_text\";s:67:\"Get all latest content delivered to your email a few times a month.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:10:\"Your Email\";s:6:\"feedid\";s:18:\"your_feedburner_id\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:3;a:12:{s:5:\"title\";s:37:\"مشترک شدن در خبرنامه\";s:14:\"subscribe_text\";s:116:\"هر ماه چند بار آخرین مطالب تحویل شده به ایمیل خود را دریافت کنید.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:6:\"codevz\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:4;a:12:{s:5:\"title\";s:32:\"اشتراک در خبرنامه\";s:14:\"subscribe_text\";s:116:\"هر ماه چند بار آخرین مطالب تحویل شده به ایمیل خود را دریافت کنید.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:18:\"your_feedburner_id\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:5;a:12:{s:5:\"title\";s:22:\"Subscribe to RSS Feeds\";s:14:\"subscribe_text\";s:67:\"Get all latest content delivered to your email a few times a month.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:10:\"Your Email\";s:6:\"feedid\";s:18:\"your_feedburner_id\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:6;a:12:{s:5:\"title\";s:44:\"در خبرنامه ما مشترک شوید\";s:14:\"subscribe_text\";s:121:\"آخرین مطالب را که چند بار در ماه ارسال شده به ایمیل خود دریافت کنید.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:18:\"your_feedburner_id\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:7;a:12:{s:5:\"title\";s:32:\"اشتراک در خبرنامه\";s:14:\"subscribe_text\";s:126:\"آخرین مطالب را که چند بار در ماه ارسال شده را در ایمیل خود دریافت کنید.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:6:\"codevz\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:8;a:12:{s:5:\"title\";s:32:\"اشتراک در خبرنامه\";s:14:\"subscribe_text\";s:126:\"آخرین مطالب را که چند بار در ماه ارسال شده را در ایمیل خود دریافت کنید.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:18:\"your_feedburner_id\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:9;a:12:{s:5:\"title\";s:32:\"اشتراک در خبرنامه\";s:14:\"subscribe_text\";s:121:\"آخرین مطالب را که چند بار در ماه ارسال شده در ایمیل خود دریافت کنید.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:6:\"codevz\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:10;a:12:{s:5:\"title\";s:32:\"اشتراک در خبرنامه\";s:14:\"subscribe_text\";s:121:\"آخرین مطالب را که چند بار در ماه ارسال شده در ایمیل خود دریافت کنید.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:18:\"your_feedburner_id\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:11;a:10:{s:5:\"title\";s:32:\"اشتراک در خبرنامه\";s:14:\"subscribe_text\";s:121:\"آخرین مطالب را که چند بار در ماه ارسال شده به ایمیل خود دریافت کنید.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:6:\"codevz\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:12;a:10:{s:5:\"title\";s:32:\"اشتراک در خبرنامه\";s:14:\"subscribe_text\";s:121:\"آخرین مطالب را که چند بار در ماه ارسال شده به ایمیل خود دریافت کنید.\";s:4:\"icon\";s:11:\"fa fa-check\";s:11:\"placeholder\";s:17:\"ایمیل شما\";s:6:\"feedid\";s:18:\"your_feedburner_id\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("188", "widget_codevzpagecontent", "a:3:{i:1;a:8:{s:5:\"title\";s:0:\"\";s:2:\"id\";s:6:\"Footer\";s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:2;a:5:{s:5:\"title\";s:0:\"\";s:2:\"id\";s:3:\"424\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("189", "widget_codevzportfolio", "a:10:{i:1;a:13:{s:5:\"title\";s:15:\"پروژه ها\";s:9:\"posts_num\";s:1:\"6\";s:13:\"gallery_order\";s:4:\"DESC\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:7:\"columns\";s:1:\"3\";s:9:\"post_type\";s:9:\"portfolio\";s:11:\"c_on_mobile\";s:1:\"1\";}i:2;a:10:{s:5:\"title\";s:8:\"Projects\";s:9:\"posts_num\";s:1:\"6\";s:13:\"gallery_order\";s:4:\"DESC\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:3;a:12:{s:5:\"title\";s:21:\"نمونه کارها\";s:9:\"posts_num\";s:1:\"6\";s:13:\"gallery_order\";s:4:\"DESC\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:7:\"columns\";s:1:\"3\";s:9:\"post_type\";s:9:\"portfolio\";}i:4;a:10:{s:5:\"title\";s:0:\"\";s:9:\"posts_num\";s:1:\"9\";s:13:\"gallery_order\";s:4:\"DESC\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:36:\"margin-bottom:0px;border-style:none;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:5;a:10:{s:5:\"title\";s:0:\"\";s:9:\"posts_num\";s:1:\"9\";s:13:\"gallery_order\";s:4:\"DESC\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:36:\"margin-bottom:0px;border-style:none;\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:6;a:10:{s:5:\"title\";s:9:\"Portfolio\";s:9:\"posts_num\";s:1:\"6\";s:13:\"gallery_order\";s:4:\"DESC\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:7;a:10:{s:5:\"title\";s:15:\"پروژه ها\";s:9:\"posts_num\";s:1:\"9\";s:13:\"gallery_order\";s:4:\"DESC\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:8;a:10:{s:5:\"title\";s:15:\"پروژه ها\";s:9:\"posts_num\";s:1:\"6\";s:13:\"gallery_order\";s:4:\"DESC\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";}i:9;a:8:{s:5:\"title\";s:21:\"نمونه کارها\";s:9:\"posts_num\";s:1:\"6\";s:13:\"gallery_order\";s:4:\"DESC\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("190", "widget_lc_taxonomy", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("191", "widget_codevz_soundcloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("192", "widget_codevz_unboxed", "a:1:{s:12:\"_multiwidget\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("193", "widget_xtra_newsletter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("197", "elementor_active_kit", "3205", "yes");
INSERT INTO `wp_options` VALUES("200", "elementor_version", "3.35.4", "yes");
INSERT INTO `wp_options` VALUES("201", "elementor_install_history", "a:4:{s:5:\"3.5.6\";i:1647365243;s:6:\"3.13.2\";i:1685102616;s:6:\"3.18.0\";i:1705734956;s:6:\"3.35.4\";i:1771329003;}", "yes");
INSERT INTO `wp_options` VALUES("205", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "no");
INSERT INTO `wp_options` VALUES("19013", "_transient_timeout_woocommerce_admin_payment_gateway_suggestions_specs", "1771933698", "no");
INSERT INTO `wp_options` VALUES("19014", "_transient_woocommerce_admin_payment_gateway_suggestions_specs", "a:1:{s:5:\"fa_IR\";a:24:{s:6:\"affirm\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"affirm\";s:5:\"title\";s:6:\"Affirm\";s:7:\"content\";s:169:\"Affirm’s tailored Buy Now Pay Later programs remove price as a barrier, turning browsers into buyers, increasing average order value, and expanding your customer base.\";s:5:\"image\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:7:\"plugins\";a:0:{}s:13:\"external_link\";s:59:\"https://woocommerce.com/products/woocommerce-gateway-affirm\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}s:23:\"recommendation_priority\";i:8;}s:8:\"afterpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"afterpay\";s:5:\"title\";s:8:\"Afterpay\";s:7:\"content\";s:125:\"Afterpay allows customers to receive products immediately and pay for purchases over four installments, always interest-free.\";s:5:\"image\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:3:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";}s:23:\"recommendation_priority\";i:9;}s:14:\"airwallex_main\";O:8:\"stdClass\":11:{s:2:\"id\";s:14:\"airwallex_main\";s:5:\"title\";s:18:\"Airwallex Payments\";s:7:\"content\";s:115:\"Boost international sales and save on FX fees. Accept 60+ local payment methods including Apple Pay and Google Pay.\";s:5:\"image\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/airwallex.png\";s:12:\"square_image\";s:112:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex-square.png\";s:7:\"plugins\";a:1:{i:0;s:33:\"airwallex-online-payments-gateway\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:17:{i:0;s:2:\"GB\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"EE\";i:4;s:2:\"FR\";i:5;s:2:\"DE\";i:6;s:2:\"GR\";i:7;s:2:\"IE\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";i:11;s:2:\"PT\";i:12;s:2:\"AU\";i:13;s:2:\"NZ\";i:14;s:2:\"HK\";i:15;s:2:\"SG\";i:16;s:2:\"CN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";N;}s:24:\"amazon_payments_advanced\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"amazon_payments_advanced\";s:5:\"title\";s:10:\"Amazon Pay\";s:7:\"content\";s:94:\"Enable a familiar, fast checkout for hundreds of millions of active Amazon customers globally.\";s:5:\"image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:7:\"plugins\";a:1:{i:0;s:44:\"woocommerce-gateway-amazon-payments-advanced\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:18:{i:0;s:2:\"US\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"CY\";i:4;s:2:\"DK\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"DE\";i:8;s:2:\"GB\";i:9;s:2:\"HU\";i:10;s:2:\"IE\";i:11;s:2:\"IT\";i:12;s:2:\"LU\";i:13;s:2:\"NL\";i:14;s:2:\"PT\";i:15;s:2:\"SL\";i:16;s:2:\"SE\";i:17;s:2:\"JP\";}s:23:\"recommendation_priority\";i:7;}s:4:\"bacs\";O:8:\"stdClass\":8:{s:2:\"id\";s:4:\"bacs\";s:5:\"title\";s:20:\"Direct bank transfer\";s:7:\"content\";s:32:\"Take payments via bank transfer.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/bacs.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/bacs.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";N;}s:3:\"cod\";O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"cod\";s:5:\"title\";s:16:\"Cash on delivery\";s:7:\"content\";s:36:\"Take payments in cash upon delivery.\";s:5:\"image\";s:99:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/cod.svg\";s:11:\"image_72x72\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/cod.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";N;}s:4:\"eway\";O:8:\"stdClass\":11:{s:2:\"id\";s:4:\"eway\";s:5:\"title\";s:4:\"Eway\";s:7:\"content\";s:171:\"The Eway extension for WooCommerce allows you to take credit card payments directly on your store without redirecting your customers to a third party site to make payment.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway.png\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/eway.png\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway-square.png\";s:7:\"plugins\";a:1:{i:0;s:24:\"woocommerce-gateway-eway\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:7;}s:3:\"kco\";O:8:\"stdClass\":10:{s:2:\"id\";s:3:\"kco\";s:5:\"title\";s:15:\"Klarna Checkout\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-checkout-for-woocommerce\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"NO\";i:1;s:2:\"SE\";i:2;s:2:\"FI\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:15:\"klarna_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:15:\"klarna_payments\";s:5:\"title\";s:15:\"Klarna Payments\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:19:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:19:{i:0;s:2:\"MX\";i:1;s:2:\"US\";i:2;s:2:\"CA\";i:3;s:2:\"AT\";i:4;s:2:\"BE\";i:5;s:2:\"CH\";i:6;s:2:\"DK\";i:7;s:2:\"ES\";i:8;s:2:\"FI\";i:9;s:2:\"FR\";i:10;s:2:\"DE\";i:11;s:2:\"GB\";i:12;s:2:\"IT\";i:13;s:2:\"NL\";i:14;s:2:\"NO\";i:15;s:2:\"PL\";i:16;s:2:\"SE\";i:17;s:2:\"NZ\";i:18;s:2:\"AU\";}s:23:\"recommendation_priority\";i:6;}s:30:\"mollie_wc_gateway_banktransfer\";O:8:\"stdClass\":11:{s:2:\"id\";s:30:\"mollie_wc_gateway_banktransfer\";s:5:\"title\";s:6:\"Mollie\";s:7:\"content\";s:128:\"Effortless payments by Mollie: Offer global and local payment methods, get onboarded in minutes, and supported in your language.\";s:5:\"image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie.svg\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mollie.png\";s:12:\"square_image\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie-square.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"mollie-payments-for-woocommerce\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:11:{i:0;s:2:\"AT\";i:1;s:2:\"BE\";i:2;s:2:\"CH\";i:3;s:2:\"ES\";i:4;s:2:\"FI\";i:5;s:2:\"FR\";i:6;s:2:\"DE\";i:7;s:2:\"GB\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:5;}s:7:\"payfast\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payfast\";s:5:\"title\";s:7:\"Payfast\";s:7:\"content\";s:299:\"The Payfast extension for WooCommerce enables you to accept payments by Credit Card and EFT via one of South Africa’s most popular payment gateways. No setup fees or monthly subscription costs. Selecting this extension will configure your store to use South African rands as the selected currency.\";s:5:\"image\";s:80:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/payfast.png\";s:11:\"image_72x72\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payfast.png\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-payfast-gateway\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"ZA\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:5;}s:17:\"payoneer-checkout\";O:8:\"stdClass\":10:{s:2:\"id\";s:17:\"payoneer-checkout\";s:5:\"title\";s:17:\"Payoneer Checkout\";s:7:\"content\";s:202:\"Payoneer Checkout is the next generation of payment processing platforms, giving merchants around the world the solutions and direction they need to succeed in today’s hyper-competitive global market.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payoneer.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payoneer.png\";s:7:\"plugins\";a:1:{i:0;s:17:\"payoneer-checkout\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"HK\";i:1;s:2:\"CN\";}s:23:\"recommendation_priority\";i:11;}s:8:\"paystack\";O:8:\"stdClass\":11:{s:2:\"id\";s:8:\"paystack\";s:5:\"title\";s:8:\"Paystack\";s:7:\"content\";s:127:\"Paystack helps African merchants accept one-time and recurring payments online with a modern, safe, and secure payment gateway.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack.png\";s:12:\"square_image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack-square.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paystack.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-paystack\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GH\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NG\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"ZA\";i:1;s:2:\"GH\";i:2;s:2:\"NG\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:7:\"payubiz\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payubiz\";s:5:\"title\";s:20:\"PayU for WooCommerce\";s:7:\"content\";s:169:\"Enable PayU’s exclusive plugin for WooCommerce to start accepting payments in 100+ payment methods available in India including credit cards, debit cards, UPI, & more!\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payu.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payu.png\";s:7:\"plugins\";a:1:{i:0;s:10:\"payu-india\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:12:\"ppcp-gateway\";O:8:\"stdClass\":11:{s:2:\"id\";s:12:\"ppcp-gateway\";s:5:\"title\";s:15:\"PayPal Payments\";s:7:\"content\";s:78:\"Safe and secure payments using credit cards or your customer\'s PayPal account.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/paypal.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paypal.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paypal.svg\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:49:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:48:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";}s:19:\"category_additional\";a:49:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";i:48;s:2:\"IN\";}s:23:\"recommendation_priority\";i:4;}s:8:\"razorpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"razorpay\";s:5:\"title\";s:8:\"Razorpay\";s:7:\"content\";s:133:\"The official Razorpay extension for WooCommerce allows you to accept credit cards, debit cards, netbanking, wallet, and UPI payments.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/razorpay.svg\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/razorpay.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-razorpay\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:5;}s:18:\"square_credit_card\";O:8:\"stdClass\":10:{s:2:\"id\";s:18:\"square_credit_card\";s:5:\"title\";s:6:\"Square\";s:7:\"content\";s:169:\"Securely accept credit and debit cards with one low rate, no surprise fees (custom rates available). Sell online and in store and track sales and inventory in one place.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/square-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/square.png\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}i:1;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:12:\"brick-mortar\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:18:\"brick-mortar-other\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:21:\"no_im_selling_offline\";s:7:\"default\";s:0:\"\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:34:\"im_selling_both_online_and_offline\";s:7:\"default\";s:0:\"\";}}}}}}}}}s:14:\"category_other\";a:8:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"IE\";i:3;s:2:\"ES\";i:4;s:2:\"FR\";i:5;s:2:\"GB\";i:6;s:2:\"AU\";i:7;s:2:\"JP\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:6:\"stripe\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"stripe\";s:5:\"title\";s:6:\"Stripe\";s:7:\"content\";s:112:\"Accept debit and credit cards in 135+ currencies, methods such as Alipay, and one-touch checkout with Apple Pay.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/stripe.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/stripe.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/stripe.svg\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:40:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AT\";i:5;s:2:\"BE\";i:6;s:2:\"BG\";i:7;s:2:\"CH\";i:8;s:2:\"CY\";i:9;s:2:\"CZ\";i:10;s:2:\"DK\";i:11;s:2:\"EE\";i:12;s:2:\"ES\";i:13;s:2:\"FI\";i:14;s:2:\"FR\";i:15;s:2:\"DE\";i:16;s:2:\"GB\";i:17;s:2:\"GR\";i:18;s:2:\"HU\";i:19;s:2:\"IE\";i:20;s:2:\"IT\";i:21;s:2:\"LV\";i:22;s:2:\"LT\";i:23;s:2:\"LU\";i:24;s:2:\"MT\";i:25;s:2:\"NL\";i:26;s:2:\"NO\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"RO\";i:30;s:2:\"SK\";i:31;s:2:\"SL\";i:32;s:2:\"SE\";i:33;s:2:\"AU\";i:34;s:2:\"NZ\";i:35;s:2:\"HK\";i:36;s:2:\"JP\";i:37;s:2:\"SG\";i:38;s:2:\"ID\";i:39;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:2;}s:23:\"woo-mercado-pago-custom\";O:8:\"stdClass\":11:{s:2:\"id\";s:23:\"woo-mercado-pago-custom\";s:5:\"title\";s:12:\"Mercado Pago\";s:7:\"content\";s:198:\"Set up your payment methods and accept credit and debit cards, cash, bank transfers and money from your Mercado Pago account. Offer safe and secure payments with Latin America’s leading processor.\";s:5:\"image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mercadopago.png\";s:11:\"image_72x72\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mercadopago.png\";s:7:\"plugins\";a:1:{i:0;s:23:\"woocommerce-mercadopago\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}}}}s:16:\"is_local_partner\";b:1;s:14:\"category_other\";a:8:{i:0;s:2:\"AR\";i:1;s:2:\"CL\";i:2;s:2:\"CO\";i:3;s:2:\"EC\";i:4;s:2:\"PE\";i:5;s:2:\"UY\";i:6;s:2:\"MX\";i:7;s:2:\"BR\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:3;}s:20:\"woocommerce_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:20:\"woocommerce_payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:1:\"<\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:17:\"woocommerce-admin\";}}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:1:\"<\";}}}}s:23:\"recommendation_priority\";i:1;}s:47:\"woocommerce_payments:without-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:47:\"woocommerce_payments:without-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:37:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:1;}s:44:\"woocommerce_payments:with-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:44:\"woocommerce_payments:with-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:212:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies – with no setup costs or monthly fees – and you can now accept in-person payments with the Woo mobile app.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:1;}s:25:\"woocommerce_payments:bnpl\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"woocommerce_payments:bnpl\";s:5:\"title\";s:38:\"Activate BNPL instantly on WooPayments\";s:7:\"content\";s:185:\"The world’s favorite buy now, pay later options and many more are right at your fingertips with WooPayments — all from one dashboard, without needing multiple extensions and logins.\";s:5:\"image\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:2:\">=\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}i:4;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}s:23:\"recommendation_priority\";N;}s:8:\"zipmoney\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"zipmoney\";s:5:\"title\";s:27:\"Zip Co - Buy Now, Pay Later\";s:7:\"content\";s:84:\"Give your customers the power to pay later, interest free and watch your sales grow.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/zipmoney.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/zipmoney.png\";s:7:\"plugins\";a:1:{i:0;s:29:\"zipmoney-payments-woocommerce\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}}}", "no");
INSERT INTO `wp_options` VALUES("19023", "_transient_timeout_wc_term_counts", "1773920840", "no");
INSERT INTO `wp_options` VALUES("19024", "_transient_wc_term_counts", "a:7:{i:1664;s:1:\"7\";i:1667;s:1:\"3\";i:1665;s:1:\"4\";s:16:\"1664_product_cat\";i:7;s:16:\"1667_product_cat\";i:3;s:16:\"1665_product_cat\";i:4;s:16:\"1666_product_cat\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("206", "elementor_remote_info_feed_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("19669", "_transient_timeout_elementor_remote_info_api_data_3.35.4", "1771933632", "off");
INSERT INTO `wp_options` VALUES("19670", "_transient_elementor_remote_info_api_data_3.35.4", "a:18:{s:6:\"status\";s:4:\"free\";s:8:\"site_key\";s:0:\"\";s:4:\"feed\";a:0:{}s:7:\"library\";a:0:{}s:7:\"plugins\";a:0:{}s:5:\"theme\";a:0:{}s:6:\"addons\";a:0:{}s:3:\"pro\";b:0;s:7:\"version\";s:6:\"3.35.4\";s:7:\"license\";a:2:{s:6:\"status\";s:8:\"inactive\";s:4:\"type\";s:0:\"\";}s:8:\"features\";a:0:{}s:7:\"updates\";a:0:{}s:14:\"upgrade_notice\";a:0:{}s:12:\"admin_notice\";a:0:{}s:17:\"canary_deployment\";a:0:{}s:11:\"pro_widgets\";a:0:{}s:15:\"deactivate_data\";a:0:{}s:14:\"uninstall_data\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("19671", "_site_transient_timeout_woocommerce_blocks_patterns", "1773920832", "off");
INSERT INTO `wp_options` VALUES("19672", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:6:\"10.5.1\";s:8:\"patterns\";a:41:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:10:\"banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:15:\"coming-soon.php\";}i:3;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"coming-soon-store-only.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"footer-large.php\";}i:8;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"footer-simple-menu.php\";}i:9;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"footer-with-3-menus.php\";}i:10;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"four-image-grid-content-left.php\";}i:11;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-centered-pattern.php\";}i:12;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-distraction-free.php\";}i:13;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"header-essential.php\";}i:14;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"header-large.php\";}i:15;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:18:\"header-minimal.php\";}i:16;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:51:\"heading-with-three-columns-of-content-with-link.php\";}i:17;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:24:\"hero-product-3-split.php\";}i:18;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"hero-product-chessboard.php\";}i:19;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"hero-product-split.php\";}i:20;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:43:\"intro-centered-content-with-image-below.php\";}i:21;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"just-arrived-full-hero.php\";}i:22;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:29:\"no-products-found-filters.php\";}i:23;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:21:\"no-products-found.php\";}i:24;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:28:\"page-coming-soon-default.php\";}i:25;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:34:\"page-coming-soon-image-gallery.php\";}i:26;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-minimal-left-image.php\";}i:27;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:33:\"page-coming-soon-modern-black.php\";}i:28;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:38:\"page-coming-soon-split-right-image.php\";}i:29;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-with-header-footer.php\";}i:30;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-3-columns.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-4-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-5-columns.php\";}i:33;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:50:\"product-collection-featured-products-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"product-query-product-gallery.php\";}i:35;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"product-search-form.php\";}i:36;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"related-products.php\";}i:37;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:36:\"social-follow-us-in-social-media.php\";}i:38;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"testimonials-3-columns.php\";}i:39;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"testimonials-single.php\";}i:40;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:41:\"three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `wp_options` VALUES("210", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-c.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-b.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("211", "revslider_server_refresh", "1769593177", "yes");
INSERT INTO `wp_options` VALUES("212", "revslider-update-check-short", "1771198009", "no");
INSERT INTO `wp_options` VALUES("213", "revslider-connection", "1", "no");
INSERT INTO `wp_options` VALUES("214", "revslider-update-hash", "b749d114a2be6572b702d65a588ff568", "no");
INSERT INTO `wp_options` VALUES("215", "revslider-latest-version", "6.7.41", "no");
INSERT INTO `wp_options` VALUES("216", "revslider-stable-version", "4.2.0", "no");
INSERT INTO `wp_options` VALUES("217", "revslider-notices", "a:7:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-c.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":11:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:446:\"<div style=\"display: block; background: #3900de;text-align: center; height: 360px;\"><a href=\"https://account.sliderrevolution.com/portal/premium-slider-revolution/?utm_source=wordpress-admin&utm_medium=inapp-banner&utm_campaign=free2premium-upgrade&utm_content=speed-hardwired\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/ads/2a-68e8cd89c844b.webp\"></a></div>\";s:4:\"code\";s:10:\"TPAD2_2025\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:2:\"id\";s:8:\"rs_ads_1\";s:10:\"additional\";a:0:{}}i:5;O:8:\"stdClass\":11:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:325:\"<style type=\"text/css\">#rs_ads_3 .rs_close_advert { display: none; } #rs_ads_3 { box-shadow: none !important; }</style>\n<iframe id=\"sr-notice-ad-iframe-wrapper\" \n        src=\"//updates.themepunch-ext-c.tools//banners/ads/ads.php\"\n        style=\"text-align: center; height:360px;width: 100%;\"\n        scrolling=\"no\">\n</iframe>\";s:4:\"code\";s:10:\"TPAD3_2025\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:2:\"id\";s:8:\"rs_ads_3\";s:10:\"additional\";a:0:{}}i:6;O:8:\"stdClass\":11:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:430:\"<div style=\"display: block; background: #f7345e;text-align: center; height:360px;\"><a href=\"https://account.sliderrevolution.com/portal/black-friday-sale/?utm_source=wordpress-admin&utm_medium=inapp-banner&utm_campaign=BFCM2025&utm_content=wpadmin-extension\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:360px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/bf/admin3-s.jpg\"></a></div>\";s:4:\"code\";s:10:\"TPBF3_2025\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:5:\"theme\";s:4:\"dark\";s:10:\"additional\";a:0:{}}}", "no");
INSERT INTO `wp_options` VALUES("218", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-c.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-c.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("219", "rs-addons-counter", "1", "yes");
INSERT INTO `wp_options` VALUES("220", "revslider-addons", "O:8:\"stdClass\":35:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"559\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"6.7.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"558\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"567\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"551\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"6.7.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2026-01-08\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"568\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:6:\"6.7.31\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"6.7.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2025-01-17\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"545\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"569\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"555\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"552\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"553\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"556\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"6.7.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2026-02-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"547\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"550\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2024-12-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"554\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2024-12-06\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"562\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"557\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2024-09-24\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"575\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"6.7.9\";s:10:\"background\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2026-02-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"549\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2025-02-18\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"564\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2024-12-19\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"571\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:6:\"6.9.99\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:81:\"//updates.themepunch-ext-c.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"560\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"6.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:1:{i:0;s:19:\"Added Functionality\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"561\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"6.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"566\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.8\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"6.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"6.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"570\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"548\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "no");
INSERT INTO `wp_options` VALUES("221", "revslider-library-check", "1770947412", "no");
INSERT INTO `wp_options` VALUES("222", "revslider-library-hash", "8f5739c44eebb6dd2c18c90b8e1b26f0", "no");
INSERT INTO `wp_options` VALUES("223", "rs-library", "a:3:{s:4:\"hash\";s:32:\"8f5739c44eebb6dd2c18c90b8e1b26f0\";s:7:\"objects\";a:417:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:420;a:13:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19226;s:4:\"orig\";i:758093;}}i:421;a:13:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12387;s:4:\"orig\";i:472820;}}i:422;a:13:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10972;s:4:\"orig\";i:380716;}}i:423;a:13:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12394;s:4:\"orig\";i:959761;}}i:424;a:13:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11474;s:4:\"orig\";i:284282;}}i:425;a:13:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13395;s:4:\"orig\";i:519568;}}i:426;a:13:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15367;s:4:\"orig\";i:364626;}}i:427;a:13:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16174;s:4:\"orig\";i:265728;}}i:428;a:13:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7677;s:4:\"orig\";i:256526;}}i:429;a:13:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12408;s:4:\"orig\";i:354771;}}i:430;a:13:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17621;s:4:\"orig\";i:673109;}}i:431;a:13:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9464;s:4:\"orig\";i:180683;}}i:432;a:13:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16190;s:4:\"orig\";i:381967;}}i:433;a:13:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26583;s:4:\"orig\";i:792941;}}i:434;a:13:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17464;s:4:\"orig\";i:394604;}}i:435;a:13:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19126;s:4:\"orig\";i:403268;}}i:436;a:13:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16597;s:4:\"orig\";i:552042;}}i:437;a:13:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16027;s:4:\"orig\";i:430912;}}i:438;a:13:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15961;s:4:\"orig\";i:706482;}}i:439;a:13:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20286;s:4:\"orig\";i:704324;}}i:440;a:13:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10077;s:4:\"orig\";i:197347;}}i:441;a:13:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14092;s:4:\"orig\";i:517927;}}i:442;a:13:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18629;s:4:\"orig\";i:620706;}}i:443;a:13:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10220;s:4:\"orig\";i:348322;}}i:444;a:13:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6348;s:4:\"orig\";i:211494;}}i:445;a:13:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9826;s:4:\"orig\";i:377551;}}i:446;a:13:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13862;s:4:\"orig\";i:454028;}}i:447;a:13:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18636;s:4:\"orig\";i:785357;}}i:448;a:13:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17409;s:4:\"orig\";i:996686;}}i:449;a:13:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12053;s:4:\"orig\";i:916937;}}i:450;a:13:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3887;s:4:\"orig\";i:154603;}}i:451;a:13:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16305;s:4:\"orig\";i:483681;}}i:452;a:13:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12105;s:4:\"orig\";i:314746;}}i:453;a:13:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18137;s:4:\"orig\";i:371805;}}i:454;a:13:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11586;s:4:\"orig\";i:354781;}}i:455;a:13:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9848;s:4:\"orig\";i:195359;}}i:456;a:13:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10089;s:4:\"orig\";i:218538;}}i:457;a:13:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16403;s:4:\"orig\";i:547096;}}i:458;a:13:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19188;s:4:\"orig\";i:371592;}}i:459;a:13:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15157;s:4:\"orig\";i:658386;}}i:460;a:13:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24833;s:4:\"orig\";i:942816;}}i:461;a:13:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:345362;}}i:462;a:13:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15665;s:4:\"orig\";i:407640;}}i:463;a:13:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19443;s:4:\"orig\";i:844506;}}i:464;a:13:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15564;s:4:\"orig\";i:573777;}}i:465;a:13:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13337;s:4:\"orig\";i:762091;}}i:466;a:13:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16746;s:4:\"orig\";i:365391;}}i:467;a:13:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12699;s:4:\"orig\";i:427166;}}i:468;a:13:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4748;s:4:\"orig\";i:238506;}}i:469;a:13:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19043;s:4:\"orig\";i:595277;}}i:470;a:13:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11863;s:4:\"orig\";i:228649;}}i:471;a:13:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10878;s:4:\"orig\";i:313238;}}i:472;a:13:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7596;s:4:\"orig\";i:193734;}}i:473;a:13:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9305;s:4:\"orig\";i:223763;}}i:474;a:13:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23289;s:4:\"orig\";i:699269;}}i:475;a:13:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16638;s:4:\"orig\";i:415507;}}i:476;a:13:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11706;s:4:\"orig\";i:310875;}}i:477;a:13:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18880;s:4:\"orig\";i:531273;}}i:478;a:13:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20175;s:4:\"orig\";i:554813;}}i:479;a:13:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6818;s:4:\"orig\";i:122809;}}i:480;a:13:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8776;s:4:\"orig\";i:190452;}}i:481;a:13:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52127;s:4:\"orig\";i:352596;}}i:482;a:13:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8878;s:4:\"orig\";i:183427;}}i:483;a:13:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:368977;}}i:484;a:13:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15080;s:4:\"orig\";i:707157;}}i:485;a:13:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5473;s:4:\"orig\";i:288675;}}i:486;a:13:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19262;s:4:\"orig\";i:513524;}}i:487;a:13:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9810;s:4:\"orig\";i:317981;}}i:488;a:13:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15773;s:4:\"orig\";i:519696;}}i:489;a:13:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32647;s:4:\"orig\";i:350074;}}i:490;a:13:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14643;s:4:\"orig\";i:314424;}}i:491;a:13:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19823;s:4:\"orig\";i:511473;}}i:492;a:13:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37262;s:4:\"orig\";i:1590451;}}i:493;a:13:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13647;s:4:\"orig\";i:408622;}}i:494;a:13:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10075;s:4:\"orig\";i:216586;}}i:495;a:13:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10969;s:4:\"orig\";i:405945;}}i:496;a:13:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9975;s:4:\"orig\";i:257177;}}i:497;a:13:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9598;s:4:\"orig\";i:300066;}}i:498;a:13:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7588;s:4:\"orig\";i:184359;}}i:499;a:13:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9507;s:4:\"orig\";i:290246;}}i:500;a:13:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14875;s:4:\"orig\";i:324145;}}i:501;a:13:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18138;s:4:\"orig\";i:736181;}}i:502;a:13:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10664;s:4:\"orig\";i:411404;}}i:503;a:13:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11609;s:4:\"orig\";i:273103;}}i:504;a:13:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16837;s:4:\"orig\";i:456937;}}i:505;a:13:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13774;s:4:\"orig\";i:385875;}}i:506;a:13:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12285;s:4:\"orig\";i:546492;}}i:507;a:13:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12631;s:4:\"orig\";i:540206;}}i:508;a:13:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9964;s:4:\"orig\";i:309994;}}i:509;a:13:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13683;s:4:\"orig\";i:369417;}}i:510;a:13:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15941;s:4:\"orig\";i:475914;}}i:511;a:13:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17854;s:4:\"orig\";i:371480;}}i:512;a:13:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17441;s:4:\"orig\";i:507045;}}i:513;a:13:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32396;s:4:\"orig\";i:750503;}}i:514;a:13:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25355;s:4:\"orig\";i:517171;}}i:515;a:13:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30467;s:4:\"orig\";i:1076108;}}i:516;a:13:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17629;s:4:\"orig\";i:804567;}}i:517;a:13:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12952;s:4:\"orig\";i:489898;}}i:518;a:13:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11065;s:4:\"orig\";i:384178;}}i:519;a:13:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6262;s:4:\"orig\";i:198960;}}i:520;a:13:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16353;s:4:\"orig\";i:245636;}}i:521;a:13:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6048;s:4:\"orig\";i:133907;}}i:522;a:13:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15187;s:4:\"orig\";i:450326;}}i:523;a:13:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17977;s:4:\"orig\";i:582673;}}i:524;a:13:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20171;s:4:\"orig\";i:617346;}}i:525;a:13:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14937;s:4:\"orig\";i:227355;}}i:526;a:13:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9789;s:4:\"orig\";i:321713;}}i:527;a:13:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18374;s:4:\"orig\";i:642218;}}i:528;a:13:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17332;s:4:\"orig\";i:791283;}}i:529;a:13:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28854;s:4:\"orig\";i:1228379;}}i:530;a:13:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7529;s:4:\"orig\";i:263779;}}i:531;a:13:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18101;s:4:\"orig\";i:617407;}}i:532;a:13:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18049;s:4:\"orig\";i:757700;}}i:533;a:13:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18133;s:4:\"orig\";i:633849;}}i:534;a:13:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24430;s:4:\"orig\";i:954378;}}i:535;a:13:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16738;s:4:\"orig\";i:664032;}}i:536;a:13:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17594;s:4:\"orig\";i:503413;}}i:537;a:13:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15558;s:4:\"orig\";i:508616;}}i:538;a:13:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14665;s:4:\"orig\";i:429256;}}i:539;a:13:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20433;s:4:\"orig\";i:1162968;}}i:540;a:13:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10872;s:4:\"orig\";i:289488;}}i:541;a:13:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17988;s:4:\"orig\";i:602577;}}i:542;a:13:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9794;s:4:\"orig\";i:352053;}}i:543;a:13:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:370551;}}i:544;a:13:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10397;s:4:\"orig\";i:280660;}}i:545;a:13:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26832;s:4:\"orig\";i:677097;}}i:546;a:13:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13591;s:4:\"orig\";i:846550;}}i:547;a:13:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12138;s:4:\"orig\";i:511326;}}i:548;a:13:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14005;s:4:\"orig\";i:392648;}}i:549;a:13:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11612;s:4:\"orig\";i:688650;}}i:550;a:13:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28096;s:4:\"orig\";i:766943;}}i:551;a:13:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17419;s:4:\"orig\";i:759716;}}i:552;a:13:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10910;s:4:\"orig\";i:191059;}}i:553;a:13:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24825;s:4:\"orig\";i:706226;}}i:554;a:13:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11091;s:4:\"orig\";i:300143;}}i:555;a:13:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15004;s:4:\"orig\";i:475888;}}i:556;a:13:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13155;s:4:\"orig\";i:683645;}}i:557;a:13:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15305;s:4:\"orig\";i:655207;}}i:558;a:13:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17740;s:4:\"orig\";i:745183;}}i:559;a:13:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17442;s:4:\"orig\";i:641873;}}i:560;a:13:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16088;s:4:\"orig\";i:241567;}}i:561;a:13:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8512;s:4:\"orig\";i:267430;}}i:562;a:13:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25804;s:4:\"orig\";i:908234;}}i:563;a:13:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4691;s:4:\"orig\";i:108160;}}i:564;a:13:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12753;s:4:\"orig\";i:218714;}}i:565;a:13:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19312;s:4:\"orig\";i:438345;}}i:566;a:13:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16224;s:4:\"orig\";i:409547;}}i:567;a:13:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22344;s:4:\"orig\";i:432904;}}i:568;a:13:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9431;s:4:\"orig\";i:220442;}}i:569;a:13:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29538;s:4:\"orig\";i:733632;}}i:570;a:13:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12859;s:4:\"orig\";i:430959;}}i:571;a:13:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13413;s:4:\"orig\";i:324558;}}i:572;a:13:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11553;s:4:\"orig\";i:146076;}}i:573;a:13:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21184;s:4:\"orig\";i:537577;}}i:574;a:13:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14134;s:4:\"orig\";i:245565;}}i:575;a:13:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16035;s:4:\"orig\";i:401592;}}i:576;a:13:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12906;s:4:\"orig\";i:483885;}}i:577;a:13:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:80956;}}i:578;a:13:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11452;s:4:\"orig\";i:175118;}}i:579;a:13:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12170;s:4:\"orig\";i:236860;}}i:580;a:13:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10268;s:4:\"orig\";i:117315;}}i:581;a:13:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12485;s:4:\"orig\";i:374567;}}i:582;a:13:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8401;s:4:\"orig\";i:203253;}}i:583;a:13:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12578;s:4:\"orig\";i:287796;}}i:584;a:13:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8484;s:4:\"orig\";i:199508;}}i:585;a:13:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16659;s:4:\"orig\";i:524922;}}i:586;a:13:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9240;s:4:\"orig\";i:109310;}}i:587;a:13:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8288;s:4:\"orig\";i:216553;}}i:588;a:13:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6855;s:4:\"orig\";i:234043;}}i:589;a:13:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12347;s:4:\"orig\";i:238706;}}i:590;a:13:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7748;s:4:\"orig\";i:169462;}}i:591;a:13:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10402;s:4:\"orig\";i:358403;}}i:592;a:13:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12887;s:4:\"orig\";i:261525;}}i:593;a:13:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:2963;s:4:\"orig\";i:30890;}}i:594;a:13:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10266;s:4:\"orig\";i:183341;}}i:595;a:13:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8156;s:4:\"orig\";i:102119;}}i:596;a:13:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10271;s:4:\"orig\";i:138495;}}i:597;a:13:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11654;s:4:\"orig\";i:171098;}}i:598;a:13:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10569;s:4:\"orig\";i:437331;}}i:599;a:13:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15739;s:4:\"orig\";i:446809;}}i:600;a:13:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9456;s:4:\"orig\";i:206722;}}i:601;a:13:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13833;s:4:\"orig\";i:341185;}}i:602;a:13:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10647;s:4:\"orig\";i:193025;}}i:603;a:13:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6239;s:4:\"orig\";i:48178;}}i:604;a:13:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14454;s:4:\"orig\";i:454843;}}i:605;a:13:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7734;s:4:\"orig\";i:119909;}}i:606;a:13:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11927;s:4:\"orig\";i:209224;}}i:607;a:13:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9609;s:4:\"orig\";i:230249;}}i:608;a:13:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12396;s:4:\"orig\";i:290596;}}i:629;a:14:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25803;s:11:\"video_thumb\";i:2753823;s:5:\"cover\";i:127867;s:4:\"orig\";i:5991847;}}i:630;a:14:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19154;s:11:\"video_thumb\";i:4783500;s:5:\"cover\";i:97843;s:4:\"orig\";i:12408832;}}i:631;a:14:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28284;s:11:\"video_thumb\";i:2150510;s:5:\"cover\";i:124176;s:4:\"orig\";i:7726114;}}i:632;a:14:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23354;s:11:\"video_thumb\";i:3635377;s:5:\"cover\";i:106283;s:4:\"orig\";i:12688465;}}i:633;a:14:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29858;s:11:\"video_thumb\";i:9614915;s:5:\"cover\";i:153660;s:4:\"orig\";i:13424151;}}i:634;a:14:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19155;s:11:\"video_thumb\";i:2361089;s:5:\"cover\";i:103588;s:4:\"orig\";i:14717688;}}i:635;a:14:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:11719;s:11:\"video_thumb\";i:4841259;s:5:\"cover\";i:40309;s:4:\"orig\";i:11715637;}}i:636;a:14:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:56469;s:11:\"video_thumb\";i:5107558;s:5:\"cover\";i:273635;s:4:\"orig\";i:13833056;}}i:637;a:14:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:30439;s:11:\"video_thumb\";i:3864288;s:5:\"cover\";i:133345;s:4:\"orig\";i:13159814;}}i:638;a:14:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31267;s:11:\"video_thumb\";i:2732735;s:5:\"cover\";i:173636;s:4:\"orig\";i:5536475;}}i:639;a:14:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29090;s:11:\"video_thumb\";i:4861363;s:5:\"cover\";i:188894;s:4:\"orig\";i:13731609;}}i:640;a:14:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31123;s:11:\"video_thumb\";i:1386258;s:5:\"cover\";i:219740;s:4:\"orig\";i:6479275;}}i:641;a:14:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21091;s:11:\"video_thumb\";i:11134706;s:5:\"cover\";i:115059;s:4:\"orig\";i:12313637;}}i:642;a:14:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19624;s:11:\"video_thumb\";i:3913179;s:5:\"cover\";i:118864;s:4:\"orig\";i:14700830;}}i:643;a:14:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:45123;s:11:\"video_thumb\";i:2547876;s:5:\"cover\";i:268587;s:4:\"orig\";i:8823724;}}i:644;a:14:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:33867;s:11:\"video_thumb\";i:5972511;s:5:\"cover\";i:172632;s:4:\"orig\";i:13869858;}}i:645;a:14:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16185;s:11:\"video_thumb\";i:4097952;s:5:\"cover\";i:160912;s:4:\"orig\";i:12307362;}}i:646;a:14:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9324;s:11:\"video_thumb\";i:1843046;s:5:\"cover\";i:94919;s:4:\"orig\";i:4938526;}}i:647;a:14:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:13455;s:11:\"video_thumb\";i:5101194;s:5:\"cover\";i:66493;s:4:\"orig\";i:11852447;}}i:648;a:14:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20003;s:11:\"video_thumb\";i:1696754;s:5:\"cover\";i:103202;s:4:\"orig\";i:12515577;}}i:649;a:14:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19377;s:11:\"video_thumb\";i:3861934;s:5:\"cover\";i:101592;s:4:\"orig\";i:13370749;}}i:650;a:14:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31120;s:11:\"video_thumb\";i:2732488;s:5:\"cover\";i:190596;s:4:\"orig\";i:13625169;}}i:651;a:14:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17475;s:11:\"video_thumb\";i:1248121;s:5:\"cover\";i:203284;s:4:\"orig\";i:4921567;}}i:652;a:14:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26132;s:11:\"video_thumb\";i:5777142;s:5:\"cover\";i:138198;s:4:\"orig\";i:12817212;}}i:653;a:14:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40668;s:11:\"video_thumb\";i:3711074;s:5:\"cover\";i:243587;s:4:\"orig\";i:12354374;}}i:654;a:14:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:41275;s:11:\"video_thumb\";i:2631988;s:5:\"cover\";i:330226;s:4:\"orig\";i:8304831;}}i:655;a:14:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:54209;s:11:\"video_thumb\";i:4596191;s:5:\"cover\";i:335804;s:4:\"orig\";i:13306988;}}i:656;a:14:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:75484;s:11:\"video_thumb\";i:3134686;s:5:\"cover\";i:461854;s:4:\"orig\";i:20337064;}}i:657;a:14:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25915;s:11:\"video_thumb\";i:2352326;s:5:\"cover\";i:136931;s:4:\"orig\";i:12104254;}}i:658;a:14:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40965;s:11:\"video_thumb\";i:8637814;s:5:\"cover\";i:195812;s:4:\"orig\";i:13878956;}}i:659;a:14:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19037;s:11:\"video_thumb\";i:3065043;s:5:\"cover\";i:65493;s:4:\"orig\";i:12935967;}}i:660;a:14:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:24344;s:11:\"video_thumb\";i:1911296;s:5:\"cover\";i:192540;s:4:\"orig\";i:4631422;}}i:661;a:14:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23517;s:11:\"video_thumb\";i:4899641;s:5:\"cover\";i:86737;s:4:\"orig\";i:12281833;}}i:662;a:14:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31844;s:11:\"video_thumb\";i:4412295;s:5:\"cover\";i:154844;s:4:\"orig\";i:10753079;}}i:663;a:14:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14905;s:11:\"video_thumb\";i:3394055;s:5:\"cover\";i:73276;s:4:\"orig\";i:11722124;}}i:664;a:14:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:48591;s:11:\"video_thumb\";i:5268295;s:5:\"cover\";i:211021;s:4:\"orig\";i:11990742;}}i:665;a:14:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27863;s:11:\"video_thumb\";i:2674570;s:5:\"cover\";i:119321;s:4:\"orig\";i:11602755;}}i:666;a:14:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27505;s:11:\"video_thumb\";i:3025283;s:5:\"cover\";i:144357;s:4:\"orig\";i:13176990;}}i:667;a:14:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22543;s:11:\"video_thumb\";i:1327376;s:5:\"cover\";i:111224;s:4:\"orig\";i:4727340;}}i:668;a:14:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:34936;s:11:\"video_thumb\";i:3198076;s:5:\"cover\";i:160493;s:4:\"orig\";i:12804022;}}i:669;a:14:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28883;s:11:\"video_thumb\";i:4750283;s:5:\"cover\";i:153687;s:4:\"orig\";i:13054569;}}i:670;a:14:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:53693;s:11:\"video_thumb\";i:9780815;s:5:\"cover\";i:341419;s:4:\"orig\";i:13738077;}}i:671;a:14:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9494;s:11:\"video_thumb\";i:942533;s:5:\"cover\";i:52833;s:4:\"orig\";i:6629299;}}i:672;a:14:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22781;s:11:\"video_thumb\";i:2415073;s:5:\"cover\";i:126450;s:4:\"orig\";i:11684367;}}i:673;a:14:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22296;s:11:\"video_thumb\";i:1465206;s:5:\"cover\";i:73047;s:4:\"orig\";i:4008355;}}i:674;a:14:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19851;s:11:\"video_thumb\";i:3023599;s:5:\"cover\";i:25426;s:4:\"orig\";i:12847145;}}i:675;a:14:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:18002;s:11:\"video_thumb\";i:1791449;s:5:\"cover\";i:101725;s:4:\"orig\";i:13746552;}}i:676;a:14:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:8176;s:11:\"video_thumb\";i:4255586;s:5:\"cover\";i:75455;s:4:\"orig\";i:10948491;}}i:677;a:14:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:46567;s:11:\"video_thumb\";i:3789289;s:5:\"cover\";i:25425;s:4:\"orig\";i:15943336;}}i:678;a:14:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26927;s:11:\"video_thumb\";i:2605391;s:5:\"cover\";i:149830;s:4:\"orig\";i:13232415;}}i:679;a:14:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20000;s:11:\"video_thumb\";i:655504;s:5:\"cover\";i:620066;s:4:\"orig\";i:13229794;}}i:680;a:14:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23213;s:11:\"video_thumb\";i:498407;s:5:\"cover\";i:308442;s:4:\"orig\";i:11108924;}}i:681;a:14:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21648;s:11:\"video_thumb\";i:109062;s:5:\"cover\";i:305957;s:4:\"orig\";i:6267674;}}i:682;a:14:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19198;s:11:\"video_thumb\";i:326656;s:5:\"cover\";i:554701;s:4:\"orig\";i:10151652;}}i:683;a:14:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14725;s:11:\"video_thumb\";i:72977;s:5:\"cover\";i:72535;s:4:\"orig\";i:4938006;}}i:684;a:14:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:12165;s:11:\"video_thumb\";i:256975;s:5:\"cover\";i:340550;s:4:\"orig\";i:9691449;}}i:685;a:14:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:36900;s:11:\"video_thumb\";i:920631;s:5:\"cover\";i:949012;s:4:\"orig\";i:13422013;}}i:686;a:14:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17289;s:11:\"video_thumb\";i:137402;s:5:\"cover\";i:300574;s:4:\"orig\";i:7528458;}}i:687;a:14:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16562;s:11:\"video_thumb\";i:161004;s:5:\"cover\";i:291708;s:4:\"orig\";i:7596827;}}i:688;a:14:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19186;s:11:\"video_thumb\";i:404406;s:5:\"cover\";i:496556;s:4:\"orig\";i:15358645;}}i:689;a:14:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11778;s:5:\"video\";i:126230;}}i:690;a:14:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9342;s:5:\"video\";i:258890;}}i:691;a:14:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22925;s:5:\"video\";i:337622;}}i:692;a:14:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13590;s:5:\"video\";i:143116;}}i:693;a:14:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12603;s:5:\"video\";i:267056;}}i:694;a:14:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11225;s:5:\"video\";i:104722;}}i:695;a:14:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16221;s:5:\"video\";i:183244;}}i:696;a:14:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15072;s:5:\"video\";i:90577;}}i:697;a:14:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11741;s:5:\"video\";i:96061;}}i:698;a:14:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15979;s:5:\"video\";i:136040;}}i:699;a:14:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13637;s:5:\"video\";i:98053;}}i:700;a:14:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14892;s:5:\"video\";i:125449;}}i:701;a:14:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16568;s:5:\"video\";i:127133;}}i:702;a:14:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19099;s:5:\"video\";i:202784;}}i:703;a:14:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21756;s:5:\"video\";i:295899;}}i:704;a:14:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20783;s:5:\"video\";i:279347;}}i:705;a:14:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17862;s:5:\"video\";i:111140;}}i:706;a:14:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10799;s:5:\"video\";i:49269;}}i:707;a:14:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14442;s:5:\"video\";i:143950;}}i:708;a:14:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16819;s:5:\"video\";i:142842;}}i:709;a:14:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12575;s:5:\"video\";i:106541;}}i:710;a:14:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12931;s:5:\"video\";i:84922;}}i:711;a:14:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18105;s:5:\"video\";i:184683;}}i:712;a:14:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13440;s:5:\"video\";i:104866;}}i:713;a:14:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17477;s:5:\"video\";i:147765;}}i:714;a:14:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36069;s:5:\"video\";i:104559;}}i:715;a:14:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20095;s:5:\"video\";i:60429;}}i:716;a:14:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:38056;s:5:\"video\";i:45726;}}i:717;a:14:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:54736;s:5:\"video\";i:26685;}}i:718;a:14:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34717;s:5:\"video\";i:16283;}}i:719;a:14:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25700;s:5:\"video\";i:38602;}}i:720;a:14:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:55897;s:5:\"video\";i:21279;}}i:721;a:14:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39579;s:5:\"video\";i:22677;}}i:722;a:14:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41903;s:5:\"video\";i:65515;}}i:723;a:14:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25902;s:5:\"video\";i:15295;}}i:724;a:14:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40029;s:5:\"video\";i:28970;}}i:725;a:14:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21834;s:5:\"video\";i:21250;}}i:726;a:14:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36633;s:5:\"video\";i:51973;}}i:727;a:14:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22669;s:5:\"video\";i:46598;}}i:728;a:14:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52537;s:5:\"video\";i:29580;}}i:729;a:14:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34343;s:5:\"video\";i:18413;}}i:730;a:14:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20519;s:5:\"video\";i:25391;}}i:731;a:14:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16265;s:5:\"video\";i:75634;}}i:732;a:14:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41495;s:5:\"video\";i:49692;}}i:733;a:14:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40417;s:5:\"video\";i:80078;}}i:734;a:14:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34150;s:5:\"video\";i:23500;}}i:735;a:14:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15426;s:5:\"video\";i:21651;}}i:736;a:14:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:33524;s:5:\"video\";i:46449;}}}s:4:\"tags\";a:23:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:35;a:3:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:2:\"ai\";s:4:\"name\";s:2:\"AI\";}i:34;a:3:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:12:\"architecture\";s:4:\"name\";s:12:\"Architecture\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:33;a:3:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:5:\"drink\";s:4:\"name\";s:5:\"Drink\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}i:32;a:3:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:10:\"technology\";s:4:\"name\";s:10:\"Technology\";}i:31;a:3:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:8:\"textures\";s:4:\"name\";s:8:\"Textures\";}}}", "no");
INSERT INTO `wp_options` VALUES("224", "revslider-templates-check", "1771111400", "no");
INSERT INTO `wp_options` VALUES("225", "revslider-templates-hash", "52d037cad5a6632d98a77c5ccc7a4483", "no");
INSERT INTO `wp_options` VALUES("226", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("227", "rs-templates", "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", "no");
INSERT INTO `wp_options` VALUES("228", "rs-templates-counter", "0", "no");
INSERT INTO `wp_options` VALUES("229", "revslider_table_version", "1.0.13", "yes");
INSERT INTO `wp_options` VALUES("232", "revslider_update_version", "6.7.24", "yes");
INSERT INTO `wp_options` VALUES("233", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("234", "rs_cache_overlay", "6.5.18", "yes");
INSERT INTO `wp_options` VALUES("235", "revslider-update-check", "1771329034", "no");
INSERT INTO `wp_options` VALUES("236", "revslider_update_info", "O:8:\"stdClass\":3:{s:7:\"checked\";i:1771329034;s:5:\"basic\";O:8:\"stdClass\":7:{s:4:\"slug\";s:9:\"revslider\";s:6:\"plugin\";s:23:\"revslider/revslider.php\";s:7:\"version\";s:6:\"6.7.41\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:5:\"6.9.0\";s:5:\"icons\";a:1:{s:2:\"1x\";s:62:\"//updates.themepunch-ext-c.tools/revslider/logo.png?rev=6.2.23\";}s:3:\"url\";s:33:\"https://www.sliderrevolution.com/\";}s:4:\"full\";O:8:\"stdClass\":20:{s:7:\"banners\";a:2:{s:3:\"low\";s:63:\"//updates.themepunch-ext-c.tools/revslider/banner.png?rev=6.5.5\";s:4:\"high\";s:63:\"//updates.themepunch-ext-c.tools/revslider/banner.png?rev=6.5.5\";}s:4:\"name\";s:17:\"Slider Revolution\";s:4:\"slug\";s:9:\"revslider\";s:6:\"plugin\";s:23:\"revslider/revslider.php\";s:6:\"stable\";s:5:\"4.2.0\";s:7:\"version\";s:6:\"6.7.41\";s:6:\"tested\";s:5:\"6.9.0\";s:14:\"upgrade_notice\";a:0:{}s:11:\"last_update\";s:10:\"2026-02-06\";s:12:\"last_updated\";s:10:\"2026-02-06\";s:8:\"requires\";s:3:\"3.6\";s:6:\"author\";s:51:\"<a href=\"https://www.themepunch.com\">ThemePunch</a>\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";s:9:\"file_name\";s:13:\"revslider.zip\";s:15:\"active_installs\";i:9100000;s:8:\"homepage\";s:33:\"https://www.sliderrevolution.com/\";s:8:\"sections\";a:3:{s:11:\"description\";s:497:\"<h4>Slider Revolution WordPress Builder Plugin</h4>\n	<p>Slider Revolution 6 is a new way to build rich & dynamic content for your websites. With our powerful visual editor, you can create modern designs in no time, and with no coding experience required.</p><p>Create Sliders & Carousels, Hero Headers, Content Modules, Full Websites, Dynamic Solutions and Special FX with our amazing Add-Ons.</p>\n	<p>200+ templates are included in our online library. Cutting edge designs. Easily customized.</p>\";s:9:\"changelog\";s:155:\"<p>For Slider Revolution\'s changelog, please visit <a \nhref=\"https://www.sliderrevolution.com/documentation/changelog/\" \ntarget=\"_blank\">this</a> site!</p>\";s:3:\"faq\";s:2178:\"<div class=\"tp-faq-content\"><div class=\"tp-faq-column tp-faq-recent\"><h4>Recent Solutions</h4><ul class=\"tp-faq-recent-content ready\"><li><a href=\"https://www.youtube.com/watch?v=sCcnw5bZqYY&amp;list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_&amp;index=2&amp;t=111s\" target=\"_blank\" title=\"Video Tutorials\">Video Tutorials</a></li><li><a href=\"https://www.themepunch.com/faq/responsive-content/\" target=\"_blank\" title=\"Responsive Content Setup\">Responsive Content Setup</a></li><li><a href=\"https://www.themepunch.com/faq/video-content-mobile/\" target=\"_blank\" title=\"Video Content &amp; Mobile Considerations\">Video Content &amp; Mobile Considerations</a></li><li><a href=\"https://www.themepunch.com/faq/how-to-change-the-timing-of-slides/\" target=\"_blank\" title=\"How to change the timing of Slides\">How to change the timing of Slides</a></li><li><a href=\"https://www.themepunch.com/faq/mouse-hovers-for-layer-content/\" target=\"_blank\" title=\"Mouse Hovers for Layer Content\"> Mouse Hovers for Layer Content</a></li></ul></div><div class=\"tp-faq-column tp-faq-popular\"><h4>Popular Solutions</h4><ul class=\"tp-faq-popular-content ready\"><li><a href=\"https://www.themepunch.com/faq/after-updating-make-sure-to-clear-all-caches/\" target=\"_blank\" title=\"After updating – Make sure to clear all caches\">After updating – Make sure to clear all caches</a></li><li><a href=\"https://www.themepunch.com/faq/purchase-code-registration-faqs/\" target=\"_blank\" title=\"Purchase Code Registration FAQ’s\">Purchase Code Registration FAQ’s</a></li><li><a href=\"https://www.themepunch.com/faq/ideal-image-size/\" target=\"_blank\" title=\"Ideal Image Size\">Ideal Image Size</a></li><li><a href=\"https://www.themepunch.com/faq/add-links-to-slides-and-layers/\" target=\"_blank\" title=\"How to Hyperlink Slides and Layers\">How to Hyperlink Slides and Layers</a></li><li><a href=\"https://www.themepunch.com/faq/where-to-find-the-purchase-code/\" target=\"_blank\" title=\"Where to find the Purchase Code\">Where to find the Purchase Code</a></li></ul></div><div style=\"clear: both\"></div><p><a class=\"button button-primary\" href=\"https://themepunch.com/support-center\"><strong>See All Faq\'s</strong></a></p></div>\";}s:3:\"url\";s:33:\"https://www.sliderrevolution.com/\";s:8:\"external\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("247", "_elementor_installed_time", "1647365291", "yes");
INSERT INTO `wp_options` VALUES("249", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("250", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("251", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("252", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("253", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("254", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("255", "auto_update_core_major", "unset", "yes");
INSERT INTO `wp_options` VALUES("256", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("257", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("258", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("266", "xtra_plugin_version", "4.4.9", "no");
INSERT INTO `wp_options` VALUES("19718", "_transient_woocommerce_admin_settings_payments_has_providers_with_incentive", "no", "off");
INSERT INTO `wp_options` VALUES("19738", "_site_transient_timeout_feed_mod_b7293ccde035c8cf244a9ddb3e8550ab", "1771372154", "off");
INSERT INTO `wp_options` VALUES("19739", "_site_transient_feed_mod_b7293ccde035c8cf244a9ddb3e8550ab", "1771328954", "off");
INSERT INTO `wp_options` VALUES("19740", "_transient_timeout_dash_v2_b994a1a794faa0049d6c8a467c47c4eb", "1771372154", "off");
INSERT INTO `wp_options` VALUES("19741", "_transient_dash_v2_b994a1a794faa0049d6c8a467c47c4eb", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wp-parsi.com/parsidate-5-1-8/\'>انتشار نگارش ۵.۱.۸ افزونهٔ پارسی‌دیت</a></li><li><a class=\'rsswidget\' href=\'https://wp-parsi.com/parsidate-5-1-7/\'>نگارش ۵.۱.۷ افزونه پارسی دیت منتشر شد</a></li><li><a class=\'rsswidget\' href=\'https://wp-parsi.com/wordpress-updates-on-speed/\'>تاثیر به‌روزرسانی‌های وردپرس روی سرعت و عملکرد سایت‌ها</a></li><li><a class=\'rsswidget\' href=\'https://wp-parsi.com/parsidate-5-1-4/\'>نگارش ۵.۱.۴ افزونه پارسی‌دیت منتشر شد</a></li><li><a class=\'rsswidget\' href=\'https://wp-parsi.com/parsidate-new/\'>مسیر جدید توسعه افزونه پارسی دیت</a></li></ul></div>", "off");
INSERT INTO `wp_options` VALUES("19757", "_site_transient_timeout_codevz_api_throttle_d3a610a6c3b583cee7246f78d5b7123d", "1771350628", "off");
INSERT INTO `wp_options` VALUES("19758", "_site_transient_codevz_api_throttle_d3a610a6c3b583cee7246f78d5b7123d", "1771329028", "off");
INSERT INTO `wp_options` VALUES("19767", "_site_transient_timeout_wp_theme_files_patterns-f3390cbe58b6e6e285c725e8f38a69ac", "1771330864", "off");
INSERT INTO `wp_options` VALUES("19768", "_site_transient_wp_theme_files_patterns-f3390cbe58b6e6e285c725e8f38a69ac", "a:2:{s:7:\"version\";s:3:\"1.0\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("19769", "_site_transient_timeout_wp_theme_files_patterns-78cc99756d3523b3b7bce40d94aaaf7f", "1771330864", "off");
INSERT INTO `wp_options` VALUES("19770", "_site_transient_wp_theme_files_patterns-78cc99756d3523b3b7bce40d94aaaf7f", "a:2:{s:7:\"version\";s:3:\"5.6\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("269", "codevz_fonts_out", "a:2:{i:0;s:17:\"font-family:dana;\";i:1;s:17:\"font-family:dana;\";}", "no");
INSERT INTO `wp_options` VALUES("272", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("276", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.5\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1647365328;s:7:\"version\";s:5:\"5.5.6\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("277", "action_scheduler_hybrid_store_demarkation", "297", "yes");
INSERT INTO `wp_options` VALUES("278", "schema-ActionScheduler_StoreSchema", "8.0.1771328769", "yes");
INSERT INTO `wp_options` VALUES("279", "schema-ActionScheduler_LoggerSchema", "3.0.1647365329", "yes");
INSERT INTO `wp_options` VALUES("282", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("283", "woocommerce_store_address", "خراسان رضوی-مشهد", "yes");
INSERT INTO `wp_options` VALUES("284", "woocommerce_store_address_2", "مشهد", "yes");
INSERT INTO `wp_options` VALUES("285", "woocommerce_store_city", "مشهد", "yes");
INSERT INTO `wp_options` VALUES("286", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_options` VALUES("287", "woocommerce_store_postcode", "12345-6789", "yes");
INSERT INTO `wp_options` VALUES("288", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("289", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("290", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("291", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("292", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("293", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("294", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("295", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("296", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("297", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("298", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `wp_options` VALUES("299", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("300", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("301", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("302", "woocommerce_shop_page_id", "154", "yes");
INSERT INTO `wp_options` VALUES("303", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("304", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("305", "woocommerce_placeholder_image", "3190", "yes");
INSERT INTO `wp_options` VALUES("306", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("307", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("308", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("309", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("310", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("311", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("312", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("313", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("314", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("315", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("316", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("317", "woocommerce_stock_email_recipient", "aref.dariavi@gmail.com", "no");
INSERT INTO `wp_options` VALUES("318", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("319", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("320", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("321", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("322", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("323", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("324", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("325", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("326", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("328", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("329", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("330", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("331", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("332", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("333", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("334", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("335", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("336", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("337", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("338", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("339", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("340", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("341", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("342", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("343", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("344", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("345", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wp_options` VALUES("346", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("347", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("348", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("349", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("350", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("351", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `wp_options` VALUES("352", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `wp_options` VALUES("353", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("354", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("355", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("356", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("357", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("358", "woocommerce_email_from_name", "xtra demo", "no");
INSERT INTO `wp_options` VALUES("359", "woocommerce_email_from_address", "aref.dariavi@gmail.com", "no");
INSERT INTO `wp_options` VALUES("360", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("361", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("362", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("363", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("364", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("365", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("366", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("367", "woocommerce_cart_page_id", "3170", "on");
INSERT INTO `wp_options` VALUES("368", "woocommerce_checkout_page_id", "156", "on");
INSERT INTO `wp_options` VALUES("369", "woocommerce_myaccount_page_id", "157", "on");
INSERT INTO `wp_options` VALUES("370", "woocommerce_terms_page_id", "", "on");
INSERT INTO `wp_options` VALUES("371", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("372", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("373", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("374", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("375", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("376", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("377", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("378", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("379", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("380", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("381", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("382", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("383", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("384", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("385", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("386", "woocommerce_show_marketplace_suggestions", "no", "on");
INSERT INTO `wp_options` VALUES("387", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("388", "woocommerce_thumbnail_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("389", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("390", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("391", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("392", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("393", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("396", "default_product_cat", "31", "yes");
INSERT INTO `wp_options` VALUES("398", "woocommerce_refund_returns_page_id", "3260", "yes");
INSERT INTO `wp_options` VALUES("401", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:15:\"admin@admin.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:15:\"admin@admin.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("402", "woocommerce_version", "10.5.1", "yes");
INSERT INTO `wp_options` VALUES("403", "woocommerce_db_version", "10.5.1", "yes");
INSERT INTO `wp_options` VALUES("404", "woocommerce_inbox_variant_assignment", "6", "yes");
INSERT INTO `wp_options` VALUES("409", "action_scheduler_lock_async-request-runner", "699456e8e43d66.00292553|1771329316", "yes");
INSERT INTO `wp_options` VALUES("410", "woocommerce_admin_notices", "a:1:{i:0;s:23:\"regenerating_thumbnails\";}", "yes");
INSERT INTO `wp_options` VALUES("411", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"bRS12oyM3M6OHUVyzwcw1Ijso9kFU21m\";}", "yes");
INSERT INTO `wp_options` VALUES("413", "widget_woocommerce_widget_cart", "a:5:{i:1;a:4:{s:5:\"title\";s:4:\"Cart\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:2;a:9:{s:5:\"title\";s:15:\"سبد خرید\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:13:\"hide_if_empty\";i:0;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:3;a:9:{s:5:\"title\";s:15:\"سبد خرید\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:13:\"hide_if_empty\";i:0;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:4;a:9:{s:5:\"title\";s:15:\"سبد خرید\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:13:\"hide_if_empty\";i:0;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("414", "widget_woocommerce_layered_nav_filters", "a:2:{i:1;a:6:{s:5:\"title\";s:25:\"فیلترهای فعال\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("415", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("416", "widget_woocommerce_price_filter", "a:8:{i:1;a:9:{s:5:\"title\";s:33:\"فیلتر بر اساس قیمت\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:2;a:9:{s:5:\"title\";s:19:\"فیلتر قیمت\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:3;a:4:{s:5:\"title\";s:15:\"Filter by price\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:4;a:6:{s:5:\"title\";s:33:\"فیلتر بر اساس قیمت\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:5;a:8:{s:5:\"title\";s:19:\"فیلتر قیمت\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:6;a:8:{s:5:\"title\";s:24:\"فیلتر با قیمت\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:7;a:8:{s:5:\"title\";s:19:\"فیلتر قیمت\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("417", "widget_woocommerce_product_categories", "a:10:{i:1;a:0:{}i:2;a:11:{s:5:\"title\";s:18:\"Product categories\";s:7:\"orderby\";s:4:\"name\";s:12:\"hierarchical\";s:1:\"1\";s:9:\"max_depth\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:3;a:0:{}i:4;a:15:{s:5:\"title\";s:39:\"دسته بندی های محصولات\";s:7:\"orderby\";s:4:\"name\";s:12:\"hierarchical\";s:1:\"1\";s:9:\"max_depth\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}i:5;a:15:{s:5:\"title\";s:30:\"دسته های محصولات\";s:7:\"orderby\";s:4:\"name\";s:12:\"hierarchical\";s:1:\"1\";s:9:\"max_depth\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}i:6;a:11:{s:5:\"title\";s:18:\"Product categories\";s:7:\"orderby\";s:4:\"name\";s:12:\"hierarchical\";s:1:\"1\";s:9:\"max_depth\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:7;a:11:{s:5:\"title\";s:18:\"Product categories\";s:7:\"orderby\";s:4:\"name\";s:12:\"hierarchical\";s:1:\"1\";s:9:\"max_depth\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:8;a:11:{s:5:\"title\";s:18:\"Product categories\";s:7:\"orderby\";s:4:\"name\";s:12:\"hierarchical\";s:1:\"1\";s:9:\"max_depth\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:9;a:9:{s:5:\"title\";s:30:\"دسته های محصولات\";s:7:\"orderby\";s:4:\"name\";s:12:\"hierarchical\";s:1:\"1\";s:9:\"max_depth\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("418", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("419", "widget_woocommerce_product_tag_cloud", "a:8:{i:1;a:8:{s:5:\"title\";s:12:\"Product tags\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:2;a:8:{s:5:\"title\";s:25:\"برچسب محصولات\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:3;a:8:{s:5:\"title\";s:32:\"برچسب های محصولات\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:4;a:8:{s:5:\"title\";s:12:\"Product tags\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:5;a:8:{s:5:\"title\";s:12:\"Product tags\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:6;a:8:{s:5:\"title\";s:12:\"Product tags\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:7;a:6:{s:5:\"title\";s:32:\"برچسب های محصولات\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("420", "widget_woocommerce_products", "a:17:{i:1;a:0:{}i:2;a:15:{s:5:\"title\";s:23:\"سایر محصولات\";s:6:\"number\";s:1:\"4\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"rand\";s:5:\"order\";s:4:\"desc\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:3;a:12:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:4;a:12:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"5\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:5;a:0:{}i:6;a:15:{s:5:\"title\";s:23:\"سایر محصولات\";s:6:\"number\";s:1:\"4\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"rand\";s:5:\"order\";s:4:\"desc\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;s:11:\"c_on_mobile\";s:1:\"1\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:7;a:14:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:8;a:14:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";s:1:\"5\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:9;a:14:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";s:1:\"5\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:10;a:12:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"5\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:11;a:12:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:12;a:12:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"5\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:13;a:14:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:16:\"center_on_mobile\";i:1;s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:14;a:12:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"5\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:15;a:10:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}i:16;a:10:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";s:1:\"4\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("421", "widget_woocommerce_recently_viewed_products", "a:8:{i:1;a:9:{s:5:\"title\";s:24:\"Recently Viewed Products\";s:6:\"number\";s:2:\"10\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:2;a:9:{s:5:\"title\";s:31:\"محصولات پیشنهادی\";s:6:\"number\";s:2:\"10\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:3;a:9:{s:5:\"title\";s:35:\"اخیرا مشاهده شده ها\";s:6:\"number\";s:2:\"10\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:16:\"center_on_mobile\";i:0;}i:4;a:9:{s:5:\"title\";s:24:\"Recently Viewed Products\";s:6:\"number\";s:2:\"10\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:5;a:9:{s:5:\"title\";s:24:\"Recently Viewed Products\";s:6:\"number\";s:2:\"10\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:6;a:9:{s:5:\"title\";s:24:\"Recently Viewed Products\";s:6:\"number\";s:2:\"10\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;s:16:\"center_on_mobile\";i:0;}i:7;a:7:{s:5:\"title\";s:46:\"محصلاتی که اخیرا دیده اید\";s:6:\"number\";s:2:\"10\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";s:14:\"hide_on_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("422", "widget_woocommerce_top_rated_products", "a:5:{i:1;a:5:{s:5:\"title\";s:18:\"Top rated products\";s:6:\"number\";s:1:\"5\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:2;a:9:{s:5:\"title\";s:34:\"محبوب ترین محصولات\";s:6:\"number\";s:1:\"5\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:3;a:9:{s:5:\"title\";s:34:\"محبوب ترین محصولات\";s:6:\"number\";s:1:\"5\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:4;a:9:{s:5:\"title\";s:34:\"محبوب ترین محصولات\";s:6:\"number\";s:1:\"5\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("423", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("424", "widget_woocommerce_rating_filter", "a:5:{i:1;a:4:{s:5:\"title\";s:14:\"Average rating\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";i:0;}i:2;a:8:{s:5:\"title\";s:27:\"متوسط امتیازات\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:3;a:8:{s:5:\"title\";s:31:\"محصولات پرطرفدار\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}i:4;a:8:{s:5:\"title\";s:27:\"متوسط امتیازات\";s:9:\"is_sticky\";i:0;s:14:\"hide_on_tablet\";i:0;s:14:\"hide_on_mobile\";s:0:\"\";s:4:\"czsk\";s:0:\"\";s:10:\"czsk_hover\";s:0:\"\";s:11:\"czsk_tablet\";s:0:\"\";s:11:\"czsk_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("427", "woocommerce_admin_version", "3.2.1", "yes");
INSERT INTO `wp_options` VALUES("428", "woocommerce_admin_install_timestamp", "1647365331", "yes");
INSERT INTO `wp_options` VALUES("429", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `wp_options` VALUES("432", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("433", "wc_admin_show_legacy_coupon_menu", "0", "yes");
INSERT INTO `wp_options` VALUES("437", "wc_blocks_surface_cart_checkout_probability", "53", "yes");
INSERT INTO `wp_options` VALUES("438", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("441", "xtra-downloaded-demo", "moving", "no");
INSERT INTO `wp_options` VALUES("442", "xtra-downloaded-folder", "elementor", "no");
INSERT INTO `wp_options` VALUES("443", "codevz_demo_path", "/home/toswpir/xtra-moving.tooswp.ir/wp-content/uploads/codevz_demo_data/moving/", "no");
INSERT INTO `wp_options` VALUES("444", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("479", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("527", "duplicator_pro_license_key", "activated", "yes");
INSERT INTO `wp_options` VALUES("528", "duplicator_pro_reset_user_settings_required", "0", "yes");
INSERT INTO `wp_options` VALUES("529", "duplicator_pro_plugin_version", "4.0.6.2", "yes");
INSERT INTO `wp_options` VALUES("1940", "rs_image_meta_todo", "a:2:{i:3050;s:86:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content/uploads/revslider/homeslider/slide1.jpg\";i:3141;s:89:\"/home/toswpir/xtra-moving.tooswp.ir/wp-content/uploads/revslider/home-slider/slider-2.jpg\";}", "yes");
INSERT INTO `wp_options` VALUES("2497", "codevz_theme_options", "a:292:{s:6:\"layout\";s:5:\"right\";s:7:\"primary\";s:7:\"primary\";s:9:\"secondary\";s:9:\"secondary\";s:10:\"responsive\";b:1;s:23:\"responsive_breakpoint_2\";s:5:\"960px\";s:23:\"responsive_breakpoint_3\";s:5:\"420px\";s:11:\"description\";s:40:\"Xtra premium all purpose WordPress theme\";s:8:\"keywords\";s:110:\"xtra,unlimited,ultimate,pro,premium,wp,WordPress,site,site builder, website builder, drag and drop,all purpose\";s:8:\"lazyload\";b:1;s:17:\"remove_query_args\";b:1;s:3:\"css\";s:90:\"/* Do Not Remove This CSS */\nheader .services div.service_text {\n    white-space: nowrap\n}\";s:10:\"site_color\";s:7:\"#ffdd00\";s:14:\"site_color_sec\";s:7:\"#1c7e68\";s:5:\"boxed\";b:0;s:12:\"_css_buttons\";s:78:\"font-weight:700;background-color:#1c7e68;border-style:solid;border-radius:5px;\";s:18:\"_css_buttons_hover\";s:39:\"color:#000000;background-color:#ffdd00;\";s:12:\"_css_widgets\";s:76:\"color:#ffffff;background-color:#1c7e68;margin-bottom:25px;border-radius:5px;\";s:18:\"_css_widgets_links\";s:14:\"color:#ffffff;\";s:21:\"_css_widgets_headline\";s:167:\"font-size:16px;color:#000000;background-color:#ffdd00;padding:10px 40px;margin-right:-45px;margin-bottom:30px;margin-left:-45px;border-radius:5px;display:inline-block;\";s:19:\"_css_input_textarea\";s:51:\"color:#000000;border-style:solid;border-radius:5px;\";s:4:\"logo\";s:65:\"https://xtra-moving.tooswp.ir/wp-content/uploads/2023/05/logo.png\";s:6:\"social\";a:3:{i:0;a:3:{s:5:\"title\";s:12:\"فیسبوک\";s:4:\"icon\";s:14:\"fa fa-facebook\";s:4:\"link\";s:1:\"#\";}i:1;a:3:{s:5:\"title\";s:20:\"اینستاگرام\";s:4:\"icon\";s:16:\"fab fa-instagram\";s:4:\"link\";s:1:\"#\";}i:2;a:3:{s:5:\"title\";s:12:\"آپارات\";s:4:\"icon\";s:15:\"fa czico-aparat\";s:4:\"link\";s:1:\"#\";}}s:15:\"social_hover_fx\";s:14:\"cz_social_fx_2\";s:19:\"social_inline_title\";b:0;s:13:\"_css_social_a\";s:132:\"font-size:18px;color:#1c7e68;background-color:rgba(255,221,0,0.04);padding:4px;margin-left:3px;border-style:solid;border-radius:5px;\";s:19:\"_css_social_a_hover\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:13:\"header_1_left\";a:1:{i:0;a:13:{s:7:\"element\";s:4:\"icon\";s:10:\"element_id\";s:13:\"header_1_left\";s:13:\"menu_location\";s:7:\"primary\";s:7:\"it_icon\";s:10:\"fa fa-bolt\";s:7:\"it_text\";s:44:\"Hello, Welcome to Xtra Construnction website\";s:5:\"sk_it\";s:29:\"font-size:14px;color:#f2f2f2;\";s:10:\"sk_it_icon\";s:14:\"color:#f2f2f2;\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:3:{s:3:\"top\";s:4:\"10px\";s:6:\"bottom\";s:4:\"10px\";s:4:\"left\";s:4:\"20px\";}}}s:14:\"header_1_right\";a:3:{i:0;a:12:{s:7:\"element\";s:4:\"icon\";s:10:\"element_id\";s:14:\"header_1_right\";s:13:\"menu_location\";s:7:\"primary\";s:7:\"it_text\";s:17:\"Free Consultation\";s:7:\"it_link\";s:6:\"#popup\";s:5:\"sk_it\";s:29:\"font-size:14px;color:#f2f2f2;\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:2:{s:3:\"top\";s:3:\"9px\";s:5:\"right\";s:4:\"25px\";}}i:1;a:9:{s:7:\"element\";s:4:\"line\";s:10:\"element_id\";s:14:\"header_1_right\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:1:{s:3:\"top\";s:4:\"10px\";}}i:2;a:9:{s:7:\"element\";s:6:\"social\";s:10:\"element_id\";s:14:\"header_1_right\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:1:{s:3:\"top\";s:4:\"11px\";}}}s:23:\"_css_container_header_1\";s:13:\"display:none;\";s:17:\"_css_row_header_1\";s:90:\"_class_shape:cz_row_shape_full_filled_left cz_row_shape_no_right;background-color:#ffdd00;\";s:20:\"_css_menu_a_header_1\";s:33:\"font-size:16px;padding: 6px  6px;\";s:26:\"_css_menu_a_hover_header_1\";s:14:\"color:#ffffff;\";s:33:\"_css_menu_a_hover_before_header_1\";s:88:\"_class_menu_fx:cz_menu_fx_fade_in;border-style:solid;border-width:0px;border-radius:4px;\";s:13:\"header_2_left\";a:1:{i:0;a:10:{s:7:\"element\";s:4:\"logo\";s:10:\"element_id\";s:13:\"header_2_left\";s:10:\"logo_width\";s:5:\"208px\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:2:{s:3:\"top\";s:4:\"42px\";s:6:\"bottom\";s:4:\"20px\";}}}s:14:\"header_2_right\";a:2:{i:0;a:19:{s:7:\"element\";s:9:\"icon_info\";s:10:\"element_id\";s:14:\"header_2_right\";s:6:\"custom\";s:24:\"Insert shortcode or HTML\";s:7:\"it_icon\";s:26:\"fa czico-081-placeholder-2\";s:7:\"it_text\";s:22:\"آدرس دفتر ما\";s:9:\"it_text_2\";s:29:\"مشهد،توس وردپرس\";s:7:\"it_link\";s:31:\"https://goo.gl/maps/oG3crkmCUcp\";s:5:\"sk_it\";s:14:\"color:#ffdd00;\";s:7:\"sk_it_2\";s:45:\"font-size:20px;color:#ffffff;font-weight:700;\";s:10:\"sk_it_icon\";s:81:\"font-size:28px;color:rgba(0,0,0,0.76);background-color:#ffdd00;border-radius:5px;\";s:16:\"sk_it_icon_hover\";s:25:\"background-color:#ffffff;\";s:11:\"search_type\";s:13:\"icon_dropdown\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:12:\"Button title\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"10px\";s:6:\"bottom\";s:4:\"28px\";s:4:\"left\";s:4:\"10px\";}}i:1;a:18:{s:7:\"element\";s:9:\"icon_info\";s:10:\"element_id\";s:14:\"header_2_right\";s:6:\"custom\";s:24:\"Insert shortcode or HTML\";s:7:\"it_icon\";s:23:\"fa czico-122-phone-call\";s:7:\"it_text\";s:19:\"شماره تماس\";s:9:\"it_text_2\";s:8:\"09350000\";s:7:\"it_link\";s:12:\"tel:09350000\";s:5:\"sk_it\";s:14:\"color:#ffdd00;\";s:7:\"sk_it_2\";s:45:\"font-size:22px;color:#ffffff;font-weight:700;\";s:10:\"sk_it_icon\";s:72:\"font-size:28px;color:#000000;background-color:#ffdd00;border-radius:5px;\";s:11:\"search_type\";s:13:\"icon_dropdown\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:12:\"Button title\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"50px\";s:6:\"bottom\";s:4:\"28px\";s:4:\"left\";s:4:\"50px\";}}}s:23:\"_css_container_header_2\";s:105:\"background-color:transparent;background-image:linear-gradient(90deg,#3f3f3f,#a1a1a1);padding-bottom:40px;\";s:20:\"_css_menu_a_header_2\";s:18:\"padding: 6px  6px;\";s:26:\"_css_menu_a_hover_header_2\";s:14:\"color:#ffffff;\";s:24:\"menus_indicator_header_2\";s:16:\"fa fa-angle-down\";s:21:\"_css_menu_ul_header_2\";s:78:\"background-color:#ffdd00;margin:1px 12px;border-style:solid;border-radius:4px;\";s:23:\"_css_menu_ul_a_header_2\";s:14:\"color:#ffffff;\";s:29:\"_css_menu_ul_a_hover_header_2\";s:14:\"color:#e2e2e2;\";s:25:\"menus_indicator2_header_2\";s:17:\"fa fa-angle-right\";s:13:\"header_3_left\";a:1:{i:0;a:9:{s:7:\"element\";s:4:\"menu\";s:10:\"element_id\";s:13:\"header_3_left\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"10px\";s:5:\"right\";s:4:\"10px\";s:6:\"bottom\";s:4:\"10px\";s:4:\"left\";s:4:\"10px\";}}}s:14:\"header_3_right\";a:2:{i:0;a:14:{s:7:\"element\";s:6:\"button\";s:10:\"element_id\";s:14:\"header_3_right\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:38:\"دریافت مشاوره رایگان\";s:8:\"btn_link\";s:141:\"https://xtra-moving.tooswp.ir/%d8%af%d8%b1%db%8c%d8%a7%d9%81%d8%aa-%d9%85%d8%b4%d8%a7%d9%88%d8%b1%d9%87-%d8%b1%d8%a7%db%8c%da%af%d8%a7%d9%86/\";s:6:\"sk_btn\";s:105:\"font-size:14px;color:#000000;font-weight:700;background-color:#ffdd00;padding:7px 25px 6px;display:block;\";s:12:\"sk_btn_hover\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"10px\";s:5:\"right\";s:4:\"10px\";s:6:\"bottom\";s:4:\"10px\";s:4:\"left\";s:4:\"10px\";}}i:1;a:12:{s:7:\"element\";s:6:\"social\";s:10:\"element_id\";s:14:\"header_3_right\";s:6:\"custom\";s:24:\"Insert shortcode or HTML\";s:7:\"it_text\";s:40:\"I am a text element and you can edit me.\";s:11:\"search_type\";s:13:\"icon_dropdown\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:12:\"Button title\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:2:{s:3:\"top\";s:4:\"10px\";s:6:\"bottom\";s:3:\"8px\";}}}s:17:\"_css_row_header_3\";s:126:\"background-color:#ffffff;margin-top:-32px;margin-bottom:-31px;border-radius:5px;box-shadow:0px 10px 60px 0px rgba(0,0,0,0.15);\";s:20:\"_css_menu_a_header_3\";s:84:\"font-size:15px;color:rgba(37,34,32,0.9);padding:6px 17px 7px;margin:0px 5px 0px 0px;\";s:26:\"_css_menu_a_hover_header_3\";s:14:\"color:#ffffff;\";s:33:\"_css_menu_a_hover_before_header_3\";s:133:\"_class_menu_fx:cz_menu_fx_fade_in;background-color:#1c7e68;width:100%;border-style:solid;border-width:0px;border-radius:5px;left:0px;\";s:24:\"menus_indicator_header_3\";s:16:\"fa fa-angle-down\";s:21:\"_css_menu_ul_header_3\";s:124:\"background-color:#ffffff;margin:1px 20px 0px;border-style:solid;border-radius:5px;box-shadow:0px 10px 60px rgba(0,0,0,0.15);\";s:23:\"_css_menu_ul_a_header_3\";s:53:\"font-size:16px;color:rgba(0,0,0,0.7);font-weight:500;\";s:29:\"_css_menu_ul_a_hover_header_3\";s:14:\"color:#000000;\";s:25:\"menus_indicator2_header_3\";s:17:\"fa fa-angle-right\";s:12:\"smart_sticky\";b:1;s:23:\"_css_container_header_5\";s:25:\"background-color:#2e2e2e;\";s:13:\"header_4_left\";a:1:{i:0;a:10:{s:7:\"element\";s:4:\"logo\";s:10:\"element_id\";s:13:\"header_4_left\";s:10:\"logo_width\";s:5:\"160px\";s:13:\"menu_location\";s:7:\"primary\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:2:{s:3:\"top\";s:4:\"20px\";s:6:\"bottom\";s:4:\"15px\";}}}s:14:\"header_4_right\";a:2:{i:0;a:11:{s:7:\"element\";s:4:\"menu\";s:10:\"element_id\";s:14:\"header_4_right\";s:13:\"menu_location\";s:7:\"primary\";s:9:\"menu_type\";s:20:\"offcanvas_menu_right\";s:12:\"sk_menu_icon\";s:75:\"color:#000000;background-color:#ffdd00;border-style:none;border-radius:5px;\";s:11:\"search_type\";s:4:\"form\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:3:{s:3:\"top\";s:4:\"20px\";s:5:\"right\";s:3:\"3px\";s:6:\"bottom\";s:4:\"20px\";}}i:1;a:16:{s:7:\"element\";s:4:\"icon\";s:10:\"element_id\";s:14:\"header_4_right\";s:13:\"menu_location\";s:7:\"primary\";s:9:\"menu_type\";s:20:\"offcanvas_menu_right\";s:7:\"it_icon\";s:11:\"fa fa-phone\";s:7:\"it_link\";s:12:\"tel:09350000\";s:10:\"sk_it_icon\";s:103:\"font-size:24px;color:#ffffff;background-color:#1c7e68;padding:10px;border-style:none;border-radius:5px;\";s:11:\"search_type\";s:9:\"icon_full\";s:18:\"search_placeholder\";s:10:\"Search ...\";s:15:\"sk_search_input\";s:72:\"padding-top:10px;padding-bottom:10px;margin-top:10px;border-radius:10px;\";s:11:\"ajax_search\";s:1:\"1\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_1\";s:10:\"wpml_title\";s:15:\"translated_name\";s:6:\"margin\";a:4:{s:3:\"top\";s:4:\"20px\";s:5:\"right\";s:3:\"6px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:3:\"8px\";}}}s:23:\"_css_container_header_4\";s:25:\"background-color:#000000;\";s:28:\"_css_menu_container_header_4\";s:60:\"background-size:cover;background-color:#1c7e68;padding:30px;\";s:20:\"_css_menu_a_header_4\";s:69:\"color:#ffffff;margin-bottom:10px;border-style:none;border-radius:5px;\";s:26:\"_css_menu_a_hover_header_4\";s:39:\"color:#000000;background-color:#ffdd00;\";s:24:\"menus_indicator_header_4\";s:16:\"fa fa-angle-down\";s:23:\"_css_menu_ul_a_header_4\";s:54:\"margin-bottom:6px;border-style:none;border-radius:5px;\";s:29:\"_css_menu_ul_a_hover_header_4\";s:39:\"color:#ffffff;background-color:#252220;\";s:25:\"menus_indicator2_header_4\";s:16:\"fa fa-angle-down\";s:10:\"page_cover\";s:5:\"title\";s:10:\"page_title\";s:1:\"6\";s:21:\"breadcrumbs_home_icon\";s:10:\"fa fa-home\";s:21:\"breadcrumbs_separator\";s:24:\"fa fa-angle-double-right\";s:15:\"_css_page_title\";s:127:\"background-color:#ffdd00;padding-top:60px;padding-bottom:15px;border-style:solid;border-width:0px 0px 1px;border-color:#f4f4f4;\";s:21:\"_css_page_title_color\";s:36:\"font-size:20px;margin:0px 26px 10px;\";s:26:\"_css_breadcrumbs_container\";N;s:32:\"_css_breadcrumbs_inner_container\";s:50:\"margin-top:0px;margin-right:20px;margin-left:10px;\";s:14:\"_css_body_typo\";s:17:\"font-family:dana;\";s:13:\"footer_layout\";s:5:\"s6,s6\";s:11:\"_css_footer\";s:38:\"padding-top:100px;padding-bottom:50px;\";s:18:\"_css_footer_widget\";s:41:\"color:#dddddd;padding:0px 10px 10px 10px;\";s:13:\"_css_footer_a\";s:28:\"color:#ffffff;line-height: 2\";s:19:\"_css_footer_a_hover\";s:14:\"color:#c6c6c6;\";s:15:\"footer_2_center\";a:1:{i:0;a:13:{s:7:\"element\";s:4:\"icon\";s:10:\"element_id\";s:15:\"footer_2_center\";s:6:\"custom\";s:24:\"Insert shortcode or HTML\";s:7:\"it_text\";s:163:\" © کپی رایت [cz_current_year] توسعه توسط مارکت <a href=\"https://toswp.ir/\" target=\"_blank\" rel=\"noopener noreferrer\">توس وردپرس</a>\";s:5:\"sk_it\";s:62:\"font-size:14px;color:rgba(255,255,255,0.37);text-align:center;\";s:11:\"search_type\";s:13:\"icon_dropdown\";s:22:\"inview_position_widget\";s:11:\"inview_left\";s:9:\"btn_title\";s:12:\"Button title\";s:11:\"shop_plugin\";s:3:\"woo\";s:9:\"line_type\";s:13:\"header_line_2\";s:10:\"wpml_title\";s:15:\"translated_name\";s:11:\"avatar_size\";s:4:\"40px\";s:6:\"margin\";a:2:{s:3:\"top\";s:4:\"20px\";s:6:\"bottom\";s:4:\"20px\";}}}s:17:\"_css_row_footer_2\";s:75:\"border-style:solid;border-top-width:1px;border-color:rgba(255,255,255,0.1);\";s:9:\"backtotop\";s:14:\"fa fa-angle-up\";s:14:\"_css_backtotop\";s:97:\"font-size:18px;border-style:none;border-radius:55px;box-shadow:1px 8px 32px 0px rgba(0,0,0,0.08);\";s:25:\"_css_cf7_beside_backtotop\";s:92:\"font-size:18px;border-style:none;border-radius:5px;box-shadow:1px 8px 32px rgba(0,0,0,0.08);\";s:14:\"meta_data_post\";a:7:{i:0;s:5:\"image\";i:1;s:4:\"date\";i:2;s:6:\"author\";i:3;s:4:\"cats\";i:4;s:4:\"tags\";i:5;s:10:\"author_box\";i:6;s:9:\"next_prev\";}s:12:\"related_post\";s:21:\"You May Also Like ...\";s:14:\"slug_portfolio\";s:8:\"projects\";s:15:\"title_portfolio\";s:15:\"پروژه ها\";s:13:\"cat_portfolio\";s:12:\"projects/cat\";s:19:\"cat_title_portfolio\";s:22:\"دسته بندی ها\";s:14:\"tags_portfolio\";s:13:\"projects/tags\";s:20:\"tags_title_portfolio\";s:15:\"برچسب ها\";s:18:\"template_portfolio\";s:3:\"574\";s:19:\"meta_data_portfolio\";a:3:{i:0;s:4:\"date\";i:1;s:4:\"cats\";i:2;s:4:\"tags\";}s:17:\"related_portfolio\";s:21:\"You May Also Like ...\";s:16:\"layout_portfolio\";s:2:\"ws\";s:17:\"primary_portfolio\";s:7:\"primary\";s:19:\"secondary_portfolio\";s:9:\"secondary\";s:19:\"page_coverportfolio\";s:1:\"1\";s:19:\"page_titleportfolio\";s:1:\"1\";s:24:\"_css_page_titleportfolio\";N;s:30:\"_css_page_title_colorportfolio\";N;s:42:\"_css_page_title_breadcrumbs_colorportfolio\";N;s:35:\"_css_breadcrumbs_containerportfolio\";N;s:41:\"_css_breadcrumbs_inner_containerportfolio\";N;s:37:\"_css_right_br_full_containerportfolio\";N;s:23:\"_css_sidebar-1_search-2\";N;s:29:\"_css_sidebar-1_recent-posts-2\";N;s:32:\"_css_sidebar-1_recent-comments-2\";N;s:25:\"_css_sidebar-1_archives-2\";N;s:27:\"_css_sidebar-1_categories-2\";N;s:21:\"_css_sidebar-1_meta-2\";N;s:28:\"_css_footer_widget_headlines\";s:127:\"font-size:18px;color:#ffffff;border-style:solid;border-bottom-width:4px;border-color:rgba(28,126,104,0.6);display:inline-block;\";s:20:\"page_cover_portfolio\";s:1:\"1\";s:20:\"_css_backtotop_hover\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:31:\"_css_cf7_beside_backtotop_hover\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:20:\"page_title_portfolio\";s:1:\"1\";s:36:\"_css_breadcrumbs_container_portfolio\";N;s:18:\"page_cover_product\";s:1:\"1\";s:18:\"page_title_product\";s:1:\"1\";s:34:\"_css_breadcrumbs_container_product\";N;s:14:\"layout_product\";s:2:\"ws\";s:15:\"primary_product\";s:7:\"primary\";s:17:\"secondary_product\";s:9:\"secondary\";s:7:\"woo_col\";s:1:\"4\";s:18:\"woo_items_per_page\";s:1:\"8\";s:23:\"_css_woo_products_title\";s:48:\"font-size:18px;color:#000000;margin-bottom:10px;\";s:23:\"_css_woo_products_stars\";s:13:\"display:none;\";s:29:\"_css_woo_products_add_to_cart\";s:160:\"color:rgba(0,0,0,0.79);background-color:rgba(0,0,0,0.15);padding-top:20px;padding-bottom:20px;margin-top:0px;border-radius:0 0 5px 5px;display:block;float:none;\";s:24:\"_css_woo_products_onsale\";s:164:\"font-size:16px;color:#000000;line-height:2em;background-color:#ffdd00;width:2em;height:2em;padding:3px 10px;border-style:solid;border-radius:5px;top:10px;left:10px;\";s:23:\"_css_woo_products_price\";s:92:\"font-size:16px;color:#252220;background-color:#ededed;border-radius:5px;top:10px;right:10px;\";s:22:\"_css_woo_product_price\";s:29:\"font-size:26px;color:#ffdd00;\";s:16:\"_css_woo_buttons\";s:39:\"color:#ffffff;background-color:#ffdd00;\";s:22:\"_css_woo_buttons_hover\";s:51:\"color:#ffdd00;background-color:rgba(255,221,0,0.1);\";s:21:\"_css_primary_search-2\";N;s:27:\"_css_primary_recent-posts-2\";N;s:30:\"_css_primary_recent-comments-2\";N;s:23:\"_css_primary_archives-2\";N;s:25:\"_css_primary_categories-2\";N;s:19:\"_css_primary_meta-2\";N;s:24:\"_css_footer-2_nav_menu-2\";N;s:24:\"_css_footer-3_nav_menu-3\";N;s:24:\"_css_footer-4_nav_menu-4\";N;s:24:\"posts_per_page_portfolio\";s:1:\"6\";s:8:\"readmore\";s:19:\"ادامه مطلب\";s:13:\"readmore_icon\";s:19:\"fa czico-061-menu-4\";s:17:\"_css_all_img_tags\";s:18:\"border-radius:5px;\";s:20:\"_css_tags_categories\";s:112:\"background-color:rgba(255,255,255,0.1);padding-right:20px;padding-left:20px;border-style:none;border-radius:5px;\";s:26:\"_css_tags_categories_hover\";s:39:\"color:#1c7e68;background-color:#ffdd00;\";s:18:\"_css_pagination_li\";s:89:\"color:#ffffff;background-color:rgba(28,126,104,0.38);border-style:none;border-radius:5px;\";s:21:\"_css_pagination_hover\";s:39:\"color:#ffdd00;background-color:#2e2e2e;\";s:17:\"hide_br_on_mobile\";b:1;s:17:\"hide_br_on_tablet\";b:1;s:16:\"related_post_col\";s:2:\"s4\";s:16:\"related_post_ppp\";s:1:\"3\";s:13:\"_css_readmore\";s:39:\"color:#ffffff;background-color:#1c7e68;\";s:19:\"_css_readmore_hover\";s:39:\"color:#000000;background-color:#ffdd00;\";s:15:\"_css_readmore_i\";s:45:\"font-size:20px;color:#ffffff;margin-top:-1px;\";s:21:\"_css_readmore_hover_i\";N;s:17:\"columns_portfolio\";s:1:\"3\";s:12:\"woo_template\";s:1:\"2\";s:15:\"woo_related_col\";s:1:\"3\";s:26:\"_css_woo_product_thumbnail\";s:66:\"border-style:solid;border-width:1px;border-color:rgba(0,0,0,0.15);\";s:24:\"_css_primary_tag_cloud-2\";N;s:30:\"_css_primary_codevzinstagram-2\";N;s:30:\"_css_primary_codevzsimpleads-2\";N;s:33:\"_css_footer-1_codevzpagecontent-2\";N;s:37:\"_css_footer-2_codevzcustommenulist2-2\";N;s:37:\"_css_footer-3_codevzcustommenulist2-3\";N;s:37:\"_css_footer-4_codevzcustommenulist2-4\";N;s:10:\"nicescroll\";b:0;s:18:\"hide_on_mobile_brt\";a:1:{i:0;s:20:\"title_hide_on_mobile\";}s:34:\"responsive_breakpoint_2_custom_css\";s:81:\".page_title, .header_onthe_cover .page_title {\n    padding: 10px 0 0 !important\n}\";s:34:\"responsive_breakpoint_3_custom_css\";s:81:\".page_title, .header_onthe_cover .page_title {\n    padding: 10px 0 0 !important\n}\";s:24:\"_css_menu_ul_ul_header_3\";s:52:\"margin-top:-12px;margin-right:12px;margin-left:12px;\";s:28:\"_css_page_title_color_tablet\";s:15:\"margin-top:0px;\";s:39:\"_css_breadcrumbs_inner_container_tablet\";s:15:\"margin-top:4px;\";s:22:\"_css_page_title_tablet\";s:17:\"padding-top:20px;\";s:28:\"_css_page_title_color_mobile\";s:63:\"display:block;font-size:16px;margin-left:2px;CDVZwidth:100%CDVZ\";s:39:\"_css_breadcrumbs_inner_container_mobile\";s:13:\"display:none;\";s:25:\"_css_woo_products_overall\";s:92:\"border-style:solid;border-width:1px;border-color:rgba(0,0,0,0.15);border-radius:5px 5px 0 0;\";s:31:\"_css_woo_products_overall_hover\";s:44:\"box-shadow:0px 10px 50px rgba(46,46,46,0.2);\";s:17:\"row_type_footer_1\";s:4:\"page\";s:20:\"page_as_row_footer_1\";s:3:\"686\";s:14:\"template_style\";s:1:\"1\";s:14:\"posts_per_page\";s:1:\"4\";s:6:\"sticky\";b:1;s:20:\"_css_next_prev_icons\";s:57:\"color:#1c7e68;background-color:#ffdd00;border-radius:5px;\";s:26:\"_css_next_prev_icons_hover\";s:39:\"color:#1c7e68;background-color:#ffffff;\";s:18:\"_css_next_prev_con\";s:56:\"background-color:#1c7e68;padding:30px;border-radius:5px;\";s:21:\"_css_next_prev_titles\";s:14:\"color:#ffffff;\";s:18:\"related_posts_post\";s:21:\"مطالب مرتبط\";s:9:\"prev_post\";s:8:\"قبلی\";s:9:\"next_post\";s:8:\"بعدی\";s:15:\"_css_post_title\";s:17:\"padding-top:10px;\";s:13:\"wp_login_logo\";s:81:\"http://sunthemes.ir/wordpress/xtra/moving/wp-content/uploads/2017/06/logo-1-1.png\";s:14:\"_wp_login_form\";s:25:\"background-color:#191919;\";s:16:\"_wp_login_button\";s:73:\"color:#000000;background-color:#ffdd00;border-style:none;box-shadow:none;\";s:11:\"_css_select\";s:18:\"border-radius:5px;\";s:20:\"_css_select_dropdown\";s:18:\"border-radius:5px;\";s:30:\"_css_menu_indicator_a_header_3\";s:34:\"_class_indicator:fa fa-angle-down;\";s:33:\"_css_menu_ul_a_indicator_header_3\";s:35:\"_class_indicator:fa fa-angle-right;\";s:33:\"_css_menu_ul_indicator_a_header_3\";s:35:\"_class_indicator:fa fa-angle-right;\";s:14:\"social_tooltip\";s:24:\"cz_tooltip cz_tooltip_up\";s:19:\"_css_social_tooltip\";s:110:\"color:#ffffff;font-weight:500;background-color:#1c7e68;padding-right:16px;padding-left:16px;border-radius:5px;\";s:9:\"fonts_out\";a:2:{i:0;s:17:\"font-family:dana;\";i:1;s:17:\"font-family:dana;\";}s:24:\"template_style_portfolio\";s:2:\"10\";s:7:\"css_out\";s:18569:\"\n\n/* Theme color */a:hover, .sf-menu > .cz.current_menu > a, .sf-menu > .cz .cz.current_menu > a,.sf-menu > .current-menu-parent > a,.comment-text .star-rating span {color: #ffdd00} \nform button, .button, #edd-purchase-button, .edd-submit, .edd-submit.button.blue, .edd-submit.button.blue:hover, .edd-submit.button.blue:focus, [type=submit].edd-submit, .sf-menu > .cz > a:before,.sf-menu > .cz > a:before,\n.post-password-form input[type=\"submit\"], .wpcf7-submit, .submit_user, \n#commentform #submit, .commentlist li.bypostauthor > .comment-body:after,.commentlist li.comment-author-admin > .comment-body:after, \n .pagination .current, .pagination > b, .pagination a:hover, .page-numbers .current, .page-numbers a:hover, .pagination .next:hover, \n.pagination .prev:hover, input[type=submit], .sticky:before, .commentlist li.comment-author-admin .fn,\ninput[type=submit],input[type=button],.cz_header_button,.cz_default_portfolio a,\n.cz_readmore, .more-link, a.cz_btn, .cz_highlight_1:after, div.cz_btn ,.woocommerce input.button.alt.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.woocommerce .woocommerce-error .button,.woocommerce .woocommerce-info .button, .woocommerce .woocommerce-message .button, .woocommerce-page .woocommerce-error .button, .woocommerce-page .woocommerce-info .button, .woocommerce-page .woocommerce-message .button,#add_payment_method table.cart input, .woocommerce-cart table.cart input:not(.input-text), .woocommerce-checkout table.cart input,.woocommerce input.button:disabled, .woocommerce input.button:disabled[disabled],#add_payment_method table.cart input, #add_payment_method .wc-proceed-to-checkout a.checkout-button, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,.woocommerce #payment #place_order, .woocommerce-page #payment #place_order,.woocommerce input.button.alt,.woocommerce #respond input#submit.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current, .widget_product_search #searchsubmit,.woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce div.product form.cart .button, .xtra-product-icons,.woocommerce button.button.alt {background-color: #ffdd00}\n.cs_load_more_doing, div.wpcf7 .wpcf7-form .ajax-loader {border-right-color: #ffdd00}\ninput:focus,textarea:focus,select:focus {border-color: #ffdd00 !important}\n::selection {background-color: #ffdd00;color: #fff}\n::-moz-selection {background-color: #ffdd00;color: #fff}\n\n/* Dynamic  */form button,.comment-form button,a.cz_btn,div.cz_btn,a.cz_btn_half_to_fill:before,a.cz_btn_half_to_fill_v:before,a.cz_btn_half_to_fill:after,a.cz_btn_half_to_fill_v:after,a.cz_btn_unroll_v:before, a.cz_btn_unroll_h:before,a.cz_btn_fill_up:before,a.cz_btn_fill_down:before,a.cz_btn_fill_left:before,a.cz_btn_fill_right:before,.wpcf7-submit,input[type=submit],input[type=button],.button,.cz_header_button,.woocommerce a.button,.woocommerce input.button,.woocommerce #respond input#submit.alt,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, #edd-purchase-button, .edd-submit, [type=submit].edd-submit, .edd-submit.button.blue,.woocommerce #payment #place_order, .woocommerce-page #payment #place_order,.woocommerce button.button:disabled, .woocommerce button.button:disabled[disabled], .woocommerce a.button.wc-forward,.wp-block-search .wp-block-search__button,.woocommerce-message a.restore-item.button{font-weight:700;background-color:#1c7e68;border-style:solid;border-radius:5px}form button:hover,.comment-form button:hover,a.cz_btn:hover,div.cz_btn:hover,a.cz_btn_half_to_fill:hover:before, a.cz_btn_half_to_fill_v:hover:before,a.cz_btn_half_to_fill:hover:after, a.cz_btn_half_to_fill_v:hover:after,a.cz_btn_unroll_v:after, a.cz_btn_unroll_h:after,a.cz_btn_fill_up:after,a.cz_btn_fill_down:after,a.cz_btn_fill_left:after,a.cz_btn_fill_right:after,.wpcf7-submit:hover,input[type=submit]:hover,input[type=button]:hover,.button:hover,.cz_header_button:hover,.woocommerce a.button:hover,.woocommerce input.button:hover,.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:hover,.woocommerce button.button.alt:hover,.woocommerce input.button.alt:hover,.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, #edd-purchase-button:hover, .edd-submit:hover, [type=submit].edd-submit:hover, .edd-submit.button.blue:hover, .edd-submit.button.blue:focus,.woocommerce #payment #place_order:hover, .woocommerce-page #payment #place_order:hover,.woocommerce div.product form.cart .button:hover,.woocommerce button.button:disabled:hover, .woocommerce button.button:disabled[disabled]:hover, .woocommerce a.button.wc-forward:hover,.wp-block-search .wp-block-search__button:hover,.woocommerce-message a.restore-item.button:hover{color:#000000;background-color:#ffdd00}.widget{color:#ffffff;background-color:#1c7e68;margin-bottom:25px;border-radius:5px}.widget a{color:#ffffff}.widget > .codevz-widget-title, .sidebar_inner .widget_block > div > div > h2{font-size:16px;color:#000000;background-color:#ffdd00;padding:10px 40px;margin-right:-45px;margin-bottom:30px;margin-left:-45px;border-radius:5px;display:inline-block}input,textarea,select,.qty,.woocommerce-input-wrapper .select2-selection--single,#add_payment_method table.cart td.actions .coupon .input-text, .woocommerce-cart table.cart td.actions .coupon .input-text, .woocommerce-checkout table.cart td.actions .coupon .input-text,.woocommerce form .form-row .input-text, .woocommerce form .form-row select{color:#000000;border-style:solid;border-radius:5px}.elms_row .cz_social a, .fixed_side .cz_social a, #xtra-social-popup [class*=\"xtra-social-type-\"] a{font-size:18px;color:#1c7e68;background-color:rgba(255,221,0,0.04);padding:4px;margin-left:3px;border-style:solid;border-radius:5px}.elms_row .cz_social a:hover, .fixed_side .cz_social a:hover, #xtra-social-popup [class*=\"xtra-social-type-\"] a:hover{color:#ffffff;background-color:#1c7e68}.header_1{display:none}.header_1 .row{background-color:#ffdd00}#menu_header_1 > .cz > a{font-size:16px;padding: 6px  6px}#menu_header_1 > .cz > a:hover,#menu_header_1 > .cz:hover > a,#menu_header_1 > .cz.current_menu > a,#menu_header_1 > .current-menu-parent > a{color:#ffffff}#menu_header_1 > .cz > a:before{border-style:solid;border-width:0px;border-radius:4px}.header_2{background-color:transparent;background-image:linear-gradient(90deg,#3f3f3f,#a1a1a1);padding-bottom:40px}#menu_header_2 > .cz > a{padding: 6px  6px}#menu_header_2 > .cz > a:hover,#menu_header_2 > .cz:hover > a,#menu_header_2 > .cz.current_menu > a,#menu_header_2 > .current-menu-parent > a{color:#ffffff}#menu_header_2 .cz .sub-menu:not(.cz_megamenu_inner_ul),#menu_header_2 .cz_megamenu_inner_ul .cz_megamenu_inner_ul{background-color:#ffdd00;margin:1px 12px;border-style:solid;border-radius:4px}#menu_header_2 .cz .cz a{color:#ffffff}#menu_header_2 .cz .cz a:hover,#menu_header_2 .cz .cz:hover > a,#menu_header_2 .cz .cz.current_menu > a,#menu_header_2 .cz .current_menu > .current_menu{color:#e2e2e2}.header_3 .row{background-color:#ffffff;margin-top:-32px;margin-bottom:-31px;border-radius:5px;box-shadow:0px 10px 60px 0px rgba(0,0,0,0.15)}#menu_header_3 > .cz > a{font-size:15px;color:rgba(37,34,32,0.9);padding:6px 17px 7px;margin:0px 5px 0px 0px}#menu_header_3 > .cz > a:hover,#menu_header_3 > .cz:hover > a,#menu_header_3 > .cz.current_menu > a,#menu_header_3 > .current-menu-parent > a{color:#ffffff}#menu_header_3 > .cz > a:before{background-color:#1c7e68;width:100%;border-style:solid;border-width:0px;border-radius:5px;left:0px}#menu_header_3 .cz .sub-menu:not(.cz_megamenu_inner_ul),#menu_header_3 .cz_megamenu_inner_ul .cz_megamenu_inner_ul{background-color:#ffffff;margin:1px 20px 0px;border-style:solid;border-radius:5px;box-shadow:0px 10px 60px rgba(0,0,0,0.15)}#menu_header_3 .cz .cz a{font-size:16px;color:rgba(0,0,0,0.7);font-weight:500}#menu_header_3 .cz .cz a:hover,#menu_header_3 .cz .cz:hover > a,#menu_header_3 .cz .cz.current_menu > a,#menu_header_3 .cz .current_menu > .current_menu{color:#000000}.onSticky{background-color:#2e2e2e !important}.header_4{background-color:#000000}#menu_header_4{background-size:cover;background-color:#1c7e68;padding:30px}#menu_header_4 > .cz > a{color:#ffffff;margin-bottom:10px;border-style:none;border-radius:5px}#menu_header_4 > .cz > a:hover,#menu_header_4 > .cz:hover > a,#menu_header_4 > .cz.current_menu > a,#menu_header_4 > .current-menu-parent > a{color:#000000;background-color:#ffdd00}#menu_header_4 .cz .cz a{margin-bottom:6px;border-style:none;border-radius:5px}#menu_header_4 .cz .cz a:hover,#menu_header_4 .cz .cz:hover > a,#menu_header_4 .cz .cz.current_menu > a,#menu_header_4 .cz .current_menu > .current_menu{color:#ffffff;background-color:#252220}.page_title,.header_onthe_cover .page_title{background-color:#ffdd00;padding-top:60px;padding-bottom:15px;border-style:solid;border-width:0px 0px 1px;border-color:#f4f4f4}.page_title .codevz-section-title{font-size:20px;margin:0px 26px 10px}.breadcrumbs{margin-top:0px;margin-right:20px;margin-left:10px}[class*=\"cz_tooltip_\"] [data-title]:after,[data-count]:after{font-family:\'dana\'}body, body.rtl, .rtl form, .xtra-fixed-mobile-nav-e > div{font-family:\'dana\'}.cz_middle_footer{padding-top:100px;padding-bottom:50px}.footer_widget{color:#dddddd;padding:0px 10px 10px 10px}.cz_middle_footer a{color:#ffffff;line-height: 2}.cz_middle_footer a:hover{color:#c6c6c6}.footer_2 .row{border-style:solid;border-top-width:1px;border-color:rgba(255,255,255,0.1)}i.backtotop{font-size:18px;border-style:none;border-radius:55px;box-shadow:1px 8px 32px 0px rgba(0,0,0,0.08)}i.fixed_contact{font-size:18px;border-style:none;border-radius:5px;box-shadow:1px 8px 32px rgba(0,0,0,0.08)}.footer_widget > .codevz-widget-title, footer .widget_block > div > div > h2{font-size:18px;color:#ffffff;border-style:solid;border-bottom-width:4px;border-color:rgba(28,126,104,0.6);display:inline-block}i.backtotop:hover{color:#ffffff;background-color:#1c7e68}i.fixed_contact:hover,i.fixed_contact_active{color:#ffffff;background-color:#1c7e68}.woocommerce ul.products li.product .woocommerce-loop-category__title, .woocommerce ul.products li.product .woocommerce-loop-product__title, .woocommerce ul.products li.product h3,.woocommerce.woo-template-2 ul.products li.product .woocommerce-loop-category__title, .woocommerce.woo-template-2 ul.products li.product .woocommerce-loop-product__title, .woocommerce.woo-template-2 ul.products li.product h3{font-size:18px;color:#000000;margin-bottom:10px}.woocommerce ul.products li.product .star-rating{display:none}.woocommerce ul.products li.product .button.add_to_cart_button, .woocommerce ul.products li.product .button[class*=\"product_type_\"]{color:rgba(0,0,0,0.79);background-color:rgba(0,0,0,0.15);padding-top:20px;padding-bottom:20px;margin-top:0px;border-radius:0 0 5px 5px;display:block;float:none}.woocommerce span.onsale, .woocommerce ul.products li.product .onsale,.woocommerce.single span.onsale, .woocommerce.single ul.products li.product .onsale{font-size:16px;color:#000000;line-height:2em;background-color:#ffdd00;width:2em;height:2em;padding:3px 10px;border-style:solid;border-radius:5px;top:10px;left:10px}.woocommerce ul.products li.product .price{font-size:16px;color:#252220;background-color:#ededed;border-radius:5px;top:10px;right:10px}.woocommerce div.product .summary > p.price, .woocommerce div.product .summary > span.price{font-size:26px;color:#ffdd00}.page_content img, a.cz_post_image img, footer img, .cz_image_in, .wp-block-gallery figcaption, .cz_grid .cz_grid_link{border-radius:5px}.tagcloud a, .widget .tagcloud a, .cz_post_cat a, .cz_post_views a{background-color:rgba(255,255,255,0.1);padding-right:20px;padding-left:20px;border-style:none;border-radius:5px}.tagcloud a:hover, .widget .tagcloud a:hover, .cz_post_cat a:hover, .cz_post_views a:hover{color:#1c7e68;background-color:#ffdd00}.pagination a, .pagination > b, .pagination span, .page-numbers a, .page-numbers span, .woocommerce nav.woocommerce-pagination ul li a, .woocommerce nav.woocommerce-pagination ul li span{color:#ffffff;background-color:rgba(28,126,104,0.38);border-style:none;border-radius:5px}.cz-cpt-post .cz_readmore, .cz-cpt-post .more-link{color:#ffffff;background-color:#1c7e68}.cz-cpt-post .cz_readmore:hover, .cz-cpt-post .more-link:hover{color:#000000;background-color:#ffdd00}.cz-cpt-post .cz_readmore i, .cz-cpt-post .more-link i{font-size:20px;color:#ffffff;margin-top:-1px}.woocommerce div.product div.images .flex-viewport{border-style:solid;border-width:1px;border-color:rgba(0,0,0,0.15)}#menu_header_3 .sub-menu .sub-menu:not(.cz_megamenu_inner_ul){margin-top:-12px;margin-right:12px;margin-left:12px}.woocommerce ul.products li.product .woocommerce-loop-product__link{border-style:solid;border-width:1px;border-color:rgba(0,0,0,0.15);border-radius:5px 5px 0 0}.woocommerce ul.products li.product:hover .woocommerce-loop-product__link{box-shadow:0px 10px 50px rgba(46,46,46,0.2)}.next_prev .previous i,.next_prev .next i{color:#1c7e68;background-color:#ffdd00;border-radius:5px}.next_prev .previous:hover i,.next_prev .next:hover i{color:#1c7e68;background-color:#ffffff}.next_prev{background-color:#1c7e68;padding:30px;border-radius:5px}.next_prev h4{color:#ffffff}.cz-cpt-post .cz_default_loop .cz_post_title h3{padding-top:10px}[class*=\"cz_tooltip_\"] [data-title]:after{color:#ffffff;font-weight:500;background-color:#1c7e68;padding-right:16px;padding-left:16px;border-radius:5px}.cz-cpt-portfolio article .cz_post_icon{font-size:18px;padding:15px;top:auto;right:10px;bottom:10px;left:auto}.rtl.cz-cpt-portfolio article .cz_post_icon{left:17%}.cz-cpt-portfolio .cz_default_loop .cz_post_image, .cz-cpt-portfolio .cz_post_svg{border-radius:10px}.page_footer{background-image:linear-gradient(90deg,rgba(68,66,64,0.64),rgba(68,66,64,0.64)),url(https://xtra-moving.tooswp.ir/wp-content/uploads/2019/06/bg1.jpg);border-style:solid;border-bottom-width:4px;border-color:#ffdd00}.cz-cpt-post .cz_default_loop > div{border-radius:5px}.cz-cpt-post article .cz_post_icon{color:#ffdd00;background-color:#1c7e68;border-radius:55px}.cz-cpt-post .cz_post_image, .cz-cpt-post .cz_post_svg{border-color:#ffffff;border-radius:5px}.cz-cpt-post .cz_readmore:hover i, .cz-cpt-post .more-link:hover i{color:#000000}.pagination .current, .pagination > b, .pagination a:hover, .page-numbers .current, .page-numbers a:hover, .pagination .next:hover, .pagination .prev:hover, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current{background-color:#1c7e68}#comments > h3,.content.cz_related_posts > h4,.content.cz_author_box > h4,.related.products > h2,.upsells.products > h2,.up-sells.products > h2,.up-sells.products > h2,.woocommerce-page .cart-collaterals .cart_totals > h2,.woocommerce-page #customer_details > div:first-child > div:first-child > h3:first-child,.woocommerce-page .codevz-checkout-details > h3,.woocommerce-page .woocommerce-order-details > h2,.woocommerce-page .woocommerce-customer-details > h2,.woocommerce-page .cart-collaterals .cross-sells > h2{color:#1c7e68;padding-bottom:22px;margin-bottom:30px;border-style:solid;border-bottom-width:2px;border-color:#1c7e68}.cz_related_posts .cz_related_post h3{color:#1c7e68;padding-top:15px;padding-bottom:5px}.xtra-comments .commentlist li article{border-radius:5px}.woocommerce ul.products li.product .button.add_to_cart_button:hover, .woocommerce ul.products li.product .button[class*=\"product_type_\"]:hover{background-color:#ffdd00;opacity:0.9}.woocommerce div.product .woocommerce-tabs .panel{margin-right:-5px}.products .product .xtra-product-icons{background-color:#1c7e68;margin-top:46%}.woocommerce .cart .xtra-product-icons-wishlist{font-size:20px}.quantity-down{color:#1c7e68;background-color:#ffffff;padding:5px 4px 3px;margin-left:-40px;border-radius:4px}.quantity-down:hover{background-color:#ffdd00}.quantity-up{color:#1c7e68;background-color:#ffffff;padding:5px 4px 3px;margin-right:-40px;margin-left:10px;border-radius:4px}.quantity-up:hover{background-color:#ffdd00}.woocommerce .quantity .qty{color:#ffffff;background-color:#1c7e68;width:110px;border-style:none}.woocommerce div.product form.cart .button{background-color:#1c7e68}div.xtra-share{background-color:#1c7e68;border-radius:5px}div.xtra-share a{color:#1c7e68;background-color:#ffffff;margin-right:7px;margin-left:7px;border-radius:5px;opacity:1}div.xtra-share a:hover{color:#000000;background-color:#ffdd00}div.xtra-share:before{font-size:14px;color:rgba(255,255,255,0.6);margin-right:10px}.rtl div.xtra-share:before{margin-right:0px;margin-left:10px}.xtra-fixed-mobile-nav{background-color:#1c7e68}.xtra-fixed-mobile-nav > a{padding-top:20px;padding-bottom:15px}.xtra-fixed-mobile-nav > a:hover,.xtra-fixed-mobile-nav > .xtra-active{background-color:rgba(0,0,0,0.31)}.xtra-fixed-mobile-nav > a i, .xtra-fixed-mobile-nav > a img{color:#1c7e68;background-color:#ffdd00;padding:10px;border-radius:33px}.xtra-fixed-mobile-nav > a span{font-size:13px;margin-right:10px;margin-left:0px}\n\n/* Responsive */@media screen and (max-width:1360px){#layout{width:100%!important}#layout.layout_1,#layout.layout_2{width:95%!important}.row{width:90% !important;padding:0}blockquote{padding:20px}footer .elms_center,footer .have_center .elms_left, footer .have_center .elms_center, footer .have_center .elms_right{float:none;display:block;text-align:center;margin:0 auto;flex:unset}}@media screen and (max-width:768px){.page_title .codevz-section-title{margin-top:0px;}.breadcrumbs{margin-top:4px;}.page_title,.header_onthe_cover .page_title{padding-top:20px;}}@media screen and (max-width:480px){.page_title .codevz-section-title{display:block;font-size:16px;margin-left:2px;width:100%}.breadcrumbs{display:none;}div.xtra-share a{margin-right:3px;margin-left:3px;}}\";s:22:\"default_featured_image\";b:1;s:25:\"_css_portfolio_hover_icon\";s:85:\"font-size:18px;padding:15px;top:auto;right:10px;bottom:10px;left:auto;RTLleft:17%;RTL\";s:20:\"_css_portfolio_image\";s:19:\"border-radius:10px;\";s:7:\"404_msg\";s:95:\"صفحه مورد نظر شما پیدا نشد! لطفا در سایت جستجو کنید ...\";s:7:\"404_btn\";s:35:\"بازگشت به صفحه اصلی\";s:12:\"custom_fonts\";a:29:{i:0;a:1:{s:4:\"font\";s:14:\"irsns-light-fa\";}i:1;a:1:{s:4:\"font\";s:16:\"irsns-regular-fa\";}i:2;a:1:{s:4:\"font\";s:13:\"irsns-bold-fa\";}i:3;a:1:{s:4:\"font\";s:7:\"Shabnam\";}i:4;a:1:{s:4:\"font\";s:12:\"Shabnam-Bold\";}i:5;a:1:{s:4:\"font\";s:15:\"Lalezar-Regular\";}i:6;a:1:{s:4:\"font\";s:12:\"scirsnsyekan\";}i:7;a:1:{s:4:\"font\";s:9:\"broyabold\";}i:8;a:1:{s:4:\"font\";s:6:\"rezvan\";}i:9;a:1:{s:4:\"font\";s:7:\"khodkar\";}i:10;a:1:{s:4:\"font\";s:9:\"DastNevis\";}i:11;a:1:{s:4:\"font\";s:9:\"BTitrBold\";}i:12;a:1:{s:4:\"font\";s:6:\"BYekan\";}i:13;a:1:{s:4:\"font\";s:4:\"BZar\";}i:14;a:1:{s:4:\"font\";s:9:\"BSinaBold\";}i:15;a:1:{s:4:\"font\";s:5:\"BZiba\";}i:16;a:1:{s:4:\"font\";s:5:\"Vazir\";}i:17;a:1:{s:4:\"font\";s:5:\"aviny\";}i:18;a:1:{s:4:\"font\";s:9:\"IRANBlack\";}i:19;a:1:{s:4:\"font\";s:9:\"iranyekan\";}i:20;a:1:{s:4:\"font\";s:10:\"iransansdn\";}i:21;a:1:{s:4:\"font\";s:18:\"mahboubeh_mehravar\";}i:22;a:1:{s:4:\"font\";s:9:\"iransharp\";}i:23;a:1:{s:4:\"font\";s:4:\"IRAN\";}i:24;a:1:{s:4:\"font\";s:13:\"Anjoman-Light\";}i:25;a:1:{s:4:\"font\";s:15:\"Anjoman-Regular\";}i:26;a:1:{s:4:\"font\";s:12:\"Anjoman-Bold\";}i:27;a:1:{s:4:\"font\";s:4:\"dana\";}i:28;a:1:{s:4:\"font\";s:8:\"IRANSans\";}}s:18:\"_css_overal_footer\";s:214:\"background-image:linear-gradient(90deg,rgba(68,66,64,0.64),rgba(68,66,64,0.64)),url(https://xtra-moving.tooswp.ir/wp-content/uploads/2019/06/bg1.jpg);border-style:solid;border-bottom-width:4px;border-color:#ffdd00;\";s:11:\"layout_post\";s:1:\"1\";s:12:\"post_excerpt\";s:2:\"20\";s:20:\"hover_icon_icon_post\";s:21:\"fa czico-107-web-link\";s:9:\"not_found\";s:27:\"موردی یافت نشد!\";s:11:\"cm_disabled\";s:55:\"امکان ارسال دیدگاه وجود ندارد!\";s:17:\"_css_overall_post\";s:18:\"border-radius:5px;\";s:20:\"_css_post_hover_icon\";s:58:\"color:#ffdd00;background-color:#1c7e68;border-radius:55px;\";s:15:\"_css_post_image\";s:39:\"border-color:#ffffff;border-radius:5px;\";s:21:\"_css_readmore_i_hover\";s:14:\"color:#000000;\";s:24:\"_css_pagination_li_hover\";s:25:\"background-color:#1c7e68;\";s:24:\"posted_by_translate_post\";s:26:\"ارسال شده توسط\";s:17:\"on_translate_post\";s:4:\"در\";s:10:\"no_comment\";s:21:\"بدون دیدگاه\";s:7:\"comment\";s:12:\"دیدگاه\";s:8:\"comments\";s:12:\"دیدگاه\";s:28:\"_css_related_posts_sec_title\";s:117:\"color:#1c7e68;padding-bottom:22px;margin-bottom:30px;border-style:solid;border-bottom-width:2px;border-color:#1c7e68;\";s:24:\"_css_related_posts_title\";s:50:\"color:#1c7e68;padding-top:15px;padding-bottom:5px;\";s:26:\"_css_single_comments_title\";s:117:\"color:#1c7e68;padding-bottom:21px;margin-bottom:30px;border-style:solid;border-bottom-width:2px;border-color:#1c7e68;\";s:23:\"_css_single_comments_li\";s:18:\"border-radius:5px;\";s:19:\"search_title_prefix\";s:31:\"نتایج جستجو برای:\";s:13:\"layout_search\";s:5:\"right\";s:22:\"post_excerpt_portfolio\";s:2:\"20\";s:25:\"hover_icon_icon_portfolio\";s:21:\"fa czico-188-arrows-2\";s:18:\"readmore_portfolio\";s:25:\"اطلاعات بیشتر\";s:23:\"readmore_icon_portfolio\";s:17:\"fa fa-angle-right\";s:29:\"posted_by_translate_portfolio\";s:26:\"ارسال شده توسط\";s:22:\"on_translate_portfolio\";s:4:\"در\";s:14:\"prev_portfolio\";s:8:\"قبلی\";s:14:\"next_portfolio\";s:8:\"بعدی\";s:21:\"related_portfolio_ppp\";s:1:\"3\";s:23:\"related_posts_portfolio\";s:68:\"ممکن است به این موارد علاقمند باشید ...\";s:21:\"related_portfolio_col\";s:2:\"s4\";s:20:\"no_comment_portfolio\";s:10:\"No comment\";s:17:\"comment_portfolio\";s:7:\"Comment\";s:18:\"comments_portfolio\";s:8:\"Comments\";s:8:\"woo_cart\";s:15:\"سبد خرید\";s:12:\"woo_checkout\";s:19:\"تسویه حساب\";s:15:\"woo_no_products\";s:45:\"سبد خرید شما خالی می باشد\";s:35:\"_css_woo_products_add_to_cart_hover\";s:37:\"background-color:#ffdd00;opacity:0.9;\";s:15:\"custom_sidebars\";a:0:{}s:28:\"_css_woo_product_tab_content\";s:18:\"margin-right:-5px;\";s:12:\"woo_wishlist\";i:3257;s:14:\"woo_quick_view\";b:1;s:22:\"woo_wishlist_qv_center\";b:1;s:23:\"_css_woo_products_icons\";s:40:\"background-color:#1c7e68;margin-top:46%;\";s:23:\"_css_woo_product_onsale\";s:11:\"right:10px;\";s:25:\"_css_woo_product_wishlist\";s:15:\"font-size:20px;\";s:25:\"_css_woo_product_qty_down\";s:95:\"color:#1c7e68;background-color:#ffffff;padding:5px 4px 3px;margin-left:-40px;border-radius:4px;\";s:31:\"_css_woo_product_qty_down_hover\";s:25:\"background-color:#ffdd00;\";s:23:\"_css_woo_product_qty_up\";s:113:\"color:#1c7e68;background-color:#ffffff;padding:5px 4px 3px;margin-right:-40px;margin-left:10px;border-radius:4px;\";s:29:\"_css_woo_product_qty_up_hover\";s:25:\"background-color:#ffdd00;\";s:20:\"_css_woo_product_qty\";s:69:\"color:#ffffff;background-color:#1c7e68;width:110px;border-style:none;\";s:28:\"_css_woo_product_add_to_cart\";s:25:\"background-color:#1c7e68;\";s:9:\"post_type\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}s:5:\"share\";a:6:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:9:\"pinterest\";i:3;s:8:\"linkedin\";i:4;s:8:\"whatsapp\";i:5;s:4:\"copy\";}s:15:\"share_box_title\";s:25:\"اشتراک گذاری :\";s:10:\"_css_share\";s:43:\"background-color:#1c7e68;border-radius:5px;\";s:12:\"_css_share_a\";s:100:\"color:#1c7e68;background-color:#ffffff;margin-right:7px;margin-left:7px;border-radius:5px;opacity:1;\";s:19:\"_css_share_a_mobile\";s:33:\"margin-right:3px;margin-left:3px;\";s:18:\"_css_share_a_hover\";s:39:\"color:#000000;background-color:#ffdd00;\";s:16:\"_css_share_title\";s:101:\"font-size:14px;color:rgba(255,255,255,0.6);margin-right:10px;RTLmargin-right:0px;margin-left:10px;RTL\";s:13:\"share_tooltip\";b:1;s:12:\"_css_tooltip\";s:17:\"font-family:dana;\";s:18:\"mobile_menu_social\";b:1;s:16:\"mobile_menu_text\";s:32:\"کپی رایت © [codevz_year]\";s:21:\"_css_mm_text_header_4\";s:33:\"color:#ffffff;margin-bottom:25px;\";s:23:\"_css_mms_icons_header_4\";s:122:\"font-size:20px;background-color:#ffdd00;padding:5px;margin-right:5px;margin-bottom:15px;margin-left:5px;border-radius:5px;\";s:23:\"mobile_fixed_navigation\";b:1;s:29:\"mobile_fixed_navigation_items\";a:2:{i:0;a:4:{s:5:\"title\";s:22:\" تماس بگیرید\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:25:\"fa czico-092-phone-call-1\";s:4:\"link\";s:12:\"tel:09350000\";}i:1;a:4:{s:5:\"title\";s:25:\"مشاوره بگیرید\";s:9:\"icon_type\";s:4:\"icon\";s:4:\"icon\";s:42:\"fa czico-006-speech-bubble-with-text-lines\";s:4:\"link\";s:47:\"https://xtra-moving.tooswp.ir/get-a-free-quote/\";}}s:8:\"_css_mfn\";s:25:\"background-color:#1c7e68;\";s:10:\"_css_mfn_a\";s:37:\"padding-top:20px;padding-bottom:15px;\";s:16:\"_css_mfn_a_hover\";s:34:\"background-color:rgba(0,0,0,0.31);\";s:10:\"_css_mfn_i\";s:71:\"color:#1c7e68;background-color:#ffdd00;padding:10px;border-radius:33px;\";s:29:\"mobile_fixed_navigation_title\";s:31:\"xtra-fixed-mobile-nav-title-row\";s:14:\"_css_mfn_title\";s:49:\"font-size:13px;margin-right:10px;margin-left:0px;\";s:7:\"disable\";a:1:{i:0;s:8:\"importer\";}}", "on");
INSERT INTO `wp_options` VALUES("19679", "_elementor_element_cache_unique_id", "241520b661f7cabe198a7f563936dcb6", "auto");
INSERT INTO `wp_options` VALUES("19704", "wp_notes_notify", "1", "on");
INSERT INTO `wp_options` VALUES("19700", "codevz_plus_autoload_fix_done", "1", "off");
INSERT INTO `wp_options` VALUES("19716", "woocommerce_gateway_order", "a:4:{s:33:\"_wc_offline_payment_methods_group\";i:0;s:4:\"bacs\";i:1;s:6:\"cheque\";i:2;s:3:\"cod\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("19702", "_transient_timeout_woocommerce_marketplace_promotions_v2", "1771415299", "off");
INSERT INTO `wp_options` VALUES("19703", "_transient_woocommerce_marketplace_promotions_v2", "a:2:{s:6:\"notice\";a:8:{s:13:\"date_from_gmt\";s:16:\"2024-11-17 00:00\";s:11:\"date_to_gmt\";s:16:\"2024-11-20 23:59\";s:6:\"format\";s:6:\"notice\";s:5:\"style\";s:4:\"info\";s:5:\"pages\";a:5:{i:0;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:0:\"\";s:4:\"name\";s:8:\"Discover\";}i:1;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:10:\"extensions\";s:4:\"name\";s:6:\"Browse\";}i:2;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:6:\"themes\";s:4:\"name\";s:6:\"Themes\";}i:3;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:17:\"business-services\";s:4:\"name\";s:17:\"Business Services\";}i:4;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:16:\"my-subscriptions\";s:4:\"name\";s:16:\"My Subscriptions\";}}s:7:\"content\";a:1:{s:5:\"en_US\";s:192:\"<strong>Save 40%</strong> in the WooCommerce Marketplace sale. Offer ends December 3 at 3 pm UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&amp;Cs</a> apply.\";}s:4:\"icon\";s:7:\"percent\";s:14:\"is_dismissible\";b:1;}s:6:\"promos\";a:4:{i:0;a:9:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"path\";s:0:\"\";s:8:\"pathname\";s:33:\"/wp-admin/admin.php?page=wc-admin\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:13:\"Shop the sale\";}s:8:\"cta_link\";s:52:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:240:\"Save up to 40% on themes and extensions in the WooCommerce Marketplace until December 2 at 14:00 UTC. <strong>Coupon applied at checkout.</strong> <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:29:\"Black Friday savings are live\";}s:4:\"icon\";s:7:\"percent\";}i:1;a:9:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:10:\"/marketing\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:23:\"Level up your marketing\";}s:8:\"cta_link\";s:52:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:223:\"Save up to 40% in the Woo BFCM sale. <strong>Coupon applied at checkout.</strong> Offer ends December 2 at 14:00 UTC. T&Cs apply. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:43:\"Take up to 40% off marketing tools and more\";}s:4:\"icon\";s:7:\"percent\";}i:2;a:10:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"path\";s:0:\"\";s:8:\"pathname\";s:40:\"/wp-admin/edit.php?post_type=shop_coupon\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:19:\"Upgrade your promos\";}s:8:\"cta_link\";s:52:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:211:\"Save up to 40% in the Woo BFCM sale. <strong>Coupon applied at checkout.</strong> Offer ends December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:46:\"Take up to 40% off coupon and promo extensions\";}s:5:\"style\";s:4:\"wide\";s:4:\"icon\";s:7:\"percent\";}i:3;a:10:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:13:\"Shop the sale\";}s:8:\"cta_link\";s:52:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:233:\"Take up to 40% off WooCommerce Marketplace products this BFCM. <strong>Coupon applied at checkout.</strong> Sale ends December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&Cs</a> apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:39:\"Save up to 40% on your next big upgrade\";}s:5:\"style\";s:14:\"has-background\";s:4:\"icon\";s:7:\"percent\";}}}", "off");
INSERT INTO `wp_options` VALUES("19708", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.9.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-12-01 10:38:20\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-02-07 06:54:04\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-02-10 07:30:35\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.9.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-12-11 21:36:34\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-01-30 16:47:55\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.9.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-01-29 07:47:58\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-10-23 12:01:47\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-02-15 00:54:09\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.9.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-02-15 00:57:15\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-11-28 08:11:27\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-11-28 08:08:17\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.9.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-02-02 11:19:29\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.9.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-12-13 06:27:29\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-12-30 11:47:57\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-12-23 16:40:44\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-11-25 13:30:15\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-12-24 12:51:19\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-01-27 10:24:57\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.9.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-12-13 04:21:30\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-01-30 19:24:13\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-02-10 15:51:08\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-02-11 00:33:09\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-01 22:54:47\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2026-02-03 16:11:04\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.9.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-11-05 21:53:17\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9-RC/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.9.1\";s:7:\"updated\";s:19:\"2025-12-25 18:17:43\";s:12:\"english_name\";s: