<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/**
 * Field: Icon
 */
if( ! class_exists( 'Codevz_Field_icon' ) ) {
  class Codevz_Field_icon extends Codevz_Fields {

    public function __construct( $field, $value = '', $unique = '', $where = '' ) {
      parent::__construct( $field, $value, $unique, $where );
    }

    public function output() {

      $value  = $this->element_value();
      $hidden = ( empty( $value ) ) ? ' hidden' : '';

      echo '<a href="#" class="button button-primary codevz-icon-add">'. esc_html__( 'Choose', 'codevz-plus' ) .'</a>';
      echo '<span class="codevz-icon-preview'. esc_attr( $hidden ) .'"><i class="'. esc_attr( $value ) .'"></i><a href="#" class="button codevz-warning-primary codevz-icon-remove fa fa-remove'. esc_attr( $hidden ) .'"></a></span>';
      echo '<input type="text" name="'. esc_attr( $this->element_name() ) .'" value="'. esc_attr( $value ) .'"'. wp_kses_post( (string) $this->element_class( 'codevz-icon-value' ) . $this->element_attributes() ) .' />';

    }

  }
}
