document.addEventListener('DOMContentLoaded', () => {
  const setCookie = (name, value, days) => {
    let expires = "";
    if (days) {
      const date = new Date();
      date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
      expires = "; expires=" + date.toUTCString();
    }
    document.cookie = name + "=" + (value || "") + expires + "; path=/";
  };

  const getCookie = (name) => {
    const value = `; ${document.cookie}`;
    const parts = value.split(`; ${name}=`);
    if (parts.length === 2) {
      return parts.pop().split(';').shift();
    }
    return null;
  };

  const cookieBar = document.querySelector('.xtra-cookie');
  if (cookieBar && !getCookie('xtra_cookie')) {
    cookieBar.style.display = 'flex';
  }

  document.body.addEventListener('click', (e) => {
    const btn = e.target.closest('.xtra-cookie-button');
    if (btn) {
      const parent = btn.parentElement;
      
      parent.style.transition = 'opacity 0.4s';
      parent.style.opacity = '0';
      
      setTimeout(() => {
        parent.style.display = 'none';
      }, 400);

      setCookie('xtra_cookie', '1', 90);
    }
  });
});