document.addEventListener('DOMContentLoaded', () => {
	const body = document.body;
	
	if (!document.querySelector('.codevz-magic-mouse')) {
		const mmHTML = '<div class="codevz-magic-mouse"><div></div><div></div></div><div class="codevz-magic-placeholder"></div>';
		body.insertAdjacentHTML('beforeend', mmHTML);
	}

	const mm = document.querySelector('.codevz-magic-mouse');
	const m1 = mm.firstElementChild;
	const m2 = mm.lastElementChild;
	const selectors = typeof codevzMagnetSelectors !== 'undefined' ? codevzMagnetSelectors : '.xxx';
	const interactive = 'a, i, button, input[type="button"], input[type="submit"]';

	let mouse = { x: 0, y: 0 };
	let pos1 = { x: 0, y: 0 };
	let pos2 = { x: 0, y: 0 };
	let isHover = false;
	let targetData = { x: 0, y: 0 };

	window.addEventListener('mousemove', (e) => {
		mouse.x = e.pageX;
		mouse.y = e.pageY;
		mm.style.opacity = '1';
	}, { passive: true });

	const update = () => {
		const target = document.elementFromPoint(mouse.x - window.scrollX, mouse.y - window.scrollY);
		const magnet = target?.closest(selectors);
		const isLink = target?.closest(interactive);

		if (magnet) {
			const rect = magnet.getBoundingClientRect();
			targetData.x = rect.left + window.scrollX + rect.width / 2;
			targetData.y = rect.top + window.scrollY + rect.height / 2;
			
			mm.classList.add('codevz-magic-mouse-hover');
			magnet.classList.add('codevz-magic-mouse-transform');

			const dx = targetData.x - mouse.x;
			const dy = targetData.y - mouse.y;

			pos2.x = targetData.x - (dx * 0.4);
			pos2.y = targetData.y - (dy * 0.4);

			magnet.style.transform = `translate3d(${ -dx * 0.2 }px, ${ -dy * 0.2 }px, 0)`;
			isHover = true;
		} else {
			document.querySelectorAll('.codevz-magic-mouse-transform').forEach(el => {
				el.classList.remove('codevz-magic-mouse-transform');
				el.style.transform = '';
			});

			if (isLink) {
				mm.classList.add('codevz-magic-mouse-hover');
			} else {
				mm.classList.remove('codevz-magic-mouse-hover');
			}

			pos2.x = mouse.x;
			pos2.y = mouse.y;
			isHover = false;
		}

	// Smooth lerp for the circles
		pos1.x += (mouse.x - pos1.x) * 0.3;
		pos1.y += (mouse.y - pos1.y) * 0.3;

		m1.style.transform = `translate3d(${pos1.x - m1.offsetWidth / 2}px, ${pos1.y - m1.offsetHeight / 2}px, 0)`;
		m2.style.transform = `translate3d(${pos2.x - m2.offsetWidth / 2}px, ${pos2.y - m2.offsetHeight / 2}px, 0)`;

		requestAnimationFrame(update);
	};

	requestAnimationFrame(update);
});