document.addEventListener('DOMContentLoaded', () => {
	const pwa = document.querySelector('.codevz-pwa');
	if (!pwa) {return;}

	const cookieName = pwa.getAttribute('data-cookie');
	const isiOS = /iPad|iPhone/.test(navigator.userAgent);

	const closePWA = () => {
		pwa.classList.remove('codevz-pwa-show');
		document.cookie = cookieName + "=true; expires=Fri, 31 Dec 2040 23:59:59 GMT; path=/";
	};

	document.body.addEventListener('click', (e) => {
		if (e.target.closest('.codevz-pwa-close')) {
			closePWA();
		}
	});

	const isStandalone = window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone === true;

	if (isStandalone) {
		closePWA();
	} else if (!document.cookie.includes(cookieName + '=')) {
		pwa.classList.add('codevz-pwa-show');
	}

	pwa.classList.remove('codevz-pwa-ios', 'codevz-pwa-android');
	pwa.classList.add(isiOS ? 'codevz-pwa-ios' : 'codevz-pwa-android');

	if (document.querySelector('.customize-partial-edit-shortcuts-shown')) {
		pwa.classList.remove('codevz-pwa-desktop');
		pwa.classList.add('codevz-pwa-show', 'codevz-pwa-mobile');
	}
});