document.addEventListener('DOMContentLoaded', () => {
	const body = document.body;

	body.addEventListener('click', (e) => {
		const shareLink = e.target.closest('.xtra-share a');
		const printBtn = e.target.closest('.cz-print');

		if (shareLink) {
			e.preventDefault();
			const href = shareLink.getAttribute('href');

			if (shareLink.querySelector('.fa-copy')) {
				navigator.clipboard.writeText(href).then(() => {
					const originalTitle = shareLink.getAttribute('data-title');
					const copiedTitle = shareLink.getAttribute('data-copied');

					shareLink.style.animation = 'xtraCopyAbsorber .8s forwards';
					shareLink.setAttribute('data-title', copiedTitle);

					setTimeout(() => {
						shareLink.style.animation = '';
						shareLink.setAttribute('data-title', originalTitle);
					}, 2000);
				});
			} else if (href && href.startsWith('http')) {
				window.open(href, "null", "height=300, width=600, top=200, left=200");
			}
		}

		if (printBtn) {
			let printDiv = document.getElementById('xtraPrint');
			if (!printDiv) {
				printDiv = document.createElement('div');
				printDiv.id = 'xtraPrint';
				body.appendChild(printDiv);
			}

			const selectors = '.xtra-post-title, .page_title .codevz-section-title, .cz_single_fi, .cz_post_content, .xtra-single-product';
			document.querySelectorAll(selectors).forEach(el => {
				const clone = el.cloneNode(true);
				
				if (clone.classList.contains('cz_single_fi')) {
					const br = document.createElement('br');
					printDiv.appendChild(clone);
					printDiv.appendChild(br);
				} else if (clone.classList.contains('xtra-post-title')) {
					clone.style.fontSize = '28px';
					printDiv.appendChild(clone);
				} else {
					printDiv.appendChild(clone);
				}
			});

			body.classList.add('xtra-printing');

			setTimeout(() => {
				window.print();
			}, 250);

			setTimeout(() => {
				body.classList.remove('xtra-printing');
				printDiv.innerHTML = '';
			}, 1000);
		}
	});
});