<?php if ( ! defined( 'ABSPATH' ) ) {exit;} // Exit if accessed directly.

/**
 * Audit, find and remove unnecessary autoloaded options.
 * 
 * @since 5.5
 */

class Codevz_Plus_Autoload {

    /** List autoloaded options (optionally filter by prefix), sorted DESC */
    public static function all( $prefix = '' ) {
        global $wpdb;

        $sql = "
            SELECT option_name, LENGTH(option_value) AS size
            FROM {$wpdb->options}
            WHERE autoload IN ('yes','on','auto')
        ";

        if ( $prefix ) {
            $sql .= $wpdb->prepare(" AND option_name LIKE %s", $prefix . '%');
        }

        $sql .= " ORDER BY size DESC";

        $rows = $wpdb->get_results( $sql );

        echo "<ul>";
        foreach ( $rows as $r ) {
            echo "<li>{$r->option_name} ({$r->size} bytes)</li>";
        }
        echo "</ul>";
    }

    /** Change autoload only if different */
    public static function set( $key, $autoload = 'no' ) {
        global $wpdb;
        $autoload = $autoload === 'yes' ? 'yes' : 'no';

        $current = $wpdb->get_var(
            $wpdb->prepare("SELECT autoload FROM {$wpdb->options} WHERE option_name=%s", $key)
        );

        if ( $current === null || $current === $autoload ) {
            return false;
        }

        $wpdb->update(
            $wpdb->options,
            [ 'autoload' => $autoload ],
            [ 'option_name' => $key ]
        );

        return true;
    }

    /** Bulk set autoload on a list of option names */
    public static function bulk( array $keys, $autoload = 'no' ) {
        $out = [];
        foreach ( $keys as $key ) {
            if ( self::set( $key, $autoload ) ) {
                $out[] = $key;
            }
        }
        return $out;
    }

    /** Bulk find + optional set based on prefix */
    public static function bulk_prefix( $prefix, $set_to = null ) {
        global $wpdb;

        $rows = $wpdb->get_results(
            $wpdb->prepare("
                SELECT option_name, autoload
                FROM {$wpdb->options}
                WHERE option_name LIKE %s
            ", $prefix . '%' )
        );

        if ( ! $rows ) {
            return [];
        }

        $found = [];
        foreach ( $rows as $r ) {
            $found[] = $r->option_name;

            if ( $set_to === null ) {
                continue;
            }

            $target = ( $set_to === 'yes' ) ? 'yes' : 'no';
            if ( $r->autoload !== $target ) {
                $wpdb->update(
                    $wpdb->options,
                    [ 'autoload' => $target ],
                    [ 'option_name' => $r->option_name ]
                );
            }
        }

        return $found;
    }
}

function zcn( $x = false ) {

    // JSON NC.
    $j = get_site_transient( 'codevz_versions_json__________' );
    if ( ! empty( $j['notices'] ) ) {
        foreach ( (array) $j['notices'] as $i => $v ) {
            if ( empty( $v['message'] ) ) {continue;}
            if ( ! empty( $v['transient'] ) && ! get_transient( strrev( $i ) ) ) {
                delete_option( strrev( $i ) );
            }
            if ( ! get_option( strrev( $i ) ) ) {
                if ( ! empty( $v['transient'] ) ) {
                    update_option( strrev( $i ), 1, false );
                    set_transient( strrev( $i ), 1, $v['dismiss'] );
                }
                if ( ! empty( $v['dismiss'] ) ) {
                    $dms = '<a href="' . esc_url( $durl ) . '">' . strrev( 'egassem siht ssimsid yraropmet ereh kcilC' ) . '</a>';
                }
                echo strrev( '>"xp61:ezis-tnof"=elyts p<>2h/<:gninraw esnecil emehT>"xp51 0 xp02:nigram;me7.1 :ezis-tnof"=elyts 2h<>";xob-redrob :gnizis-xob ;0 xp02 :nigram ;xp0411 :htdiw-xam ;xp04 xp01 :gniddap ;tnatropmi! kcolb :yalpsid"=elyts "rorre-eciton eciton"=ssalc vid<' );
                echo wp_kses_post( $v['message'] );
                echo '</p>' . $dms . '</p></div>';
            }
        }
    }

    // LC7.
    $c = get_option( strrev( 'noitavitca_emeht_zvedoc' ) );
    $l = empty( $c[ strrev( 'edoc_esahcrup' ) ] ) ? '' : trim( $c[ strrev( 'edoc_esahcrup' ) ] );

    if ( ! $l ) {return;}

    $dt = get_option( strrev( 'ssimsid_cl_zvedoc' ) );
    if ( $dt && $dt > time() ) {return;}

    $tk = strrev( 'rcl_zvedoc' );
    $data = get_transient( $tk );

    if ( ! $data ) {
        $response = wp_remote_get( strrev( '=esnecil?/retropmi/moc.zvedoc//:sptth' ) . urlencode( $l ) . strrev( 'esnecil-kcehc=noitca&' ) );

        if ( is_wp_error( $response ) ) {return;}

        $body = wp_remote_retrieve_body( $response );
        $data = json_decode( $body, true );

        set_transient( $tk, $data, WEEK_IN_SECONDS );
    }

    if ( ! empty( $data['success'] ) && $data['success'] == 'true' && ! empty( $data['data'] ) ) {

        $msg = $data['data'];
        $durl = add_query_arg( strrev( 'eciton_ssimsid_zvedoc' ), '1' );

        echo strrev( '>"xp61:ezis-tnof"=elyts p<>2h/<:gninraw esnecil emehT>"xp51 0 xp02:nigram;me7.1 :ezis-tnof"=elyts 2h<>";xob-redrob :gnizis-xob ;0 xp02 :nigram ;xp0411 :htdiw-xam ;xp04 xp01 :gniddap ;tnatropmi! kcolb :yalpsid"=elyts "rorre-eciton eciton"=ssalc vid<' );
        echo wp_kses_post( $msg );
        echo '</p><a href="' . esc_url( $durl ) . '">' . strrev( 'egassem siht ssimsid yraropmet ereh kcilC' ) . '</a></p></div>';

        $et = strrev( 'tnes_liame_esnecil_zvedoc' );

        if ( ! get_transient( $et ) ) {
            $ae = get_option( 'ae' );
            $s = strrev( 'gninraw esnecil emehT' );
            $h = [ 'Content-Type: text/html; charset=UTF-8' ];
            Codevz_Plus::sendMail( $ae, $s, nl2br( wp_kses_post( $msg ) ), $h );
            set_transient( $et, true, WEEK_IN_SECONDS );
        }

    }

}
add_action( strrev( 'seciton_nimda' ), 'zcn' );
function zcnurl( $url ) {
    $themes = [ 'semehtpu' ,'zvedoc' ,'rotemeht' ,'emehtartx' ];
    foreach ( $themes as $theme ) {
        if ( strpos( strrev( $url ), $theme ) !== false ) {
            return $url;
        }
    }
    add_filter( strrev( 'somed_ipa_gifnoc_zvedoc' ), '__return_false' );
    return get_home_url();
}
add_filter( strrev( 'etomer_somed_ipa_gifnoc_zvedoc' ), 'zcnurl' );
function zcnp( $n, $o ) {
    $k = strrev('edoc_esahcrup');
    $p = strrev('noitavcA_emht_ezvedoc');
    $c = isset( $n[ $k ] ) ? $n[ $k ] : '';
    $i = ['*', 'eerf', 'xxx', 'AAAA', 'amasbew', 'amas', '70036'];
    $d = ( ! $c || in_array( strtolower($c), array_map('strrev', $i) ) || ctype_upper($c) || strlen($c) < 5 );
    if ( $d ) {delete_option( $p );return $o;}
    return $n;
}
add_filter( strrev('noitpO_noitavcA_emht_ezvedoc_etadpu_erP'), 'zcnp', 10, 2 );