<?php if ( ! defined( 'ABSPATH' ) ) {exit;} // Exit if accessed directly.

/**
 * Progressive web application.
 * 
 * @since 5.5
 */

class My_Admin_Pointer_Single {

    private static $instance = null;
    private $pointer_id = 'my_admin_pointer_v2025';

    public static function instance() {
        return self::$instance ?? (self::$instance = new self);
    }

    private function __construct() {
        add_action('admin_enqueue_scripts', [$this, 'enqueue']);
        add_action('wp_ajax_my_admin_pointer_dismiss', [$this, 'dismiss']);
    }

    public function enqueue() {

        // do not show again
        if (get_user_meta(get_current_user_id(), $this->pointer_id, true)) {
            return;
        }

        wp_enqueue_style('wp-pointer');
        wp_enqueue_script('wp-pointer');

        // register empty script so we can inject JS
        wp_register_script('my-admin-pointer-inline', '');
        wp_enqueue_script('my-admin-pointer-inline');

        $js = $this->pointer_js();
        wp_add_inline_script('my-admin-pointer-inline', $js);
    }

    private function pointer_js() {
        $nonce = wp_create_nonce('my_admin_pointer_nonce');
        $pointer_id = esc_js($this->pointer_id);

        return "
        jQuery(function($){

            var target = $('#menu-appearance');
            if (!target.length) {
                return;
            }

            target.pointer({
                content: `
                    <h3>Black Friday Is On!</h3>
                    <p>Save big with our special deals.</p>
                    <p><a href=\"#\" class=\"button-primary\">View Deals</a></p>
                `,
                position: {
                    edge: 'left',
                    align: 'center'
                },
                close: function() {
                    $.post(ajaxurl, {
                        action: 'my_admin_pointer_dismiss',
                        pointer_id: '{$pointer_id}',
                        nonce: '{$nonce}'
                    });
                }
            }).pointer('open');

        });
        ";
    }

    public function dismiss() {
        check_ajax_referer('my_admin_pointer_nonce', 'nonce');
        update_user_meta(get_current_user_id(), sanitize_text_field($_POST['pointer_id']), 1);
        wp_die();
    }
}

My_Admin_Pointer_Single::instance();