<?php if ( ! defined( 'ABSPATH' ) ) {exit;} // Exit if accessed directly.

/**
 * Plugin all translation strings.
 */

class Codevz_Strings {

    use Codevz_Plus_Instance;

    protected $strings = [];

	public function __construct() {

		// Compatibility for Polylang.
		if ( function_exists( 'pll_languages_list' ) ) { 
			add_action( 'wpml_loaded', '__return_true', 10, 0 );
			do_action( 'wpml_loaded' );
		}

	    add_action( 'init', [ $this, 'init' ] );

	}

	// Load language(s)
	public function init() {

		$locale = ( is_admin() && ! wp_doing_ajax() ) ? get_user_locale() : get_locale();

		// Load translation only if the admin language is NOT English OR if it's the frontend.
		load_textdomain( 'codevz-plus', Codevz_Plus::$dir . 'languages/codevz-plus-' . $locale . '.mo' );

		// Load strings.
		$this->init_strings();

	}

	// Initialize all strings once
	protected function init_strings() {

		$this->strings = [

			'codevz_plus' 			=> esc_html__( 'Codevz Plus', 'codevz-plus' ),
			'activate_request' 		=> esc_html__( 'Activate your theme with purchase code to access this feature.', 'codevz-plus' ),
			'pro' 					=> esc_html__( 'PRO', 'codevz-plus' ),
			'facebook' 				=> esc_html__( 'Facebook', 'codevz-plus' ),
			'x' 					=> esc_html__( 'X', 'codevz-plus' ),
			'pinterest' 			=> esc_html__( 'Pinterest', 'codevz-plus' ),
			'reddit' 				=> esc_html__( 'Reddit', 'codevz-plus' ),
			'delicious' 			=> esc_html__( 'Delicious', 'codevz-plus' ),
			'linkedin' 				=> esc_html__( 'Linkedin', 'codevz-plus' ),
			'whatsapp' 				=> esc_html__( 'Whatsapp', 'codevz-plus' ),
			'telegram' 				=> esc_html__( 'Telegram', 'codevz-plus' ),
			'email' 				=> esc_html__( 'Email', 'codevz-plus' ),
			'print' 				=> esc_html__( 'Print', 'codevz-plus' ),
			'shortlink' 			=> esc_html__( 'Shortlink', 'codevz-plus' ),
			'share_by' 				=> esc_html__( 'Share by', 'codevz-plus' ),
			'share_on' 				=> esc_html__( 'Share on', 'codevz-plus' ),
			'copy' 					=> esc_html__( 'Copy', 'codevz-plus' ),
			'link_copied' 			=> esc_html__( 'Link copied', 'codevz-plus' ),
			'options' 				=> esc_html__( 'Options', 'codevz-plus' ),
			'live_preview' 			=> esc_html__( 'Live Preview', 'codevz-plus' ),
			'no_preview' 			=> esc_html__( 'No Preview', 'codevz-plus' ),
			'classic' 				=> esc_html__( 'Classic', 'codevz-plus' ),
			'demo_importer' 		=> esc_html__( 'Demo Importer', 'codevz-plus' ),
			'page_importer' 		=> esc_html__( 'Page Importer', 'codevz-plus' ),
			'system_status' 		=> esc_html__( 'System Status', 'codevz-plus' ),
			'site_title' 			=> esc_html__( 'Site Title', 'codevz-plus' ),
			'favicon' 				=> esc_html__( 'Favicon', 'codevz-plus' ),
			'site_logo' 			=> esc_html__( 'Site Logo', 'codevz-plus' ),
			'speed' 				=> esc_html__( 'Speed', 'codevz-plus' ),
			'performance' 			=> esc_html__( 'Performance', 'codevz-plus' ),
			'site_colors' 			=> esc_html__( 'Site Colors', 'codevz-plus' ),
			'styling' 				=> esc_html__( 'Styling', 'codevz-plus' ),
			'XXXXXXXXXXX' 			=> esc_html__( 'XXXXXXXXXXX', 'codevz-plus' ),

		];

	}

    // Instance method to get string
    public function get_instance_string( $key, ...$args ) {
        return isset( $this->strings[ $key ] ) ? sprintf( $this->strings[ $key ], ...$args ) : '';
    }

    // Static proxy for convenient calls
    public static function get( $key, ...$args ) {
        return self::instance()->get_instance_string( $key, ...$args );
    }
}

Codevz_Strings::instance();