<?php if ( ! defined( 'ABSPATH' ) ) {exit;} // Exit if accessed directly.

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class Xtra_Elementor_Widget_separator extends Widget_Base {

	protected $id = 'cz_separator';

	public function get_name() {
		return $this->id;
	}

	public function get_title() {
		return esc_html__( 'Separator', 'codevz-plus' );
	}
	
	public function get_icon() {
		return 'xtra-separator';
	}

	public function get_categories() {
		return [ 'xtra' ];
	}

	public function get_keywords() {

		return [
			esc_html__( 'XTRA', 'codevz-plus' ),
			esc_html__( 'Codevz Plus', 'codevz-plus' ),
			esc_html__( 'Separator', 'codevz-plus' ),
			esc_html__( 'Divider', 'codevz-plus' ),
			esc_html__( 'Row', 'codevz-plus' ),
			'XTRA',
			'Codevz Plus',
			'Separator',
			'Divider',
			'Row',
			'Line',
			'Border',
			'Split',
			'Section',
		];

	}

	public function get_style_depends() {
		return [ $this->id, 'cz_parallax' ];
	}

	public function get_script_depends() {
		return [ $this->id, 'cz_parallax' ];
	}

	public function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Settings', 'codevz-plus' ),
				'tab'   => Controls_Manager::TAB_CONTENT
			]
		);
 
		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Separator', 'codevz-plus' ),
				'type' => 'image_select',
				'label_block' => true,
				'options' => array(
					'5' => [
						'title'=> '5',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_5.jpg'
					],
					'19' => [
						'title'=> '19',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_19.jpg'
					],
					'64' => [
						'title'=> '64',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_64.jpg'
					],
					'1' => [
						'title'=> '1',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_1.jpg'
					],
					'2' => [
						'title'=> '2',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_2.jpg'
					],
					'3' => [
						'title'=> '3',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_3.jpg'
					],
					'4' => [
						'title'=> '4',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_4.jpg'
					],
					'6' => [
						'title'=> '6',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_6.jpg'
					],
					'7' => [
						'title'=> '7',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_7.jpg'
					],
					'8' => [
						'title'=> '8',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_8.jpg'
					],
					'9' => [
						'title'=> '9',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_9.jpg'
					],
					'10' => [
						'title'=> '10',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_10.jpg'
					],
					'11' => [
						'title'=> '11',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_11.jpg'
					],
					'12' => [
						'title'=> '12',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_12.jpg'
					],
					'13' => [
						'title'=> '13',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_13.jpg'
					],
					'13' => [
						'title' => ( Codevz_Plus::is_free() ? 'pro' : 'x' )
					],
					'14' => [
						'title'=> '14',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_14.jpg'
					],
					'15' => [
						'title'=> '15',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_15.jpg'
					],
					'16' => [
						'title'=> '16',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_16.jpg'
					],
					'17' => [
						'title'=> '17',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_17.jpg'
					],
					'18' => [
						'title'=> '18',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_18.jpg'
					],
					'20' => [
						'title'=> '20',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_20.jpg'
					],
					'21' => [
						'title'=> '21',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_21.jpg'
					],
					'22' => [
						'title'=> '22',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_22.jpg'
					],
					'23' => [
						'title'=> '23',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_23.jpg'
					],
					'24' => [
						'title'=> '25',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_25.jpg'
					],
					'26' => [
						'title'=> '26',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_26.jpg'
					],
					'27' => [
						'title'=> '27',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_27.jpg'
					],
					'28' => [
						'title'=> '28',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_28.jpg'
					],
					'29' => [
						'title'=> '29',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_29.jpg'
					],
					'30' => [
						'title'=> '30',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_30.jpg'
					],
					'31' => [
						'title'=> '31',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_31.jpg'
					],
					'32' => [
						'title'=> '32',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_32.jpg'
					],
					'33' => [
						'title'=> '33',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_33.jpg'
					],
					'34' => [
						'title'=> '34',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_34.jpg'
					],
					'35' => [
						'title'=> '35',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_35.jpg'
					],
					'36' => [
						'title'=> '36',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_36.jpg'
					],
					'37' => [
						'title'=> '37',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_37.jpg'
					],
					'38' => [
						'title'=> '38',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_38.jpg'
					],
					'39' => [
						'title'=> '39',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_39.jpg'
					],
					'40' => [
						'title'=> '40',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_40.jpg'
					],
					'41' => [
						'title'=> '41',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_41.jpg'
					],
					'42' => [
						'title'=> '42',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_42.jpg'
					],
					'43' => [
						'title'=> '43',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_43.jpg'
					],
					'44' => [
						'title'=> '44',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_44.jpg'
					],
					'45' => [
						'title'=> '45',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_45.jpg'
					],
					'46' => [
						'title'=> '46',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_46.jpg'
					],
					'47' => [
						'title'=> '47',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_47.jpg'
					],
					'48' => [
						'title'=> '48',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_48.jpg'
					],
					'49' => [
						'title'=> '49',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_49.jpg'
					],
					'50' => [
						'title'=> '50',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_50.jpg'
					],
					'51' => [
						'title'=> '51',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_51.jpg'
					],
					'52' => [
						'title'=> '52',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_52.jpg'
					],
					'53' => [
						'title'=> '53',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_53.jpg'
					],
					'54' => [
						'title'=> '54',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_54.jpg'
					],
					'55' => [
						'title'=> '55',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_55.jpg'
					],
					'56' => [
						'title'=> '56',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_56.jpg'
					],
					'57' => [
						'title'=> '57',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_57.jpg'
					],
					'58' => [
						'title'=> '58',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_58.jpg'
					],
					'59' => [
						'title'=> '59',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_59.jpg'
					],
					'60' => [
						'title'=> '60',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_60.jpg'
					],
					'61' => [
						'title'=> '61',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_61.jpg'
					],
					'62' => [
						'title'=> '62',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_62.jpg'
					],
					'63' => [
						'title'=> '63',
						'url'=> Codevz_Plus::$url . 'assets/img/sep_63.jpg'
					],
					'65' => [
						'title' => '65',
						'url' 	=> Codevz_Plus::$url . 'assets/img/sep_65.jpg'
					],
				),
				'default' => '1',
			]
		);

		$this->add_control(
			'transform',
			[
				'label' => esc_html__( 'Transform', 'codevz-plus' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'cz_sep_bottom',
				'options' => [
					'cz_sep_top' => esc_html__( 'Top', 'codevz-plus' ),
					'cz_sep_rotatey_top' => esc_html__( 'Top Flip Horizontal', 'codevz-plus' ),
					'cz_sep_bottom' => esc_html__( 'Bottom', 'codevz-plus' ),
					'cz_sep_rotatey_bottom' => esc_html__( 'Bottom Flip Horizontal', 'codevz-plus' ),
				],
			]
		);

		$this->add_responsive_control(
			'sep_width',
			[
				'label' => esc_html__( 'Width', 'codevz-plus' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'%' => [
						'min' => 50,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => '100',
				],
				'selectors' => [
					'{{WRAPPER}} .cz_sep2 svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'sep_height',
			[
				'label' => esc_html__( 'Height', 'codevz-plus' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 700,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 200,
				],
				'selectors' => [
					'{{WRAPPER}} .cz_sep2 svg' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'relative',
			[
				'label' => esc_html__( 'With gap?', 'codevz-plus' ),
				'type' => Controls_Manager::SWITCHER
			]
		);

		$this->add_control(
			'priority',
			[
				'label' => esc_html__( 'High priority?', 'codevz-plus' ),
				'type' => Controls_Manager::SWITCHER
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'codevz-plus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'color1',
			[
				'label' => esc_html__( 'Color', 'codevz-plus' ) . ' 1',
				'type' => Controls_Manager::COLOR,
				'default' => '#a7a7a7',
			]
		);

		$this->add_control(
			'color2',
			[
				'label' => esc_html__( 'Color', 'codevz-plus' ) . ' 2',
				'type' => Controls_Manager::COLOR,
				'default' => 'rgba(167,167,167,0.25)',
			]
		);


		$this->add_control(
			'color3',
			[
				'label' => esc_html__( 'Color', 'codevz-plus' ) . ' 3',
				'type' => Controls_Manager::COLOR,
				'default' => 'rgba(167,167,167,0.25)',
			]
		);

		$this->add_responsive_control(
			'sk_sep',
			[
				'label' 	=> esc_html__( 'Container', 'codevz-plus' ),
				'type' 		=> 'stylekit',
				'settings' 	=> [ 'padding', 'width' ],
				'selectors' => Xtra_Elementor::sk_selectors( '.cz_sep2' ),
			]
		);


		$this->end_controls_section();
	 
	}

	public function render() {

		// Settings.
		$settings = $this->get_settings_for_display();

		$style = $settings['style'];
		$c1 = $settings['color1'] ? $settings['color1'] : 'transparent';
		$c2 = $settings['color2'] ? $settings['color2'] : 'transparent';
		$c3 = $settings['color3'] ? $settings['color3'] : 'transparent';
		$h = empty( $settings['sep_height'][ 'size' ] ) ? '200px' : $settings['sep_height'][ 'size' ].$settings['sep_height'][ 'unit' ];
		$w = empty( $settings['sep_width'][ 'size' ] ) ? '100%' : $settings['sep_width'][ 'size' ].$settings['sep_width'][ 'unit' ];

		$settings['transform'] .= empty( $settings['priority'] ) ? '' : ' z99';
		$settings['transform'] .= empty( $settings['relative'] ) ? '' : ' relative';

		ob_start();
		?>
		<div class="relative">
			<div class="cz_sep2 cz_sep2_<?php echo esc_attr( $style ); ?> <?php echo esc_attr( $settings['transform'] ); ?>">
				<?php echo do_shortcode( self::separators_svg( $style, $c1, $c2, $c3, $h, $w ) ); ?>
			</div>
		</div>
		<?php
		$content = ob_get_clean();

		Codevz_Plus::tpl( 'page_builder', $content );
	}

	public function content_template_backup() {
		?>
		<#
		
		var style = settings.style;
		var c1 = settings.color1 ? settings.color1 : 'transparent';
		var c2 = settings.color2 ? settings.color2 : 'transparent';
		var c3 = settings.color3 ? settings.color3 : 'transparent';
		var h = settings.sep_height ? settings.sep_height : '';
		var w = settings.sep_width ? settings.sep_width : '100%';

		settings.transform = settings.priority  ? '' : ' z99';
		settings.transform = settings.relative ? '' : ' relative';
		
		#>

		<div class="relative">
			<div class="cz_sep2 cz_sep2_' . $style . ' ' . {{{settings.transform}}} . '">
				{{{style}}}{{{c1}}}{{{c2}}}{{{c3}}}{{{h}}}{{{w}}}
			</div>
		</div>
		<?php
	}

	public static function separators_svg( $s , $c1 , $c2, $c3 , $h, $w ) {
		
		$svg_attrs = 'preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" width="'. $w .'" ';
		$svg = '';

		switch ($s) {
			case '1':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 218">
						  <path style="fill:'. $c3 .'" d="M-36,213.5L1605,0V228.5H-36v-15Z"/>
						  <path style="fill:'. $c2 .'" d="M-36,213.5L1605,32V228.5H-36v-15Z"/>
						  <path style="fill:'. $c1 .'" d="M-36,212L1605,62V228H-36V212Z"/>
						</svg>';
				break;

			case '2':
				$svg .= '<svg '. $svg_attrs .' style="height:'. $h .'" viewBox="0 0 1600 122">
						  <path style="fill:'. $c3 .'" d="M800-77.787L899.787,22,800,121.787,700.213,22Z"/>
						  <rect style="fill:'. $c2 .'" x="-15" y="-60" width="1659" height="102"/>
						  <rect style="fill:'. $c1 .'" x="-15" y="-80" width="1659" height="102"/>
						  <path style="fill:'. $c1 .'" d="M800-49.276L871.276,22,800,93.276,728.724,22Z"/>
						</svg>';
				break;

			case '3':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 129">
						  <path style="fill:'. $c3 .'" d="M799.5-65.74A97.24,97.24,0,1,1,702.26,31.5,97.24,97.24,0,0,1,799.5-65.74Z"/>
						  <rect style="fill:'. $c2 .'" x="-15" y="-47" width="1659" height="102"/>
						  <circle style="fill:'. $c1 .'" cx="799.5" cy="31.5" r="71.5"/>
						  <rect style="fill:'. $c1 .'" x="-15" y="-70" width="1659" height="102"/>
						</svg>';
				break;

			case '4':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 165">
						  <path style="fill:'. $c3 .'" d="M-3,0S398.468,103.5,799.951,103.5C1201.47,103.5,1603,0,1603,0V167H-3V0Z"/>
						  <path style="fill:'. $c2 .'" d="M-3,25S398.468,128.5,799.951,128.5C1201.47,128.5,1603,25,1603,25V168H-3V25Z"/>
						  <path style="fill:'. $c1 .'" d="M-3,49S398.468,152.5,799.951,152.5C1201.47,152.5,1603,49,1603,49V167.5H-3V49Z"/>
						</svg>';
				break;

			case '5':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 172">
						  <path style="fill:'. $c3 .'" d="M-3,108.5S398.468,0.5,799.951.5C1201.47,0.5,1603,108.5,1603,108.5v203H-3v-203Z"/>
						  <path style="fill:'. $c2 .'" d="M-3,137.5s401.468-108,802.951-108c401.519,0,803.049,108,803.049,108v203H-3v-203Z"/>
						  <path style="fill:'. $c1 .'" d="M-3,164.5s401.468-108,802.951-108c401.519,0,803.049,108,803.049,108v203H-3v-203Z"/>
						</svg>';
				break;


			case '6':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 172">
						  <path style="fill:'. $c3 .'" d="M-3,0V203H1603V0S799.951,160.451,799.951,160.5C800,160.658-3,0-3,0Z"/>
						  <path style="fill:'. $c2 .'" d="M-3,27V230H1603V27S799.951,160.451,799.951,160.5C800,160.658-3,27-3,27Z"/>
						  <path style="fill:'. $c1 .'" d="M799.951,160.5C799.951,160.451,1603,57,1603,57V260H-3V57"/>
						</svg>';
				break;

			case '7':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 116">
						  <path style="fill:'. $c3 .'" d="M0,171H1600V48.5L800,1,0,51.112V171Z"/>
						  <path style="fill:'. $c2 .'" d="M0,171H1600V80L800,1,0,81.112V171Z"/>
						  <path style="fill:'. $c1 .'" d="M0,200H1600V109L800,0,0,110.112V200Z"/>
						</svg>';
				break;

			case '8':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 90">
						  <path style="fill:'. $c3 .'" d="M-599.147.584H700.809V0.606c0.582-.011,4.164-0.022,4.748-0.022,47.8,0,90.38,2.127,93.569,30.282,3.727-27.92,44.247-29.493,81.325-29.493L888,1l1311.15-.416V96.416h-2798.3V0.584Z"/>
						  <path style="fill:'. $c2 .'" d="M-259.96,18.2H727.128v0.017c0.441-.008.882-0.017,1.325-0.017,35.043,0,66.633,6.551,70.885,37.577C803.927,25.02,831.174,18.8,860.948,18.8l7-.6H1859.96V90.8H-259.96V18.2Z"/>
						  <path style="fill:'. $c1 .'" d="M-3,35H744.794v0.013c0.334-.006.668-0.013,1-0.013a54.144,54.144,0,0,1,53.7,46.65,54.129,54.129,0,0,1,46.674-46.2l7-.453H1603V90H-3V35Z"/>
						</svg>';
				break;

			case '9':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 116">
							<path style="fill:'. $c2 .'" d="M1601.15,38.893V9.15H-1.15V37.893h730.1V37.91c0.433-.008.866-0.017,1.3-0.017,42.551,0,64.929,43.527,69.594,77.948,4.26-31.432,25.8-77.356,60.487-77.356Z"/>
							<path style="fill:'. $c1 .'" d="M1601,23.11V0H0V22.11H745.466v0.013c0.333-.006.666-0.013,1-0.013A54.122,54.122,0,0,1,800,68.993a54.176,54.176,0,0,1,46.529-46.428Z"/>
						</svg>';
				break;
			
			case '10':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 214">
							<path style="fill:'. $c2 .'" d="M-117,142.593S44.816-107.076,925.8,54.248C1825.37,218.976,1675.66,212.969,1675.66,212.969L-96,209.475Z"/>
							<path style="fill:'. $c1 .'" d="M-117,165.5S44.847-84.608,926,77c899.74,165.018,750,159,750,159L-96,232.5Z"/>
						</svg>';
				break;

			case '11':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 58">
							<path style="fill:'. $c1 .'" d="M0,58V54A54,54,0,0,0,54,0H1546a54,54,0,0,0,54,54v4H0Z"/>
						</svg>';
				break;

			case '12':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 59">
							<path style="fill:'. $c1 .'" d="M0,59V0A54,54,0,0,0,54,54H1547V53.987A54,54,0,0,0,1600,0V59H0Z"/>
						</svg>';
				break;

			case '13':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 59">
							<path style="fill:'. $c3 .'" d="M-113,159V16.364h33.267A78.3,78.3,0,0,1-34.4,2,78.289,78.289,0,0,1,8.939,15.009,78.349,78.349,0,0,0,61.145,34.835a78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.348,78.348,0,0,0,52.206-19.826,78.7,78.7,0,0,1,86.684,0A78.35,78.35,0,0,0,443.34,34.835a78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.348,78.348,0,0,0,52.207,19.826,78.348,78.348,0,0,0,52.206-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.346,78.346,0,0,0,52.2,19.826,78.352,78.352,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.371,78.371,0,0,0,52.21,19.826,78.371,78.371,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.352,78.352,0,0,0,52.21,19.826,78.326,78.326,0,0,0,52.2-19.826,78.71,78.71,0,0,1,88.68,1.355H1574V159H-113Z"/>
							<path style="fill:'. $c2 .'" d="M-78,159V16.364h33.267A78.3,78.3,0,0,1,.6,2,78.289,78.289,0,0,1,43.939,15.009,78.349,78.349,0,0,0,96.145,34.835a78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.348,78.348,0,0,0,52.206-19.826,78.7,78.7,0,0,1,86.684,0A78.35,78.35,0,0,0,478.34,34.835a78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.348,78.348,0,0,0,52.206-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.344,78.344,0,0,0,52.2,19.826,78.352,78.352,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.371,78.371,0,0,0,52.21,19.826,78.371,78.371,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.352,78.352,0,0,0,52.21,19.826,78.326,78.326,0,0,0,52.2-19.826,78.71,78.71,0,0,1,88.68,1.355H1609V159H-78Z"/>
							<path style="fill:'. $c1 .'" d="M-41,159V16.364H-7.733a78.7,78.7,0,0,1,88.672-1.355,78.348,78.348,0,0,0,52.206,19.826,78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.348,78.348,0,0,0,52.206-19.826,78.7,78.7,0,0,1,86.684,0A78.35,78.35,0,0,0,515.34,34.835a78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.206,19.826,78.348,78.348,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.688,0,78.326,78.326,0,0,0,52.2,19.826,78.352,78.352,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.371,78.371,0,0,0,52.21,19.826,78.371,78.371,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.352,78.352,0,0,0,52.21,19.826,78.326,78.326,0,0,0,52.2-19.826,78.71,78.71,0,0,1,88.68,1.355H1646V159H-41Z"/>
						</svg>';
				break;

			case '14':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 88">
							<path style="fill:'. $c3 .'" d="M-41,157V14.364H-7.733a78.7,78.7,0,0,1,88.672-1.355,78.348,78.348,0,0,0,52.206,19.826,78.351,78.351,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.351,78.351,0,0,0,52.207,19.826,78.348,78.348,0,0,0,52.206-19.826,78.7,78.7,0,0,1,86.684,0A78.351,78.351,0,0,0,515.34,32.835a78.351,78.351,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.206,19.826,78.349,78.349,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.351,78.351,0,0,0,52.207,19.826,78.351,78.351,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.688,0,78.327,78.327,0,0,0,52.2,19.826,78.353,78.353,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.372,78.372,0,0,0,52.21,19.826,78.372,78.372,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.353,78.353,0,0,0,52.21,19.826,78.327,78.327,0,0,0,52.2-19.826,78.71,78.71,0,0,1,88.68,1.355H1646V157H-41Z"/>
							<path style="fill:'. $c2 .'" d="M-41,173V30.364H-7.733a78.7,78.7,0,0,1,88.672-1.355,78.348,78.348,0,0,0,52.206,19.826,78.351,78.351,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.351,78.351,0,0,0,52.207,19.826,78.348,78.348,0,0,0,52.206-19.826,78.7,78.7,0,0,1,86.684,0A78.351,78.351,0,0,0,515.34,48.835a78.351,78.351,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.206,19.826,78.349,78.349,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.351,78.351,0,0,0,52.207,19.826,78.351,78.351,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.688,0,78.327,78.327,0,0,0,52.2,19.826,78.353,78.353,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.372,78.372,0,0,0,52.21,19.826,78.372,78.372,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.353,78.353,0,0,0,52.21,19.826,78.327,78.327,0,0,0,52.2-19.826,78.71,78.71,0,0,1,88.68,1.355H1646V173H-41Z"/>
							<path style="fill:'. $c1 .'" d="M-41,188V45.364H-7.733a78.7,78.7,0,0,1,88.672-1.355,78.348,78.348,0,0,0,52.206,19.826,78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.348,78.348,0,0,0,52.206-19.826,78.7,78.7,0,0,1,86.684,0A78.35,78.35,0,0,0,515.34,63.835a78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.206,19.826,78.348,78.348,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.688,0,78.326,78.326,0,0,0,52.2,19.826,78.352,78.352,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.371,78.371,0,0,0,52.21,19.826,78.371,78.371,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.352,78.352,0,0,0,52.21,19.826,78.326,78.326,0,0,0,52.2-19.826,78.71,78.71,0,0,1,88.68,1.355H1646V188H-41Z"/>
						</svg>';
				break;

			case '15':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 76">
							<path style="fill:'. $c3 .'" d="M1635.19,0a126.386,126.386,0,0,0-56.8,13.011c-18.2,12.331-42.16,19.826-68.43,19.826s-50.23-7.495-68.42-19.826a130.508,130.508,0,0,0-113.61,0c-18.19,12.331-42.16,19.826-68.42,19.826s-50.23-7.495-68.42-19.826a130.508,130.508,0,0,0-113.61,0c-18.2,12.331-42.16,19.826-68.43,19.826s-50.224-7.495-68.419-19.826a130.506,130.506,0,0,0-113.609,0c-18.2,12.331-42.158,19.826-68.422,19.826s-50.228-7.495-68.423-19.826a130.506,130.506,0,0,0-113.609,0C558.373,25.34,534.41,32.835,508.145,32.835s-50.228-7.495-68.422-19.826a130.508,130.508,0,0,0-113.61,0c-18.194,12.331-42.158,19.826-68.422,19.826s-50.228-7.495-68.423-19.826A126.432,126.432,0,0,0,132.464,0a126.434,126.434,0,0,0-56.8,13.011C57.464,25.34,33.5,32.835,7.237,32.835S-42.991,25.34-61.186,13.009A126.433,126.433,0,0,0-117.99,0c-22.127,0-42.622,5.318-59.41,14.366H-221V157H1669S1656.19,0,1635.19,0Z"/>
							<path style="fill:'. $c2 .'" d="M-49,90V24.364h21.179C-19.666,15.316-9.711,10,1.037,10c10.2,0,19.683,4.791,27.593,13.011C37.468,35.34,49.109,42.835,61.867,42.835s24.4-7.5,33.237-19.826C103.013,14.789,112.5,10,122.7,10s19.683,4.791,27.593,13.011c8.838,12.331,20.479,19.826,33.237,19.826s24.4-7.5,33.236-19.826C224.672,14.789,234.156,10,244.355,10s19.683,4.791,27.593,13.011c8.838,12.331,20.478,19.826,33.236,19.826s24.4-7.5,33.237-19.826C346.331,14.789,355.815,10,366.014,10s19.683,4.791,27.593,13.011c8.838,12.331,20.478,19.826,33.236,19.826s24.4-7.5,33.237-19.826C467.99,14.789,477.474,10,487.673,10s19.683,4.791,27.593,13.011C524.1,35.34,535.744,42.835,548.5,42.835s24.4-7.5,33.237-19.826C589.649,14.789,599.133,10,609.332,10s19.683,4.791,27.593,13.011c8.838,12.331,20.478,19.826,33.236,19.826s24.4-7.5,33.237-19.826C711.308,14.789,720.792,10,730.991,10s19.683,4.791,27.593,13.011c8.838,12.331,20.478,19.826,33.236,19.826s24.4-7.5,33.237-19.826C832.967,14.789,842.451,10,852.65,10s19.683,4.791,27.593,13.011c8.838,12.331,20.478,19.826,33.236,19.826s24.4-7.5,33.237-19.826C954.626,14.789,964.11,10,974.309,10c10.748,0,20.7,5.318,28.861,14.366H1025V90H-49Z"/>
							<path style="fill:'. $c2 .'" d="M1640.74,32.008c-8.84,12.331-20.48,19.826-33.24,19.826s-24.4-7.495-33.23-19.826c-7.91-8.22-17.4-13.011-27.6-13.011s-19.68,4.791-27.59,13.011c-8.84,12.331-20.48,19.826-33.24,19.826s-24.39-7.495-33.23-19.826c-7.91-8.22-17.4-13.011-27.6-13.011s-19.68,4.791-27.59,13.011c-8.84,12.331-20.48,19.826-33.24,19.826s-24.39-7.495-33.23-19.826c-7.91-8.22-17.4-13.011-27.59-13.011s-19.69,4.791-27.6,13.011c-8.84,12.331-20.48,19.826-33.23,19.826s-24.4-7.495-33.24-19.826C1201.38,23.789,1191.89,19,1181.7,19s-19.69,4.791-27.6,13.011c-8.84,12.331-20.48,19.826-33.23,19.826s-24.4-7.495-33.24-19.826C1079.72,23.789,1070.24,19,1060.04,19c-10.75,0-20.71,5.318-28.86,14.366H1010V86h638S1648.65,23.789,1640.74,32.008Z"/>
							<path style="fill:'. $c1 .'" d="M-41,176V33.364H-7.733a78.7,78.7,0,0,1,88.672-1.355,78.348,78.348,0,0,0,52.206,19.826,78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.348,78.348,0,0,0,52.206-19.826,78.7,78.7,0,0,1,86.684,0A78.35,78.35,0,0,0,515.34,51.835a78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.206,19.826,78.348,78.348,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.684,0,78.35,78.35,0,0,0,52.207,19.826,78.35,78.35,0,0,0,52.207-19.826,78.7,78.7,0,0,1,86.688,0,78.326,78.326,0,0,0,52.2,19.826,78.352,78.352,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.371,78.371,0,0,0,52.21,19.826,78.371,78.371,0,0,0,52.21-19.826,78.689,78.689,0,0,1,86.68,0,78.352,78.352,0,0,0,52.21,19.826,78.326,78.326,0,0,0,52.2-19.826,78.71,78.71,0,0,1,88.68,1.355H1646V176H-41Z"/>
						</svg>';
				break;

			case '16':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 34">
							<path style="fill:'. $c2 .'" d="M1577.75,28.27V56h-27.56v0.005L1550.18,56h-55.64l-0.01.005V56h-55.65v0.005L1438.87,56h-55.64l-0.01.005V56h-55.65v0.005L1327.56,56h-55.64l-0.01.005L1271.9,56h-55.64l-0.01.005V56H1160.6v0.005L1160.59,56h-55.64l-0.01.005V56h-55.65v0.005L1049.28,56H993.637l-0.006.005,0-.005H937.981l-0.006.005,0-.005H882.325l0,0.005L882.314,56H826.669l0,0.005,0-.005H771.014l-0.006.005L771,56H715.358l0,0.005L715.347,56H659.7l0,0.005L659.691,56H604.046l0,0.005L604.036,56H548.391l-0.006.005,0-.005H492.735l0,0.005L492.724,56H437.079l0,0.005L437.068,56H381.423l0,0.005,0-.005H325.768l-0.006.005,0-.005H270.112l0,0.005L270.1,56H214.456l0,0.005L214.445,56H158.8l-0.005.005,0-.005H103.145l-0.006.005,0-.005H47.489l-0.005.005L47.478,56H-8.167l-0.005.005L-8.177,56H-36V28h0.006L-8.172,0,19.65,28h0.011L47.484,0,75.306,28h0.011L103.139,0l27.823,28h0.011L158.795,0l27.822,28h0.012L214.451,0l27.822,28h0.011L270.107,0l27.822,28h0.011L325.762,0l27.823,28H353.6L381.418,0,409.24,28h0.011L437.074,0,464.9,28h0.011L492.73,0l27.822,28h0.011L548.385,0l27.823,28h0.011L604.041,0l27.822,28h0.011L659.7,0l27.822,28h0.011L715.353,0l27.822,28h0.011L771.008,0l27.823,28h0.011L826.664,0l27.822,28H854.5L882.32,0l27.822,28h0.011L937.975,0,965.8,28h0.011L993.631,0l27.819,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01L1160.6,0l27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28Z"/>
							<path style="fill:'. $c1 .'" d="M1605.75,28.27V56h-27.56v0.005L1578.18,56h-55.64l-0.01.005V56h-55.65v0.005L1466.87,56h-55.64l-0.01.005V56h-55.65v0.005L1355.56,56h-55.64l-0.01.005L1299.9,56h-55.64l-0.01.005V56H1188.6v0.005L1188.59,56h-55.64l-0.01.005V56h-55.65v0.005L1077.28,56h-55.64l-0.01.005V56H965.981l-0.006.005,0-.005H910.325l0,0.005L910.314,56H854.669l0,0.005,0-.005H799.014l-0.006.005L799,56H743.358l0,0.005L743.347,56H687.7l0,0.005L687.691,56H632.046l0,0.005L632.036,56H576.391l-0.006.005,0-.005H520.735l0,0.005L520.724,56H465.079l0,0.005L465.068,56H409.423l0,0.005,0-.005H353.768l-0.006.005,0-.005H298.112l0,0.005L298.1,56H242.456l0,0.005L242.445,56H186.8l-0.005.005,0-.005H131.145l-0.006.005L131.134,56H75.489l-0.005.005L75.478,56H19.833l-0.005.005L19.823,56H-8V28h0.006L19.828,0,47.65,28h0.011L75.484,0l27.822,28h0.011L131.139,0l27.823,28h0.011L186.8,0l27.822,28h0.012L242.451,0l27.822,28h0.011L298.107,0l27.822,28h0.011L353.762,0l27.823,28H381.6L409.418,0,437.24,28h0.011L465.074,0,492.9,28h0.011L520.73,0l27.822,28h0.011L576.385,0l27.823,28h0.011L632.041,0l27.822,28h0.011L687.7,0l27.822,28h0.011L743.353,0l27.822,28h0.011L799.008,0l27.823,28h0.011L854.664,0l27.822,28H882.5L910.32,0l27.822,28h0.011L965.975,0,993.8,28h0.011L1021.63,0l27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01L1188.6,0l27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28Z"/>
						</svg>';
				break;

			case '17':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 62">
							<path style="fill:'. $c3 .'" d="M1606.75,28.27V56h-27.56v0.005L1579.18,56h-55.64l-0.01.005V56h-55.65v0.005L1467.87,56h-55.64l-0.01.005V56h-55.65v0.005L1356.56,56h-55.64l-0.01.005L1300.9,56h-55.64l-0.01.005V56H1189.6v0.005L1189.59,56h-55.64l-0.01.005V56h-55.65v0.005L1078.28,56h-55.64l-0.01.005V56H966.981l-0.006.005,0-.005H911.325l0,0.005L911.314,56H855.669l0,0.005,0-.005H800.014l-0.006.005L800,56H744.358l0,0.005L744.347,56H688.7l0,0.005L688.691,56H633.046l0,0.005L633.036,56H577.391l-0.006.005,0-.005H521.735l0,0.005L521.724,56H466.079l0,0.005L466.068,56H410.423l0,0.005,0-.005H354.768l-0.006.005,0-.005H299.112l0,0.005L299.1,56H243.456l0,0.005L243.445,56H187.8l-0.005.005,0-.005H132.145l-0.006.005L132.134,56H76.489l-0.005.005L76.478,56H20.833l-0.005.005L20.823,56H-7V28h0.006L20.828,0,48.65,28h0.011L76.484,0l27.822,28h0.011L132.139,0l27.823,28h0.011L187.8,0l27.822,28h0.012L243.451,0l27.822,28h0.011L299.107,0l27.822,28h0.011L354.762,0l27.823,28H382.6L410.418,0,438.24,28h0.011L466.074,0,493.9,28h0.011L521.73,0l27.822,28h0.011L577.385,0l27.823,28h0.011L633.041,0l27.822,28h0.011L688.7,0l27.822,28h0.011L744.353,0l27.822,28h0.011L800.008,0l27.823,28h0.011L855.664,0l27.822,28H883.5L911.32,0l27.822,28h0.011L966.975,0,994.8,28h0.011L1022.63,0l27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01L1189.6,0l27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28Z"/>
							<path style="fill:'. $c2 .'" d="M1606.75,42.27V70h-27.56v0.005L1579.18,70h-55.64l-0.01.005V70h-55.65v0.005L1467.87,70h-55.64l-0.01.005V70h-55.65v0.005L1356.56,70h-55.64l-0.01.005L1300.9,70h-55.64l-0.01.005V70H1189.6v0.005L1189.59,70h-55.64l-0.01.005V70h-55.65v0.005L1078.28,70h-55.64l-0.01.005V70H966.981l-0.006.005,0-.005H911.325l0,0.005L911.314,70H855.669l0,0.005,0-.005H800.014l-0.006.005L800,70H744.358l0,0.005L744.347,70H688.7l0,0.005L688.691,70H633.046l0,0.005L633.036,70H577.391l-0.006.005,0-.005H521.735l0,0.005L521.724,70H466.079l0,0.005L466.068,70H410.423l0,0.005,0-.005H354.768l-0.006.005,0-.005H299.112l0,0.005L299.1,70H243.456l0,0.005L243.445,70H187.8l-0.005.005,0-.005H132.145l-0.006.005L132.134,70H76.489l-0.005.005L76.478,70H20.833l-0.005.005L20.823,70H-7V42h0.006L20.828,14,48.65,42h0.011L76.484,14l27.822,28h0.011l27.822-28,27.823,28h0.011L187.8,14l27.822,28h0.012l27.822-28,27.822,28h0.011l27.823-28,27.822,28h0.011l27.822-28,27.823,28H382.6l27.822-28L438.24,42h0.011l27.823-28L493.9,42h0.011L521.73,14l27.822,28h0.011l27.822-28,27.823,28h0.011l27.822-28,27.822,28h0.011L688.7,14l27.822,28h0.011l27.823-28,27.822,28h0.011l27.822-28,27.823,28h0.011l27.822-28,27.822,28H883.5L911.32,14l27.822,28h0.011l27.822-28L994.8,42h0.011l27.821-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28Z"/>
							<path style="fill:'. $c1 .'" d="M1606.75,56.27V84h-27.56v0.005L1579.18,84h-55.64l-0.01.005V84h-55.65v0.005L1467.87,84h-55.64l-0.01.005V84h-55.65v0.005L1356.56,84h-55.64l-0.01.005L1300.9,84h-55.64l-0.01.005V84H1189.6v0.005L1189.59,84h-55.64l-0.01.005V84h-55.65v0.005L1078.28,84h-55.64l-0.01.005V84H966.981l-0.006.005,0-.005H911.325l0,0.005L911.314,84H855.669l0,0.005,0-.005H800.014l-0.006.005L800,84H744.358l0,0.005L744.347,84H688.7l0,0.005L688.691,84H633.046l0,0.005L633.036,84H577.391l-0.006.005,0-.005H521.735l0,0.005L521.724,84H466.079l0,0.005L466.068,84H410.423l0,0.005,0-.005H354.768l-0.006.005,0-.005H299.112l0,0.005L299.1,84H243.456l0,0.005L243.445,84H187.8l-0.005.005,0-.005H132.145l-0.006.005L132.134,84H76.489l-0.005.005L76.478,84H20.833l-0.005.005L20.823,84H-7V56h0.006L20.828,28,48.65,56h0.011L76.484,28l27.822,28h0.011l27.822-28,27.823,28h0.011L187.8,28l27.822,28h0.012l27.822-28,27.822,28h0.011l27.823-28,27.822,28h0.011l27.822-28,27.823,28H382.6l27.822-28L438.24,56h0.011l27.823-28L493.9,56h0.011L521.73,28l27.822,28h0.011l27.822-28,27.823,28h0.011l27.822-28,27.822,28h0.011L688.7,28l27.822,28h0.011l27.823-28,27.822,28h0.011l27.822-28,27.823,28h0.011l27.822-28,27.822,28H883.5L911.32,28l27.822,28h0.011l27.822-28L994.8,56h0.011l27.821-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.82,28h0.01l27.83-28,27.82,28h0.01l27.82-28,27.83,28h0.01l27.82-28,27.82,28Z"/>
						</svg>';
				break;

			case '18':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 44">
							<path style="fill:'. $c1 .'" d="M0,44V0H34.043V34H68.085V0h34.043V34H136.17V0h34.043V34h34.042V0H238.3V34H272.34V0h34.043V34h34.042V0h34.043V34h34.043V0h34.042V34H476.6V0h34.042V34h34.043V0h34.042V34h34.043V0h34.042V34h34.043V0h34.043V34h34.042V0h34.043V34h34.042V0h34.043V34h34.042V0h34.043V34h34.042V0h34.043V34h34.046V0h34.04V34h34.04V0h34.04V34h34.05V0h34.04V34h34.04V0h34.04V34h34.05V0h34.04V34h34.04V0h34.04V34h34.05V0h34.04V34h34.04V0h34.04V34h34.05V0H1600V44H0Z"/>
						</svg>';
				break;

			case '19':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 246">
							<path style="fill:'. $c3 .'" d="M748.733,61.328C1189.99,255.13,1619.82,194.517,1620,198.548v48.438H-14S272.585-147.8,748.733,61.328Z"/>
							<path style="fill:'. $c2 .'" d="M748,90.809c449.12,185.245,870.82,99.762,871,103.825v44.152l-1647,21.2S266.823-107.658,748,90.809Z"/>
							<path style="fill:'. $c1 .'" d="M748,120c449.12,170.392,870.82,72.263,871,76v60.112H-28S266.823-62.554,748,120Z"/>
						</svg>';
				break;

			case '20':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 214">
							<path style="fill:'. $c3 .'" d="M-8,70L287,49l79,98,248,49,295-90,199,65,147-81,249,47L1600,2V214.112H0Z"/>
							<path style="fill:'. $c2 .'" d="M0,84L240,48l136,83,297,67L870,96l199,57,263-66,129,51L1600,2V214.112H0V84Z"/>
							<path style="fill:'. $c1 .'" d="M-1,98L244,35,366,143l307,54L906,95l163,57,234-48,178,28L1601,0V214.112H-1V98Z"/>
						</svg>';
				break;

			case '21':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 131">
							<path style="fill:'. $c2 .'" d="M1,100.937s420.376-224.9,958,.063Z"/>
							<path style="fill:'. $c1 .'" d="M-9,39S282.19,143.518,822.773,57.419C1344.37-25.655,1352.43-2.187,1616,34v97H-10Z"/>
						</svg>';
				break;

			case '22':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 244">
							<path style="fill:'. $c3 .'" d="M-4,0V187l804,57S800,20.974-4,0ZM1604,0V187L800,244S800,20.974,1604,0Z"/>
							<path style="fill:'. $c2 .'" d="M-4,30V217l804,27S800,50.974-4,30Zm1608,0V217L800,244S800,50.974,1604,30Z"/>
							<path style="fill:'. $c1 .'" d="M-4,60V247H800S800,80.974-4,60Zm1608,0V247H800S800,80.974,1604,60Z"/>
						</svg>';
				break;

			case '23':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 303">
							<path style="fill:'. $c3 .'" d="M1607,290.074V304H-7V290.1C800.5,270.593,800.5,0,800.5,0L1607,119h0L800.5,0S800.513,270.467,1607,290.074Z"/>
							<path style="fill:'. $c2 .'" d="M1607,290.074V304H-7V290.1C800.5,270.593,800.5,66,800.5,66L1607,119h0L800.5,66S800.513,270.467,1607,290.074Z"/>
							<path style="fill:'. $c1 .'" d="M1607,290.074V304H-7V290.1C800.5,270.593,800.5,119,800.5,119h0S800.513,270.467,1607,290.074Z"/>
						</svg>';
				break;

			case '24':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 200">
							<path style="fill:'. $c2 .'" d="M-4.5,19L318,117,502,43l186,86L968,31l64,47,99-31,104,78,159,47,134-83,167.5,115H-4Z"/>
							<path style="fill:'. $c1 .'" d="M-4.5,19L328,139,528.5,63,658,148,976,56l72,43,68-38,135,85,161,34,103-76,180.5,100H-4Z"/>
						</svg>';
				break;

			case '25':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 184">
							<path style="fill:'. $c2 .'" d="M-1,62L347,0,859,139l557-15,184-87V184H0Z"/>
							<path style="fill:'. $c1 .'" d="M0,131L164,77l401,49L994,85l434,70,173-27v56H0V131Z"/>
						</svg>';
				break;

			case '26':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 252">
							<path style="fill:'. $c3 .'" d="M-77.98,285.381H2081.98C2106,277.616,1036.5-302.5-77.98,285.381Z"/>
							<path style="fill:'. $c2 .'" d="M-108,8s64-36,494,54,429.633,166.352,854,48,332-128,688-88V292H-48Z"/>
							<path style="fill:'. $c1 .'" d="M-84,145S266.435,11.367,896,180c224,60,413,97,798-20l2,96H-60Z"/>
						</svg>';
				break;

			case '27':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 62">
							<path style="fill:'. $c1 .'" d="M1637.91,62L1575.54,0h16.1L1654,62h-16.09Zm-44.26,0L1531.28,0h16.1l62.36,62h-16.09Zm-44.26,0L1487.03,0h16.09l62.36,62h-16.09Zm-44.26,0L1442.77,0h16.09l62.37,62h-16.1Zm-44.26,0L1398.51,0h16.09l62.37,62h-16.1Zm-44.25,0L1354.25,0h16.1l62.36,62h-16.09Zm-44.26,0L1310,0h16.09l62.36,62h-16.09Zm-44.26,0L1265.74,0h16.09l62.36,62H1328.1Zm-44.26,0L1221.48,0h16.09l62.37,62h-16.1Zm-44.26,0L1177.22,0h16.1l62.36,62h-16.1Zm-44.25,0L1132.96,0h16.1l62.36,62h-16.09Zm-44.26,0L1088.71,0h16.09l62.36,62h-16.09Zm-44.26,0L1044.45,0h16.09l62.36,62h-16.09Zm-44.26,0L1000.19,0h16.09l62.37,62h-16.1Zm-44.25,0L955.932,0h16.094l62.364,62H1018.3Zm-44.263,0L911.674,0h16.094l62.363,62H974.037ZM929.78,62L867.416,0H883.51l62.363,62H929.78Zm-44.258,0L823.158,0h16.094l62.363,62H885.522Zm-44.258,0L778.9,0h16.094l62.364,62H841.264Zm-44.258,0L734.642,0h16.094L813.1,62H797.006Zm-44.258,0L690.384,0h16.094l62.364,62H752.748ZM708.49,62L646.127,0H662.22l62.364,62H708.49Zm-44.258,0L601.869,0h16.093l62.364,62H664.232Zm-44.258,0L557.611,0h16.094l62.363,62H619.974Zm-44.258,0L513.353,0h16.094L591.81,62H575.716Zm-44.258,0L469.1,0h16.094l62.363,62H531.458ZM487.2,62L424.837,0h16.094l62.363,62H487.2Zm-44.257,0L380.579,0h16.094l62.363,62H442.943Zm-44.258,0L336.321,0h16.094l62.363,62H398.685Zm-44.258,0L292.063,0h16.094L370.52,62H354.427Zm-44.258,0L247.805,0H263.9l62.364,62H310.169Zm-44.258,0L203.547,0h16.094l62.364,62H265.911Zm-44.258,0L159.29,0h16.093l62.364,62H221.653ZM177.4,62L115.032,0h16.093l62.364,62H177.4Zm-44.258,0L70.774,0H86.868l62.363,62H133.137ZM88.879,62L26.516,0H42.61l62.363,62H88.879ZM44.621,62L-17.742,0H-1.648L60.715,62H44.621ZM0.363,62L-62,0h16.094L16.457,62H0.363Z"/>
						</svg>';
				break;

			case '28':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 128">
							<path style="fill:'. $c3 .'" d="M800,0h754V90H710Z"/>
							<path style="fill:'. $c2 .'" d="M835,0h754V90H745Z"/>
							<rect style="fill:'. $c1 .'" y="89" width="1600" height="38"/>
							<path style="fill:'. $c1 .'" d="M872,0h754V90H782Z"/>
						</svg>';
				break;

			case '29':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 81">
							<path style="fill:'. $c2 .'" d="M65,76V0h49l34,33h52V0h49l34,33h52V0h49l34,33h52V0h49l34,33h52V0h49l34,33h52V0h49l34,33h52V0h49l34,33h52V0h49l34,33h52V0h49l34,33h52V0h49l34,33h52V0h49l34,33h52V0h49l34,33h32V76H65Z"/>
							<path style="fill:'. $c1 .'" d="M0,81V5H49L83,38h52V5h49l34,33h52V5h49l34,33h52V5h49l34,33h52V5h49l34,33h52V5h49l34,33h52V5h49l34,33h52V5h49l34,33h52V5h49l34,33h52V5h49l34,33h52V5h49l34,33h52V5h49l34,33h32V81H0Z"/>
						</svg>';
				break;

			case '30':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 259">
							<path style="fill:'. $c2 .'" d="M0,29L261,144l277-43,262,56,263,59,269-26L1600,0V259H0V29Z"/>
							<path style="fill:'. $c1 .'" d="M0,59l261,85,277-23,262,36,263,86,269-53L1600,30V259H0V59Z"/>
						</svg>';
				break;

			case '31':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 157">
							<path style="fill:'. $c1 .'" d="M0,45s24.325,65.165,72,65c48.167-.167,59-38,59-38s31.833-93.833,54-51c0,0,18.333,29.167,44,29s38,27,38,27,11.333,20.667,36-4,34.333-7.833,58,34,38.833,40.667,84-36c0,0,8.833-18.833,26,7s35.833,9.167,48-5,19.333-8.333,33,9,27.833,37.667,56-39c0,0,9.333-38.333,44-5S765,20,765,20s50.833-35.833,68,31,38.333,57.167,59,47,23,6,23,6,22.333,54.167,56-11,44.83-6.333,71-40,51.83-79.333,97-4,68.45,10.355,89-23,37.45-40.645,69,22,43,1,43,1,21.45-64.645,62-5c0,0,23.45,45.355,68,17,0,0,18.95-21.645,64,19s66-67,66-67V157H0V45Z"/>
						</svg>';
				break;

			case '32':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 200">
							<circle style="fill:'. $c3 .'" cx="1066" cy="145" r="131"/>
							<path style="fill:'. $c2 .'" d="M363,201S512,61.1,738,53s234,108.1,421,56,81-81.9,333-51,148,142,148,142Z"/>
							<path style="fill:'. $c1 .'" d="M0,37s119.162-57.393,242,9c0,0,61.162,44.607,191,13s290.162,118.607,413,92,167.16-4.393,274,3,115.16-44.393,271-92,209-48,209-48V200H0V37Z"/>
						</svg>';
				break;

			case '33':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 279">
							<path style="fill:'. $c2 .'" d="M-1,279L351,144l180,36L1024,0l577,279H-1Z"/>
							<path style="fill:'. $c1 .'" d="M-1,279L351,174l180,36L1024,30l577,249H-1Z"/>
						</svg>';
				break;

			case '34':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 133">
							<path style="fill:'. $c3 .'" d="M-0.4-1H1600.01l0.4,134H0Z"/>
							<path style="fill:'. $c2 .'" d="M1600,71.5L0-1V133H1600V71.5Z"/>
							<path style="fill:'. $c1 .'" d="M0,0L1600,132v1H0V0Z"/>
						</svg>';
				break;

			case '35':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 200">
							<path style="fill:'. $c1 .'" d="M0,200V171.73C15.125,153.839,57.426,134,57.426,134,29.105,141.337,7.588,159.276,0,166.277V137.429S65.532,46.658,329.7,158c0,0,107.756,53.571,264.356-75.429,185.43-116.346,270.24-28.54,388.119,25.715,106.432,54.857,131.682,62.143,228.712,14.571s172.21-34.714,236.63-6,108.84,25.286,152.48,13.714V200H0Zm166.372-68.42c-19.943-11.065-34.924-9.19-34.924-9.19-13.949-.4-12.68,12.242,2.849,7.189s23.1,1.123,29.5,3.182S166.372,131.58,166.372,131.58ZM319.8,170.857c-52.777-18.6-73.267-18-73.267-18s22.97,6.343,87.128,28.286c73.862,23.143,117.822-3.429,117.822-3.429C403.592,191,372.579,189.455,319.8,170.857Zm168.317-5.143s30.5-1.028,70.3-38.571C558.416,127.143,529.62,152.174,488.119,165.714Zm220.206-87.2c-61.2,16.109-142.1,77.454-142.1,77.454C685.114,74.676,754.315,74.316,766.611,75.01c0.66,0.053,1.316.1,1.986,0.161,0,0-.667-0.087-1.986-0.161C730.74,72.146,708.325,78.514,708.325,78.514ZM836.634,56c-40.677-18.6-75.248-12-75.248-12s-49.026,6.769.99,3.429S881.188,76.571,881.188,76.571C871.4,70.831,836.634,56,836.634,56ZM1045.54,164.857s-9.07-5.554-4.95,2.572,33.5,17.159,42.58,16.285C1083.17,183.714,1054.21,175.143,1045.54,164.857Zm70.3,6c-32.26,2.374,4.95,5.143,4.95,5.143,48.6-5.912,75.25-31.714,75.25-31.714C1139.27,175.429,1115.84,170.857,1115.84,170.857Zm50.5,7.714s-10.81,6.66,2.97,5.143S1202.97,164,1202.97,164,1184.65,177.286,1166.34,178.571Zm69.3-52.285c-11.55,1.945-22.77,13.714-22.77,13.714,16.59-9.643,22.77-9.429,22.77-9.429S1247.19,124.34,1235.64,126.286ZM1376.24,110c-12.3,1.3-1.98,5.143-1.98,5.143,14.93-2.769,21.78,1.714,21.78,1.714A24.737,24.737,0,0,0,1376.24,110Zm96.04,31.714c-24.84-14.8-45.55-18-45.55-18s-11.55.66-.99,4.286,15.43,3.017,39.61,15.429,47.85,10.945,51.48,11.142,29.7-3.428,29.7-3.428S1498.2,157.163,1472.28,141.714Zm-25.75-50.571c17.83,10.928,61.39,23.143,61.39,23.143C1463.07,113.057,1446.53,91.143,1446.53,91.143ZM1315.84,69.6c-21.58-2.053-46.53,11.609-46.53,11.609,13.61-9.674,31.48-21.648,58.41-14.833s41.59,2.58,41.59,2.58C1357.38,75.607,1337.42,71.652,1315.84,69.6Zm-219.43,61.583c-13.01-4.866-5.31-9.576,4.23-3.406,0,0,8.05,5.857,25.7.166s8.6,4.21-4.09,6.115S1109.43,136.048,1096.41,131.182ZM742.574,4.571c-4.341-.239,0-1.714,0-1.714C812.738-3.81,876.238,30.286,876.238,30.286,789.851,0.714,746.915,4.81,742.574,4.571ZM548.64,89.807c8.662-6.757,1.855-1.236,1.855-1.236S549.836,89.013,548.64,89.807Zm-69.432,41.622C493.521,126.2,538.9,96.282,548.64,89.807c-3.187,2.487-8.467,6.634-16.957,13.336C500.125,128.053,479.208,131.429,479.208,131.429Zm-44.9-6.976s-3.263-4.569,5-3.489c5.647,0.738,2.32,2.907,17.13-1.163C456.436,119.8,445.463,129.079,434.31,124.453Zm17.175,20.69S388.917,174.323,327.723,140C327.723,140,378.205,160.073,451.485,145.143ZM61.1,85.547c39.46-24.821,148.394,9.973,148.394,9.973C94.374,70.106,65.087,83.249,61.1,85.547Zm0,0c-0.171.107-.343,0.213-0.511,0.322A5.473,5.473,0,0,1,61.1,85.547Z"/>
						</svg>';
				break;

			case '36':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 150">
							<path style="fill:'. $c1 .'" d="M1597.43,61.489a22.634,22.634,0,0,0,4.51-.453V150H-1.808V129.243a120.613,120.613,0,0,0,129.2-37.736,57.6,57.6,0,0,0,94.324-44.6,57.7,57.7,0,0,0-10.932-33.887A17.578,17.578,0,0,0,225.059.418a16.055,16.055,0,0,0,15.7,12.795,15.956,15.956,0,0,0,11.225-4.6,37.241,37.241,0,0,0,34.883,49.862,36.921,36.921,0,0,0,26.827-11.519A92.294,92.294,0,0,0,380.585,75.57a92.7,92.7,0,0,0,83.96-53.536A50.674,50.674,0,0,0,513.9,61.489,50.24,50.24,0,0,0,538.8,54.918a31.5,31.5,0,0,0,51.963,3.6,19.492,19.492,0,0,0,26.065-5.01,16,16,0,0,0,17.715,9.726A42.123,42.123,0,1,0,713.737,91.88a15.948,15.948,0,0,0,17.1,10.721,24.575,24.575,0,0,0,39.493,28.581,42.221,42.221,0,0,0,49-49.672c0.925,0.061,1.856.095,2.8,0.095a41.877,41.877,0,0,0,29.067-11.688,41.99,41.99,0,0,0,47.908-4.066,37.063,37.063,0,0,0,43.31,19.4c0,0.124,0,.248,0,0.373A60.1,60.1,0,0,0,1049.91,122.8a37.044,37.044,0,0,0,34.54-9.42,48.058,48.058,0,0,0,81.68-25.015c19.76,17.6,46.73,28.44,76.47,28.44,37.49,0,70.58-17.227,90.38-43.512a34.491,34.491,0,0,0,43.38-2.953,41.048,41.048,0,0,0,73.89,14.676A17.52,17.52,0,0,0,1466.86,89a17.516,17.516,0,0,0,30.13,9.136,33.548,33.548,0,0,0,54.76-23.857,22.52,22.52,0,0,0,39.1-13.765A22.505,22.505,0,0,0,1597.43,61.489Z"/>
						</svg>';
				break;

			case '37':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 170">
							<path style="fill:'. $c1 .'" d="M-10,153s39.5-2,26-75,4-66,4-66S41,3.5,37,63s10,61.5,40,60,23.5-57,20-73,15.5-52.5,17,1,7.5,66.5,30,79,35-14.5,26-41,20.24-67.468,18-5c-2.25,62.75,9.3,62.827,15,65,5.25,2,25.5,9.25,40-26,0,0,6.5-21.5,17,0s36.5,30.5,27-11,24.5-28,17,4,18,53.5,35,13c0,0,6-19.167,17,0s33,15.5,22-39,12-46.5,12-18-11,48.833-6,67,66.333,29.833,52-57,23.667-71.5,23-27-22.667,56.167,7,80c0,0,40,19.167,28-23s33.667-24.167,14,6,23.333,29.833,30,17,11,1,11,1,9,11.167,18-13c7.009-18.821,13.667-16.167,24,7s62.333,12.833,48-46,32.143-29.167,22-6-7.524,51.167,10,52,54.143,2.167,43-84c0,0-5.191-35.5,13-25s6.476,32.833,6,44-4.857,41.167,24,55,41.143-19.833,27-80c-5.476-62.5,39.476-43.5,29,9-6.809,51.167-6.191,55.833,19,67s24.476-17.833,22-37,16.143-15.833,16,5,2.809,30.833,21,32,35.143-12,23-79c0,0-4.024-20.387,9-19,12.524,1.333,8,18,8,18s-11.191,61.5,9,76c0,0,36.476,37.5,53,6a85.205,85.205,0,0,0-5-39c-7.809-20.833,29.33-53.333,26-13s-11.52,49.833,12,69,39.48-8.5,42-18,11.81-18.5,20,1,36.18,45.562,34-5c0,0-6.82-37.438,12-33s1.84,30.9,4,49,8.51,43.229,30,5,34-2,34-2,28.18,32.229,17-57c0,0-12.54-30.421,6-31,17.99-.562,10.18,30.9,8,40s-25.82,101.562,30,67,10.84-80.1,21-116,38.51-24.1,28,16-20.82,89.229,20,87,18.51-25.771,22-37,24.18-12.1,14,20,44.18,30.562,61,12,8.18-39.1,33-4,63.84-5.1,60-39c0,0-9.16-41.1,9-42s17.84,12.229,12,43,2.51,49.9,31,39,28-28,28-28v68H-10V153Z"/>
						</svg>';
				break;

			case '38':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 44">
							<path style="fill:'. $c1 .'" d="M-1,4S3.5,31,161,23s206.5,2,244,9c39.167,9,157.863,2.5,222-5s235.9-12.534,318,3.5,155.3,1.371,181-2,94.8-9.129,173-1.5,121.3,2.371,165-10,82.8-26.129,143-8V44H-1V4Z"/>
						</svg>';
				break;

			case '39':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 277">
							<path style="fill:'. $c2 .'"  d="M-25.5,126S94.62,114.528,240,207s340-54,340-54,166.442-192.959,501-18,347-41,347-41,28.57-74.371,218-94V281H-24Z"/>
							<path style="fill:'. $c1 .'" d="M-13.5,235S80.185,227.711,223,135c145.885-94.7,316.864-34.83,476.666,15.921C872.568,205.831,1040.29,117.25,1137,60c132.8-78.609,295.57-81.607,488,25V280H-18Z"/>
						</svg>';
				break;

			case '40':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 167">
							<path style="fill:'. $c3 .'" d="M-13,77S157.89-29.71,271,56,537.89,200.29,800,79s386.89-66.71,469-23,116.89-6.71,156-19,128.89-28.71,214,60v78H-12Z"/>
							<path style="fill:'. $c2 .'" d="M-15,104S173.254,205,344,86c0,0,73.254-61.146,201-2s246.254,99,471-9c0,0,122.25-71.146,184-20s77.25-5.146,145-17,119.25-15.146,276,73v57H-15V104Z"/>
							<path style="fill:'. $c1 .'" d="M-12,173S25,66,210,82s141,70,395,57,235.841-118.128,451-33c230,91,233,37,347,0s141-29,223,56l-1,9Z"/>
						</svg>';
				break;

			case '41':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1920 328">
							<path style="fill:'. $c1 .'" d="M1919.76 132.428c-90.511-64.67-174.365-144.792-314.866-123.125-94.441 14.563-142.181 105.921-220.98 148.217-117.85 63.256-155.979 35.449-264.385 14.607-84.57-16.26-117.255-29.063-199.787-.493-84.986 29.419-134.191 125.289-239.288 124.882-121.481-.472-157.447-90.325-248.953-163.594C317.535 41.67 228.822 15.373 79.5 1.958 51.97-.516 25.538-.52 0 1.242v326.661h1919.76V132.428z"/>
						</svg>';
				break;

			case '42':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1920 244">
							<path style="fill:'. $c1 .'" d="M1919.76 127.978a331.007 331.007 0 0 0-31.066-.963c-62.193.963-126.36 51.008-160.414 52.745-78.779 4.019-63.569-54.651-153.579-113.069-260.967-169.372-388.922 75.719-626.606 127.677C700.476 248.496 629.768-34.919 379.894 3.615c-94.441 14.563-142.181 105.921-220.98 148.217C87.956 189.919 45.897 194.986 0 188.445v54.77h1919.76V127.978z"/>
						</svg>';
				break;

			case '43':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 167">
							<path style="fill:'. $c3 .'" d="M-12.5,2S415.824-17.043,765,147.5c0,0,31.251,18.167,71,0C882.749,133,1179.15-17.745,1638,2V172H-11Z"/>
							<path style="fill:'. $c2 .'" d="M-12.5,32S429.824,20.957,765,147.5c0,0,31.251,18.167,71,0C882.749,133,1179.15,12.255,1638,32V172H-11Z"/>
							<path style="fill:'. $c1 .'" d="M-12.5,64S476.824,49.457,765,148c0,0,31.251,18.167,71,0,46.749-14.5,343.15-103.745,802-84V174H-11Z"/>
						</svg>';
				break;

			case '44':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 100">
							<path style="fill:'. $c1 .'" d="M728,18v3c9.867,0.242,20.534.766,28,0,2.3-.237,8.558,2.892,12,1,0,0,2.76-3.554,3-4h-3c0.828-3.245-.49-1.528,2-3,1.073,0.752.946,0.6,3,1v4h1v1c9.7,0.493,23.078,1.539,30,0l11,1c1.827-.913,1.178-2.883,4-4,4.024,3.117,15.568,4.1,23,4V20c-1.624-1.35-1.121-.64-2-3h1V16h1c0.739,3.955.094,3.212,4,4,0.087-.1,1.313-2.886,2-2v1c3.4,1.866,5.6,5.48,9,7,9.366,4.193,19.371-1.294,26-3,0.66-.17,2.97,1.715,5,2V21c2.338,0.279,9.635-.411,14,1-1.133,1.546-1.085.843-2,3h2c3.568,2.192,9.316.406,15,0V24a6.107,6.107,0,0,1-2-2h7c5.26,4.154,13.806.469,21,0,0.387-2.53-.581-1.578,3-2,3.307,1.819,7.655-1.454,13,0,14.406,3.918,32.795-2.457,49,0,5.32,0.807,15.79,2.563,24,2,3.13-.214,6.75-1.777,11-1,3.27,0.6,11.19,2.185,16,1,2.78-.684,5.38-3.133,7-4,2.1-1.123,4,.991,5,1,0,0,4.82-.916,5-1V16l14,1c1.12-.343.58-1.789,3-2,1.72-.15,10.17,2.029,13,0v2c1.29,0.548,11.74-2.385,13-2,0.33,1,.67,2,1,3,2.45,1.275,9.71-2.853,14-2,0.61,0.122,6.36.35,8,1,0.67,1,1.33,2,2,3,2.9,0.862,2.94-3.552,7-2,0.59,0.224,5.46,2.757,7,3,4.32,0.684,14.32-4.136,18-5,0.89-1.1,1,1,1,1,3.03,2.83,4.95-.019,8,1,0.33,1,.67,2,1,3,2.42,1.165,8.08-3.73,12-4,1.87,5.56,4,8.189,12,8a41.751,41.751,0,0,0,6,2h3l2-2h28V23h-13c-1.02-.8-0.27-0.355-2-1-0.33-.667-0.67-1.333-1-2h3c0.12,0.088,1.98,1.994,2,2,2.31,0.691,2.59-2.589,4-3,4.85-1.41,12.01,2.473,17,1,0.83,3.245-.49,1.528,2,3,6.92-6.858,14.45,4.146,19,6,3.47,1.411,15.52,1.106,18,1,0.52-.022,9.1,1.344,12,0,1.9-.881,3.7-3.883,8-3,2.81,0.577,5.31,3.224,7,4,5.81,2.667,9.31-1.921,15,0,1.11,0.375,1.83,2.8,3,3,1.39,0.235-.4-0.811,1-1,3.54-.477,15.77,3.761,18,0,0.98,1.06.9,4.2,2,5l3-1c7.98,3.264,28.79,10.7,38,9V44c-0.88-1.295-.89-2.467-1-5,11.5,0.411,36.76,5.877,45,1,2.84-.967.88-1.745,7-2,6.84,4.413,37.88,3.4,50,3,1.18,2.651-.9,1.794,2,3,6.7,5.129,35.86,4.051,46,6v1h-7c-1.02-.8-0.27-0.355-2-1v2c22.29,2.147,39.82,2.646,55,9v3H0V39a114.663,114.663,0,0,0,30-4l9,1a115.56,115.56,0,0,0,18-3l13,1c16.78-3.016,30.253-2.1,44-5-0.01,3.166-1.423,1.869,2,3,4.515-3.9,30.062-3.889,42-4,0.906-2.424,1.069-1.59,2-4h-2c-3.226-1.945-5.256.553-8,2-0.075-3.042-.756-2.744,0-4,1.073-.752.946-0.6,3-1,5.794,3.215,9.6-2.669,13,3-3.764.142-3.515-.471-5,2h1c0.74,0.872,1.26,1.128,2,2,4.157-1.125,13.193-2.37,18-1,1.116,0.318.925,2.9,4,2V27l6,1c2.667-.5,6.414-3.493,8-4l5,1c11.156-1.029,16.226.229,26,4,5.647,2.178,11.92-2.14,15-2,15.182,0.692,34.428.456,44,3,0.846-.309,3.153-2.757,4-3,2.412-.691,10.51,1.98,14,1l1-2h12c1.321-.739,1.626-3.157,6-4,3.431-.661,5.537,1.456,8,2,4.261,0.941,20.7-1.093,25-2,4.7-.992,8.07,1.1,10,2,2.293,1.07,18.147-3.892,19-5,1.624,1.856,8.764,5.882,14,5,1.926-.324,7.2-3.147,10-2,1.761,0.722,3.8,4.064,8,3,2.2-.558,5.218-3.315,8-4l12,1c19.763-3.527,40.9,2.694,60-2l17,1c2.857-.646,7.1-2.164,10-3,1.887-.543,7.284,2.832,8,3,0.885,0.207,9.949-2.985,10-3l16,1c0.838-.3,1.569-2.744,2-3,4.606-2.733,18.975-1.941,25-2v4c10.193,0.971,22.188,3.447,28-1,0.682-.771,1.311-2.232,2-3,3.223,2.392,9.383,3.661,11,3,3.864-.7,5.542-2.939,15-3v3c6.4-.114,15.856-1.357,21,0v1h-1a11.576,11.576,0,0,1-3,2v1h9c2.975,2.111,5.677.79,7-2,0.707-1.545.129-.135,0-3h3c7.306,4.479,20.485-6.062,27-2,5.111,1.785,5.238,4.7,9,6,1.69,1.142,4.9,1.066,8,1C725.117,17.259,723.794,18.558,728,18Zm265-5h2v1C993.246,13.369,994.029,13.807,993,13ZM766,14h2v1C766.246,14.369,767.029,14.807,766,14Zm19,0c2.532,0.074,3.716.12,5,1C787.468,14.926,786.284,14.88,785,14ZM205,16c5.976-.2,14.308-0.518,18,2C216.307,18.2,204.088,18.434,205,16Zm194,0a12.667,12.667,0,0,1,4,1c-1.021.8-.274,0.355-2,1C399.125,20.118,399.13,16.823,399,16Zm98,0c0.752,1.073.6,0.946,1,3h-1V16Zm302,0h7c0.961,1.766,1.257,1.68,2,4h-6c-2.345-1.476-9.227-.515-10-1h-1V18C793.689,17.779,797.248,17.269,799,16Zm47,0h2v1C846.246,16.369,847.029,16.807,846,16ZM335,17l2,2C334.318,19.9,333.661,18.386,335,17Zm11,0h2v1C346.246,17.369,347.029,17.807,346,17Zm374,0c2.076,0.372,1.924.242,3,1C720.924,17.628,721.076,17.758,720,17Zm8,0c3.28-.117,7.184-0.236,9,1C733.72,18.117,729.816,18.236,728,17Zm475,0c4.17-.072,6.83.228,9,2h-2c-1.18.8-1.68,0.773-4,1C1205.01,18.64,1204.07,18.194,1203,17Zm16,0c2.08,0.372,1.92.242,3,1h-2C1219.36,17.719,1219.54,18.308,1219,17ZM809,18c2.076,0.372,1.924.242,3,1C809.924,18.628,810.076,18.758,809,18Zm413,0h2v1C1222.25,18.369,1223.03,18.807,1222,18Zm5,0a10.962,10.962,0,0,1,5,2C1228.24,19.858,1228.48,20.472,1227,18ZM256,20h2v2h-1Zm610,0c6.226,0.1,7.088.179,13,0v2h-2c-0.919.325-9.181,0.472-12,1ZM303,21c6.289-.219,11.551.337,15,3C311.428,24.3,305.8,24.514,303,21Zm553,0h2v1C856.246,21.369,857.029,21.807,856,21ZM279,22h2v1C279.246,22.369,280.029,22.807,279,22Zm6,0h2v1C285.246,22.369,286.029,22.807,285,22ZM1371,32l4,1v1h-1C1371.63,36.718,1371.06,32.962,1371,32Zm-4,1c0.8,1.021.35,0.274,1,2h-1V33Zm29,0,10,1v1h-2c-2.71,1.741-6.21,1-10,1V34C1395.75,33.369,1394.97,33.807,1396,33Zm12,0c0.35,0.3,2,.523,1,2C1407.89,34.512,1405.89,33.224,1408,33Zm-9,6h2v1C1399.25,39.369,1400.03,39.807,1399,39Z"/>
							<rect style="fill:'. $c1 .'" x="-68" y="61" width="1731" height="187"/>
						</svg>';
				break;

			case '45':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 244">
							<path style="fill:'. $c1 .'" d="M0,248V186H26.966V166.5a15.481,15.481,0,1,1,30.962,0V186h90.887V129.5a15.481,15.481,0,1,1,30.961,0V186H331.587V161.5a15.481,15.481,0,1,1,30.962,0V186h89.888V141.5a15.481,15.481,0,1,1,30.961,0V186h29.963V160.5a15.481,15.481,0,1,1,30.961,0V186h29.963V124.5a15.481,15.481,0,1,1,30.961,0V186h27.965v-7.5a15.481,15.481,0,1,1,30.962,0V186H755.06V141.5a15.481,15.481,0,1,1,30.961,0V186h28.964V45.5a15.481,15.481,0,1,1,30.962,0V186h30.961V154.5a15.481,15.481,0,1,1,30.961,0V186h88.89v-5.5a15.481,15.481,0,1,1,30.961,0V186h29.96V114.5a15.48,15.48,0,1,1,30.96,0V186h29.97V170.5a15.48,15.48,0,1,1,30.96,0V186h91.88V166.5a15.485,15.485,0,1,1,30.97,0V186h87.89V173.5a15.48,15.48,0,1,1,30.96,0V186h90.88V144.5a15.485,15.485,0,1,1,30.97,0V186h31.62a15.477,15.477,0,0,1,29.63,0H1606v62H0Zm1559.56-86a15.49,15.49,0,0,1-15.48-15.5v-13a15.48,15.48,0,1,1,30.96,0v13A15.49,15.49,0,0,1,1559.56,162Zm-62.92-49a15.49,15.49,0,0,1-15.48-15.5v-67a15.48,15.48,0,1,1,30.96,0v67A15.49,15.49,0,0,1,1496.64,113Zm-59.93,56a15.49,15.49,0,0,1-15.48-15.5v-38a15.48,15.48,0,1,1,30.96,0v38A15.49,15.49,0,0,1,1436.71,169Zm-118.85,5a15.49,15.49,0,0,1-15.48-15.5v-13a15.48,15.48,0,1,1,30.96,0v13A15.49,15.49,0,0,1,1317.86,174Zm-60.93-42a15.49,15.49,0,0,1-15.48-15.5v-65a15.485,15.485,0,1,1,30.97,0v65A15.5,15.5,0,0,1,1256.93,132Zm-61.92,46a15.49,15.49,0,0,1-15.48-15.5v-34a15.48,15.48,0,1,1,30.96,0v34A15.49,15.49,0,0,1,1195.01,178Zm-60.92-40a15.49,15.49,0,0,1-15.48-15.5v-48a15.48,15.48,0,1,1,30.96,0v48A15.49,15.49,0,0,1,1134.09,138Zm-121.85,15a15.491,15.491,0,0,1-15.481-15.5v-13a15.481,15.481,0,1,1,30.961,0v13A15.49,15.49,0,0,1,1012.24,153Zm-60.925-47A15.491,15.491,0,0,1,966.8,121.5v41a15.481,15.481,0,1,1-30.961,0v-41A15.491,15.491,0,0,1,951.315,106Zm1-16A15.5,15.5,0,1,1,967.8,74.5,15.49,15.49,0,0,1,952.314,90Zm-242.7,88a15.491,15.491,0,0,1-15.48-15.5v-54a15.481,15.481,0,1,1,30.961,0v54A15.491,15.491,0,0,1,709.616,178Zm-60.924-31a15.491,15.491,0,0,1-15.481-15.5v-83a15.481,15.481,0,1,1,30.962,0v83A15.491,15.491,0,0,1,648.692,147ZM527.843,129a15.491,15.491,0,0,1-15.481-15.5v-13a15.481,15.481,0,1,1,30.961,0v13A15.491,15.491,0,0,1,527.843,129Zm-59.926-16a15.491,15.491,0,0,1-15.48-15.5v-13a15.481,15.481,0,1,1,30.961,0v13A15.491,15.491,0,0,1,467.917,113Zm-61.923,61.5a15.491,15.491,0,0,1-15.48-15.5V16a15.481,15.481,0,1,1,30.961,0V159A15.491,15.491,0,0,1,405.994,174.5ZM346.069,131a15.491,15.491,0,0,1-15.481-15.5v-13a15.481,15.481,0,1,1,30.962,0v13A15.491,15.491,0,0,1,346.069,131Zm-60.924,42a15.491,15.491,0,0,1-15.481-15.5v-97a15.481,15.481,0,1,1,30.962,0v97A15.491,15.491,0,0,1,285.145,173Zm-59.925,8a15.5,15.5,0,1,1,15.48-15.5A15.491,15.491,0,0,1,225.22,181Zm-120.85-6a15.491,15.491,0,0,1-15.481-15.5v-61a15.481,15.481,0,1,1,30.962,0v61A15.491,15.491,0,0,1,104.37,175ZM43.446,133a15.5,15.5,0,1,1,15.481-15.5A15.491,15.491,0,0,1,43.446,133Z"/>
						</svg>';
				break;

			case '46':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 160">
							<path style="fill:'. $c1 .'" d="M385,0h2V1C384.99,0.426,386.135,1.12,385,0Zm94,2h3V3h-3V2ZM417,5l3,1c-0.844,1.135.127,0.145-1,1-1.139,1.139,0,.4-2,1V5Zm5,1c1.719,1.127,1.355.633,2,3h-1V8C421.861,6.861,422.6,8,422,6Zm24,2c1.719,1.127,1.355.633,2,3h-1V10C445.861,8.861,446.6,10,446,8Zm336,2v2l-4,1V11Zm489,8h-2c-0.33-2.333-.67-4.667-1-7h1v1h1C1270.33,14,1270.67,16,1271,18Zm-265,3h2v1C1005.99,21.426,1007.13,22.12,1006,21ZM476,23c9.871-.079,21.718-0.525,30,1v1H474V24C476.01,23.426,474.865,24.12,476,23Zm-85,1c10.6-.093,34.129-1.907,42,1v1H416V25c-2.1-1.147-4.1,1.2-5,1-6.458-1.463-12.363-.168-20,0V24Zm47,0h4v1h-4V24Zm94,0c4.623-.12,15.364-1.386,18,1l-19,1Zm54,0v2h-4V25h2C585.139,23.861,584,24.6,586,24ZM366,25c3.579-.058,6.3.228,8,2-4.354.528-6.895,1.424-11,0h-4V26h7V25Zm245,0h3v1h-3V25ZM313,26c4.543-.106,18.815-0.968,21,1C328.526,27.427,312.618,32.4,313,26Zm401,0h3v1h-3V26Zm194,0v2h-3V27h1C907.139,25.861,906,26.6,908,26Zm12,0h3v1h-1c-1.139,1.139,0,.4-2,1V26Zm15,0h4v1h-4V26Zm14,0h4v1h-3v1C949.1,29.87,949,26,949,26Zm16,0h7v1h-7V26Zm14,0h3v1h-1c-0.583.494-1.147,1.733-3,1Zm15,2h-3V27h2V26C993.95,24.157,994,28,994,28ZM731,27h3v1h-1c-0.583.494-1.147,1.733-3,1Zm120,0h24c3.182,0,7.312-.5,9,1l-53,2c-4.61,0-17.662,1.038-20-1h6V28h23C843.525,28,849.077,28.711,851,27Zm46,0h3v1h-3V27ZM741,28h4v1h-4V28Zm13,0h3v1h-3V28Zm309,0h6v1h-6V28ZM773,29h6v1h-6V29Zm18,0h3v1h-3V29Zm9,2h-2V30h1V29C800.139,30.139,799.4,29,800,31Zm4-2h3v1h-3V29Zm326,0h2v1C1129.99,29.426,1131.13,30.12,1130,29Zm114,0,3,1v1h-3V29Zm-40,1c0.67,0.333,1.33.667,2,1v1h-4V31C1204.01,30.426,1202.87,31.12,1204,30Zm48,0c4.45-.12,14.48-1.282,17,1C1263.48,31.18,1254.74,33.889,1252,30Zm23,1h4v1h-4V31ZM134,40c2.217-7.891,25.9-8,37-8,4.034,0,11.732-1.029,14,1a52.323,52.323,0,0,0-14,2h-8v1h-8v1h-8C143.34,38.074,138,39.216,134,40Zm1174-8v2c-2.55.55-6.74,2.076-9,0h2V33Zm-41,1h3v1h-3V33Zm45,1h4v1h-3v1C1312.1,37.87,1312,34,1312,34Zm89,2h-2c0.84-1.135-.13-0.145,1-1V34C1401.14,35.139,1400.4,34,1401,36Zm51-2h2c-0.84,1.135.13,0.145-1,1-1.77,1.984-1.95.845-4,2v1h-2c-0.33.667-.67,1.333-1,2h-2v1h-2l-3,4-7,1v1c-3.13,1.606-5.32,3.174-9,4V50h1c1.65-2.394.75-.627,3-2V47h2c0.33-.667.67-1.333,1-2l4-1V43h2V42h2V41h2V40h2V39h2V38C1446.94,36.424,1449.96,36.375,1452,34ZM429,35h2v1C428.99,35.426,430.135,36.12,429,35Zm490,0,3,1v3h-2Q919.5,37,919,35Zm417,0h2v1h-2V35Zm135,1h4v1h-4V36ZM359,39h-3V38h2V37C358.95,35.157,359,39,359,39Zm1108,0h3v1h-2v1C1467.05,42.843,1467,39,1467,39ZM241,40h6v1h-6V40Zm370,0h3v1h-3V40ZM212,41v2h-3V42h1C211.139,40.861,210,41.6,212,41Zm276,3c31.18,2.785,67.116,1,100,1h41c9.481,2.655,24.722.995,36,1h10c10.326,2.892,26.839,1,39,1h13c8.913,2.5,23.315,1,34,1h68V47h6l64-2c8.2,0,22.138-1.282,27,0h13v1h9v1c4.185,1.176,10.245-1.392,13,1a34.228,34.228,0,0,0-8,1v3l3-1V50h2V49c2.1-.735,13.044,2.3,15,3v1l24-1V51h7V50l13,1v1h2v1h6c-0.4-4.264-2.07-4.521-3-8a20.39,20.39,0,0,1,9,5c0.33,0.667.67,1.333,1,2l6,1v1l67,1v1h-2c-2.77,2.387-8.81-.186-13,1-8.05,2.279-21.21,1-31,1h-10c-7.74,2.2-18.94-.324-27-1l-80-1H915l-9-1v1l-41,1c-6.547,0-13.91-1.13-15,2h3v1H843V59h-1v1H827c-8.913-2.5-23.315-1-34-1H675V58H605c-10.946-3.06-30.933-1-44-1-31.163,0-64.455.281-94,1,0.113,3.16,1.955,1.874-1,3V59l-5-1V57H449v1H418v1H395c-4.861,1.378-13.523-.553-19,1-4.848,1.375-13.549-.561-19,1v1h-7v1h-2v1c-1.695.393-1.75-.946-2-1H322v1H306v1H293v1H278c-12.151,3.456-29,1.569-41,5h-8v1c-2.311.706-3.975,0.23-6,1v1h20c3.634,3.221,22.909.032,28,0l50-2V71h9V70h7V69h4V68c3.355-1.421,3.752-.487,7,0-1.139,1.139,0,.4-2,1-3.041,2.9-6.425.5-9,2v1c9.79,0.022,22.944,1.255,31-1h27V70h14l34-1V68l38,1c5.526-1.547,14.856-1,22-1,12.462,0,29.385-1.963,40,1l91-1V66c-7.44,0-17.19.623-23-1l-40,1-1-3c2.652-1,6.944-1.041,11-1,1.292-1.136,18.731-1.925,22-1,6.081,1.72,16.273,1,24,1l33,1h20v1h24v1h16v1h12v1h14v1h14c7.48,2.1,36.51,2.082,44,0l15,1V68h52l34-1c3.245,0.541,11.3,2.419,16,1V67h4l1-2c3.309-1.089,3.165,1.659,4,2l11,1,31,1V68h16v2c13.3,2.411,29.13.053,43,0-0.33.667-.67,1.333-1,2h6c1.34,1.2,8.5,1,14,1h35l100,2v1h12l20,1,39,1c4.25,0,12.56,1.114,15-1-3.01-.3-2.72-0.135-4-2h9c2.2,1.99,8.17.668,12,1,1.87,0.162,2,1,2,1,7.13,1.961,15.75-.975,21-2-0.93,3.45-1.3,1.867-3,4h38c2.4,2.108,8.06.343,12,1,5.79,0.966,14.66,1,22,1,28.95,0,61.44,3.469,85-4h5c7.31-2.269,16.74-3.865,24-6h7V70h2v1h2v1c-8.12.016-12.61,3.52-19,5v2c15.3,0.24,29.51-.427,41-4l9-1V73h2V72h3V71l14,1V71l29-5c-0.56,2.448-1.04,2.21-2,4h1c1.69,1.416,5.23.169,9,0,1.09,2.078,1.61,1.771,2,5-2.5,2.247-.96,3.836-5,5-2.24,1.976-5.85.869-9,2-2.79,1-4.92,3.207-8,4-0.33,1.333-.67,2.667-1,4h14c0.33,0.667.67,1.333,1,2l14-1v4h-1v1h-4v1h5v98H0V97H20V96H19V93H18c-1.522,1.4-7.932,1.985-11,2V93l23-3V89l7-1V87h3V86l6-1V84l8-1,8-4V78H57c-2.959,2.543-8.615.7-13,2v1H39v1H33v1H27v1H23v1H17c-4.856,1.508-8.055,2.892-15,3V87H3c1.32-2.006,3.228-2.489,6-3a34.62,34.62,0,0,0,1-7l56-9c5.07-1.266,10.259,3.929,17,2,7.582-2.17,17.54-2.843,25-5h9V64h8V63h11V62h14V61l18-1h10V59h13V58l31-1V56l18-1h10V54h14V53h16V52h16V51h15V50c6.057-1.706,15.555.533,21-1h39V48h33V47h25V46c6.042-1.7,16.1.661,22-1h32V44h2V43l3-2v3Zm504-3v6c-3.041-.724-4.668-2.646-6-5h2V41h4Zm466,0h3v1h-1c-2.56,2.556-12.28,4.034-18,4V45h1c1.96-2.094,7.39-2.692,11-3h4V41ZM0,71V65H1c3.106,3.5,5.452,1.1,9,0h6V64l16-2a99.163,99.163,0,0,1,26-4V56l19-4,23-2V49h6V48h6V47h6V46h4V45h3V44l23,1h5V44h21c3.384,0,8.154-.576,10,1l-25,1v1H147v1H136v1H124v1h-9v1L77,54v1H73v1H71v1H68v1H63c-6.128,1.927-14.8,3.127-21,5L26,65v1l-9,1v1H11C7.758,69.016,4.165,70.544,0,71ZM1575,49v2a39,39,0,0,0-12,2h-9v1h-9v1h-8v1h-10v1h-8v1h-9v1h-10v1h-6v1h-7v1l-12,3v1h14c3.36-3.038,6.8.665,10,0V65h3v1h-1c-1.54,1.732-11.62,5.216-16,4-13.71-3.811-34.21-1.863-51-2v1h1c3.64,4.073,13.57,5.582,19,8v1h-5V77l-7-1V75h-3V74h-2V73a8.334,8.334,0,0,0-4-2V69c-2.19-.355-6.21-1.485-8-2h-13V66c-6.07-1.72-15.54.571-21-1h-8V64h2c2.44-2.111,17.15-1,22-1l52,2V64h3a9.409,9.409,0,0,1,2-2V61h-9c-4.11-3.538-23.93.474-31-1-3.24-.676-13.51-1-21-1h-11V58h-14v1h-4v1l-6-1V58l-4,1V58h-4V57h-1c-0.33.667-.67,1.333-1,2h-3v2c2.61-.039,19.01,1.1,20,2h-7v1h-37c-6.55,0-15.04.391-20-1h-31V62h-33V61h-37V60h-15l-19-2c-0.33-.667-0.67-1.333-1-2,2.65-1,6.94-1.041,11-1v1c2.04,1.08,9.26-2.123,13-2,4.34,0.143,9.48,1.984,13,3h10v1h35c9.14,2.547,23.13.51,34,1,13.01,0.587,32.01,2.326,45,0V57c-5.86,2.3-10.23.1-15-1-0.33-1-.67-2-1-3l10,1v2l12-2v1h4v1h7V55h14v1c2.35,0.62,2.62-.858,4-1,0.33,0.667.67,1.333,1,2l5-1V55l16-1v1h7v1h18c4.97,1.379,13.44,1,20,1h19V56h10l20-1V54h12V53h12s0.08-.834,2-1h11V51h12V50h16C1557.82,48.363,1567.55,49.031,1575,49Zm-92,1h5v1h-5V50Zm13,0h3v1h-2c-0.49.427-1.25,1.853-3,1V51C1496.01,50.426,1494.87,51.12,1496,50Zm-207,2h3v1h-3V52Zm-145,5c0.83-3.2,1.18-2.9,5-3v1h-1v1A10.6,10.6,0,0,1,1144,57ZM875,61h2v2h-2V61Zm6,4,1-3s-2.171-.207-1-1h13v1c3.942,2.175,13.5-2.044,17,1C902.722,63.678,889.082,63.506,881,65ZM358,67c-0.88,3.4-1.861,3.065-6,3V68Zm7,2h-2c0.844-1.135-.127-0.145,1-1V67C365.139,68.139,364.4,67,365,69Zm691-2c6.39-.1,15.25-0.777,20,1v1C1070.18,69.166,1058.48,70.524,1056,67Zm26,1h6v1h-6V68Zm15,2h-2c0.84-1.135-.13-0.145,1-1V68C1097.14,69.139,1096.4,68,1097,70Zm189,3V71c5.3-1.007,6.9-1.855,12-1-0.84,1.135.13,0.145-1,1C1295.25,72.643,1289.61,73.03,1286,73Z"/>
						</svg>';
				break;

			case '47':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 160">
							<path style="fill:'. $c1 .'" d="M736,18h3v1h-3V18Zm14,0h2v1C749.99,18.426,751.135,19.12,750,18Zm33,0,4,1v1C783.991,19.7,784.277,19.865,783,18Zm8,1h3v1h-3V19Zm11,0,4,1v1C802.991,20.7,803.277,20.865,802,19Zm9,1h6v1h-6V20Zm16,0h3v1h-3V20Zm8,0a9.746,9.746,0,0,1,4,1v1C835.991,21.7,836.277,21.865,835,20Zm-40,3H777V22h1c2.325-2.219,8.846-.015,13,0a20,20,0,0,0,4-1v2Zm55-2h4v1h-4V21Zm491,0h2v1C1340.99,21.426,1342.13,22.12,1341,21Zm7,0h4v1h-4V21Zm13,0c3.8-.08,7.58.081,10,1v1h-3V22c-1.9-1.037-4.16.684-5,1,0.33,1,.67,2,1,3h-1V25C1361.64,23.835,1361.47,23.176,1361,21Zm32,2v2h4v2h-5V26h-2V25l-4,1v1l-8-1V23h-3V22h-1V21h11v1c3.27,1.8,8.5-1.181,11,1h-3ZM831,23v2l-24-1-1-2h5C813.153,23.948,826.559,23.09,831,23Zm51-1h3v1h-3V22Zm447,0h2c-0.84,1.135.13,0.145-1,1-0.61.608-10.3,2.075-12,1V23C1321.43,23.117,1327.18,23.669,1329,22Zm8,4h-2c0.33-1,.67-2,1-3h-1c-1.47-1.21,3.62-.985,4-1v1C1337.28,24.127,1337.64,23.633,1337,26Zm6-4h3v1h-3V22Zm56,0,9,1v1c1.85,1.346,1.94,1.565,5,2V23h7c0.33,0.667.67,1.333,1,2,1.25,0.53,4.07.339,4-1h1v2h5V24h4c1.24,3.326-.83,2.959,5,3V26c0.95-1.843,1,2,1,2-6.84.132-11.6,1.171-18,0V26l-3,1v1c-2.56.869-4.69-.81-6-1h-5v1l-10-1V22Zm134,1c-0.33,1.666-.67,3.334-1,5-1.59.078-1.68-.544-2,1-1.22-.614-1.4-1.834-2-3a9.492,9.492,0,0,0-2,2c-1.93,1-5.96.827-8,0V27h-2V26l-17,1V25h-6c-1.63.494-4.6,3.383-8,2-0.33-.667-0.67-1.333-1-2-0.67.333-1.33,0.667-2,1V25h-1V24c6.78-2.508,19.42-1.052,28-1,1.43-1.313,7.98-1.7,11-1v1c1.67,0.279,1.75-.945,2-1C1525.98,21.128,1530.27,22.456,1533,23Zm67,5-10,2c-0.5-.232-0.3-1.77-2-2-0.46.217-.36,1.7-2,2-0.33-.667-0.67-1.333-1-2h-2V27l-3-1v2h-2v1h-9v1h-5v1h-1V30h-2V29h-5V28c-1.14-1.139-.4,0-1-2,1.14-1.139.4,0,1-2l-3,1v3c-2.21-.106-3.35-1.02-4-1v1h-6v1c-3,.811-4.88-0.621-7-1V27a3.991,3.991,0,0,0,2-2c-2.39-.607-1.86-0.317-3-2,2.32-.875,4.41-1.017,8-1v1c2.18,1.228,5.1-1.133,6-1v1h32v1h13a2.49,2.49,0,0,0,3,1V24l3-1v5ZM854,25h-2V24h1V23C854.139,24.139,853.4,23,854,25Zm45-2v2c-1.135-.844-0.145.127-1-1-1.135-.844-0.145.127-1-1h2Zm561,0,3,1a9.655,9.655,0,0,0,1,4h-4V26h-1C1459.33,25,1459.67,24,1460,23Zm6,2V23h1v1h1C1466.86,25.139,1468,24.4,1466,25Zm7-2h7v1h-7V23ZM840,24h3v1h-2v1C840.05,27.843,840,24,840,24Zm19,0h4v1h-4V24Zm17,0,7,1v1c3.3,1.054,7.626.1,10,1v1h-8V27c-4.273-2.34-10.819,2.621-15-2h6V24Zm424,0a9.773,9.773,0,0,1,4,1v1h-2C1301.23,24.984,1300.77,25.016,1300,24Zm10,4-6,1V27c5.43-.235,3.23-0.775,6-3v4Zm31-4v2h-3V25h1C1340.14,23.861,1339,24.6,1341,24Zm14,0h2v1h-2V24Zm84,0h5v1h-5V24Zm31,0h2v1C1469.99,24.426,1471.13,25.12,1470,24ZM922,25h2v1C921.99,25.426,923.135,26.12,922,25Zm374,2v2l-8-1v1h-4V28c2.01-.574.87,0.12,2-1-2.01-.574-0.87.12-2-1l9-1c0.33,0.667.67,1.333,1,2h2Zm2-2h2c-0.33,1-.67,2-1,3h-1V25Zm19,0v2h-3V26h1C1316.14,24.861,1315,25.6,1317,25Zm14,0h2v1C1330.99,25.426,1332.13,26.12,1331,25Zm122,0v2a9.773,9.773,0,0,0-4,1c-0.33-1-.67-2-1-3h5Zm-203,2v2h4v1a40.117,40.117,0,0,0-9,1V26h1v1h4Zm8-1,10,1V26h4v1h1V26h8c-0.33,1.333-.67,2.667-1,4h-7v1l-12-1V28l-3,1V26Zm207,0h2v1C1464.99,26.426,1466.13,27.12,1465,26Zm6,0h3v1h-3V26Zm8,0h3v1h-3V26ZM898,27h8v1h-8V27Zm324,2c-2.39-.607-1.86-0.317-3-2h14v1l4-1v1h1c-0.57,2.01.12,0.865-1,2-3.15,3.7-10.91,3.018-16,2V31C1222.14,29.861,1221.4,31,1222,29Zm221-2h2v1h-2V27ZM926,28l3,1v1h-5V29C926.01,28.426,924.865,29.12,926,28Zm289,2V28h1v1h1C1215.86,30.139,1217,29.4,1215,30ZM647,29v2l-5-1V29h5Zm1,0h4v1h-4V29Zm539,0h4v1h-3v1C1187.1,32.87,1187,29,1187,29ZM893,37c-0.64,2.743-1.9,3.69-3,6-1.139-1.139-.4,0-1-2h-4v1c1.139,1.139.4,0,1,2-1.774-.27-2-1-2-1l-3,1c-1.293-.574.352-0.586-1-1l1-3h-2V39l-3,1a12.709,12.709,0,0,1,1,5l-6-1V43a3.983,3.983,0,0,0,2-2c-2.316-.875-4.407-1.017-8-1V37H852c-0.978.387,0.079,2.319-3,2V38H831V37h-4V36h-1v1l-3,1V36l-11,1v1a9.584,9.584,0,0,1-4,2V38l-5-1V35l-5,1v1h-1V36h-9v1l-6-1h-1v1l-14-1-27,1-1-2c-2.794-1.139-7.282.392-9,1v1c-1.685.376-1.761-.949-2-1H703l-1,2a1.509,1.509,0,0,1-2-1h-1v1a5.025,5.025,0,0,1-5-2h2c3.4-3.64,1.826.109,6-1V34h2V31l35,1h14l1-2c1.679-.481,1.789.957,2,1h7v1h27v1h16V32h11v1h2v1l11-1v1h28C867.9,36.8,880.8,34.79,893,37Zm46-7a18.235,18.235,0,0,1,7,1v1h-7V30Zm14,0c1.139,1.139.4,0,1,2h-1V30Zm6,1c1.139,1.139.4,0,1,2h-1V31Zm7,0,13,1v1H966V31Zm184,0h3v1h-3V31Zm19,0h2c0.33,1,.67,2,1,3h-5c1.14-1.139,0-.4,2-1V31Zm12,2h-4V32h3V31C1180.9,29.13,1181,33,1181,33Zm18-2h2v1C1198.99,31.426,1200.13,32.12,1199,31ZM699,32h2v1C698.99,32.426,700.135,33.12,699,32Zm285,0h11v2H984V32Zm123,0h4v1h-4V32Zm10,0h4v1h-4V32Zm-116,1h2v1C1000.99,33.426,1002.13,34.12,1001,33Zm8,0h29c4.8,0,10.58-.279,13,2-10,.163-23.76,1.343-32-1C1015.48,33,1011.24,35,1009,33Zm142,0h2v1C1150.99,33.426,1152.13,34.12,1151,33Zm221,2V33h5c0.33,0.667.67,1.333,1,2,1,0.314,5.04-1.751,8-1v1l11-1v1h5v1l5,1V36c1.69,0.3,4.2,3.711,8,2,0.67-1,1.33-2,2-3h2v1h10v1c4.12,1.21,13.82-.184,17-1V35c3.12-.559,3.84,2.593,8,2,1.88-.268,5.53-2.562,8-2v1l13,1V36h2V35h13v1l3-1v1l11-2v1h25V34c0.67,0.333,1.33.667,2,1V34l3-1c2.94,0.358,5.07,4.3,10,3V35c0.67,0.333,1.33.667,2,1,0.77-.284.39-2.165,2-2v1c5.11,0.8,22.47-.623,23-1,1.33,0.667,2.67,1.333,4,2,0.33-.667.67-1.333,1-2,2.03,0.133,1.49,1.916,2,2h1V35h7v1c2.36,0.591,2.68-1.132,4-1a1.7,1.7,0,0,0,2,1V35h3V34h1v1l4,1V195H0V79c6.848-1.12,15.864-2.209,22-4H35l2-3h6c2.017-.607,6.667-1.555,9-2,1.382-2.612,1.769-1.693,2-6-4.758-.29-7.394-3.6-13-2v1H36v1l-9,1v1H13V65L0,66V63H1V62H7c2.889,2.568,6.459-.833,11,0v1l4-1V61l20-2V55h1V54a104.323,104.323,0,0,0,19-4l29-1V48h4V47c4.749-1.451,14.266.222,19-1l10,1c2.3-.72,5.116-4.217,9-3v1h2v1l15,1V46h4V45h1v1h6v1h11v1h2v1c2.323,0.751,2.667-1.029,4-1v1l33,1,10-1v1l7,1v1c1.713,0.364,1.716-.934,2-1h16a160.339,160.339,0,0,1,31,3v2l-18,1V56H237V55h-4V54h-2V53l-12,1-27-1v1h-1c-2.663.316-3-1-3-1H176V52H163v1c-1.716.3-1.689-.924-2-1h-5V51h-1v1h-4v1c-1.653.388-7.865-1.692-9-2-3.752-1.018-6.059,1.384-8,2h-7v1h1c0.861,0.959,8.291,4.353,10,4V57l6-1,1,2h7l1-2,7-1v1h2l1,2h2l1,2c4.676,1.9,7.427-3.786,13-2v1l4,1,1-2,15-1v1h3v1h6V58h21v1h3v1l11-1v1h2v1c2.957,0.528,2.133-1.663,3-2h37c-0.871-3.428-2.068-2.575-3-6l3-1V51h6c1.72,2.135,2.033.566,3,4h1v1h-1v1h-3v1h2c2.105,3.1,9.88,2.155,15,2V59h7V58c2.289-.7,4-0.256,6-1V56h-6c-2.305,2.2-7.426.547-10,0V55c1.719-1.127,1.355-.633,2-3h5V51a29.368,29.368,0,0,1-7-1V48h24v1h1v3c4.169,0.715,4.189.248,9,0V49c6.6-.024,14.973-0.153,20,1l7-1v1c3.465,1.091,3.047.308,6,0v2h9v1c2.32,1.889.2,1.834,4,3,0.945-1.8,1.385-1.575,2-4h12v1h4v1l7-1c3.044,0.006,3.407.739,5,1h24v1h18v1l17,1c-0.113,3.16-1.955,1.874,1,3v2c2.492-.776,7.071-0.06,12,0V57l6-1c2.166,0.564,4.282,2.383,7,3v2h-2v2c2.393,0.607,1.858.318,3,2a9.074,9.074,0,0,0,2-2c3.976-1.776,10.133,1.546,13-1l-5-1V60l-3,1V60h1V59h2V58h4v1h15l41,1,1,2h2v1h2v1h8l1,2h2c1.429-2.193,3.607-2.685,5-5l-3-1V59h-3V58h-4V57c-2.436-2.09-1.651-3.367-6-4-1.219,1.083-15.009,1.883-18,1V53h-5V52h-5V51h-2V50c-1.709-.408-1.732.939-2,1h-9v1h-5V51l-10,1V47a40.875,40.875,0,0,1,14,2l24-1v1l28,1v1l5-1,16,1,8-1v1l11,1,1-3c5.527,2.051,15.778,1.051,23,1V48c-3.268.114-8.3,0.569-10-1l14-1c0.936-3.586,2.61-3.156,7-3v2c2.158,0.587,2.387.246,1,2,3.167,1.53,2.932-1.447,4,3,6.249,0.018,14.335.329,19-1,2.3-.654,6.95,1.009,7,1V49h2V48l9,1c2.127-.087,2-1,2-1h15c0.723-2.762.279-2.237,3-3v2h1V46c0.86-1.889,1,2,1,2l8-1v1h11V47l19-1v1c1.4,0.207-.374-0.666,1-1l10,1a2.669,2.669,0,0,1,3-1v1h14c4.476-.387,13.12-2.555,19-1v1l7-1v1l10-1,1,2,5-1h26c1.522,0.429,8.867,2.524,11,2V48h11c6.73,1.879,15.315.609,22,0V46c-3.313-1.4-5.531-2.573-6-7l4-1V37l8,3,8-2v1l3,1v1l5-1V39h7c1.077,4.084,3.138,3.216,8,3V40h4l-1,2c0.784,1.295,5.643,1.111,8,1,1.539,1.357,9.831,1.9,13,1,11.236-3.179,27.347.067,39,0v2l-5,1v2c4.23,0.142,8,.068,10-2-1.72-1.127-1.36-.633-2-3,2.65-1,6.94-1.041,11-1V42h1v1h14l5-1c0.33,0.667.67,1.333,1,2l8,1V44h5V43c2.69-.582,5.09,1.657,7,2,8.68,1.553,19.72-1.026,27,1l29-1V43a143.639,143.639,0,0,1,31,3c-0.33-.667-0.67-1.333-1-2h1c1.13-1.233-.03-0.415,2-1v3h5c-0.33-1-.67-2-1-3,2.18-.422,2.85-0.664,4-2h2c0.33,0.667.67,1.333,1,2l5-1v1h-1v1h-3v1h6a7.534,7.534,0,0,1,2-3c2.43,3.487,6.07,1.787,11,3v1l3-1V44h2V43l7,1V43h3V42c4.4-1.323,6.3,1.638,10,2V42h5V40c7.95,1.362,17.2.693,25,0h8V39l3-1v2l13,1V40l3-1V38c1.96-.461,1.31.561,2,1,1.14,1.139.4,0,1,2a60.045,60.045,0,0,0,8-2V38c3.98-1,3,2.921,7,2V39l5-1c0.33,0.667.67,1.333,1,2h1V39h5V38h2V37l10,1V37l4-1V35c1.16-.231,6.7,3.251,11,2V36h4V35h1v1h10c3.05-.868,11.38-3.107,16-2v1c0.67-.333,1.33-0.667,2-1v1h4c1.53-.417,6.04-3.184,9-2,0.33,0.667.67,1.333,1,2h8Zm-318-1h3v1h-3V34Zm10,0h3v1h-3V34Zm12,0v2a7.5,7.5,0,0,1-3-2h3Zm2,0,3,1v1c-2.12-.092-3.17.494-4-1h1V34Zm21,1v2h-10c-0.33-.667-0.67-1.333-1-2h1V34c4.48,1.57,4.62-.784,8,0v1h2Zm5-1c0.67,0.333,1.33.667,2,1v1h-4V35C1104.01,34.426,1102.87,35.12,1104,34Zm15,0h4v1h-1v1h-4C1118.33,35.333,1118.67,34.667,1119,34Zm14,0h3v1h-3V34Zm25,0h2v1C1157.99,34.426,1159.13,35.12,1158,34Zm-75,1h2v1C1082.99,35.426,1084.13,36.12,1083,35ZM242,37h2v1C241.99,37.426,243.135,38.12,242,37Zm86,1h4v1h-4V38Zm9,0h4v1h-4V38Zm25,0h2v2h-2V38Zm320,0h4v1h-4V38Zm48,0v4c-2.465,1.093-4,2.339-7,3V44h1c1.256-1.909,1.014-1.659,4-2l-1-3h1C729.139,37.861,728,38.6,730,38Zm19,0v2h-3V39h1C748.139,37.861,747,38.6,749,38ZM368,39h3v2h-3V39Zm6,0h2v1C373.99,39.426,375.135,40.12,374,39Zm282,0h3v1h-3V39Zm15,0h3v1h-3V39Zm28,0h2v2h-2V39Zm63,0h2v1C761.99,39.426,763.135,40.12,762,39Zm28,0h3v2h-3V39Zm148,0h2v1C937.99,39.426,939.135,40.12,938,39ZM387,40h2v1C386.99,40.426,388.135,41.12,387,40Zm6,0h3v1h-3V40Zm253,0v2c-1.135-.844-0.145.127-1-1-1.135-.844-0.145.127-1-1h2ZM411,41l4,1v1h-4V41Zm55,1,1,3,23,1v1h13V46l5,1v2l-15-1v2h-4V49l-22,1c-0.575-2.987-1.879-4.587-3-7-4.22.116-5.233,0.577-7-2h2v1h7Zm704,1V41l3,1v1h-3Zm3-2h4v1h-4V41ZM423,42l4,1v1h-4V42Zm53,0a11.885,11.885,0,0,1,5,1v1h-5V42Zm158,0c3.1-.11,7.411-0.47,9,1l-10,1Zm40,0h2v1C673.99,42.426,675.135,43.12,674,42Zm21,0h2c-0.28.552-1,3.3-2,3C693.563,42.916,694.819,44.06,695,42Zm8,0h2v1h-2V42ZM493,43v2h-3V44c-1.135-.844-0.145.127-1-1h4Zm9,0,5,1v1h-5V43Zm165,0h4v2h-4V43ZM440,47c0.826-3.2,1.179-2.9,5-3v1h8c0.29-.068.3-1.309,2-1v1h6v1h-2C456.24,48.5,444.8,47.1,440,47Zm246-3h4v1h-4V44Zm17,0h3v1h-3V44Zm24,0h3v1h-3V44ZM543,45h2v1C542.99,45.426,544.135,46.12,543,45Zm20,2h-2V46h1V45C563.139,46.139,562.4,45,563,47Zm148-2h2v1h-1v1C710.861,45.861,711.6,47,711,45Zm184,0h5v1l-6,1ZM684,46h3v1h-3V46ZM286,47h4v1h-1v1h-4Zm225,0h5v1h-2v1C511.607,48.393,512.142,48.683,511,47Zm75,0h4v1h-4V47Zm81,0h3v1h-3V47Zm8,0h3v1h-3V47ZM278,48h3v1h-3V48Zm0,3h2v1h-1v1C277.861,51.861,278.6,53,278,51Zm274,3h2v1h-1v1C551.861,54.861,552.6,56,552,54ZM298,55h2v1C297.99,55.426,299.135,56.12,298,55Z"/>
						</svg>';
				break;

			case '48':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 160">
							<path style="fill:'. $c1 .'" d="M333,20l9-1v1c-1.139,1.139-.4,0-1,2l-2-1v1l-5,1V22C332.861,20.861,333.6,22,333,20Zm-68,0h2v1C264.99,20.426,266.135,21.12,265,20Zm8,0,6,1v1c-3.1,1.643-1.8,1.9-7,2Q272.5,22,273,20Zm-10,1h2v1C262.99,21.426,264.135,22.12,263,21Zm43,3v2l6,1v1h-1v1h-8c-1.139-1.139,0-.4-2-1,1.01-3.129.557-1.518,0-5h-8V22h1V21h3c2.05,1.885,9.224,1.1,13,1v1h-1v1h-3Zm-46-2h3v1h-2c-0.73.474-.011,1.392-2,1Zm118,0v2c-3.138.048-8.5-.565-10-2h10Zm28,0v2c-5.937.177-15.034,1.018-18-2h18Zm35,3h8q-0.5,2.5-1,5h2v3l15,1,1,2h18v1c2.719,0.547,4.4-1.148,6-2V34l6,1q-0.5,3-1,6h13v1h2v1h5l1-2,7,2c0.671,1.893,1.289,6.118,2,8,1.889,0.831,5,2.4,7,3h20v1l7,1V55l4-1v1h5V54h1v1h8V54c-1.975-1.129-2.338-1.417-3-4l-4-1v1l-9,1V50h-3V49h-1v1H545V49l-12-1V46h-3V45c1.719-1.127,1.355-.633,2-3h3v3c2.333,0.4,5.561,1.943,9,1V45h8v1h4v1h1V46h8c2.487-4.155,6.738-4.358,8-10l-5-1-1-2h2c3.694,3.591,4.09-.421,9,1v1h3v1l4-1c-0.083,2.971.011,4.984-1,7l-2,1v1h1c3.922,4.2,11.712-.247,18,2v1h2v1h3v1c5.15,1.671,8.465-2.556,10,1h-5c-0.88,3.4-1.861,3.065-6,3V51a12.7,12.7,0,0,0-5-1v3a29.368,29.368,0,0,0-7,1l1,3,14,1a25.313,25.313,0,0,0,5-1v1h3v1c1.94,0.4,3.789-1.883,7-1v1l13,1V58c3.577,0.063,5.714-.128,8-1V56l-5-1V54c-4.24-1.526-7.016,1.066-10-2,1.139-1.139.4,0,1-2h-8V49l15,1V49h13V48l6-1v2l4-1,1,3h5v1h-3v4c2.533-.505,5.063-2.78,7-3,1.6-.182,1.247,1.736,2,2,2.8,0.981,5.051-.647,7-1l1-3c4.465,0.373,2.915.628,7,0-0.36,2.022-1.432,2.944,0,4h-4v1c1.135,0.844.145-.127,1,1a10.6,10.6,0,0,0,4,1v2l8-1,1,2h2v1h8V59l8-1v1h2l1,2h9v1c4.4,1.239,12.371.419,15,0V61a3.983,3.983,0,0,1-2-2h6c1.392,1.14,5.988.69,9,0V58c3.224-.468,3.834,3.133,8,2V59l6-1v1h4v1h2v1h16v1h10v1c3.08,0.817,5.362-1.476,7-1l1,2h6V62c5.272-.273,15.725-2.758,22-1v1h5l12-1,1,2a10.88,10.88,0,0,0,7,3c1.139-1.139,0-.4,2-1V64h-3V62l15-1v1h10c3.061,0.9,8.609,3.347,14,2V63a2.657,2.657,0,0,1,3,1c4.524,1.1,8.372-.942,11-2l1-2c-1.135-.844-0.145.127-1-1l-8-1q1-3.5,2-7l10-1v1l9,1v1l32,1v2l16,1v1h-1c-0.233,1.59,1.616,1.242,2,2,1.813,3.58-1.626,3.413,4,4l3-5,6,1,1-2h6V57l9,1a100.135,100.135,0,0,1,25-3v2a105.972,105.972,0,0,0,17,1v2a11.352,11.352,0,0,0,2-2l17,1V58h3V57c3.14-.787,3.9,1.769,6,2V58l26,1v1c4.82,1.292,5.48-1.914,10-2h5v1h22v1h-1c-3.2,2.784-11.41-.178-16,0h-3v1h-14l-7-1c-0.33.667-.67,1.333-1,2l-6,1V62c1.14-1.139.4,0,1-2a40.117,40.117,0,0,0-9,1c-0.33,2-.67,4-1,6l3,1c3.13,2.854,25.01,2.763,32,2,2.93-.32,4.02-1.757,6-3V66l23,2c5.34,0.173,8.26-1.859,12-3h7V64h4v1c4.09,1.066,9.19-.477,12-1,1.43-3.826.63-3.158,8-3v1h5c0.33,0.667.67,1.333,1,2l6-1c0.67-1,1.33-2,2-3l4,1V60h4V58c-4.22.139-11.01-.111-13-2h2c3.9-3.759,16.04,1.162,19,2l8-1c0.33,1,.67,2,1,3h-3v2c2.66,1.412,4.22,2.03,9,2v1c1.61,0.894,7-1,7-1,0.33,0.667.67,1.333,1,2,1.47,0.767,6.4,2.038,9,1,0.33-.667.67-1.333,1-2h1c2.08-.276,2,1,2,1l10-1c0.33,0.667.67,1.333,1,2h21v1l12,1V68l12-1c2.02,0.176,2,1,2,1h5v1l9-1v1l4,1v1c2.87,0.571,2.36-1.808,3-2a1.549,1.549,0,0,1,2,1l5-1v2l4-1c0.33-.667.67-1.333,1-2l22-1V66h-3V64l5,1v2a12.66,12.66,0,0,0,5,1V67h3V65l6,3v1c2.76,0.74,2.28-1.723,3-2h12V66h5V65l13,1v1a2.583,2.583,0,0,0,3-1h16V65l5-1v2l37-2v1l3,1h11a2.614,2.614,0,0,1,3-1v1h4v1h7v1h-8v1h-1c-0.99,0-3.79-2.2-6-1-0.33.667-.67,1.333-1,2h-1c-0.23,1.4.37-.268,1,1,3.2,2.78,10.43-.685,15,1v1h2v1l3,1V73l31,1v1h8V74c3.92-1.1,12.43,1.283,15,2l9-1v1h7v1l5-1c0.33,0.667.67,1.333,1,2h15v7l-20-1V83h-11l-14-1V81h-13V80h-6V79h-15v1l-9-1c-0.33,1-.67,2-1,3l4,1v1h12v1h10v1c2.18,0.356,3.93-2.224,7-1,0.33,0.667.67,1.333,1,2l28-1c0.67,1,1.33,2,2,3l11-1c0.68,2.927,1.11,3.275,4,4,0.88-3.4,1.86-3.065,6-3v1h4V195H0V56c6.264-.162,9.232-2.562,14-4l19-1V50c2.893-.836,8.879-0.905,10,0-3.537.286-4.884,1.349-8,2v2l-6,1v1c-4.671,1.436-7.876-1.19-11,2l16-1v2l-4,1v3H27l1,2c-0.36.566-14.554,1.781-16,2,0.844,1.135-.127.145,1,1,2.786,3.1,6.729,1.543,12,2,1.848,0.16,2,1,2,1l15-1,45-1,1-2,8,1V67h5v1c3.858,1.033,8.376-.514,11-1V62a13.307,13.307,0,0,0,4-3h8v2l20,1V61c2.509-.907,4.5-0.283,6-2l1-3,10-1c6.236-2.012,12.925-4.594,20-6V47l28-5h14V41h17V40h11l20-1V38l11,1V38h3V37l6-2V34h11V33h3V32c2.225-.659,17.162,2.252,19,3v1h2v1c1.682,0.383,1.767-.951,2-1h15c1.382-2.612,1.769-1.693,2-6-0.223-.105-3.626-1.439-3-2h1c4.8-4.753,15.039.813,20,2v4h10c0.249,0.054.311,1.362,2,1V34h2V33l15,1v1h3v1c3.564,1.13,8.383.022,11,1v1h-5c-2.7-2.515-10.481-.273-14,0l1,3,5-1,1,2,11,2V43l6-1q-0.5-2.5-1-5c1.135-.844.145,0.127,1-1h13V35c3.394-2.495,1.052-3.507,7-4,1.653,1.6,5.613,1.99,9,2l4-5h-1c-1.139-1.139,0-.4-2-1V25ZM289,27h2v1C288.99,27.426,290.135,28.12,289,27Zm177,0h3v1h-3V27Zm26,1h4l1,2h1v1h-1v1h-5c-1.139-1.139,0-.4-2-1l-1-2h3V28Zm28,2v2c-3.619.431-12.181,1.593-15-1Zm4,1h3v1h-1c-1.139,1.139,0,.4-2,1V31Zm23,1,10,1c-1.107,4.237-3.875,4.177-5,9-1.882-.275-1.963-0.988-2-1h-5V40c3.686-.326,4.21-0.818,5-4C548.025,34.871,547.662,34.583,547,32Zm57,7h-3l-2-3h4v1C604.139,38.139,603.4,37,604,39Zm20-3h2v1C623.99,36.426,625.135,37.12,624,36Zm18,5,9,2q-0.5-2.5-1-5a15.68,15.68,0,0,1,6-1v1l5,1v1h-1c-4.27,6.684-12.423,3.763-20,5V44C641.719,42.873,641.355,43.368,642,41Zm126-3h2v1C767.99,38.426,769.135,39.12,768,38Zm44,0h6v1h-2v1h-5ZM120,39h2v1C119.99,39.426,121.135,40.12,120,39Zm566,0h4v1h-4V39Zm25,0h4v1h-4V39Zm23,0v2c-2.393-.607-1.858-0.318-3-2h3Zm198,2c4.652,0.037,5.545,1.217,9,2q0.5,2.5,1,5l-6,1v1l-4-1V41ZM610,42h2v1C609.99,42.426,611.135,43.12,610,42Zm129,0q0.5,2,1,4H729V44C734.707,44.063,735.29,42.956,739,42Zm118,4V42h1v1h9v1c2.31,0.7,3.994.252,6,1v1h-3C868.839,45.041,861.093,45.882,857,46ZM719,43h2v3h-1V45C718.861,43.861,719.6,45,719,43Zm85,0a14.823,14.823,0,0,1,6,1c-1.139,1.139,0,.4-2,1v1h-4V43Zm-30,1h1v1h10v1c-2.312.3-9.676,1.363-12,0Zm241,0h4v1h-4V44ZM900,45c2.694-.049,15.922,1.015,17,2l-10,1s0.094-1.211-2-1v1l-6-1Zm55,0h2v1h-1v1C954.861,45.861,955.6,47,955,45Zm54,0v2h-3V46h1C1008.14,44.861,1007,45.6,1009,45Zm53,3c-5.74.111-7.33,0.818-12,0V46a76.022,76.022,0,0,1,13-1v1C1061.86,47.139,1062.6,46,1062,48Zm8-3h3v1h-3V45Zm77,1c-1.08,4.573-4.35,4.249-10,4V49h1C1139.77,45.877,1141.94,45.851,1147,46ZM58,47h3v1H58V47Zm1114,0,8,1v1c-2.52,1.339-3.5,1.99-8,2V47Zm-168,1,3,1v1h3v1h-1v1h-6V51h-4V50h2V49h3V48ZM768,49c4.557,0.462,5.621.8,10,0-1.434,6.056-4.632,2.552-10,2V49Zm29,0,10,1v1h1l-1,2h9V52a3.983,3.983,0,0,1-2-2h2v1h8l1,2,5,1,1,2h4v1l-20,1V57c1.139-1.139.4,0,1-2h-9v1h-2v1l-11-1-1-3h2v1c0.6,0.021,1.85-.888,4-1V51h-2V49Zm54,3V50c0.865-.1,6.292-1.071,8,0v1Zm351,0c1.12-4.218,3.99-3.24,9-3v1c3.04,1.679,7.69-1.018,10,1ZM666,50h5v1h-5V50Zm36,0,5,1v1h-3C703.229,50.984,702.771,51.016,702,50Zm47,0h9c0.254,0.056.331,1.27,2,1V50h3v1h-2c-0.8,3.506-1.772,3.9-6,4v1h-5V55l-11,1-1-3c5.062,0.282,6.348.843,11,0V50Zm36,0h3v1h-3V50Zm80,0a9.746,9.746,0,0,1,4,1v1C865.991,51.7,866.277,51.865,865,50ZM700,51v2c-1.135-.844-0.145.127-1-1-1.135-.844-0.145.127-1-1h2Zm13,0c3.553-.072,6.785.157,9,1v1h-1v1h-3v1h-2v1h-7v1h-1V56h-4V54l9-1V51Zm12,0h2v1C724.99,51.426,726.135,52.12,725,51Zm295,0h2v1C1019.99,51.426,1021.13,52.12,1020,51Zm4,0h3v1h-3V51Zm7,0h2v1C1030.99,51.426,1032.13,52.12,1031,51Zm10,0h3v1h-3V51Zm8,2h-5V52h4s0.03-2.031,1-1v2Zm6-2h2c-0.84,1.135.13,0.145-1,1v1C1054.86,51.861,1055.6,53,1055,51ZM690,52v2c-1.135-.844-0.145.127-1-1-1.135-.844-0.145.127-1-1h2Zm367,0h3v1h-3V52Zm9,0h2v1C1065.99,52.426,1067.13,53.12,1066,52Zm4,0h2v1C1069.99,52.426,1071.13,53.12,1070,52Zm10,0h2v1C1079.99,52.426,1081.13,53.12,1080,52Zm48,0,6,1v1h-8V53C1128.01,52.426,1126.87,53.12,1128,52Zm-17,1h6v1h-6V53ZM852,55v2c-2.755.053-14.878-.973-16-2C842.784,54.955,847.071,54.143,852,55Zm308-1,3,1v1C1160.61,55.393,1161.14,55.683,1160,54Zm7,0h3v1h-3V54Zm125,0v2l-11,1c-0.33-.667-0.67-1.333-1-2h2C1283.7,53.417,1288.73,53.9,1292,54ZM875,55l9,1V55h4v3l-6-1-1,2-8,1V57h2V55ZM40,56h4v1H43v1H39Zm7,0h5v1H47V56Zm1137,0h2v1C1183.99,56.426,1185.13,57.12,1184,56ZM897,57h2v1C896.99,57.426,898.135,58.12,897,57Zm85,0h2v1C981.99,57.426,983.135,58.12,982,57Zm377,1c3.58-.063,5.71.128,8,1-0.77,1.016-1.23.984-2,2-2.22-.292-1.58-0.841-2-1h-5C1358.33,59.333,1358.67,58.667,1359,58Zm-101,1,4,1v1h-4V59ZM47,65c4.294-.088,9.149-0.079,12,1v1H49V66H44V65H42V64c-3.917-1.242-5.477,1.339-8,2V64c2.871-.672,2.524-1.8,3-2h9c2.374-.716,4.4-1.8,8-2v1H53v1H48v1C46.861,64.139,47.6,63,47,65Zm1099-5h5v1h-5V60Zm129,1h2v1C1274.99,61.426,1276.13,62.12,1275,61Zm7,0h3v1h-3V61Zm12,0h3v1c4.24,1.214,9.8-.206,13,1v1h-8V63h-8V61ZM74,66V63c5.361-1.138,14.557-1.544,18,2L82,66v1Zm24-4v2H92V63h2V62h4Zm1426,5v2c-1.8-.253-2-1-2-1h-6c-0.33-.667-0.67-1.333-1-2h2v1h7Z"/>
						</svg>';
				break;

			case '49':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 181">
							<path style="fill:'. $c3 .'" d="M248,145s6.9-55.184,74-59c0,0,38.4.816,23,42,0,0-8.6,17.816-25,11,0,0,16.9-9.184,6-22-10.956-12.882-33.6,8.816-2,54Z"/>
							<path style="fill:'. $c3 .'" d="M16,129S31.9,12.816,99,9c0,0,43.9,1.816,27,50,0,0-8.6,17.816-25,11,0,0,16.9-9.184,6-22-10.956-12.882-36.6,10.816-5,56Z"/>
							<path style="fill:'. $c3 .'" d="M-36,131s12.5-93.891,67.14-97c0,0,34.431,3.535,21.985,40.741,0,0-7,14.517-20.356,8.963,0,0,13.761-7.483,4.886-17.926C28.733,55.281-8.23,68.184,51,129Z"/>
							<path style="fill:'. $c2 .'" d="M34,127s6.932-52.269,37.219-54c0,0,19.364,1.587,12.187,22.68,0,0-3.882,8.082-11.284,4.99,0,0,7.628-4.166,2.708-9.979-4.945-5.843-25.436,1.339,7.4,35.2Z"/>
							<path style="fill:'. $c2 .'" d="M223.5,140.255s7.288-39.332,51.051-42c0,0,22.6,2.54,12.176,26.653,0,0-5.511,11.588-15.162,7.9,0,0,10.4-6.5,4.364-14.4-6.383-8.356-20.909,7.393-3,34.651Z"/>
							<path style="fill:'. $c1 .'" d="M-15,125s73,17,182-79S306.128,33.624,297,56c-5.5,21-19,36.5-46,28,0,0,25.5-5,14-28s-44.5,7.5-26,46,49,56.5,112,56l1250-1v24H-5Z"/>
						</svg>';
				break;

			case '50':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 99">
							<path style="fill:'. $c1 .'" d="M0,99V8.927a92.281,92.281,0,0,1,24.938,7.042C38.529,7.231,55.753,2,74.5,2c19.84,0,37.974,5.858,51.9,15.533A96.917,96.917,0,0,1,152.5,14a95.45,95.45,0,0,1,34.106,6.176C200.248,11.31,217.6,6,236.5,6a93.271,93.271,0,0,1,44.043,10.714A97.46,97.46,0,0,1,303.5,14a95.837,95.837,0,0,1,31.993,5.4C349.938,7.435,370.139,0,392.5,0c19.514,0,37.381,5.663,51.216,15.055A95.5,95.5,0,0,1,477.5,9a92.213,92.213,0,0,1,48.152,13.079A95.494,95.494,0,0,1,559.5,16a96.693,96.693,0,0,1,27.492,3.932C600.575,11.215,617.779,6,636.5,6c23.344,0,44.333,8.1,58.877,21a98.464,98.464,0,0,1,47.737-.133C757.1,16.993,775.43,11,795.5,11c18.728,0,35.938,5.217,49.523,13.939A95.572,95.572,0,0,1,878.5,19a92.679,92.679,0,0,1,46.349,12A97.308,97.308,0,0,1,992,30.947a97.437,97.437,0,0,1,65.2-.653C1071.78,16.645,1093.38,8,1117.5,8c21.07,0,40.22,6.6,54.45,17.378a97.963,97.963,0,0,1,56.48,1.649A92.229,92.229,0,0,1,1276.5,14a94.981,94.981,0,0,1,36.32,7.058A93.1,93.1,0,0,1,1357.5,10c21.81,0,41.57,7.073,55.93,18.524a98.431,98.431,0,0,1,47.8-1.1C1474.93,18.409,1492.43,13,1511.5,13a94.153,94.153,0,0,1,40,8.69,93.3,93.3,0,0,1,44-10.69q2.265,0,4.5.1V99H0Z"/>
						</svg>';
				break;

			case '51':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 236">
							<path style="fill:'. $c1 .'" d="M177.416,1L1615.94,226.741a50,50,0,0,1,42.21,56.729l-44.42,302.759A50,50,0,0,1,1557,628.44L-30.024,402.7a50,50,0,0,1-42.212-56.729L120.687,43.211C140.2,11.889,150.844-1.509,177.416,1Z"/>
						</svg>';
				break;

			case '52':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 257">
							<path style="fill:'. $c1 .'" d="M-7-10H1618V288H-7V-10ZM173.416,229.5L1611.94,3.759a50,50,0,0,0,42.21-56.729l-44.42-302.759A50,50,0,0,0,1553-397.94L-34.024-172.2a50,50,0,0,0-42.212,56.729L116.687,187.289C136.2,218.611,146.844,232.009,173.416,229.5Z"/>
						</svg>';
				break;

			case '53':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 154">
							<path style="fill:'. $c1 .'" d="M247.094,39.471V37.655c-0.3,0-.792,1.345-1.094,1.345,0-.3,1,0.3,1,0-4.922.717-49.155,25.535-52.406,28.2-1.986-1.729-1.935-.329-2.719-2.724-1.856-3.249,1.059-.448-0.906-3.632,1.564-.586.887-0.178,1.812-0.908h0.906l-0.906,1.816,3.625-.908V59.931H195.5V58.115c-5.705.843-15.2,0.871-19.938,4.54h-7.25c7.412-11.4,24.555-13.7,34.438-22.7h1.812V39.046c-33.045,4.863-59.366,17.691-80.656,34.506H123V72.644h0.906c0.763-7.409,6.161-7.578,10.875-10.9,6.934-4.881,26.909-21.861,33.531-21.793a11.515,11.515,0,0,0,.907-3.632c2.517-.288,4.759-0.65,6.343-1.816h0.907c-3.032-1.895-5.611.5-5.438-2.724-3.725.339-4.289,1.084-7.25,1.816a8.633,8.633,0,0,0-2.719-3.632c0.216-.377,17.3-9.864,19.032-10.9V16.345c-22.285,5.96-34.107,16.395-51.657,25.425-9.8,5.042-17.639,8.452-26.281,14.529-0.687.977-.569,0.839-0.906,2.724a26.833,26.833,0,0,0-10.875,5.448H89.469c0.91-3.523,18.033-17.005,21.75-19.069V43.586c-7.459,3.072-18.073,3.578-25.375,7.264C78.615,54.5,69.887,60.426,63.187,65.379L57.75,72.644c-7.111,5.042-15.184,6.618-21.75,11.8H28.75V83.54c7.989-2.248,12.655-7.192,18.125-11.8C52.494,67,59.837,65.1,65.906,60.839c1.4-.986,1.507-3.435,2.719-4.54,4.039-3.682,9.837-5.2,14.5-8.172,7.018-4.477,11.363-10.218,22.656-10.9V36.322h0.906V32.69c-6.1-.112-11.225.074-14.5,2.724H90.375c0.54-1.99,1.013-1.832,0-3.632,2.2-4.448,12.079-9.3,16.312-11.8V18.161c-6.989.2-9.6,2.226-14.5,3.632H86.75c-2.792,1.352-6.2,6.734-9.062,8.172H73.156c-4.926,2.419-10.377,8.314-15.406,10.9-9.787,5.026-17.68,8.423-26.281,14.529-0.687.977-.569,0.839-0.906,2.724C20.738,60.239-2.062,78.092-2.062,78.092S-2,135.933-2,155H1602V90.8c-8.07,1.075-14,7.764-24.47,9.08,1.4-6.736,7.2-5.072,10.88-9.08,2.31-2.526,2.05-5.027,5.43-7.264V81.724c-10.47,1.347-37.68,12.2-42.59,18.161h-0.91c8.47-12.994,26.23-17.5,38.07-27.241h0.9V70.828c-8.3-.347-7.56.507-14.5,1.816-0.36-1.865-.22-1.75-0.9-2.724,0.97-.688.83-0.57,2.71-0.908,0.66-7.062,11.12-13.073,17.22-14.529v-4.54c-11.9,5.567-22.69,10.3-34.43,16.345-4.93,2.533-10.33,8.329-15.41,10.9-9,4.551-16.11,6.976-22.66,13.621h-2.72V89.9a19,19,0,0,0,5.44-3.632h0.91V84.448c-2.36,1.094-12.69,6.356-12.69,6.356-0.8-1.166-.84-2.241-0.91-4.54-2.51.426-5.03,0.215-6.34,0.908h-0.91c5.5-7.23,38.57-28.346,48.94-30.874,0.58-2.026.67-2.4,1.81-3.632V51.759c-26.37,1.786-45.25,33.579-67.06,37.23,1.68-5.849,9.17-7,11.78-12.713h0.91c-3.31-5.553-11.65.4-18.13,0.908,0.26-11.549,13.65-10.811,19.94-16.345h1.81V59.931c-5,.68-8.42,1.861-14.5,1.816a16.244,16.244,0,0,0-3.62-2.724c-0.3-.908-0.6-1.816-0.91-2.724,5.34-2.757,15.62-9.5,19.94-13.621h1.81V41.77c-8.88,1.3-16.71,5.645-24.47,8.172-13.02,4.246-25.74,4.142-37.15,9.988-6.04,3.1-11.81,9.009-17.22,12.713-4.88,3.344-13.07,5.162-15.41,10.9h-1.81a5.5,5.5,0,0,0-1.81-1.816V79.908c12.75-8.455,25.23-18.821,38.06-27.241,9.56-6.278,21.21-9.3,29-17.253h0.91V34.506c-9.66,2.467-14.18,7.54-27.19,7.264,0.58-4.017,17.21-16.786,20.84-19.069V21.793c-20.7,5.741-36.33,19.335-53.47,28.149-8.37,4.306-17.08,6.727-22.65,13.621-2.41-.9-3.13-1.887-4.53-3.632-19.85,1.3-33.41,15.455-46.22,24.517-3.58,2.531-11.29,5.1-12.69,7.264h-2.72V90.8c9.21-5.429,17.06-15.013,26.28-20.885,10.38-6.608,20.71-12.357,29.91-19.977,3.26-2.7,8.51-2.9,11.78-5.448h1.81V43.586c-8.16.676-16.49,3.014-23.56,4.54V47.218h-1.81V46.31h3.62c1.31-8.739,16.16-10.971,20.85-17.253H1399V28.149c-23.86,3.559-37.77,17.323-55.28,26.333-9.8,5.041-17.64,8.451-26.28,14.529-0.69.977-.57,0.839-0.91,2.724-7.58,1.143-11.2,6.533-17.22,5.448h-5.44c2.47-3.7,16.48-11.963,20.85-14.529V61.747L1283,69.92c-0.67-.792-1.14-1.024-1.81-1.816,5.89-2.83,15.19-5.614,19.93-9.988,2.65-1.113-1.03-.616.91-2.724,1.73-1.874,15.29-8.392,18.13-9.08-0.59-1.567-.18-0.889-0.91-1.816-2.14-1.517-11.21,5.246-14.5,6.356-2.78.939-5.19-.432-7.25,0.908-0.04.024,0.36,3.2-.91,1.816-3.57.781-10.48,4.525-15.4,6.356-4.6-1.023-16.83.96-21.75,3.632-11.61,6.294-21.83,17.159-32.63,24.517-5.47,3.728-15.15,5.927-19.94,9.989h-1.81V96.253c10.49-6.3,25.39-20.684,38.06-22.7-0.67-.792-1.14-1.024-1.81-1.816,7.83-3.391,13.17-10.072,19.94-14.529,6.53-4.3,16.59-6.314,22.66-10.9h1.81V45.4c-9.21.095-16.56-.653-21.75,0-0.3-.908-0.61-1.816-0.91-2.724,5.36-2.59,12.25-5.9,16.31-9.989h0.91V30.874c-7.56,3.19-18.57,5.668-24.47,8.172-1.83.778-3,3.788-4.53,4.54h-4.53c-4.92,2.5-10.34,8.337-15.41,10.9-2.48,1.253-5.03.421-7.25,1.816-4.62,2.915-8.98,8.06-13.59,10.9-6.65,4.1-14.35,2.018-18.13,5.448h-1.81c0.53-3.274.68-2.5,3.63-3.632-0.65-2.98-.93-2.116-1.82-4.54,7.43-3.767,12.56-9.387,19.04-13.621V49.943c-8.78,1.348-18.02,8.21-24.47,12.713-0.31.216-2.98-.954-4.53,0-5.75,3.539-12.41,8.253-18.13,11.8-3.03,1.882-7.07,1.676-9.97,3.632h-2.72c2.21-4.643,18.96-15.39,23.57-19.977h0.9V57.207c-29.32,6.538-40.28,17.923-60.72,31.782-4.7,3.194-10,3.983-13.59,8.172h-2.72c2.72-8.305,13.82-10.281,19.94-15.437,0.98-.823.04-2.709,0.9-3.632,1.38-1.475,4.67-1.537,6.35-2.724,9.13-6.436,22.51-14.526,29-20.885,3.79-3.715,11.48-3.745,15.4-7.264h1.82V46.31c-7.83.085-16.52,0.1-21.75-1.816V42.678c5.98-2.846,11.97-6.357,16.31-10.9h0.91V30.874c-22.16,5.932-50.66,23.606-67.07,36.322-2.09,1.624-4.74.342-7.25,1.816-0.6,1.211-1.2,2.422-1.81,3.632-4.15,2.457-7.15-.594-11.78,2.724-1.37-1.4-.68-1.675-2.72-2.724V71.736h3.63c0.36-1.865.22-1.75,0.9-2.724-0.52-3.049-1-3.8-2.72-5.448-5.84-1.976-19.1,10.021-27.18,12.713-4.71,1.567-8.31.353-11.79,2.724h-0.9c0.89-3.445,18.13-17.011,21.75-19.069V58.115c-15.49,2.281-26.64,10.383-38.06,16.345-4.34,2.266-8.41,2.446-11.79,5.448h-0.9c1.27-6.175,7.34-7.018,11.78-9.989,7.25-4.851,15.64-10.4,22.66-15.437,4.36-3.137,9.74-3.779,13.59-7.264,1.56-.586.89-0.178,1.81-0.908-4.82-.638-15.73-0.2-19.03,3.632-2.97-.652-2.11-0.928-4.53-1.816V46.31a11.428,11.428,0,0,0,3.62.908c0.96-8.958,12.81-8.09,18.13-12.713,1.48-.91-0.95-2.2-1.81-3.632-6.27.652-19.31,5.187-24.47,8.172l-4.53,5.448c-16.36,8.382-31.811,15.2-46.221,25.425-0.687.977-.569,0.839-0.907,2.724-4.159.58-9.257,2.137-11.781,4.54h-0.906c0.971-2.528,1.846-5.768,2.719-7.264,2-4.763,7.014-3.579,10.875-6.356,2.2-1.586,3.388-5.376,5.437-7.264V55.391c-12.334,4.113-31.5,13.051-41.687,19.977-3.278,2.228-9.737.595-12.688,2.724H927.75c3.182-4.793,9-5.085,12.687-9.08,1.511-1.639,3.271-6.465,5.438-8.172,5.063-3.989,11.8-5.515,16.312-9.989h0.907V49.943c-17.837,4.5-33.586,15.669-50.75,21.793v0.908h-0.907V71.736h-1.812C918.036,64,928.278,59.1,935.906,52.667h0.906c-1.07-2.41-1.766-1.891-2.718-4.54-3.256.389-4.74,0.771-6.344,2.724-1.372-1.4-.681-1.675-2.719-2.724V47.218h3.625V44.494c7.211-3.509,16.931-8.209,22.656-13.621h0.907V29.966h-0.907V29.058c-8.66.781-15.494,5.066-21.75,8.172-3.571,1.773-6.629.337-10.875,1.816-9.665,3.368-20.143,10.5-29.906,14.529-12.092,4.995-24.113,6.2-36.25,10.9-5.932,2.3-11.174,7.381-17.219,9.989-4.033,1.74-11.268,1.019-14.5,3.632h-4.531c4.494-6.477,13.335-10,19.938-14.529l4.531-5.448c13.522-9.824,28.5-17.494,43.5-25.425,5.879-3.108,11.767-8.2,19.031-9.988V21.793a5.539,5.539,0,0,1-1.812-1.816c-15.459,2.712-39.822,20.078-52.563,28.149-8.1,5.133-14.481,13.264-27.187,13.621a14.319,14.319,0,0,0-1.813-6.356c4.588-2.744,12.31-5.385,16.313-9.08h0.906V44.494c-5.356.93-8.887,4.222-13.594,6.356V49.943c-0.339-.144,9.616-6.871,11.781-8.172V40.862c-6.263,1.046-10.026,4.7-15.406,6.356a9.915,9.915,0,0,0-2.718-1.816c1.229-8.348,13.579-9.871,18.124-15.437h1.813V29.058c-14.514,1.319-23.267,9.461-33.531,14.529-4.129,2.039-9.486.925-12.688,3.632h-5.437V46.31c6.591-3.357,10.335-9.247,16.312-12.713V30.874c-20.6-4.128-42.875,20.184-52.562,27.241-6.174,4.5-12.9,6.523-18.125,11.8h-1.813c1.154-7.562,11.626-9.9,16.313-12.713,0.013-.011,1.8.009,0.906-0.908h-0.906c1.79-2.964,5.295-3.448,8.156-5.448l1.812-3.632,2.719,0.908c1.45-1.172,2.944-4.47,4.531-5.448h3.625c2.4-1.808,3.771-6.455,6.344-8.172,6.946-4.636,16.223-7.59,21.75-13.621h1.813c-1.164-.8-2.237-0.841-4.532-0.908V18.161c5.877-2.821,11.54-6.46,19.032-7.264V9.989h-0.907V9.08c-9.806.247-18.536,3.845-23.562,9.08h-1.813V17.253c2.455-1.217,4.752-2.445,6.344-4.54h1.813V11.8c-2.589.329-3.914,0.6-5.438,1.816h-2.719V12.713c6.656-1.789,14.477-7.408,19.032-11.8H804.5V0c-10.519,2.209-20.139,4.739-28.094,9.989q-1.359,1.816-2.719,3.632C759.9,20.6,746.969,26.187,734.719,34.506c-1.2.817-2.148,2.957-3.625,3.632h-3.625c-8.071,4.873-9.261,14.19-21.75,8.172a10.657,10.657,0,0,0-1.813-4.54c3.369-2.646,14.526-5.49,19.031-8.172V30.874c-7.614.351-28.965,10.728-29.906,12.713h-1.812c1.228-4.931,9.408-8.106,13.593-9.988V32.69h0.907V31.782C678.2,32.8,658.741,52.949,641.375,64.471c-2.84,1.884-7.335,1.662-9.969,3.632h-1.812c2.643-5.488,10.5-8.348,15.406-11.8,6.538-4.608,13.316-10.975,19.937-15.437,1.826-1.23,4.506-.444,6.344-1.816,1.545-1.153,2.819-4.306,4.531-5.448l5.438-1.816,0.906-2.724h4.531a38.96,38.96,0,0,0,9.969-6.356h0.906V20.885c-5.073.366-14.9,1.7-18.125,4.54-2.915-.792-1.4.493-2.718-1.816h-1.813c2.788-2.242,5.879-2.49,9.063-4.54,5.311-3.42,10.3-8.972,15.406-12.713V4.54c-6.351.739-9.181,5.384-14.5,7.264-4.039,1.428-6.161.353-9.969,1.816-3.423,1.315-6.4,5.009-9.062,6.356-5.385,2.724-8.619,2.615-13.594,5.448-6.234,3.55-17.412,12.542-23.563,12.713-0.958,1.052-.641,2.816-1.812,3.632l-8.156,2.724c-1.574,1.217-2.8,4.407-4.532,5.448-3.573,2.152-5.158-1.614-7.25-.908a21.14,21.14,0,0,1-1.812,2.724c-2.257.741-6.646,0.459-9.969,2.724h-7.25V52.667c8.865-4.286,17.385-8.777,25.375-13.621V33.6c-9.75,1.359-17.971,6.413-26.281,9.08-6.036,1.938-9.071.781-13.594,3.632-5.566,3.509-13.031,9.907-19.937,11.8-2.069.568-6.493-1.778-9.969-.908-2.612.654-16.214,3.883-18.125,5.448H521.75V61.747c4.58-2.423,11.51-8.727,13.594-13.621h0.906V46.31c-19.03-3.117-36.063,15.309-48.031,23.609-4.52,3.135-10.656,4.383-14.5,8.172h-4.532V77.184c11.948-5.838,25.716-18.569,38.063-27.241,6.817-4.788,13.652-7.283,20.844-11.8l1.812-3.632c3.318-2.451,7.907-2.757,10.875-5.448h0.906V28.149c-5.458.215-10.332,1.908-13.593,4.54-1.862-.362-1.747-0.225-2.719-0.908h-0.906c1.024-2.249,2.557-3.339,4.531-4.54V24.517a15.6,15.6,0,0,0-5.438,4.54h-4.531V28.149h0.906c4.839-6.229,16.8-6.526,22.657-11.8H543.5V14.529c-7.578.3-23.291,5.112-29,8.172-2.165,1.161-4.22,5.284-6.344,6.356-12.87,6.5-24.809,11.52-35.344,19.977-7.465,5.993-18.762,7.8-24.468,15.437-2.805-1.528-3.559-5.881-3.625-9.988H442c0.343-3.051.183-1.892,0-5.448-3.1.462-6.315-1.115-10.875,0-5.355,1.31-9.459,3.816-16.313,4.54,2.277-8.34,15.394-9.991,21.75-14.529,1.536-1.1,1.978-3.346,3.625-4.54V32.69c-28.788,3.8-45.986,20.475-65.25,33.6-4.639,3.16-12.863,8.644-17.218,10.9-3.586,1.855-6.4,1.221-9.063,3.632h-3.625V79.908c12.391-6.481,23.844-16.054,34.438-24.517,4.472-3.573,9.648-5.065,14.5-8.172,5.127-3.284,10.315-8.462,15.406-11.8l5.437-1.816V30.874c2.073-1.87,11.565-2.888,15.407-6.356h1.812V22.7c-4.646.592-15.324,2.424-18.125,5.448h-2.719a9.107,9.107,0,0,1,4.532-5.448c-1.55-.815-2.1-0.005-3.625-0.908-1.564-.586-0.887-0.178-1.813-0.908,8.522-2.693,14.144-9.226,20.844-13.621V5.448c-13.2,5.584-23.9,10.259-36.25,16.345-4.926,2.427-10.377,8.306-15.406,10.9-9.786,5.04-17.671,8.465-26.282,14.529-0.686.977-.569,0.839-0.906,2.724-3.448.62-11.248,5.176-14.5,7.264l-4.531,6.356c-14.613,7.693-31.832,8.315-42.594,18.161h-1.812V79c8.438-4.11,13.789-11.273,21.75-15.437,6.942-3.631,16.394-3.732,22.656-8.172,3.171-.79-0.394-0.819,2.719-1.816V52.667c-15.841,3.423-37.708,9.418-56.188,19.069-5.192,2.712-16.773,3.644-22.656,9.081C255.873,79.871,295.639,51.631,294,51c0.1,1.889-54.968,30.159-59,33-3.6,2.536-6.284,3.387-12.031,4.989-0.724-.9-0.492.463-1.625-1.816-1.083-2.663-.1-0.34.656-4.172,18.6-9.466,12.536-8.093,83.1-49.363-0.1-.94-40.726,12.976-40.726,12.673h0.906C265.281,46.008,304,23.3,304,23c-19.019,3.184-88.437,49.014-92.188,50.552-5.45,2.936-8.656,6.725-15.406,6.356M796.344,19.069h1.812v0.908C796.567,19.4,797.276,19.8,796.344,19.069ZM204.562,38.138h1.813v0.908C204.785,38.473,205.5,38.871,204.562,38.138Zm944.308,9.081a10.736,10.736,0,0,0,2.72,1.816V47.218h-2.72Zm-183.964.908h1.813v0.908C965.129,48.462,965.838,48.859,964.906,48.126Zm-1.812.908h1.812v0.908C963.317,49.37,964.026,49.767,963.094,49.035ZM734.719,51.759q-0.453,1.362-.907,2.724h0.907c1.026-1.4.983-.765,1.812-2.724h-1.812Zm-130.5.908v1.816l2.718-.908V52.667h-2.718ZM195.5,57.207m164.937,2.724a8.618,8.618,0,0,1-3.625,2.724v0.908h1.813c1.57-1.566,2.522-1.361,3.625-3.632h-1.813ZM355,63.563l-0.906,1.816C355.674,64.108,355,63.563,355,63.563Zm-4.531,1.816L349.562,68.1h1.813a5.537,5.537,0,0,1,1.812-1.816V65.379h-2.718ZM469.187,67.2c-1.265,1.821-1.219,1.876-3.625,2.724v0.908h1.813A8.618,8.618,0,0,1,471,68.1C470.075,67.373,470.752,67.781,469.187,67.2Zm-123.25,1.816v1.816h1.813V69.012h-1.813ZM629.594,69.92c-2.806,3.354-9.2,3.4-9.969,6.356h3.625a26.5,26.5,0,0,1,8.156-5.448C630.481,70.1,631.158,70.505,629.594,69.92Zm96.969,0c-1.718,1.381-3.254,1.624-6.344,1.816v1.816h0.906l-0.906,1.816h0.906c1.623-1.91,5.075-3.3,7.25-4.54C727.45,70.1,728.127,70.505,726.563,69.92Zm-262.813.908-0.906,1.816C464.424,71.373,463.75,70.828,463.75,70.828Zm-202.094,4.54H260.75m199.375-2.724c-1.027,1.4-.983.765-1.813,2.724h1.813a5.539,5.539,0,0,1,1.812-1.816C461.012,72.822,461.689,73.229,460.125,72.644Zm-122.344.908c-1.456,2.332-3.209,2.263-4.531,4.54h2.719c1.588-1.983,3.308-2.072,4.531-4.54h-2.719Zm-107.844.908h1.813v0.908m222.938,0.908c0.925,0.73.248,0.322,1.812,0.908C455.575,76.454,456.252,76.862,454.688,76.276Zm611.722,0.908V79h1.81V78.092C1067.61,77.789,1067.01,77.487,1066.41,77.184Zm-816.535.908c2.332,0.885,2.028.77,0.906,2.724C248.358,79.282,250.525,79.864,249.875,78.092Z"/>
						</svg>';
				break;

			case '54':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 124">
							<path style="fill:'. $c1 .'" d="M1369.74,0.05c7.75-.145,16.14-0.162,21.33,2.413v0.4h-1.16c-1.25-.708-5.59.569-7.37,0.8-7.15.946-15.03,2.425-20.55,5.229l-16.68.8c-4.88,1.173-10.86-.5-16.29.8-9.42,2.256-23.92-.187-32.19-1.207V8.5q12.99-2.011,25.99-4.022c8.07-1.939,16.61-1.021,24.43-2.816Zm-90.36,8.045c0.22,0.287.56,0.017,0.39,0.8h-0.39c-0.14.126-.5,1.346-1.16,0.8C1278.6,9.168,1278.99,8.631,1279.38,8.095Zm-42.27.8c4.11-.055,10.18-0.786,13.57.4v0.8c-18.88,2.148-38.59,7.072-59.34,7.24-6.25.051-20.24,1.665-24.43-1.207a1.48,1.48,0,0,1-.39-0.8l15.9-2.413c4.38-1,8.83-.308,12.8-1.207,6.71-1.518,13.84-.185,20.17-1.609,3.81-.86,10.58-0.59,14.35-0.8C1231.93,9.177,1235.61,9.879,1237.11,8.9Zm31.41,2.413h0.78v0.4h-0.39a4.378,4.378,0,0,1-1.17.8v-0.8A1.334,1.334,0,0,0,1268.52,11.313Zm-137.29,7.24H1132c-0.12.268-.25,0.536-0.38,0.8l-1.17.4Zm14.35,0h0.77v0.4h-0.38a4.544,4.544,0,0,1-1.17.8v-0.8A1.334,1.334,0,0,0,1145.58,18.553ZM1661,20.967V143.648H-2V50.732c4.856-.053,12.387.245,17.064-0.8,4.377-.982,10.069.471,13.962-0.4s9.011,0.36,12.411-.4h8.92L72.85,47.916h8.92c6.54-.231,16.271.189,22.493-1.207l53.52-1.207c7.676-1.707,18.923,1.336,26.76-.4,5.583-1.238,13.492-.4,19.78-0.4,5.443,0,12.306-.661,17.064.4h21.331l51.968,2.414,86.486,7.24,23.269,1.207c4.7,1.053,10.309-.358,15.513.8,7.9,1.765,18.942.8,27.924,0.8,7.351,0,15.615,1.536,22.494,0h21.718c10.357,0,21.255-.385,31.026-0.4,6.167-.011,13.928.82,19.391-0.4,6.107-1.366,13.769.856,19.392-.4l32.965-.4c4.14-.928,10.113.635,14.737-0.4,4.017-.9,9.85.607,14.35-0.4,3.646-.818,9.056.524,13.186-0.4,3.4-.763,8.527.469,12.41-0.4,10.838-2.431,25.617.819,36.456-1.609l137.679-4.022h10.083l18.616-.4c4.6,0,10.409.479,14.349-.4l55.072-.4c10.2-2.3,23.237.657,33.353-1.609h8.532c6.928-1.563,15.605-.064,22.494-1.609h6.981l105.1-7.643c4.51-1.024,9.76-.074,14.74-1.207,13.99-3.178,30.18-.857,44.21-4.022,5.21-1.175,10.76-.135,15.52-1.207,6.93-1.562,14.73-.122,21.33-1.609h5.43c7.45-1.684,16.53-.323,24.04-2.011l37.23-1.609c5.81-1.3,12.69.613,19.01-.8,3.15-.708,7.99.414,11.63-0.4,3.54-.795,8.63-0.16,12.8-0.4,4.81-.279,11.88-0.351,16.68-0.8,8.61-.816,17.67.971,25.59-0.8l25.21-.4c4.39-.982,10.64.688,15.51-0.4,5.94-1.329,14.73-.8,20.95-0.8,4.12,0,9.32.376,12.8-.4,5.73-1.285,12.97.774,18.22-.4h20.95c6.53-1.459,15.61-.344,22.88-0.4,12.11-.1,25.66-0.4,38.39-0.4l83.39,0.4Zm-573.21,1.207h0.78l-0.39.8c-0.39.134-.78,0.268-1.16,0.4C1087.28,22.978,1087.53,22.575,1087.79,22.173ZM-2,38.263V29.413C39.645,29.5,78.932,27.4,121.329,27.4l53.908,0.4,98.508,3.62c11.059,2.481,24.992-.466,36.067,2.011,2.9,0.648,6.895-.137,9.308.4,2.9,0.648,6.895-.138,9.308.4h10.084c9.871,2.21,21.884-.608,31.8,1.609h12.411c6.148,1.374,15.328.8,22.106,0.8h7.756c6.489,1.448,15.133-1.153,22.107.4,4.058,0.905,10.012.4,14.737,0.4h29.475l210.977,0.4c3.474-.776,8.674-0.4,12.8-0.4h34.9c6.744-1.509,16.176-.4,23.657-0.4h6.981l127.983-3.62,56.235-4.827c6.858-1.552,15.186-.859,22.106-2.413h5.042c3.354-.751,7.408.052,11.247-0.8,10.044-2.241,27.394-1.484,36.064.8V27h-0.38c-3.65,3.287-11.64,2.3-17.07,3.62-12.35,3.014-26.725,2.319-39.557,5.229l-13.574.4c-5.919,1.331-12.946-.642-19.391.8-3.153.708-8-.413-11.635,0.4-4.387.984-10.642-.69-15.513,0.4-5.844,1.31-14.968.459-20.943,0.8-8.358.483-18.355-1.309-25.984,0.4h-7.369c-8.319,0-18.812-1.293-26.372.4h-6.981c-7.96,0-18-1.214-25.209.4l-38.394.4c-3.771.845-9.32-.55-13.574,0.4-5.358,1.2-13.377.8-19,.8H713.928c-3.708.83-9.21,0.4-13.574,0.4l-15.9.4h-9.308c-7.229,1.616-16.72-1.321-24.433.4-5.811,1.3-14.032.4-20.555,0.4l-34.129.4h-51.58c-3.943.878-9.745,0.4-14.35,0.4H501.4c-9.253,0-23.651,1.424-31.8-.4H440.122c-6.218-1.4-15.175-.8-21.718-0.8h-7.369c-6.429-1.446-14.6.709-21.33-.8-2.536-.571-6.677.277-9.7-0.4-2.29-.515-6.148.221-8.92-0.4-10.569-2.377-23.2.356-33.741-2.011l-16.289-.4c-10.528-2.365-23.165.365-33.74-2.011-2.9-.651-6.9.14-9.308-0.4-3.019-.678-7.16.168-9.7-0.4l-23.657-.4c-4.882-1.091-11.7.8-17.065-.4-3.474-.776-8.674-0.4-12.8-0.4H174.073c-4.878-1.086-11.887-.4-17.452-0.4H95.732c-4.483,0-10.139-.455-13.962.4-5.118,1.147-11.655-.637-16.289.4l-19.391.4ZM1048.23,25.391h0.78l-0.39.8c-0.39.134-.77,0.268-1.16,0.4C1047.72,26.2,1047.98,25.793,1048.23,25.391Zm-276.516,144.4H772.1c0.189,1.109-.217.475-0.776,0.805V171h-0.388v-0.8A1.317,1.317,0,0,0,771.714,169.793Z"/>n
						</svg>';
				break;

			case '55':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 80">
							<path style="fill:'. $c1 .'" d="M1358.44,12.6a2.331,2.331,0,0,1,1.43.373h1.44c-0.22.817-.41,0.752,0,1.49v0.373c-2.42.171-7.25,1.226-8.96-.373l-1.08-.373a3.985,3.985,0,0,1,.72-2.236,6,6,0,0,0-.36-1.863c-2.76.018-5.43-.171-6.81,1.863h-1.08V11.112c1.08-.373,2.15-0.745,3.23-1.118-0.66-2.327-3.57-1.866-4.66-4.1h-1.79l-0.36,1.118c0.66,1.034-2.74,2.162-3.23,3.726h-0.35c0.56,1.481,2.23,1.685,3.58,2.236a1.341,1.341,0,0,1-.36.745c-0.31.247-1.12,0.5-1.43,0.745-2.56-.045-2.77.614-3.59,2.236a7.227,7.227,0,0,1-3.94-1.118,1.046,1.046,0,0,0-.36-0.373c0.33-.2,3.45-0.368,4.3-0.745l0.36-.745c-2.64-1.223-4.18,1.059-6.81,0-1.48-.6-2.7-2.323-4.66-0.745-0.8-.482-0.76-0.97-1.07-1.863-1.6.326-2.06,1.131-3.23,1.863,0.05,1.436-.01,1.588.72,2.236l-0.36.745h-3.22c0.36-1.119.45-2.876,1.07-3.726-0.5-.341-2-0.416-2.51-0.745h-0.71V10.74c2.2,0.481,6.13.5,7.88-.745,3.28-.048,3.28-0.295,4.3,1.118a7.99,7.99,0,0,0,2.51,1.118,3.85,3.85,0,0,1,1.07-.745l0.72-3.354c-1.83-.1-4.22-0.895-6.45-0.373-3.02.706-5.33,1.342-7.88,0.745-3.45-.806-4.95,2.055-6.81-0.745-2.86-.163-4.13-0.1-4.66,2.236-2.61-.753-10.76-2.062-12.19.745-1.85-.772-2.44-2.387-4.66-2.981-0.85-.057-1.8,1.18-3.58,1.491a6,6,0,0,0-.36-1.863,19.156,19.156,0,0,0-2.87,2.608,1.9,1.9,0,0,0-.36,1.118h2.51a6.466,6.466,0,0,0,1.44,1.118,7.22,7.22,0,0,1-.36,2.236c-4.97-.09-7.65-1.545-12.9-1.49a3.991,3.991,0,0,0-.72-2.236h-2.15a2.559,2.559,0,0,0,.36,1.491,7.22,7.22,0,0,1-.36,2.236h-1.79a4,4,0,0,1,1.43-1.863,6,6,0,0,0-.36-1.863c-1.69.164-3.7,1.284-5.37,1.118a14.8,14.8,0,0,0-1.08-1.118h-3.94V10.367h-0.36c0.05-1.436-.01-1.588.72-2.236a7.219,7.219,0,0,0-.36-2.236c-5.2.075-10.69,1.417-15.77,0.373V6.641h-0.36a1.922,1.922,0,0,0,.36,1.118V8.5c1.55-.373,3.1-0.745,4.66-1.118V7.759h0.36c-1.43,1.462-6.14,4.008-7.89,2.608h-0.72V12.23l3.59,0.373c-1.1.764-4.8,0.993-6.09,1.118V12.6c-1.11-.538-2.75-1.908-3.59-2.236l-5.02.373c-2.74-.614-7.25.481-10.39-0.373a8.7,8.7,0,0,0-2.51-.745,3.123,3.123,0,0,0,1.08-1.49,8.586,8.586,0,0,0-3.23-1.118V8.876c0.04,0.112,1.11,1.092,1.08,1.118-0.28.984-1.05,1.347-1.08,3.354h-0.36v0.373c-2.36.167-6.15,1.052-7.88-.373h-0.72c0.7-1.543,1.64-1.766,1.79-4.1l-3.22.745a2.559,2.559,0,0,0,.36,1.491V12.23a5.029,5.029,0,0,0-1.8-.373,4.108,4.108,0,0,1-.71,2.608l-0.72,1.118h-6.09c-0.58.34-.42,1.888-1.08,2.236-0.72.38-1.56-.484-1.79-0.373-1.1.531-2.49,2.818-5.02,1.118h-0.71a21.107,21.107,0,0,1,1.43-2.608,4.384,4.384,0,0,0-.72-2.608h-1.07a3.387,3.387,0,0,1-.36,1.863c-0.42.521-.08,0.269-0.72,0V14.838c-0.81-.318-2.37-0.13-2.86-0.745-0.7-.861-0.24-2.706-1.08-3.354-0.44-.335-1.45-0.11-1.79-0.373-0.59-.373.37-0.9,0.71-1.49h3.23c0-1.552.04-2.222,0.72-2.981a6,6,0,0,0-.36-1.863c-2.17-.289-3.84,1.811-5.74.373a12.193,12.193,0,0,0-.71,2.236c-1.58.328-3.45,0.293-4.66-.745-1.05,1.616-.69,2.1-2.51,2.981,0.48,0.8,2.46,1.12,3.23,1.49-0.71,1.356-2.28.852-3.23,1.863h-0.36a8.276,8.276,0,0,0,5.02,1.49V12.23a2.331,2.331,0,0,0,1.43-.373c0.72,0.621,1.44,1.242,2.15,1.863v0.373c-4.93.291-10.87,1.109-13.62-1.863a6.688,6.688,0,0,0-1.07,1.49c-1.25-.095-1.51-0.13-2.15-0.745-0.25.286-.47,0.83-0.72,1.118v0.373h-0.72a4.625,4.625,0,0,0,.36-1.49c-1.38.039-1.82,0.085-2.51,0.745-0.88-.553-0.56-0.156-0.71-1.49-1.09.2-4.1,0.141-5.02,0.745h-0.72c0.13,1.67-.06,1.578,1.44,1.863-1,.669-3.01.459-3.95,1.118a2.331,2.331,0,0,1-1.43-.373h-0.36V15.211h2.15V14.093h-0.36V13.721c-1.49.142-4.66,0.639-5.73,1.491-1.18.861-1.83,2.778-2.51,4.1-2.74.027-4.18,0.58-6.45,0.745,0.37-2.691.88-4.293,1.07-7.08a9.967,9.967,0,0,0-3.22.373,1.414,1.414,0,0,0,.72,1.118c-1.35,2.453-3.34.393-4.3,4.844a2.555,2.555,0,0,0-1.44.745h-1.43a21.69,21.69,0,0,0,0-6.335,1.3,1.3,0,0,1-.72-0.373c-3.06-.088-3.65.678-4.66,2.608h-1.07c-0.25-1.549-.7-1.7-1.08-2.981a29.544,29.544,0,0,0-5.37,1.118l-5.38-.373a12.6,12.6,0,0,0-1.43,1.491c-2.58-.012-3.05-0.994-3.95-2.608h-1.79v1.118c-0.36.124-.72,0.248-1.07,0.373-0.69.361-3.6-.1-5.38,0-3.27.181-9.39,1.642-11.83,0-0.24.286-.47,0.831-0.71,1.118-0.64.3-1.79-.416-2.51-1.118a6.021,6.021,0,0,0-.36,2.981h-0.36v0.373c-3.67-.144-1.71-2.165-3.94-2.236-0.91.571-.77,1.108-0.72,2.608-2.41.5-6.5,0.483-8.96,0.745a5.074,5.074,0,0,0-.36-2.608V15.584h-0.71l-0.72,4.1c-1.61.375-3.83,0.646-5.02-.373-0.46-.322.27-0.684,0.72-1.118,0.5-.271.45-0.12,1.07,0.373h0.72c-0.11-2.361-.66-1.891-1.79-2.981a1.834,1.834,0,0,1-.36-1.118,18.008,18.008,0,0,0,7.17-1.49l0.72-2.236h-0.36V10.367c-3.09.079-11.46,2.154-13.26,4.1h-2.87V14.093a5.312,5.312,0,0,0,2.15-1.49c0.36-.674.09-0.672,0-1.863-2.34-.329-3.85-0.254-5.38,1.118-1.56-.214-1.23-0.445-2.15-1.118,0.32-1.576,1.03-1.644,2.15-2.236V7.013c-2.82.073-3.21,1.014-5.37,1.491-2,.441-5.77-1.352-8.96-0.373-1.36.415-5.49,0.869-6.81,0h-0.72V7.386c1.93-.374,9.39-0.721,10.04-1.118,0.35-.124.71-0.248,1.07-0.373a1.921,1.921,0,0,0-.36-1.118c-0.47-.905.17-0.263-0.71-0.745-1.09-.479-3.76.942-5.02,1.118-1.06.148-2.79-.8-4.66-0.745-0.78.025-2.69,0.849-2.87,0.745a15.307,15.307,0,0,0-1.07-1.49c-1.82-.772-4.59.473-5.74,0.745l-8.6.373c-3,.7-6.725,1.208-9.318,1.863-1.849.468-4.392-.488-5.734,0.373a2.783,2.783,0,0,1-1.434-1.863h-2.508V6.641c-6.691.194-25.744,3.345-29.389-.373a3.714,3.714,0,0,0-1.434,1.863c-2.737-.036-8.921-0.349-10.393.745h-2.151a2.237,2.237,0,0,1,.717-0.745V7.013c-0.976.2-1.348,0.522-2.15,0a15.616,15.616,0,0,0-4.66.373c0.705,1.125,2.506.474,3.584,1.118h0.717V9.249a10.018,10.018,0,0,0-4.3,0c-0.9-1.38-2.3-2.011-2.867-3.726-1.666.053-3.344,1.257-4.659,0.745V5.523h-6.093A2.906,2.906,0,0,1,923.7,5.15V4.032c-1.4-.321-1.936-0.779-2.509.745-2.026.011-1.75-.326-1.792,1.118a17.294,17.294,0,0,1-3.942.373,11.073,11.073,0,0,1,1.792-1.118V3.66a54.941,54.941,0,0,1-20.787,4.1h-3.226c-0.494.159-.946,1.4-1.792,1.118q-0.178-.559-0.358-1.118c-1.273-.531-3,0.26-3.943-0.373h-0.358c1.839-1.288,5.538-.42,7.168-1.863A1.842,1.842,0,0,0,894.31,4.4a78.822,78.822,0,0,0-18.995,2.608c-2.056.487-5.311-.16-6.809-0.373L857.4,8.131h-12.9c-1.019-.289-2.455-1.885-3.943-1.491-1.772.47-4.936,1.764-6.809,2.236-2.036.512-2.7-.733-4.659-0.745-3.771-.023-7.883.42-11.469-0.373-2.19-.484-6.1.4-7.168,0h-0.717a9.809,9.809,0,0,1,.717-1.863h-0.359V5.523a8.667,8.667,0,0,0-2.867.373,1.944,1.944,0,0,0,.359,1.118c-1.2,2.291-2.348-.421-4.66.373-0.7.242-1.935,1.4-2.867,1.49,0,0-6.982-2.477-7.168-2.608a5.678,5.678,0,0,0-4.3,2.608,7.1,7.1,0,0,1-3.942-1.118h-0.717V9.249c-2.093.072-5.088,0.923-6.451,0h-0.717c0-1.858.055-2.246,1.075-2.981V4.778c-2.3-.531-3.878-1.166-6.809-1.118,0.076,2.662.84,2.662,1.075,4.844l-4.3-.745c-0.744.279-1.893,1.578-2.867,1.863-2.231.652-4.7-.8-6.451-0.373-0.762.187-1.856,1.279-2.509,1.49-2.975.966-4.436-1.736-6.451-1.49-2.09.255-9.291,2.1-10.752,1.49q-0.18-.559-0.359-1.118c-0.515-.29-9.21-0.981-10.035-1.118-1.037-.172-1.565.59-2.15,0.745-3.153.839-12.44,0.009-13.978-1.118-1.609.128-1.725,0.15-2.15,1.49-1.432-.295-1.3-0.7-2.509-1.118-1.021-.37-2.033,1.22-4.3.745-0.827-.173-3.456.047-4.659-0.373-1.055-.368-1.284-1.229-2.867-1.49V8.5H695.4V8.876c-1.333.56-2.668,0.569-4.3,1.118-1.831.615-16.16,1.7-17.92-.373-0.729.213-.906,1.276-1.434,1.49-0.219.089-5.376,0-5.376,0-3.04-.4-7.117,1.522-8.96.373h-0.717c1.336-1.135,3.769-1.422,5.376-2.236a5.42,5.42,0,0,0-.358-1.491,1.277,1.277,0,0,1-.717-0.373c-2.011.235-.79,0.487-2.15,1.49-0.715,1.564-.663-0.683-2.151.373q-0.178.559-.358,1.118h-0.359c-0.685,0-.846-1.2-2.15-0.745-1.222.428-1.33,1.192-2.867,0.745,0.129,1.551.17,1.583,1.075,2.236-1.584,1.271-4.053,1.331-5.734,2.608a4.02,4.02,0,0,1-2.509-.745l1.075-3.354H635.9a7.08,7.08,0,0,0-.358-2.236c-1.227.422-.721-0.062-0.717,1.118-0.915.308-3.509-.2-4.659,0.373-0.635.314-1.117,1.739-1.792,2.236-0.532.464-3.419-1.1-5.376-.745l-2.868,1.118c-2.212.28-5.544-.964-7.526,0.373a12.758,12.758,0,0,1-3.942-.373,1.945,1.945,0,0,1,.358-1.118V11.485c4.066,0.12,4.255-.692,6.093-2.608V8.131c-4.533-.224-7.749.245-10.752,2.236a3.336,3.336,0,0,0,.358,1.863c-1.49,3.214-8.087,1.745-9.677,2.981-2.027.028-4.621,0.151-6.092-.373,0.129-1.551.17-1.583,1.075-2.236-0.313-1.2.194-.575-0.717-1.118-1.174-.464-2.033,1.093-3.584,0a3.132,3.132,0,0,1-1.434-1.118V9.249c2.153,0.9,6.645.856,9.319,1.118V10.74h0.358v2.236a3.716,3.716,0,0,0,1.792-.745c-0.279-1.415-.4-1.056-1.075-1.863h0.358V9.994c0.972,0.5,1.329,1.658,1.792,2.608h1.792c-0.159-2.953-1.75-4.842,0-6.335V5.523h-2.15a3.337,3.337,0,0,1-.358,1.863V8.131c-3.719-.451-7.394-0.021-11.469,0V6.268C581.2,6.335,580.8,7.7,578.2,8.131q-0.18-1.677-.359-3.354h-1.075c-0.155.879-.278,3.019-0.717,3.726V8.876a1.849,1.849,0,0,1-.358-1.118c-2.762-.492-6.009.362-9.677,0.373V5.523c-1.856.06-2.158,0.328-2.867,1.491a7.768,7.768,0,0,1-3.943-2.236c-1.826.19-1.571,0.564-2.508,1.49a10.108,10.108,0,0,0,1.433,4.471v0.373c-2.41.6-7.1-.146-9.318,1.491h-3.226a14.982,14.982,0,0,1-.358-3.354H544.87V8.876c-1.83.221-2.438,1.168-3.942,1.49l-7.168-.745a2.565,2.565,0,0,0,.717,1.863,1.355,1.355,0,0,1-.359.745c-0.426.27-6.143,0.793-6.809,0.373a4.879,4.879,0,0,1-1.434-2.236h-1.792a2.592,2.592,0,0,1-.358,1.491c-0.5.754-4.806,0.657-6.451,1.118-2.008.562-9.529,0.762-11.828,0.373-1.9-.322-2.938,1.354-5.376.745-1.9-.475-6.5-1-8.96-0.373-3.193.812-7.992,0.142-10.752-.373-1.846-.344-4.248.745-6.809,0.745H455.987c-5.116,1.3-9.454-1.255-14.336,0-3.958,1.018-11.337.662-12.9,0l-4.659.373q-0.18-.559-0.359-1.118c-0.632.96-8.177,0.645-10.035,1.118-4.222,1.075-10.488.3-14.336,1.491-1.551.478-3.816-.928-4.3-0.745-0.4.152-1.283,1.316-1.792,1.49-2.233.765-3.341-.238-5.734,0a5.453,5.453,0,0,0-.359-1.49l-2.15-.745c-0.636.973-.733,0.936-0.358,2.236-1.269-.241-1.214-0.255-1.792-1.118-0.39-.353-0.043-0.942.358-1.491,0.629-1.02,1.914-.535,2.867-1.118h0.359c-0.472-.852-0.771-0.58-1.434-1.118a1.842,1.842,0,0,1-.358-1.118c2.494,0.027,4.459.571,5.734,1.863a12.439,12.439,0,0,0,.717-2.236c1.169-.25,3.659-0.452,4.659-1.118a6.708,6.708,0,0,1,.717,1.49c1.877-.279,1.43-0.937,2.509-1.863,0,0,0-.747.358-0.373l0.358,0.745c2.024,0.6,3.263-.619,5.018-0.745a3.336,3.336,0,0,0,.358,1.863,1.7,1.7,0,0,0,1.076.373c0.455-2.423,2.041-1.833,3.584-2.981a3.717,3.717,0,0,1,1.433,1.863c2.719-.179,3.835-1.109,6.81-1.118a1.944,1.944,0,0,1-.359,1.118,5.711,5.711,0,0,1-.716,1.49,1.787,1.787,0,0,1-1.076-.373,3.726,3.726,0,0,0-1.792.745V12.23a1.389,1.389,0,0,0,1.076-.745h0.716v1.491c1.835-.22,2.374-0.748,4.66-0.745,0.712-1.53,1.688-1.98,2.15-3.726a7.674,7.674,0,0,0,4.3-1.118c0.819,0.456.768,0.928,1.433,1.49a7.929,7.929,0,0,0-.716,2.608c2.639-.105,7.624-0.311,8.96.373h1.075a7.09,7.09,0,0,0-1.792-1.863c0.553-.972,2.643-1.387,3.942-1.49V9.622h-1.075V9.994h-0.358a6.035,6.035,0,0,0,.358,1.863h1.434V9.622c3.6-.431,3.055-2.309,8.6-2.236V7.013h0.359a1.944,1.944,0,0,0-.359-1.118V5.15c-2.771.086-5.375,1.1-6.809,0h-0.359c0.779-1.256,3.828-1.052,5.018-1.863,2.894-.016,2.6,1.212,3.225,3.354h2.151c0.107-2.582.889-2.924,1.075-5.217-2.641.186-3.559,1.923-5.018,0.745-4.628-.17-7.36-0.454-8.96,2.608-2.358-.031-4.418-1.647-6.809-0.745-0.581.219-1.224,1.224-1.792,1.49-2.514-1.057-25.345-1.566-27.955-.745-2.566.806-9.821,0.355-10.752-.745-2.292.136-2.341,0.915-3.943,1.49-0.736.645-2.272-1.688-4.3-1.118-2.762.776-15.112,1.784-17.561,0-1.467.408-1.2,1.054-2.151,1.863-0.669.316-1.52-.437-2.867,0-0.441.143-.885,1.067-1.433,1.118h-0.717c-0.651-.173-0.849-1.029-2.151-1.118l-3.584.373c-0.425-.085-1.484-0.864-2.15-0.745a15.961,15.961,0,0,1-2.15,1.118c-1.439-.027-1.844-2.278-4.3-0.373-1.153-.663-0.967-1.4-2.509-1.863-0.175-.062-0.054-0.508-0.717-0.373-0.511.1-1.88,1.623-2.509,1.863-2.553.975-6.331,0.522-8.96,1.118-1.3.3-2.724-.185-3.584,0.373H325.53V7.386L328.4,6.268V5.9h0.358V5.523h-6.093a3.337,3.337,0,0,1-.358,1.863c-0.673.31-.836-0.623-2.15-0.373-4.909.937-9.506,1.828-15.053,1.118a4.038,4.038,0,0,1-.717,1.863c-2.837-1.019-9.638-1.824-12.544.373a1.842,1.842,0,0,1-.358-1.118,10.525,10.525,0,0,0-2.509-.373V9.994c-1.414.5-6,2.137-6.81,2.236-0.69.083-1.7-.637-2.15-0.745-1.9-.456-5.1.067-6.451,0.373l-7.527-.373c-0.4.177-.91,1.3-1.433,1.491-3.5,1.256-16.149-.354-19.354-0.745v1.49H244.89v0.373c-4.112,1.631-8.29-1.409-13.261-1.49,0.62-1.071,1.91-.836,2.867-1.491,2.718,0.03,6.487.372,8.6-.373V10.367h0.358c-2.537-1.913-9.759-1.235-13.261-.745V9.994h-0.358c0.132,1.535-.086,1.389,1.075,1.863-0.786.588-2.4,0.562-3.226,1.118a3.725,3.725,0,0,1-1.792-.745c0.874-.619,2.445-1.018,3.226-1.491V9.994c-2.7-1.23-6.234.119-8.96,0v4.472a5.47,5.47,0,0,0-2.867.373,9.989,9.989,0,0,1-3.226-.373l-0.358-.745c0.917-.375,3.044-0.529,3.942-1.118h0.717V10.74c-2.518.516-6.483,0.835-7.885,2.608-0.662.469,0.05,0.183,0.359,0.745a2.237,2.237,0,0,0-.717.745c-2.318-.053-7.348.392-8.6-0.745h-0.358c0.977-.671,4.514-0.641,5.734-0.745V12.975a1.848,1.848,0,0,0,.359-1.118,3.66,3.66,0,0,1-2.151-.745V9.994c-2.753.293-1.625,1.193-2.867,1.863-1.788.964-3.97,0.01-5.376,1.118-0.945.651-.5,0.025-0.358,1.118H185.037c-0.891-.21-3.592-1.664-4.659-1.118a3.839,3.839,0,0,1-1.434,1.49c-1,.285-13.023-1.113-14.694-1.49h-4.66c-1.054-.368-1.284-1.228-2.867-1.491v1.491c-2.032,1.008-2.284,2.035-3.584,3.726-1.162.794-2.955,0.591-3.942,1.491-2.474-.1-2.153-0.843-3.226-2.236a6.061,6.061,0,0,1,.359-1.863c1.181-.033,2.567-0.089,3.225.373a8.019,8.019,0,0,0,4.3-.745c-0.805-.556-2.291-0.219-3.226-0.745a31.2,31.2,0,0,1-2.867-2.236c-1.483.351-.618,0.039-1.075,1.118a13.451,13.451,0,0,1-3.942.745,1.033,1.033,0,0,1-.359.373c0.532,0.921.443,0.692,1.792,0.745-0.589,1.53-1.963,1.806-2.867,2.981-2.1-.05-2.78-0.537-3.584-1.863-1.752.267-1.618,0.6-1.434,1.863h-2.867c0.307-.247,1.125-0.5,1.434-0.745a4.989,4.989,0,0,0,.358-2.608h0.359V12.975c2.576,0.107,3.618.757,6.451,0.745V11.857c-3.058-.094-6.439-1.719-8.96,0-1.893.078-4.146,0.282-5.018-.745-0.583-.432.076-0.475,0.359-1.118-1.142-.209-2.35.971-3.584,1.118h-0.359c-0.629-.035-1.809-1.286-2.509-1.49-2.491-.727-4.513.31-6.092-1.118h-0.359V8.131l6.451-.745V6.268c-3.376-.4-6.051.332-9.676,0.373a1.944,1.944,0,0,1-.359,1.118,8.323,8.323,0,0,1-.358,2.608c-3.8.722-4.3-1.679-7.527-2.236a2.237,2.237,0,0,1,.717-0.745V6.641C100.8,6.727,97.939,7.732,94.72,8.5c-4.23,1.014-8.2-.349-11.11-0.745-1.156-.158-0.95.581-1.434,0.745H77.158c-1.556.278-4.105,0.387-6.451,0.745-2.643.4-11.712,2.377-13.619,1.118-0.4-.237.526-1.13,0.717-2.236H55.3a16.222,16.222,0,0,0-2.15,2.236H52.787V10.74a3.754,3.754,0,0,0,2.151-.373h1.075V10.74c-0.964.548-2.893,0.8-3.942,1.491H51.354c0.408-2.326,1.428-2.577,1.434-5.589,2.507,0.032,4.488-.235,5.734-1.49H58.88V4.778c-4.025-.026-6.262-0.06-9.318.745L48.486,2.169A1.214,1.214,0,0,0,47.77,1.8c-0.238.7-.494,2.28-0.717,2.981-2.054.388-3.2-.484-5.018-0.745C38.252,6.565,33.078,5.664,28.416,5.15c-1.954-.215-4.041,3.465-7.168.745-0.883-.638-0.157-0.012,0-1.118a7.515,7.515,0,0,0-1.792-.745c0.3-1.272.178-.948,1.075-1.49V2.169c-1.984.009-2.167,0.24-2.867,1.491-2.434-.174-5.687-0.807-8.6-0.373a4.151,4.151,0,0,1-2.15.373c-0.468-.111-2.978-1.637-3.226-1.49C-0.186,4.458,1.4,1.78-4.008,3.287-4.008,3.287-3,63.034-3,87.5H1600V23.409c-1.25-.038-2.87-0.126-3.58.373-2.06-.11-2.18-0.866-2.87-2.236h-2.15v1.491h-0.36v0.373c-2.22.4-4.31,0.211-5.38,1.863a7.116,7.116,0,0,1-.71-1.49c-2.13.162-2.5,0.549-3.59-.745-4.41-.169-3.32,1.291-4.66,4.1a1.262,1.262,0,0,0-.71.373,6.934,6.934,0,0,1-5.02-3.354c-2.33-.031-4.4.1-5.73,1.118a3.736,3.736,0,0,1-1.8-.745V23.781c0.78-.256,1.06-0.477,1.8,0a7.4,7.4,0,0,0,2.5-.373V21.918c-1.97.054-3.96,0.13-5.01-.745a5,5,0,0,0-1.44.373c-0.26,1.145-.7,2.26-0.36,2.981a32.022,32.022,0,0,1-2.86,1.863v0.373c-1.16.543-6.1-1.27-8.25,0.373-1.65-.346-2.65-1.879-3.58-2.981-2.4.343-6.55,2.047-9.32,1.491-1.06-.214-1.17-1.483-1.79-1.863s-4.95.086-5.73,0V22.664h0.35c2.07-1.671,7.84-.961,10.4-1.863a1.045,1.045,0,0,1,.36-0.373c-2.99-2.233-8.21-2.731-11.11-.373a4.907,4.907,0,0,1-1.44-.373,21.87,21.87,0,0,1-.72-2.981c-3.08.215-3.9,2.3-5.01,4.471-4.65-.047-13.12.105-14.7,1.491h-5.73a1.341,1.341,0,0,1,.36-0.745,5.637,5.637,0,0,0-.36-1.49c-1.65.281-4.9,0.753-6.81,1.118-2.04.388-3.88-1.229-5.38-.373h-0.36V20.428a6,6,0,0,0,2.87-1.118h0.36c-0.56-.97-1.38-0.818-2.87-0.745,0.7-.564,2.1-0.6,2.87-1.118h3.58c-0.77.138-.12,1.65,0,1.863a6.582,6.582,0,0,0,1.08,1.491c0.75-.448,1.38-1.863,1.79-2.608,1.47,0.046,3.77.24,4.66-.373h0.72V17.074c-1.19-.584-3.11-1.84-5.02-1.491-1.01.186-2.49,1.04-3.94,0.745a75.767,75.767,0,0,0-17.56-1.118c-0.01,1.858.05,2.246,1.07,2.981a1.922,1.922,0,0,1-.36,1.118c-0.83.7-1.98,0.794-3.58,0.745V18.565l-3.23.373a6,6,0,0,1,.36-1.863,7.577,7.577,0,0,1,2.51-.745,3.921,3.921,0,0,0,.72,1.863,4.99,4.99,0,0,0,1.79-2.981c-2.21.058-4.88,0.249-6.09-.745-1.26.695-.86,1.312-2.87,1.491,0.22,2.882,1.69,2.71,2.15,5.217h2.15c-2.65,1.736-12.82-.209-15.77-0.373a3.776,3.776,0,0,0,.72-1.863c-1.79-.273-4.06-0.738-5.38.373a2.986,2.986,0,0,1-1.79-.373h-0.36V18.565a11.962,11.962,0,0,0,2.87-1.118h0.36a1.6,1.6,0,0,0-1.08-1.118,19.161,19.161,0,0,1,1.43-3.726,15.651,15.651,0,0,0,2.51-.745h0.36c-0.65-1.037-2.7-.749-3.58-1.491a1.313,1.313,0,0,1-.36-0.745,16.918,16.918,0,0,1,5.02-.745c-0.48-.905.16-0.263-0.72-0.745-0.69-.354-1.47.386-2.87,0-4-1.108-3.26-.611-7.52,0V8.876a5.438,5.438,0,0,1,2.86.373h1.44c-0.66,1.344-2.97,1.691-4.3,2.236,0.31,1.2-.2.575,0.71,1.118,0.79,0.316.41,0.29,1.08-.373a1.772,1.772,0,0,1,1.07.373c0.39,0.466-.46,1.3,0,2.236a2.9,2.9,0,0,1-1.79.373,1.342,1.342,0,0,0,.36.745,5.378,5.378,0,0,0,2.87.373c-1.42,1.327-5.49,2.043-7.17,0-0.66.96-.32,1.639-1.43,2.236v0.373h-0.72V17.447a5.4,5.4,0,0,0-1.79.373,1.922,1.922,0,0,0,.36,1.118v0.745a7.308,7.308,0,0,1-4.31-1.491V16.329c-2.72.12-4.72,1.68-5.73,0.745a6.347,6.347,0,0,0-2.15.373,1.341,1.341,0,0,0,.36.745c0.74,0.476,1.01.239,1.79,0a1.342,1.342,0,0,1-.36.745c-0.79.514-2.06,0-3.22,0.373a17.136,17.136,0,0,1-1.8,1.118c-2.05.236-5.55-2.089-7.52-1.863-2.25.257-3.31-.974-4.66-0.745-1.09.184-3.93,1.262-5.02,1.49-1.26.266-1.56-.572-2.15-0.745l-11.83-.373-0.36-.745c-1.65-.5-3.49.623-5.01,0.373l-0.36-1.118a15.661,15.661,0,0,0,2.51-.745h0.71V15.211a17.478,17.478,0,0,0-6.81-1.118m-3.58.373h2.15c-2.49,1.88-7.93-1.34-9.68,1.863-3.58-.831-8.07-1.461-10.03-3.354h-0.36"/>
						</svg>';
				break;

			case '56':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 80">
							<path style="fill:'. $c1 .'" d="M628.985,18.568c2.033,0.234,1.653,1.108,3.861,1.287-0.191-1.2-.428-1.061-0.643-2.252h0.643c1.636-.994,7.127.2,9.01,0.644a37.44,37.44,0,0,0,9.653,1.287l5.47-.643c1.526,0.572,2.807,2.022,6.113,1.287,1.921-.427,5.973-1.4,8.688-0.643,2.742,0.766,5.072,3.328,9.975,2.252,2.119-.465,5.069-0.221,7.078-0.965,0.489-.181,1.434-1.187,1.931-1.287,0.759-.152,1.814.925,3.218,0.643a16.2,16.2,0,0,1,8.044.322c3.12,0.946,7.782-.416,10.3-0.965a6.217,6.217,0,0,1,2.574.322h14.48V20.5h2.574a5.7,5.7,0,0,1,.643.965h0.644c0.9-.015,1.872-1.43,2.574-1.609,1.068-.272,2.433.768,3.218,0.965,3,0.754,7.207-.177,9.653-0.644V19.855c-0.93-.5-1.624-0.709-1.931-1.931,1.908-.035,2.167-0.088,3.861,0,0.56,1.064.692,1.736,2.253,1.931,1.94,1.311,6.985,1.158,9.009.322V19.855H762.2V18.568c1.509,0.051,4.2.307,5.148-.322a6.631,6.631,0,0,1-1.931-1.287V15.994h3.218v0.322c-0.41.425-1.045,3.213-.965,5.792a7.413,7.413,0,0,1,4.5.644c0.726-1.142,1.257-1.326,3.218-1.287,0.885,0.943,11.324.55,13.192,0q0.162-.322.322-0.643c1.2,0.248,3.566,1.428,4.827,1.287,7.453-.832,16.493.575,23.488-0.965,2.449-.539,5.169.421,7.079,0.644l3.218-.965c1.317-.048,1.062.639,1.931,0.322a2.788,2.788,0,0,0,.321-1.609c4.651,0.015,10.137-.038,14.8.965h7.723l3.217-.965c2.362,0.115,4.7.943,7.4,0.643-0.213-1.287-.63-1.412-0.965-2.574h2.9v0.322h0.321c-0.069,1.621-.105,2.363.966,2.9,1.512,0.968,5.5.033,7.079-.322,2.224-.5,4.231.754,5.791,0.643,3.207-.227,4.053-2.282,6.114-2.9,1.825,2.612,7.887.822,11.583,1.609,2.31,0.492,6.018.509,8.044-.322a19.43,19.43,0,0,1,1.931-1.287c0.768-.145,4.418,1.051,5.47,1.287l11.9-.643c3.106,0.7,5.171,2.21,9.332,1.287,1.658-.368,5.307-1.844,7.078-1.287,0.7,0.219,1.238,1.378,1.931,1.609,2.413,0.8,3.082-1.313,4.5-1.609l2.252,0.322a30.875,30.875,0,0,0,7.4-.644c1.8-.418,3.636.362,4.826,0.644a30.689,30.689,0,0,0,12.549,0c1.963-.458,9.037.222,10.94,0.643h7.079c0.384-.123.114-0.7,0.965-0.643,1.12,0.077,1.682,1.779,3.218,1.287,0.287-.092,1-1.173,1.287-1.287h20.274c0.44,0.151.95,1.165,1.28,1.287,2.27,0.822,4.74-2.211,6.12-2.574,1.68-.442,4.01,1.342,6.43.643,1.46-.419,1.86-1.949,2.58-2.252,1.2-.51,5.27,1.02,6.75.322a2.348,2.348,0,0,1,2.26-.965v0.322h0.32c-0.22.536-.43,1.073-0.65,1.609h1.94c0.46-.248,9.16.981,12.22,0.322,7.72-1.661,17.51-.4,24.78-1.931,1.64-.344,3.61.384,4.82,0.643,1.86,0.4,3.26-.362,4.51-0.643v0.965c-3.49,1.75-11.65,2.613-17.38,2.252-2.33-.147-3.94-0.718-6.75,0-3.03.774-6.07,2.325-9.01,2.9-1.04.2-6.38-2.253-9.66-1.287-2.81.829-7.7-.237-11.26,0.643-2.92.723-7.22,0.855-10.62,1.609h-21.88c-3.77.854-9.341,0.358-13.51,1.287h-3.861A43.941,43.941,0,0,1,975.2,26.291v0.643h0.322c2.958,3.566,7.014,1.315,11.905,2.574,2.464,0.634,7.929.141,11.262,0.644h5.147c0.8,0.215,2,1.346,2.9,1.287,1.56-.1,3.46-1.135,5.47-1.287,0.52,1.126.79,1.673,2.25,1.93V31.761h0.32V30.8c4.28,0.035,8.08-.352,11.91-0.643V30.8h-0.33v0.322h0.33a2.358,2.358,0,0,0,1.93.644,2.1,2.1,0,0,1,1.61-.965,8.366,8.366,0,0,0,3.86,1.931c0.66-1.616.79-2.578,3.21-2.574a16.859,16.859,0,0,0,.65,2.574h0.96c0.5-.483,1.55-0.724,1.93-1.287,0.37-.533.3-1.454,0.65-1.931a24.013,24.013,0,0,0,5.15,2.574,2.745,2.745,0,0,1,2.25-1.287c0.97,1.211,1.2,1.939,3.54,1.931,1.58-1.153,3-.133,5.15,0,0.72-1.142,1.25-1.326,3.21-1.287,3.66,3.239,8.9-1.854,10.94-1.609a28.459,28.459,0,0,1,4.51,1.287v0.644c1.2-.185,3.03-1.245,4.5-1.609a13.661,13.661,0,0,1,5.15.322c3.8,0.917,8.07-.574,10.3-1.287,3.28-1.052,8.53,1.518,9.97-1.287a5.69,5.69,0,0,0-1.61-.965,5.43,5.43,0,0,1-1.61.965h-0.32l-3.21-.643c-0.79.141-2.01,1.063-3.54,0.643h-0.33c-0.53-.643-1.07-1.287-1.6-1.931-1.22-.653-2.11.376-3.22-0.322h0.32c2.91-2.549,19.18-1.522,26.06-1.287,23.79,0.811,42.65,1.229,63.71,1.287v1.287a5.986,5.986,0,0,0,3.86.965,20.606,20.606,0,0,1,.97-2.252c2.37,1.523,4.68-.226,6.43-0.643,1.6-.379,4.68.96,6.12,1.287,3.31,0.751,5.6-1.185,8.36-.644,0.44,0.086,8.03.721,8.37,0.644,0.84-.191,1.96-0.985,3.54-0.644,6.11,1.318,11.58,1.93,18.02.965,3.28-.492,6.03,1.225,8.36.965,1.2-.133,2.48-1.313,3.54-1.609h5.15a58.145,58.145,0,0,0,10.62-.644V25a6.906,6.906,0,0,0-2.25-.322c-2.3,1.43-9.62.189-11.59-.322l-9.01-.322c-0.2.064-.84,0.929-0.96,0.965-1.8.55-2.41-1.564-3.86-1.287-0.9.171-1.39,1.371-2.9,1.609a28.232,28.232,0,0,0-3.54-2.574V21.464c2.61-.152,3.89-0.178,5.47,1.287,1.76-2.447,13.08-.255,16.41-2.574-5.35.036-11.94,0.611-16.73-.322-0.11-.215-0.21-0.429-0.32-0.643a5.954,5.954,0,0,0,1.29-.965c1.28-.011,1.5-0.514,2.57,0,0.11,0.322.21,0.643,0.32,0.965a0.443,0.443,0,0,0,.64-0.322c1.44-.282,2.98-0.663,4.19-0.965h4.82c1.57-.455,1.98-1.827,3.54-2.252a4.28,4.28,0,0,0,1.93,1.287c3-2.807,8.31-2.916,14.16-2.9v1.609a6.208,6.208,0,0,1-4.18.965c-2.08,1.672-7.89,0-9.33,2.252,0.21,0.107.43,0.215,0.64,0.322,1.95,1.493,5.76-.831,7.08,0a2.137,2.137,0,0,1,.32,1.287h-0.64c-2.2,1.3-6.68.365-8.69,1.931h0.64c3.13,2.833,6.16-.319,9.01,0,1.56,0.174,4.13,1.238,6.44.643,1.24-.319,2.14-1.652,3.86-1.287,1.93,0.41,4.29,1.849,6.76.965,2.11-.758,2.5-2.606,5.47-2.9,0.81,0.64,1.86.875,2.57,1.609l3.54-.965c0.32-.2.39-1.108,0.64-1.287s2.18,0.919,3.22.643c1.63-.431,2.67-1.242,5.15-1.287V18.89a9.314,9.314,0,0,1-2.57,1.931,1.1,1.1,0,0,0,.64.322,9.165,9.165,0,0,0,1.61.644,7.011,7.011,0,0,1-.65,1.609c2.46,0.208,4.49-.574,7.4-0.643,0.29,0.771.25,1.193,0.97,1.609,1.78-1.118,7.21-1.29,9.65-.643,0.48,0.126,1.05.872,1.93,0.643,0.5-.128,1.12-1.119,1.61-1.287l4.83,0.322h13.51c1.17,0,2.84.436,3.54,0.322,0.86-.139,1.65-1.008,2.9-0.965,4.12,0.141,10.36,3.242,14.16.322a1.668,1.668,0,0,0,.32-0.965,1.273,1.273,0,0,1-.65-0.965c1.84-.377,1.69-1.221,4.19-1.287V20.5a2.137,2.137,0,0,0-.32,1.287c2.81,1.491,2.15,2.319,7.07,2.252,1.26,0.919,2.93.125,4.51-.322V22.429h0.96c0.62,1.183.73,1.835,2.58,1.931,0.81-.544,2.63-0.619,3.86-0.643-0.2-1-.48-0.794.64-1.287,0.85-.6,3-0.324,3.86,0V21.142c-2.88-1.223-3.3.283-5.47,0.965-1.64.517-5.42-.97-6.75-1.287-2.33-.555-3.49.663-5.47,0.322a2.834,2.834,0,0,0-.97-0.965V19.212c1.2-.133,4.36.475,5.47,0,0.11-.322.22-0.644,0.32-0.965,1.04-.5,3.58.621,5.15,0.643,0.66-1.547.87-1.993,3.22-1.931a2.173,2.173,0,0,1,1.29-.322v0.322h0.32a4.136,4.136,0,0,0,.32,2.252,2.173,2.173,0,0,0,1.29.322c-0.19-1.2-.43-1.061-0.65-2.252a0.972,0.972,0,0,0,.33-0.322c3.01,0,3.77-.9,6.75-0.965V17.6a13.216,13.216,0,0,1-3.86.322v1.287a10.686,10.686,0,0,1,4.18,3.218c2.32,0,2.94-.671,4.83-0.965a10.264,10.264,0,0,1,.32-2.252c1.73-.977,3.65-2.559,5.47-3.218v0.322c1.35,0.968.85,2.685,1.93,3.861,0.9,0.971,1.98.5,2.58,1.931a2.138,2.138,0,0,1,.32,1.287c2.74,0.154,5.05.4,5.47-1.931,2.41,0.212,5.01.437,7.08-.322v2.252c2.29-.053,8.41-1.813,9.33-1.609,0.94,0.21,2.03,1.7,2.9,1.931,0.8,0.215,2.03-.526,2.57-0.644l6.11,0.322c0.22-.07.83-0.919,0.97-0.965l4.5,0.643c4.91,0.455,9.6-.491,13.52.322,1.55,0.323,2.19-.557,3.54-0.643,2.43-.156,4,0.55,5.79.643,3.25,0.17,7.21-2.109,10.29-.643,0.46,0.214.73,1.01,1.29,1.287a5.278,5.278,0,0,1,4.51-2.252v1.287l0.96,0.322c1.43,1.025,3.26.379,4.83,0,0.22-.743.21-2.886,0.64-3.539,1.29-.837,5.15-0.364,7.08-0.322,1.38,0.887,6.36.678,8.69,0.643V19.855a1.917,1.917,0,0,1-1.29-1.609l3.22-.322a12.32,12.32,0,0,1-.65,2.252h7.73a3.467,3.467,0,0,1,1.93-.322c0.11,1.394.21,2.789,0.32,4.183h3.22a9.229,9.229,0,0,0,.32-2.9,3.413,3.413,0,0,1-.32-1.93,25.955,25.955,0,0,0,6.11-.644v0.644c-0.53.48-.33,0.233-0.32,0.643,0.79,0.6,2.49.615,3.54,0.965v0.965a58.539,58.539,0,0,1,7.4-.644,5.831,5.831,0,0,0,.32-1.93,13.385,13.385,0,0,1-4.18-1.931V16.316a26.451,26.451,0,0,0,7.72-.965c0.17-.049,2.15,1.166,2.57,1.287,3.73,1.068,9.49-.266,12.88.644,2.76,0.744,4.12-1.311,7.07-.644,4.62,1.044,10.86.929,16.09,0.965,2.02,0.014,3.07,1.231,4.51.965,1.32-.243,3.65-1.208,5.15-1.609,3.29-.88,6.65,2.448,10.61.965v3.861c-1.2.293-1.35,0.3-1.61,1.609-2.45-.085-2.4-1.114-3.86-1.609l-5.14.322a1.982,1.982,0,0,1-.65.644v0.643h0.65c1.86,1.429,7.7,1.238,10.61,1.287V81.956H-6.5V16.316a10.074,10.074,0,0,1,3.218.322V15.994H-3.6V15.672H-6.5v-4.5A54.241,54.241,0,0,1,5.405,12.455h9.653c2.174,0.5,4.846,1.421,6.757,1.931l8.366-.322a1.556,1.556,0,0,1-.322.965c-0.554.479-1.622,0.53-2.252,0.965,1.259,0.206,1.171.492,2.574,0.643a1.861,1.861,0,0,1,1.609-1.287,3.681,3.681,0,0,0,2.9,1.287V14.707a5.053,5.053,0,0,1,1.609-.322,1.16,1.16,0,0,0,.644.322v0.644c-0.36.474-.672,0.982-0.322,1.287,1.019,1.262,1.87.542,3.539,1.287,1.133,0.506,1.361,3.038,3.861,2.252,2.273-.714,1.268-2.454,5.47-2.574a9.7,9.7,0,0,0,0,3.539h0.644V20.821L51.1,20.5V18.89c1.853,0.139,3.938.771,4.5,2.252a2.377,2.377,0,0,1,.644,1.931c6.308-.768,11.333.9,17.7,0.965-0.341-1.722-1.237-1.5-1.609-3.218h0.322V20.5c3.156,0.781,3.183,2.7,7.079,2.252V24.36l2.252,1.609,9.009,0.965c-1.241-1.956-3.669-1.084-3.861-4.183a9.3,9.3,0,0,1,2.9-.322c1.068,1.034,5.292,1.559,7.722.965,0.543-.133,1.87-0.851,2.252-0.965h3.861l0.644-.965c1.6-.827,3.576-0.417,5.148-1.287,0.663-.367.654-0.932,1.609-1.287v0.322c0.588,0.5.449,0.284,0.643,1.287a18.316,18.316,0,0,1-4.826,1.931v0.322h0.322a2.781,2.781,0,0,0,1.608.322c1.229-1.12,5.412.874,7.4,0.644,3.276-.38,7.12-2.018,10.3-2.574,0.871-.153,2.254.54,2.895,0.644,2.293,0.37,5.362-.235,7.723-0.322a10.017,10.017,0,0,1,.965-1.609,4.588,4.588,0,0,0,1.609,1.287c0.7-2.7,1.883-1.683,2.9-3.218a2.516,2.516,0,0,1-1.287-2.252h0.321V15.351c1.826,0.047,4.484-.456,5.149-1.609-0.822-.82-0.876-1.583-2.253-1.931-0.9.6-3.374,0.363-4.826,0.322V11.489c2.012-.681,1.961-1.992,2.9-2.574h6.113c0.991,0.616,2.776-.029,4.183.322,0.713,0.178,2.05,1.21,2.574,1.287h0.644c0.276-.063,1.225-1.162,1.609-1.287h4.5l1.287,2.252,0.966-.322c0.454-1.921,1.4-2.059,3.861-1.931l2.574,0.965a5.058,5.058,0,0,1,.322,1.609,3.448,3.448,0,0,1-2.253.965c-1.362.817-3.957-.13-5.791,0.322-3.574.879-7.787,1.777-11.584,2.574v0.322c1.054,1.078,1.174,1.356,3.54,1.287,1.464-1.171,3.764-1.323,6.435-1.287v0.643a2.788,2.788,0,0,0-.322,1.609h0.322c1.466-.878,5.184-0.57,7.079-1.609V16.316H167.9a1.556,1.556,0,0,1,.322-0.965,2.171,2.171,0,0,1,1.287-.322v1.609a48.451,48.451,0,0,0,5.47.322v0.322H175.3v0.965c2.772-.079,5.627-0.122,8.366,0V17.6a1.753,1.753,0,0,1-.965-1.287h2.895c0.5,0.93.71,1.624,1.931,1.931a1.161,1.161,0,0,1,.644-0.322c0.283-.771.244-1.193,0.965-1.609,2.645,1.762,9.114.965,13.192,0.965h6.757l0.966,1.287a14.873,14.873,0,0,0,2.9.644c2.39,0.429,5.962-.774,8.045-0.965v1.93h-0.322V20.5c-5.933-.011-11.744.546-18.341,0.643-1.954.029-2.918,1.076-4.826,0.644-0.459-.1-1.595-0.866-1.931-0.965h-9.009c-6.46,0-15.622-1.006-20.915,0v0.643h0.644c1.306,0.8,3.775-.264,5.47.322,4.257,1.471,16.087.965,21.558,0.965h6.435c2.067,0.489,4.7,2.053,7.722,1.287a17.393,17.393,0,0,0,2.253-1.287l9.653,0.322c2.2,0.488,5.318.814,7.4,1.287,2.408,0.547,3.511-1.276,5.47-.643,1.057,0.341,1.525,2.217,3.54,1.609,0.747-.226,1.356-1.439,2.252-1.609a14.614,14.614,0,0,1,3.218.643A49.888,49.888,0,0,0,254.773,25c4.27-.4,7.037-1.011,11.583,0h6.436c1.241,0.429,1.6,1.6,3.217,1.931,0.17-.95.214-1.5,0.966-1.931,1.833-1.163,6.429-.061,8.044.322,3.334,0.791,7.409-.743,9.653-0.322,2.645,0.5,4.434,1.384,7.078,1.287L302.716,25c3.185,1.445,7.146.53,10.94,0.322,0.525,1.542,1.793,1.4,3.861,1.287,3.133-3.291,5.115.015,7.4,0,1.537-.01,4.127-0.952,5.47-1.287,1.967-.49,9.044.893,10.618,1.287h0.322V26.291c2.114-.736,3.921-0.4,6.435-0.322a5.528,5.528,0,0,1-.644,3.218h0.644c2.735,2.164,9.971.71,12.87,0a1.974,1.974,0,0,1,.644-0.643V27.578a1.554,1.554,0,0,1,.965.322h0.322v0.965c3.269,0.045,5.89.921,9.009,0.322V28.865c-0.758-.305-4.139-1.036-4.5-1.609h0.321V26.934l2.9-.322,2.9,0.965c0.948-.114,3.043-1.016,4.183-1.287h9.653v0.643a1.162,1.162,0,0,0-.322.643,8.058,8.058,0,0,0-1.608.644h0.321v0.322a5.054,5.054,0,0,0,1.609.322c1.025,0.715,3.735.01,4.505-.643a1.162,1.162,0,0,1-.322-0.644c-0.771-.283-1.193-0.245-1.609-0.965,1.484-.506,4.118-0.346,6.114-0.322,2.27,2.835,6.535,1.734,10.3,1.609,1.523-.05,2.128.658,2.9,0.322a5.087,5.087,0,0,0,.322-2.574h2.252v0.322c-0.7.856-.795,1.287-0.322,1.609,3.467,2.243,8.039.76,12.871,0.322h9.01c0.523-.169,1.4-1.128,1.93-1.287,1.556-.47,2.2.85,3.218,0.644,0.839-.17,1.436-1.642,2.252-1.931,1.72-.608,4.04.578,4.827,0.644,1.217,0.1,3.947-.694,5.148-0.965,4.734-1.069,9.756.065,13.514-1.609V22.429c2,0.052,2.619.619,3.861,0.965,2.146,0.6,3.805-.6,5.792-0.643,6.882-.14,14.107.246,18.662-2.252,2.254,0.248,2.737,1.4,5.47.322l0.322-.965h-0.644c-1.844-1.151-4.18.55-5.791,0.322-2.07-.293-5.517-1.23-7.4-1.609-1.312-.264-2.533.726-3.539,0.965h-6.114a1.557,1.557,0,0,0-.322-0.965c-1.236-1.24-2.855-1.352-5.47-1.287-3.568,2.363-7.493.37-11.9-.644h-5.792c-1.113-.436-3.74-2.061-5.791-1.609-0.679.15-1.268,1.378-1.931,1.609-3.613,1.259-8.211-1.056-10.618-1.609-1.756-.4-2.517.727-3.54,0.965l-9.009-.965-18.984-.322c-1.9-.416-5.1.181-7.4-0.322-2.35-.514-6.464-1.265-9.331-0.644-2.147.466-5.305,1.126-7.722,0.322-0.728-.242-1.269-1.3-2.253-1.287a42.516,42.516,0,0,0-6.113,1.287c-4.3.974-8.728-1.338-12.227-.643-1.867.371-5.152,1.131-7.4,0.643a49.033,49.033,0,0,0-15.123-.643c-4.124.383-8-.8-11.583,0-3.927.876-7.728-1.182-10.619-.965-7.86.59-17.045-1.277-23.167,0-2.225.464-4.176-1.064-4.826-.965-4.7.71-14.033,1-21.88,0.965l-8.044-.322c-0.819-.218-2-1.143-3.218-0.965-1.147.167-2.986,1.152-4.826,0.644a3.938,3.938,0,0,0-.966-0.644c-0.743-.053-0.9.539-1.287,0.644-1.4.377-2.267-.47-2.9-0.644-1.966-.542-2.648,1.15-4.5.644l-0.322-.644c-0.833-.165-1.414.6-2.574,0.644a45.96,45.96,0,0,1-11.262-.965c-5.139-1.153-10.9,1.628-15.123.643-3.7-.862-7.921,0-12.87,0-4.344,0-7.965-.792-11.906-0.965V10.2h0.322c1.755-2.35,9.594-1.287,13.514-1.287,3.587,0,7.874.2,10.94,0.322,1.049,0.042,2.739-1.479,3.861-.965q0.162,0.483.322,0.965H230c3.325,0.863,6.693-.849,10.618,0,6.652,1.439,16.013.348,23.167,0.322,5.882-.021,9.817,1.286,15.767,1.287l14.157-.322c0.766-.163,4.739-0.983,5.47-0.644q0.162,0.483.322,0.965l6.757-.644a31.949,31.949,0,0,0,6.114-.965c1.678-.353,2.786,1.055,4.183.965,1.863-.119,5.355-0.817,7.722-0.322,2.006,0.42,3.783-.819,6.114-0.322a19.5,19.5,0,0,0,6.113.643l3.861-.643c0.893,0.3,2.088,1.67,3.218,1.931l5.792-.965h20.914a29.308,29.308,0,0,0,8.045,1.287c0.538-.921.528-1.122,1.93-1.287,3.241,1.985,16.6,1.261,22.2,1.287,4.684,0.021,8.857-.093,12.87.965,1.618,0.427,3.321-.565,4.5-0.322a11.529,11.529,0,0,1,1.287.965l3.861-.643a9.354,9.354,0,0,1,2.9.643c0.72,0.144.935-.556,1.287-0.643,1.585-.392,2.379.563,3.54,0.643l3.217-.643c1.489,0.242,4.64,1.22,6.114,1.609l9.009-.322c3.227,0.728,6.84-.253,10.94.644,2.273,0.5,5.546,1.052,7.723,1.287,1.6,0.173,2.521-1.469,4.826-.965,3.264,0.714,7.7.826,11.262,1.609h9.653c4.04,0.89,9.23.67,13.514,1.609,3.429,0.751,7.724-.95,10.618-0.322l2.9,0.965c0.958-.1,2.387-1.254,3.861-0.965,0.518,0.1,1.8.864,2.253,0.965,1.929,0.426,7.807-.88,9.652-1.287,1.972-.434,4.1.335,5.47,0.644,2.346,0.526,5.284-.283,6.758-0.644,1.92-.469,4.3.228,5.47,0,1.931-.378,4.744.748,5.47,0.644,0.455-.066,1.16-1.137,1.608-1.287,2.65-.884,6.654.65,8.366,0.644,3.071-.012,7.175-1.457,10.94-0.644,3.9,0.842,8.553-.287,12.871.644a11.579,11.579,0,0,0,4.183.322,56.979,56.979,0,0,1,20.271,0c2.748,0.55,5.41-1.669,9.009-1.287v0.644A2.164,2.164,0,0,1,628.985,18.568Z"/>
						</svg>';
				break;

			case '57':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 97">
							<path style="fill:'. $c1 .'" d="M790.6,0.795c9.023-.115,18.016.41,25.2,2v0.8h-2c-1.575.962-4.624-.069-6.8,0.4-5.566,1.2-13.385,1-19.2,1.2h-8.4c-6.5,1.4-14.746-.673-21.6.8-5.768,1.24-13.338.8-19.6,0.8H731c-4.017.862-9.882-.568-14.4,0.4-11.454,2.454-24.933-.064-36.4,2.4-2.48.533-6.02-.025-8,0.4H661c-5.952,1.268-24.621.614-28-2a1.44,1.44,0,0,1-.4-0.8h0.8c1.78-1.13,4.248-.244,6.8-0.8,4.679-1.019,11.391-1.1,16.4-1.2h8c7.42-1.6,19.128-.776,27.6-0.8l16.8-.4c4.624,0,10.456.451,14.4-.4,4.006-.864,9.293.357,12.8-0.4h8c4.828-.443,11.307-0.186,16-1.2l20.8-.8C783.64,1.19,788.77,1.934,790.6.795Zm233.6,2c12.47-.164,24.99.691,34.4,3.2v0.4h-18c-2.4,1.468-9.09.331-12.4,0.4-4.66.1-11.4,0.379-16,.8H999.4c-3.507.754-8.793-.461-12.8,0.4-4.867,1.046-12.033.794-17.2,0.8H959c-5.986,1.284-15.469.59-21.6,0.8h-7.2c-4.871,1.042-10.646-.342-16,0.8-5.246,1.119-11.452-.423-17.2.8-4.947,1.052-11.362.8-16.8,0.8-9.6,0-21.821,1.463-30.4-.4-5.207-1.131-10.554.278-14-2.4a1.44,1.44,0,0,1-.4-0.8h2.8c2.135-1.3,10.959-.757,14.4-0.8,9.621-.121,19.486-0.8,29.6-0.8l41.6-.8c8.334,0,18.843,1.231,26.4-.4h11.6c8.457-.472,19.039.164,27.2-1.6l24.4-.8C1016.3,3.193,1022.16,4.065,1024.2,2.795Zm-738.4,3.2c9.6-.118,19.174.112,26.4,2v0.4h-1.6c-1.394-.882-4.6-0.2-6,0a147.628,147.628,0,0,1-15.6,1.2c-19.227.791-38.184,5.043-58.4,5.2-7.9.061-24.286,0.823-27.6-3.2h0.8c1.352,0.862,14.676.158,17.2-.4,11.889-2.628,25.653-.993,37.6-3.6,3.924-.856,8.125-0.044,11.6-0.8C274.118,5.943,283.045,7.745,285.8,5.995Zm280,1.2a61.877,61.877,0,0,1,12.8.8v0.8h-0.4c-2.43-1.5-11.985,1.363-14.4,2l-8,1.2c-7.65,1.972-30.614,5.685-36.8,0,11.779,1.684,24.406-.719,34.8-3.2C557.365,7.944,562.939,9.045,565.8,7.195Zm823.2,2h23.6c4.13,0,9.34-.348,12.8.4,2.98,0.644,6.45-.675,8.4.8l-46.4,2h-7.6c-6.7,0-16.01-.57-22.4.8l-14.8-.4h-36l-116.4-.4L1127.8,14c-6.4,0-21.25,1.077-24.8-1.6h-0.4V12h4c1.52,0.946,14.46.813,17.2,0.4,9.91-1.494,23.76-.8,34-0.8h13.6c5.19-1.121,12.15.136,18-.4,6.56-.6,15.35-0.769,22-0.8h14.4c4.2-.906,10.32-0.362,15.2-0.4,6.39-.049,13.82-0.4,20.8-0.4h110.8C1376.06,9.6,1386.87,10.51,1389,9.195Zm83.6,7.2V14.8c14.68-1.761,31.99-2.4,48.8-2.4,8.36,0,17.55-.571,24.8.8v0.4h-0.4c-4.25,2.806-14.79.709-20.8,2-5.95,1.277-13.07-.6-19.6.8-3.22.691-8.12,0.4-12,.4C1486.12,16.8,1479.71,16.88,1472.6,16.4Zm130,17.2V104H-112.6V20.8H35c5.861,0,13.252.71,18.4-.4H67.8l40.8-1.2c3.126-.669,7.973.375,11.6-0.4C124.962,17.777,131.933,18,137,18h10.4c5.4-1.15,13.085-.4,19.2-0.4,10.15,0,21.79-1.15,30.8.8h6c4.629,1.006,10.493.539,14.8,2v0.4h-0.8c-1.6-1.042-7.184-.624-9.6-0.4-8.123.752-17.878,0.9-24.4,3.6a1.443,1.443,0,0,0,.8.4c2.967,2.075,8.123.29,12.4,1.2,3.466,0.738,8.667.4,12.8,0.4,11.276,0,21.733-.782,32.4-0.8l89.6-4.4H349a56.373,56.373,0,0,1,18.4,0h12.8a55.421,55.421,0,0,0,10.8.8v0.8h-0.4c-1.314-.861-6.329-0.718-8.4-0.4-6.852,1.052-13.009,2.556-19.2,4v0.4c12.093,0.811,26.642,1.2,40.4,1.2h20.4c8.831,1.9,22.589.4,32.4,0.4,19.335,0,39.68.4,59.6,0.4,12.657,0,25.491-.4,37.6-0.4,7.837,0,18.747.687,25.6-.8l16.4-.4c4.734-1.033,10.138-.072,15.2-1.2,4.872-1.086,10.716-1.757,15.2-2.8V22.4c-1.593-.277-3.029-0.588-3.6-2H623c4.489-2.93,16.476-.632,22.8-2,10.948-2.368,24.091-.006,35.2-2.4,2.988-.644,7.111.136,9.6-0.4,3.5-.754,8.2.246,11.2-0.4h12.8c4.123-.888,10-0.237,14.8-0.4,6.138-.209,13.632-0.4,20.4-0.4,19.176-.008,39.787-0.4,59.6-0.4l112.8,0.4c10.454-1.572,23.012-.8,34.4-0.8h17.6c2.616,0.564,6.885-.272,10,0.4l20,1.6v0.8h-4.4c-1.838,1.133-6.955.4-9.6,0.4l-23.6-.4H891c-3.961.848-9.721,0.791-14,.8v0.4h0.4c2.039,1.249,14.221.722,18,.8,13.013,0.27,26.365.8,40,.8L974.6,20c8.009,0.1,17.954-1.158,25.2.4h7.6c7.15,0,16.11-.638,22.8.8l50.4,0.8c3.46,0.746,8.67.4,12.8,0.4l23.6,0.4c21.42,1.2,44.43,1.5,66,1.6l23.6,0.4c5,0,11.29-.526,15.6.4l40.8,0.4,76.4,2,27.2,0.4c3.76,0.811,9.34-.519,13.6.4,3.14,0.677,7.81.271,11.6,0.4,4.18,0.142,11.13-.075,15.2.8,4.26,0.917,9.84-.409,13.6.4,4.39,0.944,10.11-.437,14,0.4H1449c3.63,0.783,9.07-.491,13.2.4,6.42,1.384,17.11.8,24,.8h13.2c4.61,0.994,11.1.22,16.4,0.4,7.31,0.249,16.05.4,24,.4C1561.05,32.4,1582.21,33.526,1602.6,33.6ZM1355.4,15.2c8.52-.113,19.46-1.276,27.2.4,6.83,1.48,15.27-.578,21.6.8,4.64,1.009,12.76-.645,14.8,2.8h-4.8c-2.29,1.406-14.27.771-18,.8-4.01.031-10.19-.019-14,0.8-3.88.834-9.02-.327-12.4,0.4h-14.4c-4.19.9-10.33,0.4-15.2,0.4h-30.4l-96.4-.4h-25.6c-4.38,0-9.9-.4-13.6.4h-12.4c-3.38.718-8.52-.424-12.4,0.4-4.91,1.042-11.79-.748-17.2.4a29.18,29.18,0,0,1-9.6,0c-4.7-1.017-13.22,1.565-15.2-2h0.4c2.26,1.408,13.24.251,16,0l42-.4,83.2-2h16c5.56,0,12.47.3,17.6-.8,3.62-.78,8.47.273,11.6-0.4,3.88-.835,9.02.328,12.4-0.4l34.4-.8C1344.14,15.595,1353.47,16.4,1355.4,15.2ZM547,20.4c7.987-.046,15.553.266,22.8,0.8V22c-3.728.447-8.631,0.791-12.4,1.6-4.409.947-9.206-.055-13.2,0.8-3.371.722-7.929-.214-10.8,0.4-2.895.619-12.633-.176-14-1.2a1.441,1.441,0,0,1-.4-0.8h0.4V22.4c5.478-.564,11.8-1.583,18-1.6C540.024,20.788,545.192,21.544,547,20.4Z"/>
						</svg>';
				break;

			case '58':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 62">
							<path style="fill:'. $c1 .'" d="M777.4,0.282c4.587,0.455,10.493,4.462,15.6,1.128a3.566,3.566,0,0,1-2.228-.564h1.114c2.338-1.308,17.423.011,22.28,0,16.979-.038,32.455-0.635,50.13-0.564V1.41H840.34V1.974c16.478,0.182,34.99.564,52.358,0.564,7.4,0,18.236-1.538,24.508.564V3.665H851.48c-3.3-1.736-14.273.528-18.938,0.564h-9.469V5.357H783.526V4.229c3.669,0.092,11.424,1.082,13.925-.564-7.178.094-26,2.162-30.078-.564h1.114c2.515-1.521,7.727-.119,10.026-1.692C776.992,0.995,777.5,1.816,777.4.282Zm94.69,0H877.1V1.41h-5.013V0.282Zm7.8,0c1.808,0.467.851-.276,1.671,1.128h-1.671V0.282Zm36.205,0a30.972,30.972,0,0,1,6.684.564V1.41h-6.684V0.282Zm-128.11.564a3.566,3.566,0,0,1,2.228.564A3.566,3.566,0,0,1,787.982.846Zm138.693,0c1.411,0.042,2.07.068,2.785,0.564C928.049,1.368,927.39,1.342,926.675.846Zm7.241,0c1.41,0.042,2.07.068,2.785,0.564C935.29,1.368,934.631,1.342,933.916.846Zm26.736,0c2.787-.109,5.23-0.064,6.684,1.128h-6.684V0.846ZM1472.53,13.251V11.56c8.88,0.4,26.41.2,37.88,0.564,6.96,0.223,15.73-.915,21.72.564h27.3c13.16,1.406,33.11,2.808,49.57,2.819v6.766c-2.61-.089-7.27-0.538-8.91.564H1609V64H-62V13.251c3.08,0.09,9.12.779,11.14-.564H-62V8.176h1.114c4.545,2.384,30.628-.083,38.433,0,14.661,0.155,29.3,0,45.674,0H46.615c7.01-1.535,16.8,1.123,24.508-.564,2.144-.469,7.011-1.2,10.026-0.564,5.692,1.2,25.175.89,31.749-.564,9.47-2.1,21.3,1.378,30.078-.564L160.8,6.485c7.068-1.542,20.785-1.562,27.85,0,4.935,1.091,13.759.336,17.824-.564,6.458-1.43,14.843.712,20.609-.564l107.5-1.128c62.986-.014,125.84-1.691,189.937-1.692L649.846,1.41h33.977c3.679,0,10.814-1.036,13.368.564-9.3-.019-19.414-0.148-27.85,1.692-5.833,1.272-20.6.528-25.622-.564-5.8-1.262-16.233-.511-21.166.564L595.26,3.1c-45.449,0-90.338,2.255-135.351,2.256l-65.169.564C386.308,7.729,375.732,4.8,368,6.485c-5.3,1.155-14.5.324-18.938-.564l-6.127.564c-8.221.166-18.384-1.014-25.622,0.564H274.985L146.318,9.868H110.113L69.452,11c-10.645.011-24.865-1.068-32.863,0.564-10.076,2.056-22.406-1.476-31.749.564H-32.479c-3.677,0-10.817-1.037-13.368.564l65.726,0.564c7.092-.242,16.013-0.311,23.951-0.564l5.013-.564c7.474,1.542,35.061,1.988,44,0,5.109-1.136,13.273.583,16.71,0l61.27-.564c6.6,0,14.962.693,20.609-.564l95.247-1.128c6.829-1.5,16.694-.564,24.508-0.564l40.661-.564c5.919-.014,14.638,1.28,19.5.564,5.3-.782,13.529.746,19.5-0.564,2.4-.528,7.867-1.283,11.14-0.564a37.889,37.889,0,0,0,12.811,0l11.14,0.564c6.171-1.331,15.145-.564,22.28-0.564,11.911,0,28.153-1.286,37.319.564l18.938-.564c7.395,1.625,27.88,1.043,35.091-.564l22.28,0.564c11.644-.012,27.963-1.669,38.433,0l4.456-.564c7.434-.4,17.506-0.869,23.951.564,6.346,1.411,17.672.234,22.28-1.128h13.368c3.683,0,10.809-1.034,13.368.564a2.673,2.673,0,0,0-1.671.564c3.961,0.02,5.174-.852,8.355-1.128,0.26,1.618,2.864,1.251,6.127,1.128,0.816-1.424.245-.871,2.228-1.128,0.214,1.475-.414.738,1.114,1.128,1.05-1.235,2.074-1.177,4.456-1.128-0.112,1.936,4.654,1.129,7.8,1.128h23.951c2.357,1.518,8.128.227,10.583,0h30.078c1.746,0.317,13.61.326,17.267-.564h16.153c4.19-2,6.972.727,11.7-.564,3.689-1.008,4.895-1.527,8.355.564,3-.258,6.657-0.815,10.026,0l26.736-.564c7.692,1.8,18.362-1.382,26.736.564,5.063,1.176,13.028-1.517,19.5,0,2.765,0.649,6.644-.6,9.469,0,6.5,1.369,15.012.56,22.28,0.564,8.929,0,20.525-1.35,28.407.564h32.306c16.928,3.966,41.948-2.82,59.038,1.128h14.49c10.82,2.541,26.8.14,37.87,1.128l9.47-.564c13.3,3.089,32.65-.245,47.35.564,16.35,0.9,29.19.563,46.78,0.564l22.28,0.564c1.91-.531,2.28-1.491,5.02-1.692,0.23,1.516,1.38,1.239,4.45,1.128,4.15,2.487,15.52-2.293,18.38-1.128,8.98,3.65,31.78,1.665,46.79,1.692,46.67,0.082,98.35-.57,147.61-0.564v0.564a1.937,1.937,0,0,0-1.12.564h2.23c1.89,1.006,2.58-.587,3.9-1.128,1.61-.66,2.47.063,2.78,1.128,1.8,0.271,1.82-.857,3.9-1.128v1.128a1.9,1.9,0,0,0-1.11.564h2.78ZM708.888,1.41c1.721-.053,3.526-0.079,4.456.564C711.623,2.027,709.818,2.053,708.888,1.41Zm6.127,0c2.5-.088,6.807-0.479,8.355.564C720.872,2.061,716.563,2.452,715.015,1.41Zm28.407,0c1.617-.034,3.046-0.027,3.9.564C745.148,2.232,744.541,3.19,743.422,1.41Zm8.355,0h3.9V1.974h-1.114C753.232,2.89,752.577,2.757,751.777,1.41Zm5.57,0a2.673,2.673,0,0,1,1.671.564h-0.557a2,2,0,0,1-1.114.564V1.41Zm4.456,0h3.9V1.974h-0.557c-0.79.542-1.823,0.551-3.342,0.564V1.41Zm220.015,0c1.617-.034,3.046-0.027,3.9.564C984.1,2.007,982.671,2,981.818,1.41Zm13.368,0h4.456V2.537h-1.671C997.41,2.147,995.744,1.812,995.186,1.41Zm10.024,0h4.46V2.537C1006.72,2.691,1005.29,2.995,1005.21,1.41Zm11.7,0.564a3.577,3.577,0,0,1,2.23.564A3.556,3.556,0,0,1,1016.91,1.974Zm25.62,0h7.24V2.537h-1.11C1047.19,3.673,1043.38,3.444,1042.53,1.974Zm8.91,0h2.79V2.537h-0.56a3.739,3.739,0,0,1-2.23.564V1.974Zm11.14,0a37.956,37.956,0,0,1,7.8.564V3.1h-7.8V1.974Zm-126.993.564a18.755,18.755,0,0,1,4.456.564V4.229h-2.785C935.654,2.952,935.654,4.287,935.587,2.537Zm137.583,0h5.01V3.665h-3.34C1074.41,3.281,1073.59,2.926,1073.17,2.537ZM943.942,3.1h6.127V4.229h-4.456C945.183,3.845,944.37,3.49,943.942,3.1Zm181.578,0h5.57V4.229h-2.22C1128.2,3.791,1126.18,3.554,1125.52,3.1Zm15.6,0h3.34V4.229C1141.62,4.319,1141.23,4.594,1141.12,3.1Zm-139.25.564a3.577,3.577,0,0,1,2.23.564A3.556,3.556,0,0,1,1001.87,3.665Zm2.78,0h10.59V4.793h-10.59V3.665Zm160.98,0a3.6,3.6,0,0,1,2.23.564A3.556,3.556,0,0,1,1165.63,3.665Zm26.18,0h25.06V4.793h-22.28C1194.03,4.4,1192.36,4.067,1191.81,3.665Zm27.29,0a13.074,13.074,0,0,1,4.46.564V4.793C1220.61,4.946,1219.17,5.25,1219.1,3.665Zm-461.753.564h6.127V5.357h-6.127V4.229Zm494.063,0h13.36V4.793h-1.11C1261.38,6.4,1253.06,5.509,1251.41,4.229Zm15.03,0c1.62-.034,3.05-0.027,3.9.564C1268.73,4.827,1267.3,4.82,1266.44,4.229Zm13.93,0c5.65-.076,9.58-0.306,13.92.564V5.357h-11.14C1282.59,4.966,1280.93,4.631,1280.37,4.229Zm33.98,0a3.543,3.543,0,0,1,2.22.564A3.543,3.543,0,0,1,1314.35,4.229Zm8.35,0a23.7,23.7,0,0,1,7.24,1.128V5.921h-8.91c-0.18-.376-0.37-0.752-0.56-1.128A3.556,3.556,0,0,0,1322.7,4.229Zm-230.04.564h2.79V5.921h-2.79V4.793Zm4.46,0c2.1,0,3.83.217,5.01,1.128h-5.01V4.793Zm204.42,0h2.22V5.357h-0.55C1302.02,5.622,1302.63,5.893,1301.54,4.793Zm-195.51.564c1.51,0,2.56.022,3.34,0.564C1107.86,5.925,1106.81,5.9,1106.03,5.357Zm18.38,0c1.93-.074,4.47-0.189,5.57.564l-3.9.564C1125.65,6.1,1124.84,5.745,1124.41,5.357Zm211.66,0c1.81,0.467.85-.276,1.67,1.128C1336.41,6.01,1336.82,6.258,1336.07,5.357Zm8.35,0c1.42,0.042,2.07.068,2.79,0.564A4.644,4.644,0,0,1,1344.42,5.357Zm6.69,0c1.41,0.042,2.07.068,2.78,0.564C1352.48,5.879,1351.82,5.853,1351.11,5.357Zm109.73,0a3.6,3.6,0,0,1,2.23.564A3.556,3.556,0,0,1,1460.84,5.357Zm10.58,0c1.81,0.467.85-.276,1.67,1.128h-1.67V5.357Zm7.8,0c2.16-.083,5.41-0.3,6.68.564C1483.75,6,1480.49,6.223,1479.22,5.357Zm-342,.564a2.662,2.662,0,0,1,1.67.564A2.687,2.687,0,0,1,1137.22,5.921Zm17.27,0c1.41,0.042,2.07.068,2.78,0.564C1155.86,6.443,1155.2,6.417,1154.49,5.921Zm21.16,0H1179V7.048C1176.15,7.139,1175.77,7.413,1175.65,5.921Zm7.24,0h6.13V7.048h-3.34C1185.12,6.658,1183.45,6.323,1182.89,5.921Zm189.94,0a2.662,2.662,0,0,1,1.67.564A2.687,2.687,0,0,1,1372.83,5.921Zm4.46,0h2.78V6.485h-0.55c-0.88.7-.29,0.362-1.12,0A1.868,1.868,0,0,1,1377.29,5.921Zm14.48,0c3.14,0.013,5.76-.042,7.8.564V7.048h-7.8V5.921Zm85.22,0A15.754,15.754,0,0,1,1482,8.176c-6.11.122-10.86,1.855-14.48-.564h-0.56V7.048C1469.98,7.194,1475.8,7.828,1476.99,5.921Zm17.27,0a2.687,2.687,0,0,1,1.67.564A2.662,2.662,0,0,1,1494.26,5.921Zm12.81,0c1.81,0.467.85-.276,1.67,1.128C1506.75,6.8,1507.18,7.4,1507.07,5.921ZM614.2,6.485a2.673,2.673,0,0,1,1.671.564A2.673,2.673,0,0,1,614.2,6.485Zm3.342,0c1.411,0.042,2.07.068,2.785,0.564C618.914,7.007,618.255,6.981,617.54,6.485Zm613.81,0c1.52,0,2.56.022,3.35,0.564C1233.18,7.052,1232.14,7.026,1231.35,6.485Zm16.16,0h1.11V7.612C1247.1,7.2,1247.6,8.019,1247.51,6.485Zm8.91,0c3.42-.028,7.28-0.6,10.58.564V7.612C1263.6,7.746,1256.35,8.358,1256.42,6.485Zm150.95,0c1.61-.034,3.04-0.027,3.89.564C1409.65,7.082,1408.22,7.076,1407.37,6.485Zm5.57,0h11.69V7.612h-6.12C1417.34,6.894,1414.09,7.226,1412.94,6.485Zm17.26,0c5.22-.1,19.22-0.87,22.28,1.128C1447.89,7.716,1432.13,8.582,1430.2,6.485Zm120.31,0h9.47V7.612h-9.47V6.485Zm-282.95.564c1.83-.066,4-0.133,5.01.564C1270.75,7.678,1268.57,7.745,1267.56,7.048Zm18.38,0c1.62-.034,3.05-0.027,3.9.564C1288.22,7.646,1286.79,7.64,1285.94,7.048Zm15.04,0c1.41,0.042,2.07.068,2.78,0.564C1302.35,7.571,1301.69,7.544,1300.98,7.048Zm4.45,0h10.59V8.176h-10.59V7.048Zm12.82,0c0.55,0.188,1.11.376,1.67,0.564V8.176h-2.79V7.612A1.936,1.936,0,0,0,1318.25,7.048Zm166.54,0c2.56-.064,6.19.007,7.8,1.128-2.85.09-8.2,0.658-10.03-.564A3.577,3.577,0,0,0,1484.79,7.048Zm-750.837.564a3.566,3.566,0,0,1,2.228.564A3.566,3.566,0,0,1,733.953,7.612Zm590.977,0c1.83-.066,4-0.133,5.01.564C1328.12,8.242,1325.94,8.309,1324.93,7.612Zm6.68,0a4.644,4.644,0,0,1,2.79.564A4.644,4.644,0,0,1,1331.61,7.612Zm5.02,0h8.35V8.176h-0.56c-0.86.592-2.27,0.581-3.89,0.564C1339.74,8.241,1337.4,8.128,1336.63,7.612Zm11.14,0h2.78V8.74h-2.78V7.612Zm15.04,0,8.35,0.564V8.74h-0.56c-1.63,1.154-8.96.583-10.58-.564A4.644,4.644,0,0,0,1362.81,7.612Zm163.2,0a17.258,17.258,0,0,1,5.57.564V8.74h-12.26V8.176C1521.48,8.259,1524.73,8.479,1526.01,7.612ZM1394,8.176c3.23,1.02,11.07-.708,13.92,1.128-3.39.468-11.96,1.469-15.04-.564A1.9,1.9,0,0,0,1394,8.176Zm140.36,0h23.4V9.3h-13.37C1542.15,7.932,1536.59,9.578,1534.36,8.176Zm37.32,0c3.31-.059,11.99-0.523,14.48,1.128C1582.42,9.422,1571.62,10.083,1571.68,8.176Zm-144.82.564h3.9V9.3h-0.56C1428.33,10.773,1427,9.793,1426.86,8.74Zm139.25,0c1.52,0,2.56.022,3.34,0.564C1567.94,9.308,1566.89,9.282,1566.11,8.74Zm22.28,0c2.05-.079,4.94-0.245,6.13.564C1592.05,9.494,1590.3,10.105,1588.39,8.74ZM1440.23,9.3c1.41,0.042,2.07.068,2.78,0.564C1441.6,9.826,1440.94,9.8,1440.23,9.3Zm10.58,0h4.46V9.868h-0.56c-0.72.495-1.37,0.5-2.78,0.564C1451.51,9.94,1451.22,9.8,1450.81,9.3Zm6.69,0h2.78v1.128h-2.78V9.3Zm15.59,0h1.12v1.128C1472.68,10.017,1473.19,10.838,1473.09,9.3Zm3.34,0h2.23v1.128h-3.9V9.868A2.662,2.662,0,0,0,1476.43,9.3Zm5.02,0a170.013,170.013,0,0,0,17.82.564V11h-10.58c-2.03-1.091-6,.551-8.36-1.128A1.936,1.936,0,0,0,1481.45,9.3Zm-314.71.564a3.556,3.556,0,0,1,2.23.564A3.576,3.576,0,0,1,1166.74,9.868Zm39.55,0h2.23V11h-2.23V9.868Zm20.05,0.564h2.79V11.56h-2.79V10.432Zm27.29,0h2.23V11.56h-2.23V10.432Zm25.63,0h5.01V11h-0.56A3.334,3.334,0,0,1,1279.26,10.432ZM1571.12,11c2.05-.079,4.95-0.245,6.13.564C1575.21,11.639,1572.31,11.8,1571.12,11Zm15.6,0.564a3.577,3.577,0,0,1,2.23.564A3.556,3.556,0,0,1,1586.72,11.56Zm20.61,0a2.662,2.662,0,0,1,1.67.564A2.662,2.662,0,0,1,1607.33,11.56Zm-158.19.564c1.26,0.919,5.98.9,7.24,0h-7.24Zm-888.414.564c3.037,2.671,14.3,1.165,19.5,1.128,11.122-.08,31.35,2.022,42.889-0.564,4.726-1.059,12.529,1.737,16.153-.564C612.7,12.688,586.42,12.722,560.726,12.687Zm88.563,0c-1.972,1.206-6.957-.107-8.912,1.128,4.95,0.077,22.13,1.327,25.065-.564Zm20.609,0c-0.479.366-1.751,0.754-2.228,1.128,6.45,0.08,16,.906,20.609,0,3.153-.62,7.765.88,10.026-0.564C689.207,13.314,678.012,14.289,669.9,12.687Zm252.878,0c-3.686,4.388-25.082,1.763-31.192,1.692v0.564H892.7c4.87,3.053,12.171-.643,17.824.564,7.248,1.548,17.039-.851,25.065.564,12.22,2.154,32.74.4,46.788,0-0.111-1.866,17.37-1.2,21.725-1.128v0.564h-0.56c-2.81,1.873-11.4.428-14.481,0v0.564a1.9,1.9,0,0,1,1.114.564,2.673,2.673,0,0,0-1.671.564h18.938l4.46-.564c3.46,0.585,11.08,2.166,13.92.564-1.65-.468-1.52-0.25-2.23-1.692h4.46c0.72,1.391-.24.384,1.11,1.128,0.26-1.586,2.37-1.25,5.57-1.128,0.41,1.167,1.47.479,2.79-.564h-16.16c-1.42-.383-2.52-1.173-5.01-1.128-1.91.035-4.73-.3-6.13,0-0.57.122-.26,1.221-1.67,1.128-6.44-.425-18.446-1.323-23.947-0.564-10.643,1.468-20.393-2.049-28.407-.564-5.961,1.1-23.755-3.8-28.964-.564,3.3-.121,6.843-0.406,8.355.564a83.659,83.659,0,0,1-13.368,1.128V13.815c1.411-.042,2.07-0.068,2.785-0.564A6.988,6.988,0,0,1,922.776,12.687Zm562.014,0c1.63,1.148,10.06,1.137,11.7,0h-11.7Zm25.62,0a2.223,2.223,0,0,0,2.79,0h-2.79Zm-971.964.564c1.17,0.864,4.956.848,6.127,0h-6.127Zm7.8,0a3.711,3.711,0,0,0,3.9,0h-3.9Zm690.676,0a4.6,4.6,0,0,0,4.46,0h-4.46Zm291.31,0c1.18,0.864,4.96.848,6.13,0h-6.13Zm-821.57.564c1.128,0.837,4.442.819,5.57,0h-5.57Zm7.241,0c1.826,1.186,6.661.564,9.469,0.564h22.837c2.692,0,7.179.559,8.912-.564H713.9Zm45.117,0a1.613,1.613,0,0,0,2.228,0h-2.228Zm6.684,0c-0.561.391-2.227,0.726-2.785,1.128h10.026a1.594,1.594,0,0,1,.557-0.564V13.815h-1.671C770.185,14.946,767.6,14.108,765.7,13.815Zm12.254,0c1.316,1.277,7.489,1.965,9.469.564Zm41.775,0c0.958,0.5.712,0.5,1.671,0h-1.671Zm36.762,0c-0.782.5-3.123,0.612-3.9,1.128,3.583,0.136,6.55.822,8.355-.564h-0.557V13.815h-3.9Zm25.065,0c-0.747.5-3.033,0.824-3.9,1.128v0.564h6.684c1.167-.718,4.413-0.387,5.57-1.128Zm65.726,0a16.759,16.759,0,0,1,3.9.564v0.564h-3.9V13.815Zm325.846,0c2.03,1.386,14.12,1.378,16.15,0h-16.15Zm129.22,0c1.17,0.864,4.96.848,6.13,0h-6.13Zm28.41,0v1.128c4.62,0.093,15.1,1.57,18.38-.564C1443.15,14.438,1435.84,14.831,1430.76,13.815Zm-638.322.564a2,2,0,0,0,1.114.564A2,2,0,0,0,792.438,14.379Zm71.3,0c1.777,1.993,8.619,1.24,12.254,1.128V14.379h-1.671C872.474,15.555,867.06,14.474,863.734,14.379Zm472.9,0a1.6,1.6,0,0,0,2.22,0h-2.22Zm114.74,0c1.26,0.919,5.98.9,7.24,0h-7.24Zm10.02,0c1.75,1.589,6.12,1.228,9.47,1.128V14.943h0.56V14.379h-10.03Zm11.7,0v1.128c3-.054,5.46-0.508,7.24,0V14.379h-7.24Zm10.03,0v1.128c3.21,0.042,8.28-1.231,10.58-.564,2.94,0.851,14.24,2.861,17.82.564-1.82.066-4,.133-5.01-0.564a3.556,3.556,0,0,0,2.23-.564h-25.62Zm-477.35.564c0.56,0.188,1.11.376,1.67,0.564v0.564h-1.67V14.943Zm89.68,1.692v1.692h1.11c0.91,0.4,11.02.794,12.25,0-1.93-.151-3.11-0.3-3.9-1.692h2.79c1.66,2.58,9,2.506,13.37,2.256,6.97-.4,18.47.563,28.96,0.564,3.19,0,9.24.909,10.58-1.128h-10.58c-2.49-1.59-6.52.524-7.8,0a1.9,1.9,0,0,0,1.12-.564h-7.24V16.634c4.58,0.118,10.24,1.521,13.36-.564-5.28.076-12.98,0.906-17.26-.564v1.128a3.6,3.6,0,0,1,2.23.564h-1.12c-2.05,1.474-8.53.6-10.02-.564,2.85,0.134,5.93.352,7.24-1.128-4.1,1.329-8.7-.817-12.81-0.564-1.26.077-1.55,0.93-2.23,1.128h-15.6c-3.67,0-10.82-1.037-13.37.564h8.92Zm402.15-1.692c2.5-.088,6.81-0.479,8.35.564C1503.46,15.595,1499.15,15.985,1497.6,14.943Zm-489.6.564h12.25v1.128h-1.67C1016.2,15.179,1010.35,16.992,1008,15.507Zm35.64,0a4.6,4.6,0,0,0,4.46,0h-4.46Zm5.02,0c2.34,1.839,20.29.565,26.18,0.564,2.57,0,6.72.5,8.35-.564h-34.53Zm102.49,0a4.406,4.406,0,0,1-1.12,1.692h5.57V16.634C1154.55,16.284,1152.19,15.881,1151.15,15.507Zm368.73,0a5.532,5.532,0,0,0,5.01,0h-5.01Zm61.83,0a1.6,1.6,0,0,0,2.22,0h-2.22Zm5.57,0c0.95,0.5.71,0.5,1.67,0h-1.67Zm-315.82,3.947a7.44,7.44,0,0,1-5.02-1.692,2.7,2.7,0,0,0,1.68-.564c-4.53-.692-12.45,0-17.27,0-4.39,0-8.07-1-12.81,0l-9.47-.564c-3.57.765-16.96,3.413-20.61,1.128h1.11c2.65-1.622,9.07.526,11.7-1.128-13.48-.064-27.67-1.578-37.32,0-6.93,1.134-15.53-2.3-20.05.564h27.29c3.97,0,9.21-.532,11.7,1.128h-39.55v1.128h7.8c1.41,0.749,10.25.563,13.93,0.564,11.66,0,28.26,2.036,37.87-1.128,3.91-1.285,12.34,2.962,16.71,0a8.841,8.841,0,0,1-3.34-1.128h8.35V18.89c-1.51,0-2.56.022-3.34,0.564,13.6,0.252,28.49.972,40.66-1.692,4.44-.971,11.67,1.577,15.04-0.564-6.26-.34-18.07-0.817-25.06.564v1.692Zm254.55-3.383c3.13,2.078,15.68.7,18.38,0.564,2.38-.123,5.73.423,7.24-0.564h-25.62Zm-487.94.564a16.051,16.051,0,0,0,2.79,1.128V16.634h-2.79Zm10.03,0c0.87,1.031.49,0.787,2.23,1.128V17.2Zm49.02,0h2.78v1.128h-2.78V16.634Zm459.52,0a1.615,1.615,0,0,0,2.23,0h-2.23Zm15.04,0c1.98,1.356,13.62,1.347,15.6,0h-15.6Zm-503.53.564c-0.48.366-1.75,0.754-2.23,1.128,2.5,0.088,6.81.479,8.36-.564Zm23.4,0c0.87,1.031.49,0.787,2.22,1.128V17.762h-0.55V17.2h-1.67Zm216.11,0c-1.2,4.481-22.17-.9-28.4,2.256v0.564h25.06c2.63,1.669,10.14.564,13.93,0.564h32.86c3.61,0,11.12.806,12.81,0l1.11-.564V19.454h-9.47c-2.43-1.544-9.26-.564-12.81-0.564h-32.86V17.762a2.662,2.662,0,0,0,1.67-.564A10.38,10.38,0,0,1,1307.66,17.2Zm6.69,0a3.712,3.712,0,0,0,3.9,0h-3.9Zm22.28,0a2.914,2.914,0,0,0,3.34,0h-3.34Zm-295.21.564c1.03,0.942,1.54,1.275,2.78.564Zm13.36,0c1.22,0.892,5.47.876,6.69,0h-6.69Zm176.02,0a3.542,3.542,0,0,1,2.22.564A3.544,3.544,0,0,1,1230.8,17.762Zm15.59,0h10.03V18.89h-10.03V17.762Zm10.59,0a3.542,3.542,0,0,1,2.22.564A3.544,3.544,0,0,1,1256.98,17.762Zm2.78,0h3.9V18.89h-3.9V17.762Zm96.36,0a1.615,1.615,0,0,0,2.23,0h-2.23Zm-178.8,1.128c1.83-.066,4.01-0.133,5.02.564C1180.51,19.52,1178.34,19.587,1177.32,18.89Zm15.6,0a4.644,4.644,0,0,1,2.79.564A4.644,4.644,0,0,1,1192.92,18.89Zm154.29,0.564a3.577,3.577,0,0,1,2.23.564A3.556,3.556,0,0,1,1347.21,19.454Zm24.51,1.692V19.454h-5.02c-0.72,1.391.24,0.384-1.11,1.128v0.564h6.13Zm1.67-1.692v1.128c6.14,0.371,16.71,1.988,21.16-1.128h-21.16Zm9.47,0.564a3.6,3.6,0,0,1,2.23.564A3.557,3.557,0,0,1,1382.86,20.018Zm-220.02.564v1.128h2.79V20.582h-2.79Zm6.69,0a3.712,3.712,0,0,0,3.9,0h-3.9Zm5.57,0.564v1.128c2.38,0.087,6.34.42,7.79-.564Zm10.58,0v1.128c3.91,0.092,12.34,1.2,15.04-.564Zm22.28,0c1.13,0.837,4.44.819,5.57,0h-5.57Zm378.2,0v1.128c2-.235,1.4.266,2.23-1.128h-2.23Zm-365.39.564c0.96,0.5.71,0.5,1.67,0h-1.67Zm368.73,0a3.712,3.712,0,0,0,3.9,0h-3.9Zm8.36,0a2,2,0,0,0,1.11.564A1.96,1.96,0,0,0,1597.86,21.709Zm-362.61.564c1.5,1,19.67,1,21.17,0h-21.17Zm30.64,0a1.615,1.615,0,0,0,2.23,0h-2.23Zm3.34,0c2.41,1.553,9.28.564,12.81,0.564h30.64c3.41,0,9.93.925,12.25-.564h-55.7Zm212.77,0c0.96,0.5.72,0.5,1.67,0H1482Zm84.11,1.128c1.98,1.356,13.62,1.347,15.6,0h-15.6Zm-451.73.564c1.79,1.236,11.59,1.226,13.37,0h-13.37Zm52.92,0.564a2,2,0,0,0,1.11.564A2,2,0,0,0,1167.3,24.529Zm7.24,0c0.96,0.5.71,0.5,1.67,0h-1.67Zm10.03,0a1.959,1.959,0,0,0,1.11.564A2,2,0,0,0,1184.57,24.529Zm396.58,5.639c1.26,0.919,5.98.9,7.24,0h-7.24Z"/>
						</svg>';
				break;

			case '59':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 89">
							<path style="fill:'. $c1 .'" d="M96.7,4.937H89.34m-9.2.46H80.6c2.065,1.251,4.032-.734,6.44,0,1.092,0.333,1.181,1.76,3.22,1.38,1.369-.255,3.882-1.574,6.44-0.92,12.184,3.114,32.923-1.806,48.3.46a27.008,27.008,0,0,0,7.82-.92c1.956-.62,7.54.917,10.58,0.92h28.98c5.643,1.24,13.707.969,20.7,0.92l5.52-.46c6.879,1.4,16.967.92,25.3,0.92,4.885,0,11.069.445,15.18-.46L271.96,7.7a72.68,72.68,0,0,1,22.54-.46c2.275,0.373,2.656-1.621,5.06-.92,1.287,0.375,1.4,1.226,3.68,1.38,0.956-1.377,1.706-1.434,4.14-1.38,0.761,1.6,3.84,1.969,6.44,1.38,5.229-1.186,11.659-.459,18.4-0.46,26.857,0,50.306-1.379,76.36-1.38,11.892,0,23.029.016,34.04,0,6.726-.01,11.906.552,16.1-0.46h7.36l13.8-.46c2.419,0.213,6.329.544,8.74,0,3.8-.858,8.231.394,11.5,0.46l17.94-.92a40.1,40.1,0,0,0,15.64,0h63.02c5.289-1.715,22.761-.92,34.5-0.92l64.86-.46v1.38c-2.118-.049-3.436-0.3-4.6,0a1.3,1.3,0,0,0,.46.46c1.63,0.988,18.383.46,23,.46h85.1l10.12,0.46c8.694-1.9,26.292-.88,32.2.46l4.6-.46c6.9-.13,13.327-0.91,19.32.46l10.58-.46,10.58,0.46c4.891-1.073,19.339-1.255,23.46-.46h11.04l19.32,0.46a32.03,32.03,0,0,1,7.82-.92H966.1l0.46-1.38c2.947-1.347,9.548.2,11.04,0.46V5.4a2.813,2.813,0,0,0-.92.92h3.22V4.937h0.92c3.622-2.432,8.922.848,12.88,0a6.98,6.98,0,0,0,1.38-1.38l11.96-.46v1.38a5.291,5.291,0,0,1-3.22.92c-1.88,1.122-7.391-.365-9.66,0v0.92c2.021,0.558,2.275,1.275,5.06,1.38,3.53-2.268,9.23.078,12.88-2.3h-3.68a2.209,2.209,0,0,1,.46-1.38c1.77-1.148,7-.521,9.66-0.46a2.905,2.905,0,0,1-.92,2.3h1.84c2.17-1.831,22.04,0,26.22.92V5.4h40.02c6.01,0,13.13-1.38,19.32,0,8.92,1.99,21.44.46,31.28,0.46h15.64c1.12-.25,14.84-1.474,15.18-1.38,0.06,0.016.92,1.38,0.92,1.38h0.92c1.63-1.389,2.62-1.309,5.06-1.84,3.56-.775,6.8.745,10.12,0,7.81-1.752,17.6,1.2,24.84-.46,5.08-1.164,10.92,1.648,14.72.92,5.29-1.013,14.85-.225,20.7-1.38,2.14-.423,2.61,1.1,4.14.92,3.55-.414,8.84-0.873,12.42-1.84l43.7,0.46c20.58,0,37.55-.635,57.5.46,32.01,1.758,70.43,2.759,101.2,2.76,7.6,0,15.25-.237,21.16.46,2.46,0.29,2.36-1.279,4.6-.92,3.86,0.619,13.53,2.925,17.02,1.38h0.92V5.4a2.224,2.224,0,0,1,1.38.46c0.66,0.851.33,1.234,1.38,1.84,3.06-1.915,17.64.392,23,0,18.43-1.345,39.66,2.344,57.96,2.76,0-1.791,1.23-1.624,4.14-1.38,1.82,1.157,8.35.794,10.58,0.92v82.34H-4.5V4.937c11.367,0.025,21.2,0,33.58,0,6,0,12.117,1.152,17.48,0,5.914-1.271,17.785,2.179,21.16.46-1.363-.381-1.257-0.2-1.84-1.38m64.4,0.38-17.94-.46,66.7,0,505.54-.92c-0.646.407-2.58,0.5-3.22,0.92a24.131,24.131,0,0,0,6.9,0V3.477A10.881,10.881,0,0,1,684.58,3.017Zm-614.56.92c0.791,0.405.588,0.409,1.38,0H70.02ZM984.04,4.4c-0.355.314-1.027,0.6-1.38,0.92h4.14V4.857h-0.46V4.4h-2.3Zm4.6,0c-0.355.314-1.027,0.6-1.38,0.92l4.14,0.46V5.317l-1.38-.46A2.348,2.348,0,0,0,988.64,4.4Zm25.3,1.38c0.51,1.321.08,0.847,1.38,1.38a1.848,1.848,0,0,0,2.3,0C1016.04,6.669,1015.85,6.094,1013.94,5.777Zm63.94,0a5.4,5.4,0,0,1-2.3.92v0.92h8.74a1.675,1.675,0,0,1,.92-0.46V6.7a20.811,20.811,0,0,0-5.98-.46A2.351,2.351,0,0,0,1077.88,5.777ZM732.42,6.7c0.767,0.891.662,0.767,2.3,0.92,1.021,0.7,4.027.308,5.06-.46A64.132,64.132,0,0,0,732.42,6.7Zm-34.96.46c-0.355.314-1.027,0.6-1.38,0.92a5.956,5.956,0,0,0,3.22-.46Zm135.24,0c-2,1.235-7.428.2-9.66,0.92v0.46h5.06c3.314-2.013,8.322,1.076,11.5-.92ZM853.86,9V7.157c-1.847.054-2.542,0.128-3.22,1.38Zm25.76-1.84C877,8.8,870.487,7.924,867.2,8.537V9h12.42c0.876-.551,3.616-0.6,4.6-0.92V7.617A14.4,14.4,0,0,1,879.62,7.157Zm91.08,0v0.92h3.22V7.617h-0.46V7.157H970.7Zm-227.24.46a4.624,4.624,0,0,0,4.14,0h-4.14Zm34.5,0c0.832,0.968,1.343.921,3.22,0.92,0.646-.407,2.579-0.5,3.22-0.92h-6.44Zm7.82,0a3.283,3.283,0,0,0,1.84.92V7.617h-1.84Zm23.92,0v0.92h7.82V7.617H809.7Zm103.96,0v0.46c-0.294.471-1,.094-0.46,0.46a3.1,3.1,0,0,0,1.84.46,5.324,5.324,0,0,1,1.38-.92V7.617h-2.76Zm-361.56.46c-0.355.314-1.027,0.6-1.38,0.92h0.46c1.736,1.478,8.771.1,12.88,0V8.537a17,17,0,0,0-5.06-.46C557.432,9.1,554.486,8.177,552.1,8.077Zm44.16,5.98v-1.38c-1.388,0-9.792-.171-10.12,0-0.564.293-1.082,2.437-3.22,1.38q-0.229-.69-0.46-1.38c-1.972-.856-9.809-0.317-11.04.46,3.472-.06,8.346-0.461,11.04.46v0.46H572.34c-0.845.57-2.624,0.5-4.14,0.46l-0.46-1.38a1.575,1.575,0,0,0,.92-0.46H551.18c-1.277.377-2.507,1.913-3.68,2.3-1.923.635-5.665-.176-6.9-0.46-4.239-.973-9.872-0.438-13.8.46-6.774,1.548-13.906-.694-19.32.46l-6.44-.46V15.9c-1.513.976-3.486,0.9-5.98,0.92v-0.46a2.813,2.813,0,0,0,.92-0.92c-3.348-.061-4.884-1.687-8.28-0.92-1.461.33-3.639,1.5-5.98,0.92a47.162,47.162,0,0,0-19.78,0c0.01,1.6-.058,1.527-2.76,1.38-1.406.849-5.046,0.049-6.44,0.92,21.644,0.893,46.077.034,70.38,0,12.465-.017,30.285,1.666,40.48-1.38h11.96c10.461,0,27.205,1.6,36.34-.46h14.72c12.88,0,27.679.884,39.1-.92,3.607-.57,8.211,1.94,12.88.92,12.161-2.656,30.334-.669,43.24-0.46,7.683,0.125,15.972-.74,24.38-0.46l10.12,0.92a78.837,78.837,0,0,1,21.62.46l5.98-.92a59.21,59.21,0,0,0,19.32-.46c3.318-.763,6.071,1.184,8.28.92,6.72-.8,16.915-0.918,23,0.46,3.129,0.709,8-.338,10.58-0.92,3.487-.788,7.682.381,10.12,0.92,4.24,0.937,10.736-1.072,13.8-.46h17.48a55.773,55.773,0,0,0,21.16,0c5.019-1.138,19.652-.233,23,0.46,2.51,0.52,7.308-.463,10.58-0.46l17.02,0.46c2.4-.711,6.42-0.921,10.12-0.92,9.895,0,16.044-.464,25.3-0.46,3.587,0,8.78,1.475,10.12-.92h-34.5c-2.5,1.581-16.97.511-21.16,0.46v-1.84h31.28l12.88-.46c3.425,0.725,7.287.015,11.04,0,4.76-.019,6.58.611,10.58,0.46v1.38c-2.43.208-5.77-.391-8.28,0.46v0.46h19.78c1.59,1.191,5.26.389,5.98-.92h-2.3c-1.5-.793-6.49.212-8.74,0v-1.84c4.82-.075,11.52-0.484,15.64.92-0.31.613-.61,1.227-0.92,1.84h0.92c1.34,0.745,6.01,0,8.74,0h23.46c13.92-.275,32.78.616,46.92-1.38,0.87-.123,2.2.8,2.76,0.92l7.82-.92c0.37,0.1,1.47,1.264,1.84,1.38,4.47,1.388,8.24-1.379,11.5-1.84V13.6h0.46v1.38c1.22,0.024,3.59.656,4.14,0.46,1.07-.377.95-2.814,3.68-1.84,0.31,0.46.61,0.92,0.92,1.38a75.55,75.55,0,0,0,10.58-.92h-2.76v-0.92c8.65,0.141,19.78,2.566,27.6.46,2.54-.684,6.3.405,6.9,0,0.31-.153.61-0.307,0.92-0.46v-0.46h-1.84c-2.89-1.8-9.09.345-12.88-.46a76.817,76.817,0,0,0-27.6,0h-9.66c-5.95,0-12.17.3-17.48,0.46a2.208,2.208,0,0,0-.46-1.38c-4.24-2.626-11.32.413-15.64-.46-5.93-1.2-14.2.936-20.7-.46-12.83-2.756-30.13-.11-42.78,0-0.15-.46-0.31-0.92-0.46-1.38a2.766,2.766,0,0,0,.92-0.92h-1.38c-3.96,3.181-10.26,1.828-17.02,1.84l-27.6.92c-0.226-.086-1.044-1.271-1.38-1.38h-4.6c-0.028,2.218-7.45,1.513-11.04,1.38a8.233,8.233,0,0,0-4.6-.46c-5.071,1.355-13.081-.322-19.32.92-4.555.906-15.177,0-22.54,0-11.736,0-19.07.461-31.28,0.46-5.591,0-12.6-1.409-16.56.46-2.672,1.261-4.291-1.542-6.44,0a9.951,9.951,0,0,1,3.22.92V13.6H851.1c-2.088,1.3-6-.015-7.82-0.46l-17.94-.92c-2.2-.132-8.648,1.93-13.34.92-3.683-.793-15.187-0.835-18.86,0-2.459.559-5.61-.63-7.36-0.46-6.478.628-14.562,0.692-19.78-.92-2.489-.769-2.772.963-3.68,1.38-2.211,1.015-16.105-.224-17.02-0.92h-0.46v-0.46a10.881,10.881,0,0,0,3.68-.46v-0.46h-1.84c-2.1,1.307-8.006.46-11.04,0.46-9.167,0-19.154.149-27.6,0.46v0.46c0.874,0.542.556-.029,0.46,0.92-2.739,2.216-3.346-.283-6.9.46-3.484.728-7.427,0.48-13.8,0.46l-4.6-.46c-10.488,2.366-32.772.5-46.92,0.46h-20.7a23.165,23.165,0,0,0-2.3-1.38c-1.895-.22-0.942,1-1.84,1.38C610.7,14.367,598.727,14.062,596.26,14.057Zm-126.5-5.52c-0.532,1.034-.668.684-1.38,1.38,3.339,0.141,7.666,1.252,10.12-.46A39.749,39.749,0,0,0,469.76,8.537Zm11.04,0c0.808,1.4.969,1.379,3.22,1.38a1.3,1.3,0,0,1,.46-0.46V9h-1.84A3.1,3.1,0,0,0,480.8,8.537Zm529.92,0c1,0.728,4.52.715,5.52,0h-5.52ZM518.98,9v0.92h3.22V9.457h-0.46V9h-2.76Zm259.44,0.46v0.92c1.647-.192,1.157.217,1.84-0.92h-1.84Zm818.34,0a1.848,1.848,0,0,0,2.3,0h-2.3Zm-1198.3.46,0.46,1.38h1.38v-0.46A6.923,6.923,0,0,0,398.46,9.917Zm912.64,0.46c-2.96,1.8-9.93-.908-12.88.92,3.38,0.064,14.09.83,16.1-.46A9.274,9.274,0,0,1,1311.1,10.377Zm8.28,0c-0.46.319-1.84,0.592-2.3,0.92,2.06,0.072,5.62.391,6.9-.46Zm-202.86.92v1.38h-7.36v-0.46h0.46C1111.3,10.663,1114.1,10.96,1116.52,11.3Zm111.32,3.68a2.224,2.224,0,0,0,1.38-.46c1.19-1.459.6-2.045,3.22-2.3,2.02,0.944,10.07,0,13.8,0,12.13,0,22.68-.384,33.58-0.46,4.82-.034,13.9,1.28,17.02-0.92-9.58-.059-20.15.578-28.98,0.46-4.5-.06-11.17-0.963-15.64,0-8.42,1.813-18.84-1.229-26.68.46-5.45,1.175-14.59-1.948-18.4.92h19.78a2.835,2.835,0,0,0,.92.92v1.38ZM675.38,11.3c0.832,0.968,1.343.921,3.22,0.92v-0.46Zm408.02,0h5.52v1.84h-5.52V11.3Zm-399.74.46c-0.964.586-3.645,0.316-4.6,0.92,2.772,0.1,6.206.23,7.82-.92h-3.22Zm18.86,0c0.832,0.968,1.343.921,3.22,0.92v-0.92h-3.22Zm12.42,0h10.58v0.92C722.6,13.113,715.1,14.088,714.94,11.757Zm15.18,0H740.7v0.92a7.039,7.039,0,0,1-4.14.92C734.253,12.279,730.215,14.117,730.12,11.757Zm140.3,0c1.115,0.8,5.783.784,6.9,0h-6.9Zm183.54,0,23,0.46v0.46h-0.46c-3.23,2.024-24.3.969-31.28,0.92v-0.92C1048.23,12.781,1052.24,13.032,1053.96,11.757Zm149.96,0c-0.75.463-2.94,0.441-3.68,0.92h5.98v-0.46h-0.46v-0.46h-1.84Zm-275.08.92h3.68v0.46h-0.46C930.488,14.382,928.959,13.538,928.84,12.677Zm7.36,0h8.28a6.946,6.946,0,0,1,.92,1.84h-8.74a2.348,2.348,0,0,0-1.38-.46v-0.92A1.575,1.575,0,0,0,936.2,12.677Zm102.12,0h5.98v0.46h-0.46C1042.26,14.325,1038.44,13.895,1038.32,12.677Zm-473.8.46h2.76V13.6h-0.46a3.983,3.983,0,0,1-2.3.46v-0.92Zm802.24,0c1.32,1.329,4.91.248,5.98,1.84-2.02-.116-3.83-0.342-4.6.92h2.3c1.6,0.988,4.64-.025,6.9.46,2.52,0.539,16.03,1.6,18.86.46,0.31-.46.61-0.92,0.92-1.38,3.93-1.574,6.63,1.742,10.58.92,5.52-1.148,15.51-.3,20.7.46,1.29,0.19,2.41-.757,3.22-0.92,1.79-.359,2.4.728,3.22,0.92,2.38,0.556,4.63-.841,6.9-0.46v1.38a1.555,1.555,0,0,0-.92.46h12.42v-0.46c-1.17-.669-0.52.1-0.92-1.38a2.766,2.766,0,0,0,.92-0.92h-6.9c-3.4-2.138-14.1.182-18.86-.92-6.44-1.492-18.52-1.474-25.3-.46-5.65.846-10.28-.946-13.34,0.46-1.94.891-5.23-.621-6.44-0.92Zm-943.92,4.14V15.9l1.84-.46v-0.46h-4.6l-0.92,1.38c-3.258,1.227-10.746-2.347-15.18-1.38a52.185,52.185,0,0,1-11.04.92c-1.151,0-3.15-.667-3.68-0.46v0.92a17.7,17.7,0,0,1-2.3.92H371.32v-1.84c-3.845.049-4.347,1.627-6.9,2.3l-11.04-1.38c-5.83,1.236-10.777,1.7-15.64,2.76-2.066.451-5.666-1.074-6.9-1.38-0.876-.217-2.384,1.1-3.68.92-1.908-.272-5.518-1.872-8.28-0.92-1.007.347-2.153,1.944-3.22,2.3-3.406,1.138-6.591-1.143-8.28-1.38h-0.92L306,20.037c-1.393.683-3.026,0.167-4.14,0.92l35.42-.46c5.048,0,11.041.046,14.72-.92h5.52a19.3,19.3,0,0,1,1.84-1.38c3.576-.995,4.791,1.415,6.44,1.84,2.151,0.555,3.919-1.633,5.06-1.84,1.036-.188,1.328.793,1.84,0.92,1.967,0.487,3.458-.643,4.6-0.92h25.76l4.6,0.46c0.515-.138,2.463-1.222,3.22-1.38,1.813-.377,3.426.649,4.6,0.92,4.273,0.988,11.128-.048,14.72-0.46,2.14-.245,2.121,1.438,3.22,1.84,2.087,0.765,7.516-.966,9.2-1.38,2.887-.71,6.524.041,8.74-1.38a2.971,2.971,0,0,1-1.84-.46h0.46c0.539-.529,1.305-0.846,1.84-1.38-1.576-.843-3.693-0.973-6.44-0.92-1.111,2.392-2.4.564-5.06,1.38-0.379.116-1.461,1.266-1.84,1.38-2.343.7-3.764-1.1-5.06-.92,0,0-2.006,1.307-2.3,1.38C428.1,18.028,425.089,17.108,422.84,17.277Zm73.6-2.3a1.66,1.66,0,0,0,.92.46A1.659,1.659,0,0,0,496.44,14.977Zm-91.08.46a7.809,7.809,0,0,1,2.76.46v0.46h-0.46a3.1,3.1,0,0,1-1.84.46C405.072,15.569,405.439,16.752,405.36,15.437Zm1052.02,0c-0.39,1.82.45,1.576-1.84,1.84-0.4.3-1.45,0.615-1.84,0.92,2.45,0.073,7.15.586,8.74-.46a3.16,3.16,0,0,1-2.3-1.38h3.68c1.55,0.988,3.71-.6,5.06,0,1.05,0.465-.28,1.294,3.22,1.38,0.51-1.322.08-.847,1.38-1.38V15.9C1468.51,15.8,1462.71,15.679,1457.38,15.437Zm-13.34.92a7.818,7.818,0,0,1,2.76.46v0.46h-0.46a2.351,2.351,0,0,1-1.38.46C1443.82,16.609,1444.11,17.729,1444.04,16.357ZM1274.76,18.2c-1.41.849-5.05,0.049-6.44,0.92,4.75,0.079,16.6,1.154,18.86-.46C1283.44,18.509,1279.1,18.206,1274.76,18.2Zm-18.4.46c-1.02.649-4.29,0.7-5.52,0.92v0.46h5.06c1.07-.65,4-0.25,5.06-0.92A14.413,14.413,0,0,1,1256.36,18.657Zm247.48,0v0.92h5.52v-0.92h-5.52ZM191.46,20.037v0.92c4.662,0.048,10.339.316,14.26-.46v-0.46H191.46Zm56.12,0.46c-0.4.3-1.446,0.615-1.84,0.92,2.057,0.292,4.327.725,5.98-.46A12.608,12.608,0,0,1,247.58,20.5Zm1140.34,0.46c3.16,2.029,25.19.919,31.28,0.92,3.04,0,7.85,1.116,9.66,0C1416.96,19.62,1401.3,20.955,1387.92,20.957Zm-1148.16.46a5.474,5.474,0,0,0,4.6,0h-4.6Zm1194.62,0c0.21,1.32,2.36,1.02,5.06.92,0.46-.319,1.84-0.592,2.3-0.92h-7.36Zm11.5,0c2,1.817,14.62,1.6,16.1.46C1457.24,21.556,1451.3,21.42,1445.88,21.417Zm19.78,0.92c4.13,2.893,23.61,1.425,30.82,1.38v-0.46c-2.48-.841-6.89-0.5-10.12-0.46C1484.89,21.866,1469.2,22.293,1465.66,22.337Z"/>
						</svg>';
				break;

			case '60':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 167">
							<path style="fill:'. $c1 .'" d="M1472.19,41.378c0.35-2.341,5.42-10.18,7.48-10.69,1.13,1.184,2.63,2.016,3.75,3.207a1.793,1.793,0,0,0,1.06-.535c1.12-1.195,1.88-3.363,2.68-4.81,2.48,1.268,5.53,1.7,5.88,5.345-2.26,1.5-5.84,6.72-6.42,9.621,5.42,1.356,6.94,6.236,11.76,8.017V51c2.5-2.829,3.44-9.606,8.02-10.155,0.91,1.38,2.12,2.054,3.21,3.207a1.793,1.793,0,0,0,1.06-.534,41.536,41.536,0,0,0,2.68-4.81,1.862,1.862,0,0,1,1.07.535c2.19,0.592,4.33,1.827,4.81,4.276a8.755,8.755,0,0,0-3.21,4.81c2.22,0.531,3.65,1.658,5.34,2.672-1,1.966-6.31,8.854-5.34,10.155,0.86,1.238.78,1.257,2.67,1.6a16,16,0,0,1,2.67-5.345,1.827,1.827,0,0,1,1.07.534c2.28,0.808,2.16,2.116,4.81,2.672,1.03-2.626,1.01-4.676,4.81-4.81a6.853,6.853,0,0,0,3.75,3.207V58.481c1.11-1.194,1.87-3.363,2.67-4.81-3.96-1.18-7.47-4.315-10.69-6.414,0.18-.534.35-1.069,0.53-1.6a6.181,6.181,0,0,0,2.68-4.276c-2.35-.484-4.32-1.219-4.81-3.742,1.77-2,1.49-4.174,4.81-4.81a7.365,7.365,0,0,0,4.27,3.207c1.05-4.051,4.38-7.355,6.42-10.69l11.22,6.948c-1.99,4.175-6.9,12.5-10.16,15.5a1.856,1.856,0,0,0,.54,1.069,12.452,12.452,0,0,0,6.41,3.207c0.87-2.023,1.17-3.271,3.74-3.741a10.884,10.884,0,0,0,4.28,3.207V51c1.69-1.936,1.09-4.167,4.28-4.81,1.82,2.365,5.23,3.978,8.01,5.345,0.81-2.824,2.58-2.937,3.21-5.879-2.39-.936-4.49-1-4.81-4.276a31.407,31.407,0,0,0,6.41-9.621c-3-1.322-9.27-4.047-10.69-6.948,2.14-1.87,1.32-4.627,4.81-5.345,0.67,1.106,3.54,4.091,4.28,3.207,1.83-2.151.82-4.54,4.81-4.81a14.777,14.777,0,0,0,4.28,3.207c-1.93,4.121-5.51,6.923-6.95,11.224,2.51,0.506,5,1.373,5.34,4.276a8.34,8.34,0,0,0-3.2,4.276h0.53c4.35,4.188,11.56,7.391,16.57,10.69l5.88,3.207v8.552h-0.54c-0.83-.943-4.22-3.961-4.81-3.207a32.766,32.766,0,0,0-6.41,10.155h0.53c2.52,2.474,6.64,3.349,9.09,5.879,1.47-.537,1.17-0.77,2.14-1.6V175H-3V22.67c1.672-4.246,7-11.352,9.621-15.5,3.9,1.841,6.76,5.53,11.224,6.414l2.672-4.81a14.126,14.126,0,0,1-5.345-3.207c2.1-1.813,1.446-4.641,4.81-5.345,1.852,1.75,3.885,1.4,4.276,4.81a10.149,10.149,0,0,0-2.672,4.276,8.671,8.671,0,0,1,3.741,2.672,1.831,1.831,0,0,0,1.069-.535c1.631-1.856,1.28-4.158,4.276-4.81,1.155,1.571,8.709,7.053,9.621,6.414,1.838-2.128.987-4.412,4.81-4.81a6.815,6.815,0,0,0,3.742,3.207V10.912C50.74,9.164,49.98,6.8,53.121,6.1c2.231,2.322,6.494,5.815,10.155,6.414C63.8,9.94,64.5,7.976,67.553,7.7c2.552,2.647,6.36,4.518,9.621,6.414a1.832,1.832,0,0,1-.534,1.069c-1.83,5.874-7.659,9.762-9.621,15.5h0.534a27.47,27.47,0,0,0,10.155,5.879c1.319-4.319,4.978-6.988,6.414-11.224h0.534V24.808A13.659,13.659,0,0,1,80.38,22.67l0.535-1.6c1.575-1.746,1.41-3.663,4.276-4.276L88.4,19.464c0.773-2.808,3.634-8.666,6.948-9.086,0.8-.89.387-0.544,1.069-0.535,1.436,0.417,10.272,5.534,10.69,6.414,0.518,1.092-.525,1.143,0,2.138a11.257,11.257,0,0,0,3.207,2.138c0.574-2.782,1.507-5.076,4.81-5.345,2.166,3.061,8.439,3.9,9.087,8.017a10.2,10.2,0,0,0-1.6,2.138h0.535V24.808c2.064-1.379,5.358-6.437,5.879-9.086-2.776-1.491-8.955-3.944-10.155-6.948,1.691-1.955,1.15-4.657,4.276-5.345,1.267,1.415,2.525,2.774,4.81,3.207,0.936-2.391,1-4.49,4.276-4.81,1.6,1.542,3.612,1.7,4.276,4.276-2.514,2.679-3.771,6.542-6.414,9.086a1.833,1.833,0,0,0,.534,1.069c1.1,0.948,4.146,1.376,4.811,2.672Q135.166,20,134.9,21.067c0.976,1.924,2.747.429,3.207,3.741-1.149.892-1.643,1.507-1.069,2.672a17.527,17.527,0,0,0,4.276,2.673c1.7-5.509,6.984-8.622,8.018-14.431-2.213-.9-4.439-1.317-4.811-4.276,2.647-2.076,4.867-6.524,6.414-9.621A1.831,1.831,0,0,1,152,2.36c2.618,0.562,4.667,1.543,4.81,4.81a4.582,4.582,0,0,0-2.672,3.741L164.3,17.326c0.574-2.782,1.507-5.076,4.811-5.345,2.249,3.253,7.364,3.874,9.086,7.483-1.788,2.052-1.164,4.4-4.81,4.81a9.424,9.424,0,0,0-4.276-3.207L160.019,37.1c-1.626-.04-1.467-0.4-2.138,0a5.333,5.333,0,0,0-1.6,2.672h0.534c2.354,2.225,6.466,2.262,6.949,6.414-1.932,1.585-1.765,3.652-4.811,4.276-1.591-2.415-4.227-3.546-6.948-4.81v0.535h0.534a18.93,18.93,0,0,0,4.811,2.672,1.827,1.827,0,0,1-.535,1.069c-0.687,2.059-1.96,2.7-2.672,4.81,0.738,0.356,8.017,3.207,8.017,3.207,2.173-1.707,9.04-12.474,9.621-15.5-2.259-.577-4.482-1.537-4.81-4.276,3.061-3.152,7.144-14.122,11.224-14.966,2.174,2.731,6.15,3.883,8.552,6.414a1.834,1.834,0,0,0,1.069-.535,18.684,18.684,0,0,0,1.6-1.6c-0.405-1.406-.64-1.275-1.069-2.672,3.022-2.493,3.869-9.052,8.018-10.155,0.474,0.081.8-1.029,2.672-.534,0.9,0.239,1.885,1.243,3.207,1.6a9.819,9.819,0,0,1,1.6-3.207l5.879,3.207c-0.617,2.531-2.026,3.949-3.207,5.879,1.494,0.531,3.941,3.658,4.81,2.672,1.678-1.314,3.316-4.5,3.742-6.948-3.536-.874-6-3.277-9.087-4.81q0.268-.8.535-1.6c1.726-1.931,1.333-3.889,4.81-4.276,1.5,2.257,6.721,5.841,9.621,6.414A51.705,51.705,0,0,1,223.624,7.7a1.834,1.834,0,0,1,1.069.534c2.275,0.808,2.159,2.116,4.81,2.672,1.533-2.888,3.928-9.388,7.483-10.155,3.3,4.008,15.855,10.2,20.845,13.362-0.644,1.263-3.667,5.107-3.207,5.345,1.055,1.354,9.819,6.311,10.155,5.879,1.116-1.195,1.876-3.363,2.673-4.81a1.834,1.834,0,0,1,1.069.534c1.347,0.465,4.461,3.337,4.81,2.672,3.113-3.256,6.69-14.832,11.224-15.5a10.863,10.863,0,0,0,4.276,3.207V10.912c1.686-1.936,1.094-4.167,4.276-4.81,1.1,1.4,3.157,2.392,4.811,3.207a1.828,1.828,0,0,1-.535,1.069c-1.43,4.3-5.45,7.259-6.948,11.759h0.534a4.048,4.048,0,0,0,2.673,2.138c0.516-2.676,1.085-5.056,4.276-5.345,1.28,1.645,3.332,2.309,4.81,3.741a1.831,1.831,0,0,0,1.069-.535c3.642-2.982,8.139-12.225,10.69-16.569a1.834,1.834,0,0,1,1.069.534c2.894,0.835,8.938,4.333,10.155,6.948-2.27,2.34-5.744,7.142-6.414,10.69a22.242,22.242,0,0,1,9.087,5.345,1.834,1.834,0,0,0,1.069-.534,12.536,12.536,0,0,0,3.207-3.741c-2.112-1.085-4.95-1.82-5.345-4.81,2.475-2.549,4.073-8.808,8.017-9.621,0.871,1.255,3.33,3.183,4.276,2.672,2.975-2.535,3.365-8.942,8.017-9.621,2.037,2.6,6.6,4.9,9.621,6.414a1.833,1.833,0,0,1-.534,1.069A24.714,24.714,0,0,1,350.832,20a1.827,1.827,0,0,0,.535,1.069c1.856,1.617,3.823,1.039,4.276,4.276-1.189,1.05-2.676,3.111-2.138,4.276,0.854,1.354,3.25,3.2,4.276,2.672l6.413-10.155c2.431,1.012,5.313,1.78,5.88,4.81-1.572,1.155-7.054,8.709-6.414,9.621,0.928,0.706.859,0.923,1.6,0.534l2.673-3.741a1.834,1.834,0,0,1,1.069.535c3.858,1.161,6.619,4.127,10.155,5.879l-0.534,1.6a7.638,7.638,0,0,1,6.414,4.276h-0.535a8.675,8.675,0,0,1-2.672,3.741,1.834,1.834,0,0,0,.534,1.069V51a1.831,1.831,0,0,0,1.069-.534,32.408,32.408,0,0,0,6.948-10.69h0.535V39.24c-2.57-.538-4.851-1.5-5.345-4.276a9.423,9.423,0,0,0,3.207-4.276c-2.2-.91-4.789-1.556-5.345-4.276,2.734-2.7,4.955-6.8,6.948-10.155L401.609,23.2a23.642,23.642,0,0,0-2.673,5.879c2.276,0.808,2.16,2.116,4.811,2.672,0.722-3.183,7.854-15.281,11.224-15.5,1.453,1.918,13.932,10.024,14.431,9.621,1.788-2.052,1.164-4.4,4.811-4.81,0.907,1.38,2.117,2.054,3.207,3.207h1.068a17.933,17.933,0,0,1,2.673-5.345,1.834,1.834,0,0,1,1.069.535c2.276,0.808,2.159,2.116,4.81,2.672l2.673-4.81-10.69-6.414,0.534-1.6c1.814-1.631,1.288-3.62,4.276-4.276a10.863,10.863,0,0,0,4.276,3.207V7.7c1.967-1.681,1.445-3.8,4.811-4.276,1.852,1.75,3.885,1.4,4.276,4.81-1.37.925-1.94,2.23-3.207,3.207v0.535c2.5,0.9,2.456,2.6,5.345,3.207A30.165,30.165,0,0,1,465.747,4.5c2.038,1.918,4.918,1.674,5.345,5.345-3.564,3.576-10.578,19.23-14.965,19.776a7.339,7.339,0,0,0-4.276-2.672,8.669,8.669,0,0,1-2.673,3.741,1.828,1.828,0,0,0,.535,1.069c1.936,1.686,4.167,1.094,4.81,4.276-1.106.668-4.091,3.54-3.207,4.276,2.829,2.5,9.606,3.439,10.156,8.017a9.423,9.423,0,0,0-3.207,4.276c1.406,0.406,1.275.64,2.672,1.069,0.446-2.61.712-4.017,3.741-4.276,0.929,0.706.86,0.923,1.6,0.535a7.475,7.475,0,0,0,2.672-3.741h0.535V45.654a17.685,17.685,0,0,1-8.552-5.345c2.042-1.754,1.622-4.628,4.81-5.345,1.332,1.6,2.962,1.6,5.345,2.138,0.55-2.13,1.157-3.445,3.742-3.741a67.852,67.852,0,0,0,7.483,4.276l9.62-16.035a1.827,1.827,0,0,1,1.069.534c2.285,0.779,2.652,2.144,5.345,2.672,0.988-3.836,3.965-7.017,5.88-10.155a1.834,1.834,0,0,1,1.069.534c2.807,0.812,8.97,4.4,10.155,6.948-2.316,2.256-5.824,7.061-6.414,10.69,2.687,0.528,4.554,1.07,4.811,4.276a7.384,7.384,0,0,0-3.207,4.276c4.1,1.265,6.13,4.569,10.689,5.345,0.714-2.056,1.929-2.232,2.673-4.276-1.874-.809-4.457-1.9-5.345-3.741,1.757-1.985,1.629-4.662,4.81-5.345,2.35,2.94,6.782,3.983,9.087,6.948h0.534V39.774c2.1-1.67,5.011-6.407,5.88-9.086h0.534c0.529-.54-0.527-0.528-0.534-0.534-1.491-1.785-3.851-1.893-4.811-4.276,2.032-1.734,1.539-4.139,4.811-4.81,0.727,1.011,3.738,3.319,4.275,2.672,1.323-1.023,2.011-2.6,3.207-3.741V18.929c-2.275-.468-4.773-1.412-5.344-3.741,3.021-2.521,3.9-8.35,7.482-10.155,1.813,2.1,4.641,1.446,5.345,4.81-1.063.659-3.966,3.741-3.207,4.276,2.053,1.788,4.4,1.164,4.811,4.81-2.222,1.534-5.84,6.72-6.414,9.621a35.331,35.331,0,0,1,5.345,2.672,1.827,1.827,0,0,1-.535,1.069c-0.808,2.276-2.116,2.159-2.672,4.81,2.212,0.9,4.439,1.317,4.81,4.276a10.143,10.143,0,0,0-2.672,4.276c2.275,0.808,2.159,2.116,4.81,2.672,1.125-2.751,4.4-9.725,7.483-10.155,1,0.951.424,0.988,1.6,0.535l2.672-3.741c-1.716-.855-1.91-0.718-2.138-3.207,5.421-5.242,9.428-13.735,13.362-20.311a1.831,1.831,0,0,1,1.069.535c2.508,0.655,4.551,1.691,4.811,4.81-1.382.811-3.251,2.609-2.673,3.741,1.776,2.23,6.984,5.3,10.155,5.879,0.809-2.276,2.116-2.159,2.673-4.81-2.38-.512-4.572-1.52-5.345-3.741,1.414-1.267,2.774-2.526,3.207-4.81-2.212-.9-4.439-1.317-4.81-4.276,1.749-1.852,1.4-3.885,4.81-4.276,5.286,5.49,13.791,9.225,20.311,13.362a1.833,1.833,0,0,1-.535,1.069c-0.548,2.43-1.641,4.345-4.276,4.81a10.862,10.862,0,0,0-4.276-3.207v0.534a6.56,6.56,0,0,0-2.672,4.81c2.212,0.9,4.439,1.317,4.81,4.276a8.347,8.347,0,0,0-3.207,4.276c3.423,0.863,4.585,3.2,7.483,4.276V38.171c1.575-1.757,1.147-3.322,4.276-3.741,1,0.951.424,0.988,1.6,0.535,1.759-1.844,1.7-4.185,4.81-4.81,0.871,1.255,3.33,3.183,4.276,2.672,2.1-1.67,5.01-6.407,5.879-9.086,0.135-.517.419-0.2,0-0.535-1.646-1.563-4.112-1.692-4.81-4.276,2.747-2.715,4.864-6.852,6.948-10.155a1.831,1.831,0,0,1,1.069.534,8.672,8.672,0,0,1,3.742,2.672,1.834,1.834,0,0,0,1.069-.535c1.641-1.947.9-3.823,4.275-4.276,1.789,1.7,3.836,1.6,4.276,4.81-1.716,1.771-1.761,3.686-4.81,4.276a7.388,7.388,0,0,0-4.276-3.207v0.534c-2.54,2.781-3.383,6.785-6.414,9.086a1.514,1.514,0,0,0,.535.534c1.8,2.233,7.316,5.493,10.155,6.414V29.084c1.631-1.856,1.28-4.158,4.276-4.81a14.232,14.232,0,0,0,4.81,3.741c-0.651,1.235-3.978,4.827-3.207,5.345,1.024,1.141,3.9,3.177,4.811,2.672,1.66-1.655,8.967-13.22,9.621-15.5-2.38-.512-4.573-1.52-5.345-3.741,2.51-2.584,4.224-9.156,8.017-10.155,1.773,1.7,4.175,1.875,4.81,4.81a40.017,40.017,0,0,0-6.948,9.621,9.762,9.762,0,0,1,4.276,2.672,1.831,1.831,0,0,0,1.069-.535c1.75-1.852,1.4-3.885,4.81-4.276,0.945,1.339,2.263,1.868,3.207,3.207h0.535V21.6c1.826-1.566,1.547-4.06,4.276-4.81,1.35,1.438,8.47,6.673,9.621,5.879,1.38-.907,2.054-2.117,3.207-3.207V18.395c-1.984-.835-4.524-1.644-5.345-3.741Q695.31,9.576,698.785,4.5a1.834,1.834,0,0,1,1.069.534c2.894,0.836,8.938,4.333,10.155,6.948A31.111,31.111,0,0,0,703.6,22.136h0.535c0.855,1.354,3.25,3.2,4.276,2.672,1.846-2.209.887-4.411,4.81-4.81a6.816,6.816,0,0,0,3.742,3.207V22.67c1.372-1.1,2.327-3.277,3.207-4.81,2.365,0.989,5.3,1.923,5.879,4.81a7.626,7.626,0,0,0-3.207,4.81c5.507,2.515,9.822,7.169,15.5,9.086,0.714-2.056,1.929-2.233,2.673-4.276h0.534V31.757c-2.939-.817-9.915-4.491-10.69-7.483,2.611-2.665,4.095-8.458,7.483-10.155v0.534c5.744,1.761,10.675,6.862,16.035,9.621a1.828,1.828,0,0,1-.535,1.069c-0.479,1.348-3.507,4.281-2.672,4.81,2.623,2.409,6.532,3.411,9.086,5.879a1.827,1.827,0,0,0,1.069-.535c2.5-2.46,8.629-11.492,9.621-14.966-3.019-.851-9.429-4.249-10.69-6.948,1.915-2.022,1.614-4.416,5.345-4.81,1.663,2.2,6.641,5.821,9.621,6.414a51.9,51.9,0,0,1,2.672-5.345c2.1,1.093,5.3,2.062,5.88,4.81a8.766,8.766,0,0,0-3.207,4.81c1.491,0.481,4.077,2.953,4.81,2.138a17.927,17.927,0,0,0,3.207-4.81c2.165,1.124,5.315,1.914,5.88,4.81-2.549,1.986-9.483,11.983-10.156,15.5,5.585,1.331,4.5,5,10.156,5.879,1.039-4,4.386-7.361,6.414-10.69h1.068a9.98,9.98,0,0,0,4.811,3.207,8.675,8.675,0,0,1,2.672-3.741V30.688c-2.749-1.472-9.3-4.242-10.155-7.483,2.62-2.723,3.961-9.092,8.017-10.155a7.388,7.388,0,0,0,4.276,3.207V15.722c2.04-1.878,1-3.866,4.811-4.276,2.11,2.244,14.121,10.08,14.431,9.621,2.618-2.757,3.491-9.509,8.017-10.155a9.424,9.424,0,0,0,4.276,3.207V13.584c1.116-1.195,1.876-3.363,2.673-4.81a1.834,1.834,0,0,1,1.069.534c2.379,0.689,9.2,6.759,10.155,5.879,1.63-1.856,1.28-4.158,4.276-4.81,1.267,1.415,2.525,2.774,4.81,3.207,0.853-2.154,1.062-4.263,3.742-4.81,1.686,1.927,4.112,1.19,4.81,4.276-3.167,3.256-7.526,14.629-11.759,15.5-0.907-1.38-2.117-2.054-3.207-3.207a1.835,1.835,0,0,0-1.069.534c-1.531,1.149-6.491,8.708-5.879,9.621,1.856,1.631,4.158,1.28,4.81,4.276-1.414,1.267-2.774,2.526-3.207,4.81a1.827,1.827,0,0,1,1.069.535,1.827,1.827,0,0,0,1.069-.535c1.574-1.624,1.464-3.183,4.276-3.741a8.35,8.35,0,0,0,4.276,3.207V43.516c1.292-1.119,2.18-3.477,3.207-4.81-1.538-.742-2.055-0.923-2.672-2.672,1.736-1.4,2.154-3.785,4.276-4.81,1.034,1.09,4,3.13,4.81,2.672a7.483,7.483,0,0,0,2.673-3.741c0.134-.517.419-0.2,0-0.535-1.856-1.631-4.159-1.28-4.811-4.276,2.694-2.664,4.907-6.947,6.949-10.155l11.224,6.948c-0.932,1.823-3.221,4.461-2.673,5.879,0.96,1,2.255,1.665,3.207,2.672a1.831,1.831,0,0,0,1.069-.534c4.361-3.7,9.2-19.218,14.431-20.311a17.955,17.955,0,0,0,4.811,3.207,1.827,1.827,0,0,1-.535,1.069c-0.53,1.494-3.658,3.941-2.672,4.81,1.2,1.116,3.363,1.876,4.81,2.672V22.67c-2.119,1.872-1.028,4.355-4.81,4.81-0.986-1.149-3.283-3.222-4.276-2.672-2.573,2.621-3.465,6.834-6.414,9.086a1.514,1.514,0,0,0,.535.535,8.985,8.985,0,0,0,4.81,3.207V37.1c1.686-1.936,1.094-4.167,4.276-4.81,2.834,4.128,10.342,7.929,14.966,10.155,1.2-3.98,4.387-6.829,6.414-10.155-3.08-1.419-9.437-4.276-10.69-7.483h0.534c0.8-2.819,4.429-9.523,7.483-10.155a9.858,9.858,0,0,0,4.811,3.207,17.909,17.909,0,0,1,2.672-5.345c2.5,1.059,3.624,2.548,5.879,3.741-1.352,2.832-10.2,15.408-9.62,16.035,3.4,4.583,10.934,5.6,14.431,10.155h0.534V41.912c2.234-1.791,5.585-7.237,6.414-10.155-1.9-.527-4.542-2.059-5.345-3.741,2.209-1.9,1.428-4.381,5.345-4.81,2.272,2.405,6.113,5.434,9.621,6.414,0.949-3.378,7.739-15.142,11.224-15.5,3.854,3.931,10.561,5.795,13.9,10.155h0.534V23.739c1.253-1.069,1.957-3.263,2.673-4.81a1.834,1.834,0,0,1,1.069.535c2.379,0.512,4.572,1.52,5.345,3.741-1.97,1.67-1.722,4.129-4.811,4.81-0.871-1.255-3.33-3.183-4.276-2.672-2.76,2.189-4.621,7.067-6.413,10.155a1.827,1.827,0,0,1-1.069-.534c-2.1-.715-2.9-2.193-4.811-3.207-0.6,2.316-1.624,4.857-4.276,5.345-2.262-2.328-6.331-5.345-9.621-6.414v0.534c-1.871,1.446-9.915,15.121-9.62,15.5,0.838,0.977.471,0.746,2.138,1.069,0.521-2.575,1.218-4.539,4.276-4.81,1.4,1.445,3.369,2.334,4.275,4.276-2.9,2.359-7.813,10.867-9.62,14.431,2.272,0.856,10.234,9.582,12.293,8.017A9.981,9.981,0,0,0,967.1,64.9c-2.856-1.519-9.644-4.253-10.155-8.017,2.981-2.981,7.7-14.029,11.224-14.966,2.318,2.276,6.56,5.741,10.155,6.414,1.689-3.141,7.625-14.707,10.69-15.5a17.936,17.936,0,0,0,4.81,3.207,1.833,1.833,0,0,1-.534,1.069c-0.671,2.133-1.945,2.763-2.673,4.81h0.535a6.558,6.558,0,0,0,4.81,2.672c0.522-2.575,1.219-4.539,4.279-4.81,0.65,1.055,3.05,3.49,3.74,2.672,3.21-3.275,6.53-13.115,10.15-14.966V26.946h0.54v0.534c2.42,0.623,3.54,2.029,5.34,3.207a1.8,1.8,0,0,1-.53,1.069c-0.87,2.7-11.3,18.225-13.36,19.776a1.431,1.431,0,0,0,.53.534c0.89,1.036.77,0.892,2.67,1.069,0.54-1.425,1.07-2.851,1.61-4.276H1012c1.16,1.419,3.74,2.3,5.34,3.207a1.857,1.857,0,0,1-.53,1.069c-0.61,2.3-1.67,4.343-4.28,4.81-0.93-.706-0.86-0.923-1.6-0.534-2.16,2.014-5.27,5.766-5.88,9.086,1.27,0.45.88,0.215,1.6,1.069h0.54c0.52-2.252,1.63-4.084,3.74-4.81a5.088,5.088,0,0,0,2.13,1.6c0.62-2.531,2.03-3.949,3.21-5.879h1.07c1.02,1.323,2.6,2.01,3.74,3.207a1.828,1.828,0,0,0,1.07-.535c2.38-2.376,11.88-17.089,12.83-20.311-3.1-1.633-9.69-3.8-10.16-8.017,4.05-3.936,7.1-10.147,10.16-14.966l11.22,6.948c-0.93,1.823-3.22,4.46-2.67,5.879,0.96,1,2.26,1.665,3.21,2.672a1.828,1.828,0,0,0,1.07-.535c4.36-3.7,9.2-19.218,14.43-20.311,3.07,3.063,13.96,7.439,14.96,11.224-2.13,2.075-9.42,14.735-9.08,14.966,2.54,2.469,8.76,4.138,9.62,8.017A10.859,10.859,0,0,0,1074.53,51h0.54c0.39,0.466.67,0.6,1.06,1.069h1.07c0.69-2.9,3.9-9,6.95-9.621,1.01,0.951.43,0.988,1.61,0.535,6.43-6.446,12.26-18.127,17.1-26.19a1.828,1.828,0,0,1,1.07.535c3.79,1.295,6.34,5.052,10.15,6.414,0.54-2.57,1.5-4.85,4.28-5.345,2.34,2.861,8.56,4.194,9.62,8.017-3.99,4.033-5.64,10.98-10.16,14.431v0.535h0.54c1.87,2.12,4.35,1.028,4.81,4.81-1.38.907-2.05,2.117-3.21,3.207a1.857,1.857,0,0,0,.54,1.069c0.93,0.706.86,0.923,1.6,0.534,1.62-1.839.93-3.369,4.28-3.741a16.424,16.424,0,0,0,6.95,4.276V51c2.23-1.72,5.81-7.1,6.41-10.155-2.21-.9-4.44-1.317-4.81-4.276a9.429,9.429,0,0,0,3.21-4.276c-2.21-.91-4.79-1.556-5.35-4.276a41.047,41.047,0,0,0,6.95-10.155c1.22,0.635,5.01,3.815,5.34,3.207,1.51-1.153,2.36-3.015,3.21-4.81,2.37,0.969,5.48,1.684,5.88,4.81-3.82,3.654-7.79,10.114-10.16,14.966a9.746,9.746,0,0,1,4.28,2.672,1.828,1.828,0,0,0,1.07-.535c1.06-1.18,1.89-3.451,2.67-4.81a1.828,1.828,0,0,1,1.07.535c1.5,0.53,3.94,3.658,4.81,2.672a11.08,11.08,0,0,0,2.67-4.81c-2.5-.655-4.55-1.691-4.81-4.81,2.59-2,4.91-6.072,6.42-9.086a1.828,1.828,0,0,1,1.07.535c2.94,0.7,9.52,4.457,10.15,7.483a10.956,10.956,0,0,0-3.21,4.276h0.54c1.75,1.894,4.11,1.135,4.81,4.276-1.22,1.157-6.6,9.075-5.88,9.621,2.59,2.517,8.79,3.978,9.62,8.017a7.075,7.075,0,0,0-3.21,4.81,1.827,1.827,0,0,1,1.07.535h1.07c1.11-3.589,4.18-6.325,5.88-9.621a9.86,9.86,0,0,1,3.21,1.6c0.8-2.824,2.57-2.937,3.21-5.879-2.25-.935-4.29-1.454-4.81-4.276,1.72-1.931,1.33-3.889,4.81-4.276a8.335,8.335,0,0,0,4.27,3.207V37.636c1.07-1.18,1.9-3.451,2.67-4.81h1.07c2.49,3.01,9.19,3.761,10.16,8.017a10.14,10.14,0,0,0-2.67,4.276h0.53c1.01,1.641,1.95,2.788,4.28,3.207,0.46-2.275,1.41-4.773,3.74-5.345,1.26,1.414,2.52,2.774,4.81,3.207,2.04-3.77,10.87-20.149,14.43-20.845,2.17,2.732,6.12,3.913,8.55,6.414a1.827,1.827,0,0,0,1.07-.535c2.4-2.71,3.64-9.092,8.02-9.621a34.424,34.424,0,0,0,9.62,6.414q-3.48,5.612-6.95,11.224a1.828,1.828,0,0,1-1.07-.535c-3.99-1.265-5.92-4.985-10.15-5.879-2.51,5.49-6.05,10.376-9.09,15.5,4.08,1.289,6.05,5.029,10.15,6.414V54.205c1.71-2.024.98-4.157,4.28-4.81a9.393,9.393,0,0,0,4.28,3.207V52.067a19.2,19.2,0,0,0,2.67-4.81,1.828,1.828,0,0,1,1.07.535c1.34,0.465,4.46,3.337,4.81,2.672,3.09-3.232,6.81-14.859,11.22-15.5,1.35,1.426,8.54,6.625,9.62,5.879a8.146,8.146,0,0,0,2.68-4.81q-2.415-1.336-4.81-2.672c0.91-2.251,1.48-5.3,4.27-5.879a17.873,17.873,0,0,0,4.81,3.207,1.858,1.858,0,0,1-.53,1.069q-1.335,2.4-2.68,4.81c2.35,0.822,2.45,2.172,5.35,2.672,0.52-2.575,1.22-4.539,4.28-4.81,2.13,2.287,6.39,5.491,9.62,6.414,0.51-2.676,1.08-5.056,4.27-5.345,1.01,1.641,1.95,2.788,4.28,3.207a35.019,35.019,0,0,1,2.67-5.345,1.828,1.828,0,0,1,1.07.535c3.9,1.212,6.51,4.6,10.15,6.414,0.54-2.57,1.5-4.85,4.28-5.345,2.52,2.5,8.76,4.135,9.62,8.017-2.59,2.043-8,10.8-9.62,13.9-0.43.823-.76,0.55,0,1.069,2.62,2.409,6.53,3.411,9.09,5.879a1.862,1.862,0,0,0,1.07-.534c4.5-4.628,8.32-12.194,11.75-17.638,1.79-2.827,2.13-7.176,5.88-8.017,1.44,1.869,14.53,9.96,14.97,9.621,1.79-2.052,1.16-4.4,4.81-4.81,1.53,2.271,4.02,2.931,5.88,4.81a1.828,1.828,0,0,0,1.07-.534c2.62-2.728,4.02-9.6,8.55-10.155,2.41,2.934,8.75,3.836,9.62,8.017a8.474,8.474,0,0,0-3.21,5.345c1.58,0.692,1.56.327,1.07,1.6a8.656,8.656,0,0,1-2.67,3.741,1.8,1.8,0,0,0,.54,1.069,10.117,10.117,0,0,0,4.27,2.672V58.481c2.05-1.617,8.3-11.712,9.09-14.431h0.53V43.516h-0.53c-1.55-1.844-3.86-1.721-4.81-4.276,2.77-2.68,4.86-6.854,6.95-10.155,2.25,0.96,5.23,2.172,5.88,4.81a10.861,10.861,0,0,0-3.21,4.276h0.53c1.33,1.414,8.64,6.564,9.62,5.879,1.63-1.855,1.28-4.158,4.28-4.81,2.53,2.664,6.82,5.232,10.15,6.948-1.09,2.1-2.06,5.3-4.81,5.879-1.08-1.529-2.67-2.172-3.74-3.741h-0.53V48.86c-3.78,3.248-6.31,15.056-11.76,15.5-1.17-1.593-7.85-6.655-9.09-5.879a8.188,8.188,0,0,0-2.67,4.81c2.51,0.874,4.5.977,4.81,4.276-2.61,2.552-3.76,6.579-6.41,9.086a1.8,1.8,0,0,0,.53,1.069c0.4,0.466.67,0.6,1.07,1.069a1.827,1.827,0,0,0,1.07-.534c2.78-2.763,4.94-7.263,6.95-10.69a1.828,1.828,0,0,1,1.07.534c2.68,0.528,4.55,1.07,4.81,4.276a11.9,11.9,0,0,0-3.74,5.879c2.1,0.55,3.81,1.381,4.27,3.742-0.98.638-2.88,2.577-2.14,3.207,1.09,1.261,1.68,2.748,2.68,3.207a2.7,2.7,0,0,0,1.6.534c1.82-6,7.14-9.763,9.09-15.5-1.99-.845-4.43-1.767-5.35-3.741,2.75-2.88,4.89-7.228,6.95-10.69,2.15,0.958,5.25,2.246,5.88,4.81-1.15.986-3.22,3.283-2.67,4.276,1.76,2.24,7.01,5.831,10.15,6.414,0.47-2.275,1.41-4.773,3.74-5.345a3.845,3.845,0,0,0,2.14,1.069c1.96-3.352,5.28-6.828,6.42-10.69-2.19-1.248-4.41-2.914-6.95-3.741v0.535c-1.47,1.651-1.01,3.15-3.74,3.741-1.41-1.736-3.79-2.154-4.81-4.276a10.05,10.05,0,0,0,3.2-5.345c-2.28-.806-4.26-1.013-4.81-3.741,1.93-1.686,1.19-4.112,4.28-4.81,0.98,1.075,5.67,4.5,6.41,3.742a9.929,9.929,0,0,0,2.67-3.742,1.828,1.828,0,0,1,1.07.535c2.28,0.808,2.16,2.116,4.81,2.672,0.9-2.212,1.32-4.439,4.28-4.81C1470.39,41.108,1470.6,41.138,1472.19,41.378ZM25.862,24.808c-1.521,4.822-6.416,7.817-7.483,12.828,2.432,0.478,4.828,1.12,5.345,3.742-1.415,1.267-2.774,2.526-3.207,4.81l10.155,5.879c1.166-3.815,4.43-6.9,6.414-10.155l-4.276-2.138a16.321,16.321,0,0,1-1.6,3.741H30.138c-1.2-1.628-3.766-2.532-5.345-3.741V38.705a25.054,25.054,0,0,0,6.414-9.086c0.134-.517.419-0.2,0-0.535-1.1-1.361-3.144-1.923-4.811-2.672A2.584,2.584,0,0,0,25.862,24.808Zm29.932,0C53.7,29.235,49.985,36.373,46.173,39.24v0.534h0.535c1.323,1.744,8.173,5.935,10.155,4.81a4.581,4.581,0,0,0,2.672-3.741c-2.379-.512-4.572-1.52-5.345-3.742,2.419-2.351,5.843-6.778,6.948-10.155A34.14,34.14,0,0,0,55.794,24.808Zm217.537,0c-1.054,1.819-6.761,11.04-6.414,11.224,1.12,1.058,8.8,4.7,10.69,5.345V40.843c1.8-1.96,2.422-5.051,4.276-6.948-0.342-1.457-.422-3.541-0.534-3.741A23.355,23.355,0,0,0,273.331,24.808Zm-151.26,1.069c-1.089,2.4-2.952,6.342-5.88,6.948a10.857,10.857,0,0,0-4.276-3.207v0.535c-1.686,1.936-1.094,4.167-4.276,4.81-1.267-1.415-2.525-2.774-4.81-3.207A29.887,29.887,0,0,0,101.76,35.5c3.395,0.84,8.446,5.772,9.086,9.086-0.787.7-2.817,2.775-2.138,3.207a4.048,4.048,0,0,0,2.673,2.138c1.561-2.857,4.415-9.441,8.017-10.155,1.271,1.612,3.39,2.288,4.811,3.741a1.834,1.834,0,0,0,1.069-.535c0.814-.795,1.317-1.884,2.137-2.672V39.24c-2.447-.99-4.628-1.3-4.81-4.81a8.772,8.772,0,0,0,3.207-4.81c0.134-.517.419-0.2,0-0.535-1.441-1.3-2.592-.881-3.207-3.207h-0.534Zm577.248,2.138c-1.049,1.787-2.221,2.9-2.672,5.345,2.938,0.628,9.827,4.373,10.155,7.483-1.961,1.648-1.628,3.646-4.81,4.276a8.346,8.346,0,0,0-4.276-3.207v0.535c-1.772,2.047-.979,4.023-4.81,4.276a3.271,3.271,0,0,0-1.069-1.069,9.355,9.355,0,0,1-3.742,4.81,1.522,1.522,0,0,0,.535.534c0.8,0.69,5.243,1.72,5.345,1.6,1.62-1.839.931-3.369,4.275-3.741,0.908,1.38,2.118,2.054,3.207,3.207h1.069a17.933,17.933,0,0,1,2.673-5.345,1.834,1.834,0,0,1,1.069.534c2.816,0.916,5.04,3.325,7.483,4.81,0.447-2.408,1.4-2.248,2.138-4.276,0.134-.517.419-0.2,0-0.535-1.585-1.65-3.7-2.678-4.276-5.345a13.766,13.766,0,0,0,3.741-4.276c-4.384-2.062-11.84-5.662-14.431-9.621h-1.6Zm142.175,1.069-10.156,15.5a1.834,1.834,0,0,0,.535,1.069c0.928,0.706.859,0.923,1.6,0.535,1.788-2.053,1.164-4.4,4.811-4.81,0.86,1.212,5.637,5.077,6.414,4.276,2.34-1.813,5.811-7.441,6.414-10.69C847.586,33.889,844.522,30.926,841.494,29.084Zm-693.234,1.6a16.121,16.121,0,0,1-1.6,3.207c1.312,0.423,3.3,2.274,3.742,1.6a16.794,16.794,0,0,0,1.6-3.207C150.362,31.794,150,31.181,148.26,30.688Zm908.1,1.6-2.67,4.276a1.8,1.8,0,0,0,.53,1.069c1.86,1.617,3.82,1.039,4.28,4.276-1.27.978-1.84,2.281-3.21,3.207a1.6,1.6,0,0,0,.53.535,7.033,7.033,0,0,0,4.81,3.207q2.685-5.077,5.35-10.155C1062.27,37.481,1059.82,34.078,1056.36,32.291Zm-817.771.534c-1.162,2.307-2.707,3.413-3.207,6.414,3.451,0.809,4.231,3.035,7.483,3.741q1.07-2.4,2.138-4.81a3.452,3.452,0,0,0,2.138-.535C243.932,36.675,241.459,34.309,238.589,32.826Zm536.094,5.879c-1.259,4.215-4.47,7.459-6.414,11.224,2.37,0.651,6.491,2.665,7.482,4.81,0.135,0.517.42,0.2,0,.534a7.307,7.307,0,0,1-3.206,4.276,1.511,1.511,0,0,0,.534.535,55.217,55.217,0,0,0,8.017,3.741c1.771-3.1,4.608-6.333,5.345-10.155-2.682-1.231-8.947-4.295-9.621-7.483a8.144,8.144,0,0,0,2.673-4.81C777.365,40.645,777.013,39.394,774.683,38.705Zm388.037,2.672c-0.76,1.433-2.75,3.8-2.14,4.81a9.9,9.9,0,0,0,4.81,2.672,22.033,22.033,0,0,1,2.14-4.81,5.314,5.314,0,0,1-3.2-2.672h-1.61Zm-952.993.534c-0.76,1.433-2.754,3.8-2.138,4.81,1.719,1.545,4.1,1.627,4.81,4.276-1.414,1.267-2.774,2.526-3.207,4.81a7.57,7.57,0,0,0,2.138.535,26.27,26.27,0,0,1,5.88-9.086V46.188a16.473,16.473,0,0,1-5.88-4.276h-1.6Zm382.7,0c-0.76,1.433-2.755,3.8-2.138,4.81,1.719,1.545,4.1,1.627,4.81,4.276-1.415,1.267-2.774,2.526-3.207,4.81a7.561,7.561,0,0,0,2.138.535,26.282,26.282,0,0,1,5.879-9.086V46.188a16.469,16.469,0,0,1-5.879-4.276h-1.6Zm-45.432.535a15.984,15.984,0,0,1-2.673,4.276v1.069a8.773,8.773,0,0,1,3.742,2.138,1.834,1.834,0,0,0,1.069-.535l2.672-3.741C550.055,44.608,549.016,43.165,546.99,42.447Zm926.81,1.069c-0.44,1.656-2.84,4.726-2.14,5.345A6.476,6.476,0,0,0,1473.8,51c0.58-3.208,2.53-3.344,3.2-6.414C1475.93,44.228,1474.86,43.872,1473.8,43.516Zm-1325,1.069a21.189,21.189,0,0,1-5.345,8.552,1.827,1.827,0,0,0,.535,1.069l0.534,1.069h0.535V54.74c1.639-1.074,5.462-6.954,5.879-9.086ZM1227.93,45.119a56.656,56.656,0,0,0-3.21,5.345c1.78,0.891,3.57,1.782,5.35,2.672,0.53-1.425,1.07-2.851,1.6-4.276h0.54V48.326h-0.54A15.257,15.257,0,0,0,1227.93,45.119Zm73.22,1.6c-1.13,2.251-1.51,5-4.81,5.345-0.97-1.265-2.28-1.84-3.2-3.207h-0.54v0.535c-4.46,3.6-5.57,10.925-10.15,14.431v0.535h0.53c1.87,2.12,4.36,1.028,4.81,4.81a9.41,9.41,0,0,0-3.2,4.276h0.53c0.93,0.707.86,0.923,1.6,0.534,2.92-2.414,3.18-8.193,7.49-9.086,0.93,0.706.86,0.923,1.6,0.534,3.9-4.19,5.63-11.475,10.16-14.966V49.929C1303.95,49.256,1302.87,47.773,1301.15,46.723Zm87.66,2.672c-1.91,4.134-4.87,7.176-6.95,11.224h-1.07a7.606,7.606,0,0,0-4.81-3.207c-0.93,2.391-1,4.49-4.27,4.81a10.884,10.884,0,0,0-4.28-3.207V59.55c-1.68,1.936-1.09,4.167-4.27,4.81a8.4,8.4,0,0,0-4.28-3.207v0.535a8.135,8.135,0,0,0-2.67,4.81c3.19,1.184,6.24,2.841,6.95,6.414-2.46,2.414-8.93,11.9-9.63,15.5,2.78,1.2,7.03,3.4,9.09,5.345a1.828,1.828,0,0,0,1.07-.534,7.314,7.314,0,0,0,2.67-4.276h0.54V88.413h-0.54c-2.39-2.266-6.48-2.126-6.95-6.414,3.89-3.729,7.13-10.02,9.63-14.966a1.826,1.826,0,0,1,1.06.534c2.43,0.623,3.55,2.029,5.35,3.207-1.04,2.131-2.52,3.5-3.74,5.345,1.4,0.406,1.27.64,2.67,1.069V76.654c2.14-2.338,2.95-7.092,5.88-8.552,1.35-.262,8.55,3.207,8.55,3.207a7.314,7.314,0,0,0,2.67-4.276h0.54V66.5c-2.51-.506-5-1.373-5.35-4.276,2.74-2.667,3.93-7.284,6.95-9.621V52.067C1391.7,51.5,1390.38,50.333,1388.81,49.395Zm-703.387.535a7.6,7.6,0,0,1-2.138,3.207,1.511,1.511,0,0,0,.534.535l0.535,1.069h1.069a11.054,11.054,0,0,0,1.6-3.207c0.134-.517.419-0.2,0-0.535C686.305,50.131,686.684,50.4,685.423,49.929Zm105.294,0a15.7,15.7,0,0,1-2.138,3.207v1.069a1.831,1.831,0,0,1,1.069.535,1.831,1.831,0,0,0,1.069-.535A5.577,5.577,0,0,0,792.855,51,8.048,8.048,0,0,0,790.717,49.929ZM676.871,51c-1.04,2.075-2.232,3.1-2.673,5.879a3.99,3.99,0,0,1,2.138,2.138,15.357,15.357,0,0,0-3.207,3.741H674.2c0.929,0.706.86,0.923,1.6,0.534a27,27,0,0,0,5.879-9.621C679.622,52.984,678.985,51.71,676.871,51Zm-127.743.535a8.67,8.67,0,0,1-2.673,3.741,1.834,1.834,0,0,0,.535,1.069,10.151,10.151,0,0,0,4.276,2.672l0.534-1.069a8.138,8.138,0,0,0,1.6-4.276Zm-45.432.534c-1.074,1.809-6.747,9.087-5.879,10.155,2.107,2.363,3.9,1.918,5.345,5.345h1.069c2.055-3.546,5.207-7.035,6.414-11.224Zm408.885,0c-0.745,2.426-2.39,3.581-3.207,5.879a8.048,8.048,0,0,0,2.138,1.069,12.46,12.46,0,0,1,3.207-4.81V53.136A7.159,7.159,0,0,1,912.581,52.067Zm407.279,0c-1.6,5.935-7.79,9.652-9.08,15.5a13.5,13.5,0,0,0,2.67,1.069c0.25-2.742.81-4.038,3.74-4.276,0.72,0.868.34,0.6,1.6,1.069,0.49-3.5,4.19-8.057,6.42-10.155V54.205A34.189,34.189,0,0,0,1319.86,52.067ZM889.6,53.136c-0.984,2.388-1.651,4.959-4.811,5.345a4.75,4.75,0,0,0-1.6-1.6c-0.58,1.866-1.52,2.424-2.138,4.276,2.464,1.444,4.482,3.334,7.483,4.276,0.589-1.939,1.7-2.784,2.672-4.276,1.038,0.5,2.188,1.718,2.673,1.069a10.144,10.144,0,0,0,2.672-4.276C893.77,56.434,893.135,54.1,889.6,53.136Zm258.162,0.535a10.324,10.324,0,0,0,2.13,1.6,1.8,1.8,0,0,1-.53,1.069c-1.03,3.835-4.12,5.488-5.35,9.086h0.54a16.678,16.678,0,0,0,6.95,4.81c1.52-2.792,3.39-7.186,5.88-9.086V60.619C1153.62,59.488,1151.57,55.072,1147.76,53.671ZM83.053,54.205v1.6c2.192,0.462,3.289.844,3.741,3.207-1.415,1.267-2.774,2.526-3.207,4.81a1.831,1.831,0,0,1,1.069.535,91.7,91.7,0,0,1,15.5-1.6,5.875,5.875,0,0,1,1.069-1.6V60.085c-1.211-.585-4.432-2.668-4.81-2.138-1.449,1.56-.777,2.349-3.741,2.672C90.415,58.285,86.464,55.161,83.053,54.205ZM1463.64,90.551c-0.26,1.767-2.07,4.512-1.6,4.81,2.26,2.127,10.01,3.441,13.89,3.741,0.66-2.463,2.64-6.4,5.35-6.948a4.724,4.724,0,0,0,1.6,1.6c0.71-2.047,1.64-1.874,2.14-4.276-2.93-1.33-9.42-4-10.16-7.483,2.59-2.552,4.79-6.777,6.42-10.155,2.23,1.08,3.25,2.665,5.88,3.207,0.93-2.243,1.45-4.289,4.27-4.81,1.79,1.7,3.84,1.6,4.28,4.81a7.314,7.314,0,0,0-2.67,4.276A8.718,8.718,0,0,1,1496.78,82a1.828,1.828,0,0,0,1.07-.535c2.41-2.549,4.31-6.916,5.88-10.155a1.862,1.862,0,0,1,1.07.535c4.47,1.207,6.24,5.1,10.69,6.414V77.723c-5.03-3.019-9.34-7.406-14.97-10.155,0.18-.534.36-1.069,0.53-1.6,1.78-2.047.98-4.023,4.81-4.276a6.853,6.853,0,0,0,3.75,3.207c0.74-1.264,2.09-3.392,1.6-4.276-1.83-2.387-5.19-2.713-6.95-5.345h-0.53v0.535c-3.05,2.614-3.25,9.462-8.02,10.155-2.49-2.5-6.13-3.851-8.55-6.414a1.828,1.828,0,0,0-1.07.535c-1.12,1.195-1.88,3.363-2.67,4.81a1.828,1.828,0,0,1-1.07-.534c-1.35-.48-4.28-3.507-4.81-2.672-1.84,2.23-.73,4.542-4.81,4.81-0.82-1.381-2.61-3.251-3.75-2.672-1.23.916-2.6,3.943-2.13,4.81,2.8,2.524,9.11,3.342,9.62,8.017-2.43,1.586-4.91,5.673-5.88,8.552,2.72,0.747,2.9,2.362,4.81,3.741-0.99,2.366-1.92,5.3-4.81,5.879A12.071,12.071,0,0,0,1463.64,90.551ZM823.856,56.343a44.836,44.836,0,0,0-2.673,4.276c3.314,1.02,4.628,3.7,7.483,4.81V64.9a6.891,6.891,0,0,0,2.672-4.276Zm345.284,4.276c-0.52,1.509-3.6,4.513-2.68,5.345,1.07,1.072,2.66,1.616,3.74,2.672a1.827,1.827,0,0,0,1.07-.534c1.23-1.314,2.13-3.416,3.21-4.81A20.645,20.645,0,0,0,1169.14,60.619Zm71.08,0c-0.99,2.428-1.5,5.015-4.81,5.345-1.01-1.641-1.95-2.788-4.27-3.207-0.41,1.546-2.65,5.01-2.14,5.345,0.86,1.228,1.14.807,1.6,2.672a11.078,11.078,0,0,0-2.67,4.81,1.828,1.828,0,0,1,1.07.534,1.828,1.828,0,0,0,1.07-.534,22.967,22.967,0,0,0,3.2-4.81h1.07c1.65,2.006,4.63,2.91,6.42,4.81a1.828,1.828,0,0,0,1.07-.535,9.314,9.314,0,0,0,2.13-4.276c-1.56-.788-1.72-0.578-2.13-2.672a7.613,7.613,0,0,0,3.2-4.81C1243.11,62.723,1241.79,61.557,1240.22,60.619Zm-1035.3.535a13.024,13.024,0,0,1-2.137,3.741,1.833,1.833,0,0,0,.534,1.069c1.744,1.789,4.351,2.818,5.879,4.81h0.535V70.24a5.577,5.577,0,0,0,2.138-3.207c0.134-.517.419-0.2,0-0.535C211.367,66.02,205.19,61.259,204.916,61.154Zm382.7,0a13,13,0,0,1-2.138,3.741,1.827,1.827,0,0,0,.535,1.069c1.744,1.789,4.35,2.818,5.879,4.81h0.535V70.24a5.58,5.58,0,0,0,2.137-3.207c0.135-.517.42-0.2,0-0.535C594.061,66.02,587.885,61.259,587.611,61.154Zm592.749,0c-0.69,1.315-2.14,2.878-1.6,3.741,0.93,0.706.86,0.923,1.6,0.534a6.013,6.013,0,0,0,2.14-3.741Zm378.95,0-5.88,10.69c-1.5-.219-1.52-0.654-2.67,0a7.119,7.119,0,0,0-2.14,3.207c2.16,0.537,3.21,1.542,5.35,2.138,1.65-5.318,6.46-8.385,8.02-13.9h0.53V62.757h-0.53A3.773,3.773,0,0,0,1559.31,61.154Zm-1365.618.535c-1.082,2.134-2.628,3.228-3.741,5.345,2.57,0.538,4.85,1.495,5.345,4.276-1.044.994-2.559,3.505-2.138,4.276,0.721,0.868.342,0.6,1.6,1.069V76.119c2.513-2.7,3.518-7.333,6.414-9.621V65.964C198.481,65.08,196.4,62.977,193.692,61.688Zm382.695,0c-1.082,2.134-2.628,3.228-3.742,5.345,2.57,0.538,4.851,1.495,5.345,4.276-1.044.994-2.559,3.505-2.138,4.276,0.722,0.868.342,0.6,1.6,1.069V76.119c2.513-2.7,3.517-7.333,6.414-9.621V65.964C581.176,65.08,579.094,62.977,576.387,61.688Zm501.353,1.069c-0.53,2.086-1.5,2.9-2.14,4.81a8,8,0,0,0,2.14,1.069c0.62-2.352,1.93-3.144,2.67-5.345h-1.07A2.7,2.7,0,0,0,1077.74,62.757Zm130.41,0.534c-0.53,1.781-1.07,3.563-1.6,5.345h1.07v0.535h0.53c0.64-2.133,1.97-3.315,3.21-4.81a3.256,3.256,0,0,1-1.07-1.069h-2.14ZM412.3,63.826c-0.983,2.388-1.65,4.959-4.81,5.345a4.758,4.758,0,0,0-1.6-1.6c-0.58,1.866-1.52,2.424-2.138,4.276,2.464,1.444,4.481,3.334,7.483,4.276,0.589-1.939,1.7-2.784,2.672-4.276,1.037,0.5,2.187,1.718,2.672,1.069a10.145,10.145,0,0,0,2.673-4.276C416.47,67.124,415.836,64.794,412.3,63.826ZM328.437,51.9c-0.8,2.824-2.574,2.937-3.207,5.879,1.8,0.764,6.978,4.2,7.483,3.741,1.251-1.244,1.94-3.048,3.207-4.276V56.171C333.287,54.873,331.366,52.857,328.437,51.9ZM944.65,65.964c-0.625,2.352-1.928,3.144-2.672,5.345h0.534c0.722,0.868.342,0.6,1.6,1.069V71.844l3.207-4.81A13.78,13.78,0,0,0,944.65,65.964ZM1109.27,66.5l-2.67,5.345a1.827,1.827,0,0,1,1.07.534h1.07c0.67-2.133,1.94-2.763,2.67-4.81C1110.7,67.211,1109.99,66.855,1109.27,66.5Zm-8.55,1.6c-0.94,1.889-1.62,4.508-3.74,5.345a1.957,1.957,0,0,0,1.07.534c0.96,1.373,1.29.876,1.6,3.207a5.365,5.365,0,0,0-2.67,3.207h0.53c0.84,0.977.48,0.746,2.14,1.069,1.2-3.915,4.21-6.135,5.35-10.155C1103.19,70.4,1102.3,69.153,1100.72,68.1Zm58.8,2.138-5.88,9.621a1.828,1.828,0,0,1-1.07-.534c-1.5-.531-3.94-3.658-4.81-2.672-1.12,1.195-1.88,3.363-2.68,4.81,2.96,0.921,4.63,3.259,7.49,4.276V85.206c2.21-1.769,8.49-11.321,9.08-14.431h-0.53V70.24h-1.6Zm-79.11.535c-0.73,2.623-2.34,2.985-3.21,5.345a25.7,25.7,0,0,1,5.88,2.138c0.53-2.086,1.51-2.9,2.14-4.81C1083.62,72.556,1082.01,71.665,1080.41,70.775Zm462.33,1.069c-1.21,2.832-1.81,4.171-4.81,5.345a1.856,1.856,0,0,0,.54,1.069c1.35,1.214,3.86,2.278,5.34,3.207,0.78-2.421,2.59-4.592,3.74-6.948a5.314,5.314,0,0,1-3.2-2.672h-1.61ZM624.9,68.378c-0.58,1.866-1.52,2.424-2.138,4.276H623.3c1.1,1.269,2.87,1.161,5.344,1.069q0.268-.8.535-1.6c0.134-.517.419-0.2,0-0.534A10.862,10.862,0,0,0,624.9,68.378Zm896.456,6.138a14.606,14.606,0,0,1-3.74,5.345,9.613,9.613,0,0,0,2.68,1.6,36.2,36.2,0,0,0,3.2-6.414h-0.53V74.516h-1.61Zm-272.05,1.069c-0.76,1.433-2.75,3.8-2.14,4.81a3.845,3.845,0,0,0,2.14,1.069c0.4-2.48,1.57-3.134,2.67-4.81a3.354,3.354,0,0,1-1.07-1.069h-1.6Zm73.22,1.6c-0.87,2.51-.97,4.5-4.27,4.81a2.726,2.726,0,0,0-1.6-.535c-0.99,1.491-1.71,1.51-2.14,3.741,2.43,0.478,4.82,1.12,5.34,3.741-1.41,1.267-2.77,2.526-3.2,4.81a7.52,7.52,0,0,0,2.13.534c1.77-3.587,4.73-6.022,5.88-10.155-1.96-.541-1.88-0.351-2.14-2.672a12,12,0,0,0,2.68-3.207,3.257,3.257,0,0,1-1.07-1.069h-1.61Zm230.9,1.6c-1.16,4.2-4.98,5.721-5.88,10.155,1.44,0.76,3.8,2.754,4.82,2.138a19.2,19.2,0,0,0,2.67-4.81c1.5,0.34,1.93.949,2.67,0.535a7.26,7.26,0,0,0,2.14-3.742h0.53V82.533h-0.53A16.234,16.234,0,0,0,1553.43,78.792ZM916.839,74.464a10.506,10.506,0,0,1-2.138,3.207V78.74a1.827,1.827,0,0,1,1.069.534,1.827,1.827,0,0,0,1.069-.534A4.847,4.847,0,0,0,918.977,75ZM1397.9,87.344a11.706,11.706,0,0,0-1.07,4.276h0.53v0.534a1.828,1.828,0,0,0,1.07-.534,17.46,17.46,0,0,0,2.14-3.207,3.257,3.257,0,0,1-1.07-1.069h-1.6Zm171.57,11.224V96.43a5.365,5.365,0,0,0,2.67-3.207h0.54V92.689h-0.54c-1.13-1.354-2.92-1-4.27-2.138-0.36-1.069-.72-2.138-1.07-3.207h-1.61c-0.87,1.824-5.37,8.462-4.81,9.086C1562.44,98.489,1565.13,98.675,1569.47,98.568Zm-171.57-4.81c-0.69,1.314-2.14,2.878-1.61,3.741,1.06,0.973,5.62,5.85,6.42,4.81,1.47-1.651,1-3.15,3.74-3.741a1.957,1.957,0,0,0,1.07.534A26.962,26.962,0,0,0,1397.9,93.758Zm-829-21.38c-0.58,1.866-1.52,2.424-2.138,4.276H567.3c1.1,1.269,2.87,1.161,5.344,1.069q0.268-.8.535-1.6c0.134-.517.419-0.2,0-0.534A10.862,10.862,0,0,0,568.9,72.378Zm-231-27c-0.58,1.866-1.52,2.424-2.138,4.276H336.3c1.1,1.269,2.87,1.161,5.344,1.069q0.269-.8.535-1.6c0.134-.517.419-0.2,0-0.535A10.862,10.862,0,0,0,337.9,45.378Zm-38,9c-0.58,1.866-1.52,2.424-2.138,4.276H298.3c1.1,1.269,2.87,1.161,5.344,1.069q0.269-.8.535-1.6c0.134-.517.419-0.2,0-0.535A10.862,10.862,0,0,0,299.9,54.378Zm338.935-3.914a10.506,10.506,0,0,1-2.138,3.207V54.74a1.827,1.827,0,0,1,1.069.535,1.827,1.827,0,0,0,1.069-.535A4.847,4.847,0,0,0,640.977,51Z"/>
						</svg>';
				break;

			case '61':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 113">
							<path style="fill:'. $c1 .'" d="M108.948,0.5H437.929V3.7H108.948V0.5Zm332.719,0h17.09V3.7h-17.09V0.5Zm20.829,0h46.463V3.7H462.5V0.5Zm53.94,0H887.073a9.093,9.093,0,0,0,.534,3.2H800.022a9.786,9.786,0,0,0-.535,3.2H786.67V4.238a9.777,9.777,0,0,0-3.2-.534,9.763,9.763,0,0,0-.534,3.2h-4.807V3.7h-98.8v3.2h-4.806V4.238c-6.689-2.2-21.254-.534-29.374-0.534H579.989a9.763,9.763,0,0,0-.534,3.2H549.547V3.7h-3.2v3.2H524.981V3.7h-8.545V0.5Zm373.842,0h67.291V3.7l12.284-.534V6.909H949.024V3.7H915.913v3.2h-9.079V4.238h-3.2v2.67H894.55V3.7h-4.806V3.17A4.631,4.631,0,0,0,890.278.5Zm83.313,2.67h8.545V6.909h-8.545V3.17ZM0,9.579H118.027v2.67h319.9v3.2H394.67c-3.013,0-14.9,1.318-15.488,1.068-5.883-2.508-17.84-1.068-25.634-1.068H263.291c-5.428,0-12.818-.556-16.555,1.068h-11.75c-9.207,0-27.4,1.875-34.18-1.068H108.948V13.317H0V9.579Zm441.667,2.67c22.194,0,44.026,0,67.292,0v3.2H467.3c-1.922.835-18.1,2.486-21.362,1.068a7.075,7.075,0,0,0-4.273-1.068v-3.2Zm74.769,0,586.394,0.534v3.738H982.136v2.136h-8.545V16.522h-3.738v2.136H949.024V16.522c-6.756,0-16.389.918-21.362-1.068,0,0-9.458,1.068-11.749,1.068v2.136h-9.079V16.522h-3.2v2.136H894.55V16.522H799.487v2.136H786.67V16.522h-3.738v2.136h-4.807V16.522h-98.8v2.136h-4.806V16.522H579.455v2.136H549.547V16.522h-3.2v2.136H524.981v-3.2c-3.716.083-4.539,1.005-8.545,1.068V12.249Zm590.134,0.534h96.13v3.738h-96.13V12.783Zm99.87,0h208.28v3.738H1206.44V12.783Zm212.02,0h58.22v3.738h-58.22V12.783Zm61.95,0h79.58v3.738h-79.58V12.783Zm83.32,0h38.45v3.738h-38.45V12.783ZM0,19.192H110.016v2.136h3.2V19.192H425.646v2.67h3.738v-2.67H890.812v2.67h3.738v-2.67h17.09v2.67h3.738v-2.67h21.363v2.67h3.738v-2.67H1090.55v2.67h3.74v-2.67h54.47v2.67h3.74v-2.67h120.7v2.67h3.74v-2.67h108.95v2.67c30.09,0.009,59.66,0,90.79,0v6.409h-58.22V25.6h-3.74v2.67H1206.44V25.6h-3.74v2.67h-96.13V25.6h-3.74v2.67H927.662V25.6h-3.205v2.67H546.343v2.67c246.475,0,483.207,0,726.857,0v2.67h3.74v-2.67l187.45,0.534v2.136h3.74V31.476h134.05v83.006H0V28.271H118.027v2.67h3.739v-2.67h79.04V25.6L0,25.067V19.192Zm1480.41,2.67c31.65,0,62.77,0,91.86,0v2.67h19.76v-2.67h10.15v6.409h-38.45V25.6h-3.74v2.67h-79.58V21.862ZM437.929,22.4v3.2h-53.94v2.67h53.94v2.67h3.738v-2.67h4.273V25.6h-4.273V22.4h-3.738Zm20.828,0v2.136H462.5V22.4h-3.739Zm748.223,0v2.136h3.73V22.4h-3.73Zm61.95,0v2.136h3.73V22.4h-3.73ZM246.736,25.6v2.67H379.182V25.6H246.736Zm220.566,0v2.67h49.134V25.6H467.3Zm53.94,0v2.67h3.739V25.6h-3.739Zm-299.073,2.67v2.67h3.738v-2.67h-3.738ZM130.311,34.68v3.2h4.272v-3.2h-4.272Zm25.1,2.67a4.446,4.446,0,0,0,4.273,0h-4.273Zm232.316,0v2.67H392V37.35h-4.273Zm37.385,0a4.444,4.444,0,0,0,4.272,0h-4.272Zm-190.66.534V40.02h3.739V37.884h-3.739Zm232.316,0V40.02h4.273V37.884h-4.273Zm25.1,0V40.02h4.273V37.884h-4.273Zm87.586,0v2.67c278.07,0,557.555.319,834.735,0.534v-3.2C1138.46,37.837,856.7,38.094,579.455,37.884Zm847.555,0v3.2h3.74v-3.2h-3.74Zm49.67,0v3.2h4.27v-3.2h-4.27Zm45.92,0v3.2h3.74v-3.2h-3.74Zm20.3,0v3.2h4.27v-3.2h-4.27Zm25.1,0v5.341h4.27V37.884H1568Zm-1130.071.534v2.136h3.738V38.418h-3.738Z"/>
						</svg>';
				break;

			case '62':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 136">
							<path style="fill:'. $c1 .'" d="M1215.67,47.9c1.74,0.313,1.61.2,2.52,0.84-1.74.994-1.58,0.575-2.52,2.521,1.09,0.466.62,0.025,0.84,0.84a26.33,26.33,0,0,1-5.03,2.521c-1.79-4.049-10.2-2.666-14.25-6.722-1.85-1.849-.81-4.525-3.35-5.882-2.47,2.1-22.86.889-27.67,0-0.24,2.223-.69,1.759-5.03,1.681-0.69-2.727.42-1.284-1.67-2.521-0.99,1.6.05,1.016-1.68,0.84-1.44-.648-7.04-6.318-8.38-7.562,2.58-.872,2.45-0.812,3.35-3.361a5.058,5.058,0,0,1-1.67-1.68c-3.11,2.02-2.52.8-6.71,0-0.85,4.1-1.33,3.226-3.35,5.041-0.7-2.727.41-1.284-1.68-2.521v0.84c-1.2,1.752-.53,2.994-2.51,4.2-3.97,2.886-19.52,2.592-25.15,5.041-0.81-2.221-2.87-2.874-5.87-1.68V39.5c-0.2-.713-1.36-1.378-3.35-2.521-0.39,3.487-.27,2.821-2.52,4.2l1.68,2.521c-3.62.4-5.92,1.487-10.06,0-0.93,6.4-7.63,6.016-11.74,9.243-1.14.9-1.36,4.165-2.51,5.041-3.09,2.343-4.35-.927-5.87,1.681,1.36,1.134.94,0.538,1.68,2.521-2.92,1.171-2.26,2.037-2.52,5.882-5.35.3-3.23,3.683-6.7,5.882-4.01,2.542-7.82,1.855-10.9,5.041-1.47-.53-0.81-0.162-1.68-0.84-0.67-.858-0.29-0.23-0.83-1.68,4.78-1.4,16.85-10.173,17.6-12.6-3.06-2.5-4.98-8.959-6.71-12.6-4.35-.278-4.32-0.55-7.54.84,3.15-4.846,9.96-4.612,11.73-10.083-1.8-1.457-2.37-3.6-4.19-5.041-3.06-1.987-16.76-3.361-16.76-3.361-4.02,2.2-9.82,7.2-14.25,8.4-2.7.734-8.97-1.208-10.06-1.68-4.26,2.1-11.86,3.632-16.77,5.041h-6.7c-1.879.824-4.445,4.093-6.706,5.041-4.352,1.826-15.089-3.361-15.089-3.361-3.068,1.738-10.786,7.228-14.25,1.681,2.417-1,3.542-2.157,4.191-5.041-1.692-1.326-2.387-3.005-3.353-5.041-3.9-.177-13.062-2.4-15.927-1.681-1.381.346-3.525,2.115-5.029,2.521-2.175-.719-2.887-2.047-5.868-2.521-1.662,3.969-7.455,5.379-11.736,6.722-5.24,1.644-20.712,4.251-29.339,6.722l-6.706-.84c-2.943.6-9.35,1.757-13.412,3.361,3.621-4.444,11.685-4.63,15.927-8.4l-0.838-2.521c-1.612-1.451-3.911-4.12-5.868-5.041h-4.191l-2.515-3.361c-1.154-.617-6.568,5.237-9.221,5.041-3.161-.233-12.453-3.144-15.927-1.681L849.354,39.5a22.178,22.178,0,0,1-12.574,1.681c-2.3.889-5.562,3.415-7.544,4.2-3.285,1.3-5.814-1.237-7.545-1.681-4.316,1.343-10.533,3.925-13.412,5.041a9.2,9.2,0,0,1-1.676,2.521c1.626,4.407,3.682,7.6,4.191,12.6-3.311,2.517-6.079,7.387-7.544,9.243-1.994-3.182-1.852-.148-3.353-1.681h-0.839c1.912-1.861,4.36-2.543,3.354-5.041-0.774-2.762-1.559-4.049-4.192-5.041-5.581-3.971-11.427-1.456-18.441-.84v-0.84c5.418-3.317,8.518-4.412,13.412-2.521,1.345-1.931,1.795-1.269,2.514-4.2-1.108-1.46-1.448-1.351-.838-2.521,1.822-2.939,4.454-2.055,5.868-5.882H799.9c-0.774-2.762-1.559-4.05-4.192-5.041-12.607-8.917-24.4,7.06-36.045,7.562-3.534,2.348-10.354-1.7-11.735-4.2l-2.515.84c-3.077,7.25-7.687,9.074-14.25,12.6-1.609.865-7,1.807-7.544,0.84-0.8,1.125.379,2.708-.839,3.361-3.167,1.7-21.521-2.88-25.147-4.2l-12.574-.84q-0.42-1.26-.838-2.521c-3.556-2.145-9.1-3.564-12.574-5.041-7.866-3.342-22.16-1.882-25.148-4.2-0.706,3.832-1.509,3.476-5.868,3.361-3.2-1.269-9.605.9-14.25,1.681-0.312-1.744-.2-1.617-0.838-2.521-0.312,1.744-.2,1.617-0.839,2.521-3.467-2.936-4.658.4-10.059-.84-1.734-2.186-7.491-.343-12.574-1.681-8.216-2.162-21.174.607-28.5,5.882a11.99,11.99,0,0,1-7.545-4.2c-3.539,1.6-4.6,1.648-9.22,2.521-0.762,1.456-5.5,8.537-6.706,9.243-1.228-.7-8.358-1.45-10.9-1.681v3.361h-0.838c-3.131-1.677-11.635-1.451-15.927-3.361,0.621-.732,1.056-0.948,1.677-1.68-4.161.544-5.079,1.183-8.383,1.68v-0.84c2.069-1.088.571,0.36,1.677-1.681-1.677.024-.236,0.86-1.677,0-0.571.648-1.1,1.875-1.676,2.521-4.2-3.386-10.472,1.641-11.736-3.361-0.211-.813-0.657-0.319,0-0.84,2.149-4.281,11.3-3.936,12.574-9.243-0.593-1.3-.108-0.114,0-2.521-2.225.032-1.266,0.172-2.515-2.521-2.054.508-2.485,1.974-3.353,0.84h-0.838V39.5c0.536-.86,1.818-0.172.838-0.84a14.882,14.882,0,0,0-1.676-3.361c-3.456,4.134-7.746,4.587-11.736,2.521-1.844,1.125-3.307,4.721-7.544,3.361-1.111-.357-4.63-4.05-7.544-2.521,0,0-3.006,4.042-3.353,4.2-2.367,1.081-6.769,1.223-8.383,1.68-5.141,1.459-13.6.238-14.25,0.84a7.458,7.458,0,0,0-2.515,2.521c-3.626-1.842-8.416-2.093-12.574-2.521v3.361h-0.838c-2.285-1.309-2.828.562-5.868,0-4.254-.786-8.747-3.207-11.736-5.041-3.582.381-6.735,1.548-8.382-.84,2-.707,1.379-0.337,2.515-1.681a2.384,2.384,0,0,1-.839-0.84c-13.674,6.936-37.427,5.132-54.486,4.2v5.041H356.46a12.187,12.187,0,0,0-1.677-5.882c-6.276,3.609-8.179,3.691-17.6,2.521V43.7a2.381,2.381,0,0,0-.838.84c-2.883.106-2.9,2.272-8.383,2.521-0.9-.632-0.793-0.505-2.515-0.84-0.311,1.744-.2,1.617-0.838,2.521-1.22-2.136.182-.948-2.515-1.681-0.312,1.744-.2,1.617-0.838,2.521-3.614-2.342-9.836.612-15.089,0.84,0.164-1.956.162-2.374,0.839-3.361,1.123-2.327,2.219-1.881,3.353-4.2-1.091-.466-0.622-0.025-0.839-0.84,1.036-2.577,1.927-2.449,2.515-5.882h-2.515v2.521c-2.811-.467-5.26-1.278-5.867-2.521a5.126,5.126,0,0,1-1.677-1.68h0.838a9.711,9.711,0,0,0,2.515,1.68V33.617c-2.963-.6-2.08-1.032-5.029-1.68,0.058,1.964.744,1.446-.839,3.361-0.9-.632-0.792-0.505-2.514-0.84-0.312,1.744-.2,1.617-0.839,2.521v-0.84c-1.3-.952-0.706-0.911-2.514-1.68V31.937h-2.515c-0.694,2.727.411,1.284-1.677,2.521-0.694-2.727.411-1.284-1.676-2.521-3.353,2.125-20.8.453-27.663,0v5.041h-3.353a12.176,12.176,0,0,0-1.676-5.882c-6.276,3.609-8.18,3.691-17.6,2.521V31.1a2.389,2.389,0,0,0-.838.84c-2.882.106-2.9,2.272-8.382,2.521-0.9-.632-0.793-0.505-2.515-0.84v2.521l4.191,0.84c0.56,2.776.834,1.965,1.677,4.2-2.72.7-1.281-.412-2.515,1.681-2.151-1.667-3.618-3.447-6.706-4.2a10.652,10.652,0,0,0,.838,3.361l-4.191.84V40.339c-2.549.395-2.632,1.667-3.353,0.84l-1.677-.84V37.819h-5.029v2.521h3.353c0.312,1.744.2,1.617,0.838,2.521,4.985,4.531,10.691,2.64,15.927,6.722h-3.353V52.1c-5.082-.5-5.234-1.032-10.9-0.84V47.9H212.28v3.361h-0.838c-1.72-1.074-2.775-.6-5.03-0.84-0.793-2.851-.323-2.614-3.353-3.361-0.312,1.744-.2,1.617-0.838,2.521-0.918-1.256-13.77-1.609-19.28-.84V46.221c-10.012.926-19.538,2.112-26.824,7.562-1.512-.4-2.138-2.673-5.03-1.681-6.054,2.078-7.253,7.177-16.765,6.722-0.312,1.744-.2,1.617-0.838,2.521-0.989.674-1.409,0.649-3.353,0.84v2.521c-5.422,1.046-6.024,4.851-11.736,5.882-0.991-1.737-.573-1.581-2.514-2.521-0.661,1.769.026,1.518-.839,2.521-1.221-2.1-.491-1.812-3.353-2.521a10.676,10.676,0,0,0,.839,3.361h-1.677c-1.22-2.136.182-.948-2.515-1.68a10.653,10.653,0,0,1-.838,3.361H106.66v-4.2h-2.515V63.026a11.834,11.834,0,0,0-3.353-.84c-0.706,2.007-.337,1.382-1.677,2.521V62.185c-3.261.215-3.673,1.015-5.029,0-0.674-.858-0.3-0.23-0.838-1.68l1.676-.84c1.4-.84,3.355-0.973,5.868-0.84-0.615-2.652-.355-2.006,0-5.882H99.954v0.84H99.115c-0.555,1.685-.316,2.62-0.838,3.361V56.3c-0.674-.858-0.3-0.23-0.838-1.681A11.251,11.251,0,0,0,101.63,47.9H99.954c-0.529,1.474-.162.816-0.838,1.681L98.277,43.7h1.677c0.312,1.744.2,1.617,0.838,2.521v-4.2a2.381,2.381,0,0,1-.838-0.84c-2.36.96-2.1,1.683-3.353,1.681-0.706-1.012-.3-0.772-0.838-2.521H94.086c0.146,2.644.432,1.262,0,3.361-2.515-2.332-4.27-6.09-7.544-7.562-1.085.737-2.068,0.751-4.191,0.84-0.694-2.727.411-1.284-1.677-2.521-2.58,1.7-15.838,5.106-22.633,6.722-3.751.892-4.629-1.767-7.544,0-0.649.394-1.7,2.924-2.515,3.361C41.159,48.194,35,49.388,28.7,52.943c-2.705,1.526-4.838,5.2-7.544,6.722-2.287,1.288-4.855.865-6.706,2.521C9.324,66.769,5.567,71-3.99,71.428v70.58H1605.46V54.623c0-14.566,1.66-32.3-.84-45.373h-3.35c-5.13,2.277-11.58-2.163-15.93-3.361-4.12-1.136-11.19,1.725-16.76,1.68a25.713,25.713,0,0,1-2.52,4.2v-0.84a9.817,9.817,0,0,1-1.67-2.521h-0.84c0.05,2.442.81,1.167,0,2.521-1.44,1.062-3.02,1.157-4.19,2.521-1.69,2.388-.4,3.737-1.68,5.882-0.07-.081-1.1-2.425-1.68-1.681v0.84c-3.96,1.965-5.79,3.5-11.73,5.882,0.33,2.464,1.37,1.053-.84,2.521-4.73,4.379-10.79,3.322-15.93,5.882-0.31-1.744-.2-1.617-0.84-2.521-6.75,5.478-17.24-.75-17.6,10.083,2.13,1.223.95-.182,1.68,2.521-2.39-.269-1.74-0.887-3.36,0-1.26,2.021-1.12,5.769-2.51,7.562-1.58-.722-0.62-0.4-2.52,0,0.01-2.657,1.42-1.13-.83-2.521v3.361a12.079,12.079,0,0,0-4.2.84c0.18-2.811,1.81-2.016-.83-3.361-0.94,2.414-.15,1.548-2.52,2.521,0.35-3.611-.16-2.827-0.84-6.722a16.184,16.184,0,0,0,1.68-3.361,11.834,11.834,0,0,0,3.35.84c-0.46-3.824-1.96-4.546-3.35-7.562-5.29-.023-6.97-7.79-13.41-9.243a14.378,14.378,0,0,0-.84-5.041c1.59,0.052,7.08-.859,8.38-3.361h-0.84v-0.84c-0.73.622-.94,1.058-1.67,1.68-0.35-3.008.39-2.114-1.68-3.361-3.89-2.855-10.28,1.17-15.93,1.681v3.361c-3.99-.545-7.6.718-13.41,0.84V18.493c0.89-1.474.51-1.834,0.84-4.2h-4.19c-1.75,2.033-1.48.355-3.35,1.681-0.63.9-.51,0.794-0.84,2.521-5.23.294-4.01,1.9-6.71,3.361-4.45,2.406-10.11.433-13.41,0.84-2.22,7.609-10.15,12.493-15.09,17.645a154.039,154.039,0,0,1-16.76-7.562c-2.53-1.259-7.02-.226-9.22-1.68,1.73-.994,1.57-0.575,2.51-2.521h3.35c0.09-3.823.3-4.046,0-6.722-2.8-2.579-6.53-5.79-8.38-9.243h-2.51a14.378,14.378,0,0,0-.84-5.041c1.59,0.052,7.07-.859,8.38-3.361h-0.84V3.369c-0.73.622-.94,1.058-1.67,1.68-0.35-3.008.39-2.114-1.68-3.361a41.791,41.791,0,0,0-5.03-1.68c-0.31,1.744-.2,1.617-0.84,2.521V0.848c-2.34-1.591-4.33,6.261-7.54,1.68v0.84c-2.77,2.153-2.17,3.257-7.55,3.361-1.85,1.123-4.43.892-8.38,0.84V5.889c0.89-1.474.5-1.834,0.84-4.2h-4.19c-1.75,2.033-1.48.355-3.36,1.68a16.671,16.671,0,0,0-1.67,3.361c-4.64-1.132-4.97,2.191-9.22,3.361-3.88,1.064-6.75-.433-10.06,0-0.96,3.43-15.61,22.515-18.44,23.527v0.84h-0.84v-0.84c-1.74-1.6-.36-1.864-1.68-4.2-3.84-6.8-17.79-12.917-25.98-10.083-1.96.675-1.77-3.945-3.36-1.681-3.11,1.1-3.15,2.891-5.87,4.2-3.24-2.473-8.25.554-12.57,1.68-1.94-.559-14.11.056-17.6,1.68s-1.56,3.084-5.03,5.041c-1.68.28-3.36,0.56-5.03,0.84l-1.68,4.2c-1.13.62-6.11-.8-8.38,1.681-2.14,2.332,1.61,1.556-1.68,3.361V39.5c-1.25-1.3-.65-1.544-2.51-2.521C1216.66,42.293,1215.4,42.155,1215.67,47.9Zm25.15-24.367h-1.68l0.84,2.521h0.84V23.534Zm288.36,1.68c-0.63.9-.51,0.795-0.84,2.521h0.84V25.215Zm-0.84,2.521c-0.93,1.395-1.48.9,0,1.68v-1.68Zm-1213.793,0c-1.733.994-1.577,0.575-2.515,2.521C315.513,29.523,314.458,30.067,314.547,27.736Zm-119.87.84h-4.192v1.68h4.192v-1.68Zm110.649,1.68v2.521l5.03-.84c-0.312-1.744-.2-1.617-0.839-2.521C308.432,30.153,307.45,30.168,305.326,30.256Zm-7.544,0c-1.361,1.134-.94.538-1.677,2.521h2.515Zm-87.179,0h-5.867v1.681H210.6V30.256Zm312.67,1.681c-0.675.858-.3,0.23-0.839,1.68h0.839v-1.68Zm-210.4,0h-2.514V35.3h2.514V31.937ZM212.28,35.3c1.74-.312,1.613-0.2,2.515-0.84-0.674-.858-0.3-0.23-0.839-1.681H212.28V35.3Zm927.95-1.68,0.84,3.361h-1.68C1139.94,35.232,1139.27,35.084,1140.23,33.617Zm-613.6,0c-0.631.9-.5,0.794-0.839,2.521h0.839V33.617Zm-11.736,0c-2.548,1.476-2.513,1.77-2.515,5.882h0.838v-1.68A21.266,21.266,0,0,0,514.89,33.617Zm-198.667,0h-2.514v0.84h0.838V35.3h-0.838c0.9,0.632.792,0.505,2.514,0.84V33.617ZM521.6,34.458c-2.72.7-1.281-.412-2.515,1.68h0.839C520.54,35.405,520.975,35.19,521.6,34.458Zm-11.736,0h-1.676V35.3C509.654,34.768,509,35.136,509.86,34.458Zm-285.006,0h-2.515v2.521h2.515V34.458Zm-23.471,0h-2.515v2.521h2.515V34.458Zm-20.119,2.521h2.515V34.458a2.381,2.381,0,0,0-.838.84,2.381,2.381,0,0,1-.838-0.84C181.473,35.359,181.6,35.252,181.264,36.978Zm-15.088-2.521h-2.515v2.521h2.515V34.458ZM511.537,35.3H509.86C510.857,36.649,510.211,36.326,511.537,35.3Zm596,0.84c-0.68.858-.3,0.23-0.84,1.681l3.35,0.84v-0.84h-0.84C1108.59,37.086,1108.16,36.871,1107.54,36.138ZM235.751,38.659V36.138c3.805,0.1,6.872,1.136,7.544,2.521a2.381,2.381,0,0,0-.838.84A20.98,20.98,0,0,0,235.751,38.659Zm289.2-1.681h-1.676v0.84h0.838v0.84C524.785,37.8,524.408,38.428,524.949,36.978Zm-2.515,0c-3,1.208-5.076,1.261-5.867,5.041h0.838C518.986,39.842,521.185,39.473,522.434,36.978Zm-289.2,0c-0.312,1.744-.2,1.617-0.838,2.521V36.978h0.838Zm-25.147.84h-3.353q0.418,2.52.838,5.041h2.515V37.819Zm307.639,0.84a9.73,9.73,0,0,0-1.676,2.521h1.676V38.659Zm-200.343.84c-2.72.7-1.28-.412-2.515,1.681a2.384,2.384,0,0,1,.839.84A9.73,9.73,0,0,0,315.385,39.5Zm854.185,0.84c-0.68.858-.3,0.23-0.84,1.68h0.84v-1.68Zm3.35,1.68h-1.68v0.84C1172.71,42.33,1172.06,42.7,1172.92,42.02Zm-663.06,0c-0.311,1.744-.2,1.617-0.838,2.521V42.02h0.838Zm-418.289,0V43.7H90.733V42.02h0.838ZM231.56,43.7c1.282,1.136,3.611,1.468,5.029,2.521h-0.838c-1.5,1.4-3.454,1.976-5.868,2.521C230.129,46.358,230.441,45.075,231.56,43.7Zm391.465,0.84c-0.674.858-.3,0.23-0.838,1.68h0.838V44.54Zm-1.677,0-2.514.84v0.84h2.514V44.54ZM312.032,47.9c1.74-.313,1.613-0.2,2.515-0.84-0.674-.858-0.3-0.23-0.838-1.68h-1.677V47.9Zm895.258,0.84c-0.68.858-.3,0.23-0.84,1.68,1.12,0.28,2.24.56,3.35,0.84v-0.84h-0.83C1208.34,49.689,1207.91,49.474,1207.29,48.742ZM343.048,57.984c2.72,0.7,1.28-.412,2.514,1.681h-0.838c-0.9.632-.792,0.505-2.515,0.84v2.521c-1.74-.313-1.613-0.2-2.514-0.84,0.63-.9.5-0.794,0.838-2.521H337.18v3.361c-5.673.015-12.614,0.364-15.927,0v-0.84c1.533-1.318,1.17-.741,1.677-3.361h3.353V52.943h1.676c1.662,0.939,1.516.5,3.353,0,0.627,3.208,1.028,3.533,4.191,4.2v-8.4c4.379,0.371,4.351,1.6,7.545.84v8.4ZM242.457,48.742c-0.312,1.744-.2,1.617-0.838,2.521V48.742h0.838Zm716.708,0.84c-0.856.676-.229,0.3-1.676,0.84C958.345,49.746,957.718,50.124,959.165,49.582Zm-629.529,0v1.68H328.8v-1.68h0.839Zm11.735,1.68h-2.515q-0.418,2.52-.838,5.041c1.74-.313,1.613-0.2,2.515-0.84C341.268,54.376,341.283,53.391,341.371,51.262Zm-102.267,0c-0.856.676-.23,0.3-1.677,0.84C238.283,51.427,237.657,51.8,239.1,51.262ZM1502.35,52.1c-1.39.938-.89,1.487-1.67,0h1.67Zm-1406.588.84A10.664,10.664,0,0,0,96.6,56.3c-2.679-.157-1.035-0.626-3.353.84V53.783Zm430.025,0.84c-0.674.858-.3,0.23-0.838,1.68h0.838v-1.68Zm3.353,1.68c-0.63.9-.5,0.795-0.838,2.521h0.838V55.463ZM353.107,58.824l4.191-.84v0.84c-1.4,1.243-2.1,2.824-3.353,4.2V60.5c-3.94.227-3.569,0.978-6.706,1.68,0.644-3.346,2.031-3.957,3.353-6.722l2.515,0.84v2.521ZM868.634,56.3a8.749,8.749,0,0,1-5.03,3.361v-0.84c-0.674-.858-0.3-0.23-0.838-1.68h1.676C865.528,56.407,866.51,56.393,868.634,56.3Zm-147.533.84-2.515.84v0.84H721.1v-1.68ZM362.328,60.5v2.521c-3.016.264-2.8,0.614-5.03,0,1.484-1.822,2.64-3.922,4.191-5.882,2.366,1.75,2.018-.837,3.353,1.68,0.63,0.9.5,0.794,0.839,2.521h-0.839C363.943,60.714,364.05,60.84,362.328,60.5ZM128.454,57.144H125.94v2.521h2.514V57.144Zm-51.972,0c-0.856.676-.23,0.3-1.677,0.84C75.662,57.308,75.036,57.686,76.483,57.144Zm903.64,4.2c1.885,4.674,2.489,8.7,5.867,11.763-0.528,1.474-.161.816-0.838,1.68-1.085.737-2.068,0.751-4.191,0.84-2.113-.953-1.971.938-4.191,0.84-3.459-.152-8.659-5.191-11.736-6.722v-0.84C973.059,68.615,973.863,63.481,980.122,61.345ZM125.1,63.866h-2.514v2.521H125.1V63.866Zm761.974,5.882v1.68c-1.945,1.2-4.373,3.352-5.867,2.521-0.631-.9-0.5-0.794-0.839-2.521l2.515-.84C883.969,69.851,884.952,69.836,887.075,69.748Zm-88.017,4.2c-0.855.676-.229,0.3-1.676,0.84C798.238,74.113,797.612,74.491,799.058,73.949Z"/>
						</svg>';
				break;

			case '63':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 150">
						<path style="fill:'. $c1 .'" d="M0,0v27.9c2.5,1.3,5,2.9,8.5,3.7c0.1-0.9,0.3-1.7-0.5-1.9c0.8-1.6,1.5,1.4,1.9,2c0.7-0.6,2.6,0,2.2-1.6    c0.8,0.8,1.1,1.9,3.3,1.5c-0.9-2.8,1.4,0.3,2.3-2.9c1.2,1.9,3.4,0.8,4.7,1.7c0.3-1.3-0.4-2-1.9-2c1.2-1.9,1.6,1.4,3.4,0.9    c-0.4-0.7-1.5-0.8-1.2-1.9c4,2.8,13,5.1,16.9,4.6c-0.2-0.7-1.1-1.7-1.3-0.7c0-3,7.1,3.2,9.5,2.1c-0.9-6.5,12.7,0.8,16.6,0.9    c1,0,2,1.4,2,1.4c0.1,0,7.6-3.5,9.8-0.3c-0.4-2,9.3,0.2,8.2,1.4c2.1,0.5,1.7-1.7,4.2-0.8c-0.5-1-2.1-1.1-3.3-1.5    c6.4-1.9,10.8,1.4,14.9,3.8c0.9-0.2,1.5-0.7,1.6-1.7c1.5,0,0.1,2.2,0.4,3.1c2.1-1.6,3.7-0.6,5.1-2c4.6,3.9,12,1.6,14.3,3.1    c-0.5-0.9,2.6-1.1,1.6-1.7c3.3-1.2,2.7,1.8,6.8,1.8c1.5-0.3-1.1-2.1-1.8-2.6c-0.1-1.5,3.8,3,6.7,3.1c1.7-0.4-1.4-1.9-0.3-3.7    c3.6,2.3,1.2,2.5,3.7,4.6c0.9-0.1,0.7-1.5,0.9-2.4c3,2.6,6.1,4.1,8.9,1.4c0.4,3.6,3.1-0.8,2.5,2.7c2.2-1.8,3.5,0.1,5-2    c2,0.6-0.8,1.2-0.2,2.4c2.9-2.1,7.3-0.4,8.1-4.8c-0.4,2.4,1,5.4,3.7,5.2c1.8,0-0.8-1.1,0.2-2.4c1.5,0.6,1.3,2.5,3.2,2.7    c3.5-1.8,7.2-3.4,10.6-2.1c1.8-0.3-1.1-1.7-0.4-3.1c0.3,1.2,3.3,2.6,2.8-0.4c1.6,0,0.6,1.8,1.9,2c1.2,0,3.7-3.7,4.2-0.2    c1.3,0,0.6-2,1.6-2.3c2.3,0.5-1.4,3.2,0.4,3.1c2.8,0.4,0.5-1.2,0.9-2.4c0.5,2.4,5.9-0.3,4,2.2c2.2-0.6,3.9-2.1,6.3-0.6    c-1.6-1.4-0.6-1-1.1-3.2c2.4,0.9,3.4-1,6.1,1.2c1.3-1.1,0-0.8,0.2-2.4c3.1-1,12.5,3.9,13.1,0.6c3.2-0.6,7.6,2.5,10.4,0.3    c2.2,2.7,6,0,9.5,2.1c0.2-1-1-1.7,0.2-1.8c2.4,0.3,0.1,0.9,1.2,2.6c5.1-0.5,1,0.9,6.1,1.2c0-0.7-1.2-0.6-2-0.8    c5.7-0.7,6,0.6,9.6,1.5c1.5,0.2,0.5-2.1,1-3c1.5-0.7,9.4,1.7,7-0.6c1.6-1.8,6.9,3.9,7.7-0.5c1.4,2.3,4.8,0.9,3.2-0.9    c-0.4-0.3-0.8-0.5-0.9-0.7c0.4,0.3,0.7,0.5,0.9,0.7c2.2,1.3,8,2.8,12.7,1.7c-0.4-0.7-1.5-0.8-1.2-1.9c1.6-1.2,3.9,0,4.8,1    c1-1.9-2.2-0.7-1.2-2.5c2.6,0.1,6.2,1.2,6.4-1.3c1.9,1.3,0.8,2.7,3.2,2.7c1.7-0.2-2.2-1.4,0.2-2.4c1.4,4.1,10.9,1.4,15.3-0.4    c-3-3.3,4.8-2.7,8.6-2.9c-0.2-0.6-0.5-1.1-1.3-1.3c1.7,0.3,4.4-0.1,5.4,1.7c2.4,0.1-1-2.8,0.9-2.4c1.6,2.1,5.9,0.1,5.1,0.8    c2.1,0.4,1.7,2,2.4,1.1c4.2,3.4,12.4-2.3,13.8,0.6c1.1-0.4,1.2-1.9,1.7-2.9c2.9,0,3.8,1.4,6.1,1.8c3.8-3.8,10.9,0,14.1-2.4    c-1.4-1.4-3.3-2.3-3.2-3.3c1.3-1.6,2.5,1.6,4,1.6c-0.2-0.8-0.8-1.3-2-1.4c1.6-0.8,4-0.7,6.3-0.6c-0.1,1.6,3.1,1.2,1.1,2.5    c1.2-0.2,6.5,0.3,3.6-0.9c0.7-1.3,3.2,0.6,3.3,1.5c1-0.3,1.4-1.2,1.6-2.3c2.1,1.6,4.4-0.8,6.2,0.6c0.8,0.3,2.5-1.5,0.9-1.8    c1.1-1.3,2.2,2.1,3.2,2.7c2.2,0.1,2.1-2.2,5-1.4c0-0.6-0.8-0.5-1.3-0.7c2.3,0.3,5.3-2.4,6.8,1.2c2.2-0.7-0.7-2.4,2.5-4.1    c-2.4,0.1-2.3,0.5-4.1-0.4c6.3-1.3,10.6,4.5,14.8,5c1.1,0,0.3-1.2-0.8-1.8c4,1,11.5,4.4,10.7,0.2c5.1,2.3,8.7-0.3,15,3.2    c-0.3-1.8,3.8,0.1,5.6-0.7c-2.8-1.4-0.8-1.6,0.3-3.6c-0.1,2.1,4.5,0.3,6.9,0.6c5.7,0.7,11.8,3.4,16.4,2.7c1-0.5-0.2-1,1.6-1.7    c6.1,3.8,10.5-0.7,14.7-1.1c-0.4,0,1.1,2.2,4.1,1c5.4-2.2,15.3-0.2,23.5,1.5c2.4,0.2,5.5-2.2,7.6,0.1c-0.7-2,3.2,0.2,2.2-1    c2-0.4,6.2,3.1,6.9,0c1.4,3.8,5.2,1.6,8.1,2.6c-2.9-0.9,2-2.1-1.1-2.5c-0.3,0-0.5-0.1-0.7-0.1c0.3,0,0.5,0.1,0.7,0.1    c4.8,0.6,12,2.8,16.9,4.6c2.1-1.5,5-1.9,5.2-3.8c1.4,0.3-0.1,2.7,1.1,3.2c1.7,0.9,3.1-1.6,2.7,0.9c0.8-0.8,3.8-1.8,0.2-1.8    c2.2-1.6,5.9,1.1,7.6,0.1c0.3-0.8-0.1-1.1-0.7-1.2c-0.2,0-0.4-0.1-0.6-0.1c0.2,0.1,0.4,0.1,0.6,0.1c6,1.3,9.9-2.6,20.3-0.7    c1.1,0.2-0.7,1.1,0.6,1.3c2.7,1,1.6-1.9,4.2-0.8c-0.4-1.8-1-0.8-2.7-0.9c2.4-3.6,8.3,1.2,12.3,1.7c3.1-0.9,2.2-1.8,3.8-3.9    c5.7-0.1,12.6,1.8,20.5,3.7c0.8,0.2,2.4-0.5,2.8-0.3c1.9,0.6,4.2,2.6,1.4,0.1c3.1,1.6,8.9,3.2,13.3,6.1c2.4-0.3,3.9-1.6,6.5-1.8    c-0.7-0.4,2.5-3.6,2.4-3.5c0.5-0.3,2.1,0.2,2.1,0.2c0.4-0.2,0.6-0.4,0.8-0.5c-0.4-0.8,1-0.8,0,0c0.1,0.2,0.3,0.4,0.6,0.6    c1.1,0.9,6.9-0.8,4.4-2c8.7,2.2,14.1,1.2,23.1,5.2c0.5-0.8-2.5-1.7-0.5-1.9c4.6,5.4,12.2-1.7,17.1,2.8c0.8,0,0.7-1.1,0.9-1.8    c1.2,2.6,3,1.3,6,2.4c1.5-0.1-0.8-2-1.1-2.5c2.4-0.2,3.9,2.4,6.7,3.1c4.9-1.9,10-0.8,16-0.4c0.3-0.9,1-1,2.3-2.2    c3.4,2,3.3-0.5,4.9-0.8c9,1.7,30.2,5.3,39.6,0.5c0.9,0.2,3.2,2.1,3.4,0.9c1,0.4-0.1,0.5-0.1,1.2c9.5-0.7,19.7,6.1,27.3,4.9    c-0.6-0.8-4.3-1.4-4.8-1c-0.2-0.6-0.5-1.1-1.3-1.3c1.3-1.2,3.7,0.5,2.3-2.2c5.8,3.2,9.9-1.2,15.1,2c1.5,0.4,4-1.5,2.3-2.2c3.1-0.6,6.9,3.3,10,4.6c1.3-0.4,1.1-2.4,3.6-1.5c-0.4-0.6-1.2-1-2-1.4c0.5-0.3,6.9,2.2,5.2,3.5c1-0.8,4-0.5,4.8,0.4    c1.2-2.2-3.1-0.4-1.8-2.6c0.7,0.8,5.1,2.1,4.2-0.8c3,2.3,11.1,2.8,13.6,3.7c4.9,2,9.2,0.5,14.8-2.3c0-0.6-0.8-0.5-1.3-0.7    c6.4-1.2,7.2,2.8,14.4,2.5c-0.4-0.9-1.4-1.3-2.6-1.5c-1.1-1.5,4.2,0.7,4.7,1.7c1.3-1.2,2.5-0.8,1.7-2.9c1.4,0.3,1.2,1.8,2.6,2.1    c1-0.2-0.2-0.8,0.2-1.8c5.8,0.4,20.4,5,19.6-1.3c6.9,0.8,10.8-1.5,16.1-1.6c-0.2,0.7-0.7,1-1.4,1c3.8,0.6,7.1,4.6,12.6,5.5    c5.8,0.9,14.9-3.9,17.8,2.8c0.7-0.4,1.6-0.5,2.8-0.3c0.4,1.2,2,0.6,0.5,1.9c2.5,0.4,6.6-1.3,9.7,0.3c2.4-4.2,11.9,0.5,13.5-3    c1.1,1.3,6.5,5.1,7.5,1.3c0.6,2.8,11.3,1.7,5-1.4c1.2-0.2,4.5,2.7,5.9,4.2c2.4-0.3,0.2-1.4,1.6-2.3c0.9,2.7,1.6-1.1,5.4,1.7    c-0.2-1.4,3.4-1.4,3.9-3.9c3.1,2.7,3.6,1.1,8.1,2.6c1.1-2,9.3-5.2,12.6-1.3c8.5-4.1,19.5-3.3,28.5-0.5c4.1,0.3,9-3.1,14.6-0.5    c0.9-0.1,0.8-1.1,0.1-1.2c5,0,14.8,0.9,17.7-3.3c4.3,3.9,20.5,0.3,26.1,3.6c11.6-1.3,19.9-5.7,34.3-2.4c2-1.4,0.9-2,0.3-3.6    c8.1,4,19.4,2.9,24.5-2c-0.4,0.5-0.8,0.9-0.9,1.8c6.7-1.1,15.5-2.3,22.1-5.3c2.6,4.8,10.9,2.5,14.7,5.6c3.6-4.1,18.5-3.6,26.5-1.3    c0.5-3,8.6,0.2,11.9-1.4c-0.5,1.1,10.6,2.7,13.8,1.3c0.2,1-0.6,1.1-1.5,1.1c7.3,2.7,11.9,2.7,19.1,3.6c-0.5-0.6-0.6-1.4-0.5-2.5    c0.6,2.2,6.7,3.7,6.1,1.2c1.4,0.1,0.7,1.7,2.6,1.5c1.3-1.7,4.1-1.9,5.2-3.8c1.7,0.5,2.3,0.7,4.7,1.7c1.8,0-0.8-1.1,0.2-2.4    c6.4,0.6,13.6,4.4,15.2,1.4c1.4,0.2,2.3,0.8,4.2-0.8c-0.1,0.6-0.1,1.2-0.2,1.8c3.9-4.5,10.1-1.9,16.8-1.5c0.8,0,0.7-1,0.9-1.8    c8.8,1.7,11.3-1.1,17.9,1.6c0.9,0.2,0.6-1.2-0.2-1.8c-0.3-0.1-0.7-0.1-1-0.2c0.4-0.1,0.7,0,1,0.2c6.2,1.3,11.9-0.5,17.8-0.3    c0.3-1.8-1.4-2-1-3.8c1.3-1,2,0.4,3.4,0.9c-0.3-0.6-0.5-1.1-1.3-1.3c0.4-2.3,5.4,1.6,5.7-1.9c5.2,2,11.3-6.9,17.6-3.7    c5.1-2.2,12.5-0.4,17.9,1.6c3.2-2.5,8.4-3.2,10-2.8c1.4-3.5,4.8,5.8,6.9,1.7c0.8,4.2,5.8,0.7,6.7,3.1c0.8,0,0.7-1.1,0.9-1.8    c6.9,3.2,13.2-6.5,19.6-2.9c3.5-3.5,6.6,6.8,11.4,6.4c0.2-1.3-0.4-2-1.9-2c1.9-1.7,9,1.3,2.1,0.2c0.5,0.8,0.7,1.7,0.4,3.1    c1.3,0,0.6-2,1.6-2.3c1.9,3.6,7-4.6,11.1-4.9c0.1-0.1,0.2-0.1,0.3,0c-0.1,0-0.2,0-0.3,0c-0.8,0.7-1.3,5.9-2.8,5.7    c7.5,0.5,15.8,2.3,23.7-0.3c0.8,0.5,1.6-4.2,1.7-5.2c0,0,0,0,0,0c0.1-0.3,0.1-0.3,0,0c0.9-1.1,2.4,3.2,4,5.2    c-0.2-0.6,1.2-1-0.1-1.4c4.1,1.5,5.7-2.6,11.9-0.8c1.1-0.2,0.1-0.6-0.6-0.7c9.4-5.7,25.9,8.6,38.7,2.3c5.1,2,10.8,0.1,15.8,2    c-2.3-3.4,7.8,2.6,11.2-1.4c-0.7,1.9,1.3,1,1.4,0.1c1,0.3,0,1.1-0.8,1.1c0.5,0.6,1.2,1,2,1.4c0.3-0.7,1.1-2.1,4.3-1.4    c-0.7-0.8-0.6-2.2-0.3-3.7c1.1-1.8,0.5,2.2,0.4,3.1c8.9,3.3,12.8-3.2,18.3-2c0.6-1.6-1.3-1.3-1.9-2c0.6-1.3,3.4-1.7,4.3-0.8    c-0.3,0.9-1.2-0.6-1.4,0.5c0.1,0.7,1.3,0.5,1.3,1.3c3.6-1.5,4.9-1.4,9.1-0.4c1.2-0.7,2-1.9,2.4-3.4c3.1,0.2-0.8,1.5-0.3,3    c3.3-3.5,5.8-0.4,8.2-5.4c0.8,0.9,1.2,2,2.1,0.2c1,0.4-0.3,0.7-0.2,1.8c2.3,0.4,1-2.9,4.3-1.4c0-1.1-2.3-0.6-2.6-1.5    c-1.3-2,3.9,2.4,4.8,0.4c0.9,0.3,0.4,1.6,0.5,2.5c0.7-0.3,1.2-1.6,1.4-0.5c1-0.2-0.2-0.8,0.2-1.8c1.3,0.4,0.3,2.4,2.6,2.1    c1.7,0-0.6-1.7-1.2-1.9c1.2-0.1,4.7,3,5.1,5.4c0.9-1.2,3.4-0.9,3.7-2.7c1,1-0.9,3,2.5,3.3c0.5-1.7,0.7,0.3,1.6-1.7    c0.6,1.9,2.7,0.1,1.2,1.9c1.4,0.3,2.2,0.1,2.2-1c1.2,0.8,2.2,1.8,3.2,2.7c2.8-0.5,3.7-2.1,7-0.6c0.8-2.6-1.4,0.4-1.3-1.3    c2.9-2.8,7.4-0.4,8.7-4.1c7.7,3.1,20.1,1.8,22.9,7.6c0.9-0.1,0.7-1.5,0.9-2.4c1.6,1.4,3.1,3,5.9,3.6c-3.7-2.4,5.1-0.4,5.5,1.1    c1-0.1,0.7-1.5,0.9-2.4c1.6,0.5,3.4,2.9,7.5,1.3c0.8,0.2,0.5,1.2,0.5,1.9c1.3-1.7,9,2.3,11.9-0.7c1.7,1.2,1.8,1.7,3.8,3.4    c0.7-0.4,1.2-1,1.5-1.7c-5.2-0.4,1.4-2.9-1.6-5c1.3-0.8,3.4,2.8,3.7,4.6c1.4-1.4,3-2.6,3.9-4.5c4.8-0.1,10.7,2.4,13.3,6.1    c3.1,0.5,4.9-1.7,8.3,0.2c1.1-2.5,1.2-4.7-0.1-6.7c-0.4-1.6,2.1,3.5,3.1,4.6c1-1.6,3.8-0.9,4.3-1.4c0.8,0.2,0.5,1.2,0.5,1.9    c1.6,0.3,2.6,0.1,2.9-1c0.9,0.3,0.4,1.6,0.5,2.5c1-0.2,1.8-0.8,2.2-1.6c0.9,1.3,4.4,3.2,3.5-0.3c2.5-0.2,0.6,3,2.5,3.3    c2.3-0.8-2.2-2.5,0.3-3.6c0.7,0.5-0.1,1.8,1.1,3.2c0.9-0.1,1.2-1,2.2-1c0.4-1.4-3.2,0.1-1.9-2c1.3,1.5,2.3-0.3,3.4,0.9    c-1.7-2.4-0.2-1.7,0.4-4.2c0.2,3.5,8,2.8,6.1,1.2c1.1-1,2.1,2.8,3.3,2.1c1.1-0.2-0.2-0.8,0.2-1.8c1.5-0.2,2.8,4,3.4,0.9c0.8,0.2,0.5,1.2,0.5,1.9c0.8,0,0.7-1,0.9-1.8c0.9,1,1.9,2,3.2,2.7c1-0.1,0.7-1.5,0.9-2.4c0.8,0.2,0.5,1.2,0.5,1.9    c2-0.3,0.9-0.8,0.9-2.4c2.4,0.3,1.4,3.1,4.6,2.9c-1.8-3.3,0-0.3,2.9-1.6c-1.9,2.2,1.1-0.6,0.5,1.9c1.6-1.7,3.9,0.3,7.6,0.1    c9.2,4.7,19,6.9,23.9,11.9c9.6,1,14.6,1.5,24,3.4c-0.2-1.4-3.4-0.6-4.8-1c11.5,0.4,21.9,3,35.9,2.2V0H0z"></path>
					</svg>';
				break;

			case '64':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 167">
					<path style="fill:'. $c1 .'" d="M-3,167V37.992c179.806,29.856,459.764,49.4,775.849,50.474-0.023.017-.048,0.032-0.071,0.049a3.194,3.194,0,0,1,.518-0.048h0.3c1.793,0.051,6.348,1,11.71,8.4,3.966,5.471,13.639,22.5,15.031,35.068,1.612-12.431,11.482-33.163,17.536-38.408,0,0,1.74-3.94,10.021-5.01,0.106-.014.2-0.031,0.288-0.05,314.97-1.085,594.02-20.509,773.82-50.2V167H-3Z"/></svg>';
				break;

			case '65':
				$svg .= '<svg '. $svg_attrs .' viewBox="0 0 1600 406">
						<path style="fill:'. $c3 .'" d="M1608.03,417H-1.709L-3.493,267.327c76.974,52.083,173.369,106.4,262.948,114.816,82.7,7.772,175.138-15.857,175.138-15.857,296.27-61.5,450.55-323.851,772.167-357.194,146.02-12.5,299.07,11.613,401.05,33.813Z"/>
						<path style="fill:'. $c2 .'" d="M-2.25,405.5H1607.5l1-248.5S1498.97,67.09,1199,82.5C952.453,84.455,717.723,320.6,424,369c0,0-91,17-172,11-87.435-6.475-177.172-39.147-255.516-77.726Z"/>
						<path style="fill:'. $c1 .'" d="M-5.143,340.337C87.619,364.359,200.042,380.486,309,381c298.183,1.4,631.464-245.093,878-242,244.99,3.074,420.5,129,420.5,129V410H-4.75Z"/>
					</svg>';
				break;

			default:
				# code...
				break;
		}

		return $svg;
	}
}