<?php if ( ! defined( 'ABSPATH' ) ) {exit;} // Exit if accessed directly.

use Codevz_Plus as Codevz_Plus;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

class Xtra_Elementor_Widget_text_marquee extends Widget_Base {

	protected $id = 'cz_text_marquee';

	public function get_name() {
		return $this->id;
	}

	public function get_title() {
		return esc_html__( 'Marquee', 'codevz-plus' );
	}
	
	public function get_icon() {
		return 'xtra-text-marque';
	}

	public function get_categories() {
		return [ 'xtra' ];
	}

	public function get_keywords() {

		return [
			esc_html__( 'XTRA', 'codevz-plus' ),
			esc_html__( 'Codevz Plus', 'codevz-plus' ),
			esc_html__( 'Scroll', 'codevz-plus' ),
			esc_html__( 'Marquee', 'codevz-plus' ),
			esc_html__( 'Text', 'codevz-plus' ),
			esc_html__( 'Slider', 'codevz-plus' ),
			esc_html__( 'Rotate', 'codevz-plus' ),
			esc_html__( 'Movement', 'codevz-plus' ),
			'XTRA',
			'Codevz Plus',
			'Scroll',
			'Marquee',
			'Text',
			'Slider',
			'Rotate',
			'Movement',
			'Ticker',
			'Animation',
			'Slide',
			'Motion',
		];

	}

	public function get_style_depends() {
		return [ $this->id, 'cz_parallax' ];
	}

	public function get_script_depends() {
		return [ $this->id, 'cz_parallax' ];
	}

	public function register_controls() {

		$free = Codevz_Plus::is_free();

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( "Settings", 'codevz-plus' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'marquee_type',
			[
				'label' 	=> esc_html__( 'Type', 'codevz-plus' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'' 			=> esc_html__( 'Text', 'codevz-plus' ),
					'2' 		=> esc_html__( 'Gallery', 'codevz-plus' ),
					//'3' 		=> esc_html__( 'Linkable Gallery', 'codevz-plus' ),
				],
			]
		);

		$this->add_control(
			'content',
			[
				'label' 		=> esc_html__( "Content", 'codevz-plus' ),
				'type' 			=> Controls_Manager::WYSIWYG,
				'default' 		=> esc_html__( 'I am marquee text element, This is a sample marquee sentence, Feel free to replace it with any text or even you can add any HTML codes you like into this marquee ...', 'codevz-plus' ),
				'placeholder' 	=> esc_html__( 'I am marquee text element, This is a sample marquee sentence, Feel free to replace it with any text or code you can add any HTML codes you like into this marquee ...', 'codevz-plus' ),
				'condition' 		=> [
					'marquee_type' 		=> ''
				],
			]
		);

		$url = function_exists( 'wc_placeholder_img_src' ) ? wc_placeholder_img_src() : null;
		$url = $url ? preg_replace( '/-\d+x\d+(?=\.\w+$)/', '', $url ) : '';
		$id  = attachment_url_to_postid( $url );

		$this->add_control(
			'images',
			[
				'label' => esc_html__( 'Images', 'codevz-plus' ),
				'type' => Controls_Manager::GALLERY,
				'condition' => [
					'marquee_type' => '2',
				],
				'default' => [
					[ 'id' => $id, 'url' => $url ],
					[ 'id' => $id, 'url' => $url ],
					[ 'id' => $id, 'url' => $url ],
					[ 'id' => $id, 'url' => $url ],
					[ 'id' => $id, 'url' => $url ],
					[ 'id' => $id, 'url' => $url ],
					[ 'id' => $id, 'url' => $url ],
					[ 'id' => $id, 'url' => $url ],
				]
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'codevz-plus' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Codevz_Plus::$url . 'assets/img/p.svg',
				],
			]
		);

		$repeater->add_control(
			'info', 
			[
				'label' => esc_html__( 'Caption', 'codevz-plus' ),
				'type' => Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'codevz-plus' ),
				'description'  => esc_html__( 'For opening in lightbox use #', 'codevz-plus' ),
				'type' => Controls_Manager::URL,
				'show_external' => true
			]
		);

		$this->add_control(
			'gallery2',
			[
				'label' => esc_html__( 'Add items', 'codevz-plus' ),
				'type' => $free ? 'codevz_pro' : Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'prevent_empty' => false,
				'condition' => [
					'marquee_type' => '3',
				]
			]
		);

		$this->add_control(
			'direction',
			[
				'label' 		=> esc_html__( 'Direction', 'codevz-plus' ),
				'type' 			=> $free ? 'codevz_pro' : Controls_Manager::SELECT,
				'default' 		=> 'left',
				'options' 		=> [
					'left'  		=> esc_html__( 'Left', 'codevz-plus' ),
					'right' 		=> esc_html__( 'Right', 'codevz-plus' ),
					'up' 			=> esc_html__( 'Up', 'codevz-plus' ),
					'down' 			=> esc_html__( 'Down', 'codevz-plus' ),
				],
			]
		);

		$this->add_control(
			'marquee_width',
			[
				'label' 		=> esc_html__( 'Width', 'codevz-plus' ),
				'type' 			=> $free ? 'codevz_pro' : Controls_Manager::NUMBER,
				'min' 			=> 50,
				'max' 			=> 1600,
				'step' 			=> 5,
			]
		);

		$this->add_control(
			'marquee_height',
			[
				'label' 		=> esc_html__( 'Height', 'codevz-plus' ),
				'type' 			=> $free ? 'codevz_pro' : Controls_Manager::NUMBER,
				'min' 			=> 50,
				'max' 			=> 1600,
				'step' 			=> 5,
			]
		);

		$this->add_control(
			'gap',
			[
				'label' 		=> esc_html__( 'Gap', 'codevz-plus' ),
				'type' 			=> $free ? 'codevz_pro' : Controls_Manager::NUMBER,
				'min' 			=> 0,
				'max' 			=> 500,
				'step' 			=> 1,
				'default' 		=> 5
			]
		);

		$this->add_control(
			'duration',
			[
				'label' 		=> esc_html__( 'Duration', 'codevz-plus' ),
				'type' 			=> $free ? 'codevz_pro' : Controls_Manager::NUMBER,
				'min' 			=> 1,
				'max' 			=> 120,
				'step' 			=> 1,
				'default' 		=> 5
			]
		);

		$this->add_control(
			'stop_on_hover',
			[
				'label' 		=> esc_html__( 'Stop on hover?', 'codevz-plus' ),
				'type' 			=> $free ? 'codevz_pro' : Controls_Manager::SWITCHER
			]
		);

		$this->end_controls_section();

	   // Parallax settings.
		Xtra_Elementor::parallax_settings( $this );

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'codevz-plus' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'sk_marquee',
			[
				'label' 	=> esc_html__( 'Container', 'codevz-plus' ),
				'type' 		=> 'stylekit',
				'settings' 	=> [ 'color' ],
				'selectors' => Xtra_Elementor::sk_selectors( '.cz_text_marquee' ),
			]
		);

		$this->add_responsive_control(
			'sk_marquee_img',
			[
				'label' 	=> esc_html__( 'Images', 'codevz-plus' ),
				'type' 		=> 'stylekit',
				'settings' 	=> [ 'color' ],
				'selectors' => Xtra_Elementor::sk_selectors( '.cz_text_marquee img' ),
			]
		);

		$this->add_control(
			'overlay_gradient',
			[
				'label' 	=> esc_html__( 'Overlay gradient?', 'codevz-plus' ),
				'type' 		=> $free ? 'codevz_pro' : Controls_Manager::SWITCHER
			]
		);

		$this->add_control(
			'overlay_gradient_color',
			[
				'label' 	=> esc_html__( 'Gradient color', 'codevz-plus' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .codevz-plus-overlay-gradient:after' => '--overlay-gr: {{VALUE}};',
				],
				'condition' => [
					'overlay_gradient!' 	=> ''
				],
			]
		);

		$this->end_controls_section();
	}

	public function render() {

		// Settings.
		$settings = $this->get_settings_for_display();

		// Classes
		$classes = array();
		$classes[] = 'cz_text_marquee';
		$classes[] = $settings['stop_on_hover'] ? 'cz_text_marquee_soh' : '';
		$classes[] = empty( $settings['overlay_gradient'] ) ? '' : 'codevz-plus-overlay-gradient';

		$type = $settings[ 'marquee_type' ] ? $settings[ 'marquee_type' ] : '1';

		$dir = $settings['direction'] ? $settings['direction'] : 'left';
		$type = $settings[ 'marquee_type' ] ? $settings[ 'marquee_type' ] : '1';
		$styles = '--czm-dir:' . esc_attr( $dir ) . ';';
		$styles .= Codevz_Plus::contains( $dir, [ 'left', 'right' ] ) ? '--czm-offset:2px;' : '--czm-offset:0px;';
		$styles .= empty( $settings['marquee_width'] ) 	? '' : 'width:' . $settings['marquee_width'] . 'px;';
		$styles .= empty( $settings['marquee_height'] ) ? '' : 'height:' . $settings['marquee_height'] . 'px;';
		$styles .= empty( $settings['gap'] ) 			? '' : '--czm-gap:' . $settings['gap'] . 'px;';
		$styles .= empty( $settings['duration'] ) 		? '' : '--czm-duration:' . ( ( (int) $settings['duration'] ) * 2 ) . 's;';

		ob_start();
		Xtra_Elementor::parallax( $settings );

		echo '<div' . Codevz_Plus::classes( [], $classes ) . ' data-type="' . esc_attr( $type ) . '" data-dir="' . esc_attr( $dir ) . '" style="' . esc_attr( $styles ) . '"><div>';

		$sanitized_content = '';

		if ( $type === '2' ) {

			$images = (array) $settings['images'];

			foreach( $images as $image ) {

				if ( empty( $image[ 'id' ] ) ) {
					continue;
				}

				$title = get_post( $image[ 'id' ] );

				if ( is_object( $title ) ) {

					$new_settings = wp_parse_args( [ 'image' => $image ], $settings );

					ob_start();
					echo Group_Control_Image_Size::get_attachment_image_html( $new_settings );
					$sanitized_content .= ob_get_clean();
				}

			}

			echo '<div>' . $sanitized_content . '</div>';
			echo '<div>' . $sanitized_content . '</div>';

		} else {

			$sanitized_content = do_shortcode( wp_kses_post( (string) $settings['content'] ) );
			echo '<div>' . $sanitized_content . '<div class="cz_text_marquee_inner">' . $sanitized_content . '</div></div>';
			echo '<div>' . $sanitized_content . '<div class="cz_text_marquee_inner">' . $sanitized_content . '</div></div>';

		}

		echo '</div></div>';

		Xtra_Elementor::parallax( $settings, true );
		$content = ob_get_clean();

		Codevz_Plus::tpl( 'page_builder', $content );

	}

}