! function( $ ) {
	"use strict";

	Codevz_Plus.show_more_less = function() {

		document.querySelectorAll('.cz_sml').forEach(x => {
			if (x.dataset.init) {return;}
			x.dataset.init = '1';

			const inner = x.querySelector('.cz_sml_inner');
			const btn = x.querySelector(':scope > a');

			if (!inner || !btn) {return;}

			const defaultHeight = inner.getAttribute('data-height');

			btn.addEventListener('click', (e) => {
				e.preventDefault();

				const isOpen = x.classList.toggle('cz_sml_open');
				const firstChild = inner.firstElementChild;

				if (isOpen) {
					const fullHeight = firstChild ? firstChild.offsetHeight : inner.scrollHeight;
					inner.style.height = fullHeight + 'px';
				} else {
					inner.style.height = defaultHeight;
				}
			});
		});

	};

	Codevz_Plus.show_more_less();

}( jQuery );