! function( $ ) {
	"use strict";

	Codevz_Plus.team = function() {

		const handleTeamHover = (e) => {
			const container = e.currentTarget;
			const content = container.querySelector('.cz_team_content');
			if (!content) return;

			if (e.type === 'mouseenter') {
				content.style.display = 'block';
				content.style.pointerEvents = 'none';
				content.style.position = 'absolute';
				content.style.top = '0';
				content.style.left = '0';
				content.style.transition = 'all .3s cubic-bezier(.180, .890, .330, 1.270)';

				setTimeout(() => content.style.opacity = '1', 100);
			}

			if (e.type === 'mousemove') {
				const rect = container.getBoundingClientRect();
				const x = e.clientX - rect.left;
				const y = e.clientY - rect.top;

				requestAnimationFrame(() => {
					content.style.transform = `translate3d(${x - 5}px, ${y}px, 0)`;
				});
			}

			if (e.type === 'mouseleave') {
				setTimeout(() => {
					content.style.opacity = '0';
				}, 100);
			}
		};

		const initTeamHover = () => {
			document.querySelectorAll('.cz_team_6, .cz_team_7').forEach(el => {
				if (el.dataset.initHover) return;
				el.dataset.initHover = '1';

				el.addEventListener('mouseenter', handleTeamHover);
				el.addEventListener('mousemove', handleTeamHover);
				el.addEventListener('mouseleave', handleTeamHover);
			});
		};

		initTeamHover();

	};

	Codevz_Plus.team();

}( jQuery );