<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.

/**
 * Text Marquee
 * 
 * @author Codevz
 * @link http://codevz.com/
 */

class Codevz_WPBakery_text_marquee {

	public $name = false;

	public function __construct( $name ) {
		$this->name = $name;
	}

	/**
	 * Shortcode settings
	 */
	public function in( $wpb = false ) {
		add_shortcode( $this->name, [ $this, 'out' ] );

		$atts = array(
			'category'		=> Codevz_Plus::$title,
			'base'			=> $this->name,
			'name'			=> esc_html__( 'Marquee', 'codevz-plus' ),
			'description'	=> esc_html__( 'Auto scroll content', 'codevz-plus' ),
			'icon'			=> 'czi',
			'params'		=> array(
				array(
					'type' 			=> 'cz_sc_id',
					'param_name' 	=> 'id',
					'save_always' 	=> true
				),
				array(
					"type"        	=> "dropdown",
					"heading"     	=> esc_html__("Type", 'codevz-plus' ),
					"param_name"  	=> "marquee_type",
					'edit_field_class' => 'vc_col-xs-99',
					'value'		=> array(
						esc_html__( 'Text', 'codevz-plus' ) 	=> '',
						esc_html__( 'Gallery', 'codevz-plus' ) 	=> '2',
					)
				),
				array(
					"type"        	=> "textarea",
					"heading"     	=> esc_html__("Content", 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					'value' 		=> esc_html__( 'I am marquee text element, This is a sample marquee sentence, Feel free to replace it with any text or even you can add any HTML codes you like into this marquee ...', 'codevz-plus' ),
					"param_name"  	=> "marquee",
					'dependency'	=> array(
						'element'				=> 'marquee_type',
						'value_not_equal_to'	=> array( '2' )
					),
				),
				array(
					"type"        	=> "attach_images",
					"heading"     	=> esc_html__("Images", 'codevz-plus' ),
					"param_name"  	=> "images",
					'edit_field_class' => 'vc_col-xs-99',
					'dependency'	=> array(
						'element'		=> 'marquee_type',
						'value'			=> array( '2' )
					),
				),
				array(
					'type' 			=> 'dropdown',
					'heading' 		=> esc_html__('Direction', 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					'param_name' 	=> 'direction',
					'value'		=> array(
						esc_html__( 'Left', 'codevz-plus' ) 	=> 'left',
						esc_html__( 'Right', 'codevz-plus' ) 	=> 'right',
						esc_html__( 'Up', 'codevz-plus' ) 		=> 'up',
						esc_html__( 'Down', 'codevz-plus' ) 	=> 'down'
					)
				),
				array(
					"type"        	=> "cz_slider",
					"heading"     	=> esc_html__("Width", 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					"param_name"  	=> "marquee_width",
					'options' 		=> array( 'unit' => '', 'step' => 5, 'min' => 50, 'max' => 1600 ),
				),
				array(
					"type"        	=> "cz_slider",
					"heading"     	=> esc_html__("Height", 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					"param_name"  	=> "marquee_height",
					'options' 		=> array( 'unit' => '', 'step' => 5, 'min' => 50, 'max' => 1600 ),
				),
				array(
					"type"        	=> "cz_slider",
					"heading"     	=> esc_html__("Gap", 'codevz-plus' ),
					"param_name"  	=> "gap",
					'options' 		=> array( 'unit' => '', 'step' => 1, 'min' => 0, 'max' => 500 ),
					'edit_field_class' => 'vc_col-xs-99',
					'value' 		=> '5'
				),
				array(
					"type"        	=> "cz_slider",
					"heading"     	=> esc_html__("Duration", 'codevz-plus' ),
					"param_name"  	=> "duration",
					'options' 		=> array( 'unit' => '', 'step' => 1, 'min' => 1, 'max' => 120 ),
					'edit_field_class' => 'vc_col-xs-99',
					'value' 		=> '8',
				),
				array(
					'type' 			=> 'checkbox',
					'heading' 		=> esc_html__('Stop on hover?', 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					'param_name' 	=> 'stop_on_hover'
				),
				array(
					'type' 			=> 'cz_sk',
					'param_name' 	=> 'sk_marquee',
					"heading"     	=> esc_html__( "Marquee", 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					'settings' 		=> array( 'color', 'background', 'border', 'box-shadow', 'font-size', 'advanced' )
				),
				array( 'type' => 'cz_hidden','param_name' => 'sk_marquee_tablet' ),
				array( 'type' => 'cz_hidden','param_name' => 'sk_marquee_mobile' ),
				array(
					'type' 			=> 'cz_sk',
					'param_name' 	=> 'sk_marquee_images',
					'hover_id'	 	=> 'sk_marquee_images_hover',
					"heading"     	=> esc_html__( "Images", 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					'settings' 		=> array( 'width', 'height', 'background', 'border', 'box-shadow', 'advanced' )
				),
				array( 'type' => 'cz_hidden','param_name' => 'sk_marquee_images_tablet' ),
				array( 'type' => 'cz_hidden','param_name' => 'sk_marquee_images_mobile' ),
				array( 'type' => 'cz_hidden','param_name' => 'sk_marquee_images_hover' ),
				array(
					'type' 			=> 'checkbox',
					'heading' 		=> esc_html__('Overlay gradient?', 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					'param_name' 	=> 'overlay_gradient'
				),
				array(
					"type" => "colorpicker",
					"heading" => esc_html__("Gradient color",'codevz-plus'),
					"param_name" => "overlay_gradient_color",
					'edit_field_class' => 'vc_col-xs-99',
					"value" => '',
					'dependency'	=> array(
						'element'		=> 'overlay_gradient',
						'value'			=> [ 'true' ]
					)
				),

				// Advanced
				array(
					'type' 			=> 'checkbox',
					'heading' 		=> esc_html__( 'Hide on Desktop?', 'codevz-plus' ),
					'param_name' 	=> 'hide_on_d',
					'edit_field_class' => 'vc_col-xs-4',
					'group' 		=> esc_html__( 'Advanced', 'codevz-plus' )
				), 
				array(
					'type' 			=> 'checkbox',
					'heading' 		=> esc_html__( 'Hide on Tablet?', 'codevz-plus' ),
					'param_name' 	=> 'hide_on_t',
					'edit_field_class' => 'vc_col-xs-4',
					'group' 		=> esc_html__( 'Advanced', 'codevz-plus' )
				), 
				array(
					'type' 			=> 'checkbox',
					'heading' 		=> esc_html__( 'Hide on Mobile?', 'codevz-plus' ),
					'param_name' 	=> 'hide_on_m',
					'edit_field_class' => 'vc_col-xs-4',
					'group' 		=> esc_html__( 'Advanced', 'codevz-plus' )
				),
				array(
					'type' 			=> 'cz_title',
					'param_name' 	=> 'cz_title',
					'class' 		=> '',
					'content' 		=> esc_html__( 'Parallax', 'codevz-plus' ),
					'group' 		=> esc_html__( 'Advanced', 'codevz-plus' )
				),
				array(
					"type"        	=> "dropdown",
					"heading"     	=> esc_html__( "Parallax", 'codevz-plus' ),
					"param_name"  	=> "parallax_h",
					'edit_field_class' => 'vc_col-xs-99',
					'value'		=> array(
						esc_html__( 'Select', 'codevz-plus' )					=> '',
						
						esc_html__( 'Vertical', 'codevz-plus' )					=> 'v',
						esc_html__( 'Vertical + Mouse parallax', 'codevz-plus' )		=> 'vmouse',
						esc_html__( 'Horizontal', 'codevz-plus' )				=> 'true',
						esc_html__( 'Horizontal + Mouse parallax', 'codevz-plus' )	=> 'truemouse',
						esc_html__( 'Mouse parallax', 'codevz-plus' )				=> 'mouse',
					),
					"group"  		=> esc_html__( 'Advanced', 'codevz-plus' )
				),
				array(
					"type"        	=> "cz_slider",
					"heading"     	=> esc_html__( "Parallax speed", 'codevz-plus' ),
					"description"   => esc_html__( "Parallax is according to page scrolling", 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					"param_name"  	=> "parallax",
					"value"  		=> "0",
					'options' 		=> array( 'unit' => '', 'step' => 1, 'min' => -50, 'max' => 50 ),
					'dependency'	=> array(
						'element'		=> 'parallax_h',
						'value'			=> array( 'v', 'vmouse', 'true', 'truemouse' )
					),
					"group"  		=> esc_html__( 'Advanced', 'codevz-plus' )
				),
				array(
					'type' 			=> 'checkbox',
					'heading' 		=> esc_html__( 'Stop when done', 'codevz-plus' ),
					'param_name' 	=> 'parallax_stop',
					'edit_field_class' => 'vc_col-xs-99',
					'dependency'	=> array(
						'element'		=> 'parallax_h',
						'value'			=> array( 'v', 'vmouse', 'true', 'truemouse' )
					),
					'group' 		=> esc_html__( 'Advanced', 'codevz-plus' )
				), 
				array(
					"type"        	=> "cz_slider",
					"heading"     	=> esc_html__("Mouse speed", 'codevz-plus' ),
					"description"   => esc_html__( "Mouse parallax is according to mouse move", 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99',
					"param_name"  	=> "mparallax",
					"value"  		=> "0",
					'options' 		=> array( 'unit' => '', 'step' => 1, 'min' => -30, 'max' => 30 ),
					'dependency'	=> array(
						'element'		=> 'parallax_h',
						'value'			=> array( 'vmouse', 'truemouse', 'mouse' )
					),
					"group"  		=> esc_html__( 'Advanced', 'codevz-plus' )
				),
				array(
					'type' 			=> 'cz_title',
					'param_name' 	=> 'cz_title',
					'class' 		=> '',
					'content' 		=> esc_html__( 'Animation & Class', 'codevz-plus' ),
					'group' 		=> esc_html__( 'Advanced', 'codevz-plus' )
				),
				Codevz_Plus::wpb_animation_tab( false ),
				array(
					'type' 			=> 'cz_sk',
					'param_name' 	=> 'sk_brfx',
					"heading"     	=> esc_html__( "Block Reveal", 'codevz-plus' ),
					'edit_field_class' => 'vc_col-xs-99 hidden',
					'group' 	=> esc_html__( 'Advanced', 'codevz-plus' ),
					'settings' 		=> array( 'background' )
				),
				array(
					"type"        	=> "cz_slider",
					"heading"     	=> esc_html__("Animation Delay", 'codevz-plus' ),
					"description" 	=> 'e.g. 500ms',
					"param_name"  	=> "anim_delay",
					'options' 		=> array( 'unit' => 'ms', 'step' => 100, 'min' => 0, 'max' => 5000 ),
					'edit_field_class' => 'vc_col-xs-6',
					'group' 		=> esc_html__( 'Advanced', 'codevz-plus' )
				),
				array(
					"type"        	=> "textfield",
					"heading"     	=> esc_html__( "Extra Class", 'codevz-plus' ),
					"param_name"  	=> "class",
					'edit_field_class' => 'vc_col-xs-6',
					'group' 		=> esc_html__( 'Advanced', 'codevz-plus' )
				),
			)
		);

		return $wpb ? vc_map( $atts ) : $atts;
	}

	/**
	 *
	 * Shortcode output
	 * 
	 * @return string
	 * 
	 */
	public function out( $atts, $content = '' ) {

		// Settings.
		$atts = Codevz_Plus::shortcode_atts( $this, $atts );

		// ID
		if ( ! $atts['id'] ) {
			$atts['id'] = Codevz_Plus::uniqid();
			$public = 1;
		}

		// Styles
		if ( isset( $public ) || Codevz_Plus::$vc_editable || Codevz_Plus::$is_admin ) {
			$css_id = '#' . $atts['id'];

			$custom = $atts['anim_delay'] ? 'animation-delay:' . $atts['anim_delay'] . ';' : '';

			$css_array = array(
				'sk_marquee' 				=> array( $css_id, $custom ),
				'sk_marquee_images' 		=> $css_id . ' img',
				'sk_marquee_images_hover' 	=> $css_id . ' img:hover'
			);

			$css 	= Codevz_Plus::sk_style( $atts, $css_array );
			$css_t 	= Codevz_Plus::sk_style( $atts, $css_array, '_tablet' );
			$css_m 	= Codevz_Plus::sk_style( $atts, $css_array, '_mobile' );

			if ( ! empty( $atts['overlay_gradient'] ) && ! empty( $atts['overlay_gradient_color'] ) ) {
				$css .= $css_id . ':after{--overlay-gr:' . esc_attr( $atts['overlay_gradient_color'] ) . '}';
			}

		} else {
			Codevz_Plus::load_font( $atts['sk_marquee'] );
		}

		// Classes
		$classes = array();
		$classes[] = 'cz_text_marquee';
		$classes[] = empty( $atts['stop_on_hover'] ) ? '' : 'cz_text_marquee_soh';
		$classes[] = empty( $atts['overlay_gradient'] ) ? '' : 'codevz-plus-overlay-gradient';

		$dir = $atts['direction'] ? $atts['direction'] : 'left';
		$type = $atts[ 'marquee_type' ] ? $atts[ 'marquee_type' ] : '1';
		$styles = '--czm-dir:' . esc_attr( $dir ) . ';';
		$styles .= Codevz_Plus::contains( $dir, [ 'left', 'right' ] ) ? '--czm-offset:2px;' : '--czm-offset:0px;';
		$styles .= empty( $atts['marquee_width'] ) 	? '' : 'width:' . $atts['marquee_width'] . 'px;';
		$styles .= empty( $atts['marquee_height'] ) ? '' : 'height:' . $atts['marquee_height'] . 'px;';
		$styles .= empty( $atts['gap'] ) 			? '' : '--czm-gap:' . $atts['gap'] . 'px;';
		$styles .= empty( $atts['duration'] ) 		? '' : '--czm-duration:' . ( ( (int) $atts['duration'] ) * 2 ) . 's;';

		$out = '<div id="' . $atts['id'] . '"' . Codevz_Plus::classes( $atts, $classes ) . ' data-type="' . esc_attr( $type ) . '" data-dir="' . esc_attr( $dir ) . '" style="' . esc_attr( $styles ) . '"><div>';

		$sanitized_content = '';

		if ( $type === '2' ) {

			$images = $atts['images'] ? explode( ',', $atts['images'] ) : array( 1,1,1,1,1,1,1,1 );

			foreach ( $images as $image ) {
	
				$title = get_post( $image );

				if ( is_object( $title ) ) {
					$out .= Codevz_Plus::get_image( $image, 0, 1 );
				}
			}

			$out .= '<div>' . $sanitized_content . '</div>';
			$out .= '<div>' . $sanitized_content . '</div>';

		} else {

			$sanitized_content = do_shortcode( wp_kses_post( (string) $atts['marquee'] ) );
			$out .= '<div>' . $sanitized_content . '<div class="cz_text_marquee_inner">' . $sanitized_content . '</div></div>';
			$out .= '<div>' . $sanitized_content . '<div class="cz_text_marquee_inner">' . $sanitized_content . '</div></div>';

		}

		$out .= '</div></div><div aria-hidden="true"' . Codevz_Plus::data_stlye( $css, $css_t, $css_m ) . '></div>';

		return Codevz_Plus::_out( $atts, $out, 'text_marquee', $this->name );
	}

}