var Codevz = ( function( $ ) {
	"use strict";

	var wind = $( window ),
		body = $( document.body ),
		page = $( 'html, body' ),
		inla = $( '.inner_layout' ).length ? $( '.inner_layout' ) : body;

	// Remove no-js class.
	document.documentElement.classList.remove("no-js");

	// Custom easing.
	$.extend( $.easing, {
		def: 'easeInOutCodevz',
		easeInOutCodevz: function(x) {
			return x === 0 ? 0 : x === 1 ? 1 : x < 0.5 ? Math.pow( 2, 20 * x - 10 ) / 2 : ( 2 - Math.pow( 2, -20 * x + 10 ) ) / 2;
		}
	});

	// Codevz callback.
	if ( ! $.fn.codevz ) {

		$.fn.codevz = function( data, callback ) {

			if ( $( this ).length ) {

				var $this = $( this ),
					run = function( e ) {

						var l = e.length, i = 0;

						for( i; i < l; i++ ) {

							var x = $( e[i] );

							if ( x.data( 'codevz' ) !== data ) {
								callback.apply( x.data( 'codevz', data ), [ x, i ] );
							}

						}

					};

				if ( Codevz.inview( $this, 100 ) ) {

					run( $this );

				} else {

					$( window ).on( 'scroll.codevz', function() {

						run( $this );

						$( this ).off( 'scroll.codevz' );

					} );

				}

			}

		}

	}

	return {

		inview: function( e, offset ) {

			var offset 			= offset || 0,
				docViewTop 		= wind.scrollTop(),
				docViewBottom 	= docViewTop + wind.height(),
				elemTop 		= e.offset().top,
				elemBottom 		= elemTop + e.height();

			return ( ( elemTop <= docViewBottom + offset ) && ( elemBottom >= docViewTop - offset ) );

		},

		init: function() {

			// Header custom shape size.
			document.querySelectorAll('div[class*="cz_row_shape_"]').forEach(x => {
			  window.Codevz.heightChanged(x, () => {
			    const cls = '.' + Array.from(x.classList).join('.');
			    const hei = x.offsetHeight + 37;

			    let style = x.querySelector(':scope > style');
			    if (!style) {
			      style = document.createElement('style');
			      x.appendChild(style);
			    }

			    style.textContent = cls + ' .row:before,' + cls + ' .row:after{width:' + hei + 'px}.elms_row ' + cls + ':before, .elms_row ' + cls + ':after{width:' + hei + 'px}';
			  });
			});

			// Social Dorpdown.
			body.off( 'click.social_trigger' ).on( 'click.social_trigger', '.xtra-social-icon-trigger', function() {

				var x 	= $( this ),
					box = x.next( '.xtra-social-dropdown' );

				if ( box.length ) {

					if ( box.is( ':visible' ) ) {
						box.fadeOut( 'fast' );
					} else {
						box.fadeIn( 'fast' );
					}

				}

			}).on( 'click', function( e ) {

				if ( $( e.target ).closest( '.cz_elm' ).length ) {
					return;
				}

				$( '.xtra-social-dropdown' ).fadeOut( 'fast' );

			});

			// Alignfull & Videos
			const els = document.querySelectorAll('.alignfull, .cz_iframe, .content iframe, object, embed:not(.wp-embedded-content)');
			const obs = new ResizeObserver(() => requestAnimationFrame(() => {
			    const winW = window.innerWidth;
			    els.forEach(el => {
			        const pW = el.parentElement.offsetWidth;
			        if (el.classList.contains('alignfull')) {
			            Object.assign(el.style, { width: winW + 'px', left: (pW - winW) / 2 + 'px' });
			        } else {
			            const r = el.dataset.ratio ||= el.offsetHeight / el.offsetWidth;
			            Object.assign(el.style, { width: pW + 'px', height: pW * r + 'px' });
			        }
			    });
			}));
			obs.observe(document.documentElement);

			// Posts equality.
			document.querySelectorAll( '.cz_posts_container' ).forEach( el => {
			    if ( el.querySelector( '.cz_default_loop_grid' ) ) {
			        el.classList.add( 'cz_posts_equal' );
			    }
			});

			// Widget nav menu dropdown.
			document.querySelectorAll( '.widget_nav_menu .menu-item-has-children > a' ).forEach( el => {
			    if ( ! el.querySelector( '.fa-angle-down' ) ) {
			        el.insertAdjacentHTML( 'beforeend', '<i class="fa fa-angle-down" aria-hidden="true"></i>' );
			    }
			});

			// Widget nav menu dropdown arrow.
			body.on( 'click', '.widget_nav_menu .menu-item-has-children > a > i', function( e ) {

				$( this ).toggleClass( 'fa-angle-down fa-angle-up' ).closest( 'li' ).find( '> ul' ).slideToggle();

				e.preventDefault();

			// Dropdown menu off screen.
			}).on( 'mouseenter', '.sf-menu .menu-item-has-children', function() {

				var dropdown = $( this ).find( '> ul' ).removeClass( 'cz_open_menu_reverse' ),
					isVisible = dropdown.offset().left + dropdown.width() <= inla.width();

				dropdown[ isVisible ? 'removeClass' : 'addClass' ]( 'cz_open_menu_reverse' );

			});

			// Menus
			$( '.sf-menu' ).each( function( i ) {

				var x 			= $( this ),
					overlay 	= $( '.codevz-plus-dropdown-overlay .inner_layout > .cz_overlay' ),
					indicator 	= x.data( 'indicator' ) || ( x.hasClass( 'offcanvas_menu' ) ? 'fa fa-angle-down' : '' ),
					indicator2 	= x.data( 'indicator2' ) || ( x.hasClass( 'offcanvas_menu' ) ? 'fa fa-angle-down' : '' ),
					overlayTimeout;

				// Superfish.
				x.codevzMenu({

					onInit: function() {

						// Menu indicators.
						$( '.sub-menu', this ).parent().each( function() {

							var en = $( this ),
								a = en.find( '> a, > .codevz-plus-megamenu-title' );

							if ( ! a.find( '.cz_indicator' ).length ) {

								if ( $( '.cz_menu_subtitle', a ).length ) {
									$( '.cz_menu_subtitle', a ).before( '<i class="cz_indicator" aria-hidden="true"></i>' );
								} else {
									a.append( '<i class="cz_indicator" aria-hidden="true"></i>' );
								}

							}

							if ( indicator || indicator2 ) {
								$( '.cz_indicator', a ).addClass( a.closest( '.sub-menu' ).length ? indicator2 : indicator );
							}

							if ( en.html() === '' ) {
								en.find( '.cz_indicator' ).remove();
								en.next( 'ul' ).remove();
							}

							// Empty href.
							!en.attr( 'href' ) && en.removeClass( 'current_menu' );

							// Fix: Current active menu in dropdown.
							en.find( '.current_menu' ).length && setTimeout(function() {
								en.addClass( 'current_menu' );
							}, 250 );

						});

						// Fix: Keep original current menu in dropdown menu.
						if ( x.find( '.current_menu ul > .current-menu-item' ).length ) {

							x.find( '.current_menu ul > .current-menu-item' ).siblings().removeClass( 'current_menu' );

						// If there is no current menu but ancestor exists.
						} else if ( ! x.find( '.current_menu' ).length && x.find( '.current-page-ancestor, .current-post-ancestor, .current-menu-item' ).length ) {

							$( x.find( '.current-page-ancestor, .current-post-ancestor, .current-menu-item' )[0] ).addClass( 'current_menu' );

						}

						// Auto responsive menu items according to window width.
						if ( x.not( '#menu_header_4, #menu_fixed_side_1, .cz-not-three-dots' ).length ) {

							// Fix single menu in column issue.
							if ( x.parent().parent().find( '.cz_elm' ).length == 1 ) {
								x.parent().parent().append( '<div class="cz_elm">&nbsp;</div>' );
							}

							wind.on( 'resize.responsive', function() {

								var en = x,
									parent = en.parent(),
									elementor = en.closest( '.elementor-container' ),
									menu_margin = parseFloat( parent.css( 'margin-left' ) ) + parseFloat( parent.css( 'margin-right' ) ),
									elements = 0,
									container,
									three_dots = ( body.attr( 'class' ).indexOf( 'codevz-plus' ) >= 0 ) ? '<i class="fa czico-055-three cz-extra-menus" style="margin:0" aria-hidden="true"></i>' : '...';

								setTimeout( function() {

									// Reset
									en.append( en.find( '.cz-extra-menus > .sub-menu > li' ) ).find( '.cz-extra-menus' ).remove();

									// Add icon dots
									if ( ! en.find( '.cz-extra-menus' ).length ) {
										var submenu_title = $( '.cz_menu_subtitle' ).text() ? '<span class="cz_menu_subtitle">&nbsp;</span>' : '';
										en.append( '<li class="cz-extra-menus cz"><a href="#" class="sf-with-ul" role="button" tabindex="0" aria-label="More hidden menu links" aria-hidden="true"><span>&nbsp;' + three_dots + '&nbsp;</span>' + submenu_title + '</a><ul class="sub-menu" aria-hidden="true"></ul></li>');
									}

									var nw = en.find( '.cz-extra-menus' ), 
										nw_ul = nw.find( '> ul' );

									nw.hide().prev().addClass( 'cz-last-child' );

									// Get elements width
									en.parent().parent().find( '.cz_elm' ).not( parent ).each(function() {

										elements += $( this ).outerWidth() + parseFloat( $( this ).css( 'margin-left' ) ) + parseFloat( $( this ).css( 'margin-right' ) );

									});

									// Move back to parent
									nw_ul.find( '> li' ).appendTo( en );

									// Move to hidden menu
									$( en.find( '> li' ).not( '.cz-extra-menus' ).get().reverse() ).each( function() {

										if ( elementor.length ) {
											container = elementor.outerWidth();
										} else {
											container = en.closest( '.have_center' ).length ? parent.parent().parent().outerWidth() : parent.parent().outerWidth();
										}

										if ( ( parent.outerWidth() + menu_margin ) + elements + ( elementor ? 0 : 25 ) > container ) {
											$( this ).prependTo( nw_ul );
											nw.show();
										}

									});

								}, 1000 );

							}).trigger( 'resize.responsive' );

						}

					},
					onBeforeHide: function() {

						var x = $( this );

						clearTimeout( overlayTimeout );

						// Hide overlay background.
						overlayTimeout = setTimeout( function() {
							if ( ! $( '.sfHover' ).length ) {
								overlay.fadeOut();
							}
						}, 50 );

					},
					onBeforeShow: function() {

						var x = $( this );

						setTimeout( function() {

							// Sub menu.
							if ( x.hasClass( 'sub-menu' ) ) {

								overlay.css( 'z-index', '99' ).fadeIn();

								// Check if mega menu is fullwide
								if ( x.parent().hasClass( 'cz_megamenu_width_fullwide' ) ) {

									var megamenu_row = body,
										megamenu_row_offset = megamenu_row.offset().left,
										megamenu_row_width = megamenu_row.width();

									x.attr( 'style', x.attr( 'style' ) + 'width: ' + wind.width() + 'px;left:' + ( megamenu_row_offset - x.parent().offset().left ) + 'px;margin-right:0;margin-left:0;right:auto !important;' );

								}

								// Sub-menu styling
								if ( x.parent().data( 'sub-menu' ) ) {
									setTimeout(function() {
										x.attr( 'style', x.attr( 'style' ) + x.parent().data( 'sub-menu' ) );
									}, 50 );
								}

								// Megamenu
								if ( x.parent().hasClass( 'cz_parent_megamenu' ) ) {
									x.addClass( 'cz_megamenu_' + $( '> .cz', x ).length ).find( 'ul' ).addClass( 'cz_megamenu_inner_ul clr' );
								}

								// Megamenu full row
								if ( x.parent().hasClass( 'cz_megamenu_width_full_row' ) ) {

									var megamenu_row = $( '.row' ),
										megamenu_row_offset = megamenu_row.offset().left,
										megamenu_row_width = megamenu_row.width();

									if ( x.closest( '.cz-extra-menus' ).length ) {

										megamenu_row_width = megamenu_row_width - ( megamenu_row.width() - x.parent().offset().left + 10 );

									}

									x.attr( 'style', x.attr( 'style' ) + 'width: ' + megamenu_row_width + 'px;left:' + ( megamenu_row_offset - x.parent().offset().left ) + 'px;' );

								}

							}

							if ( x.closest('.fixed_side').length ) {
								var pwidth = x.parent().closest( '.sub-menu' ).length ? '.sub-menu' : '.sf-menu',
									ff_pos = $( '.fixed_side' ).hasClass( 'fixed_side_left' ) ? 'left' : 'right';
								x.css( ff_pos, x.closest( pwidth ).width() );
							}

						}, 100 );

						setTimeout( function() {

							// Fix grid & carousel.
							if ( x.parent().hasClass( 'cz_parent_megamenu' ) ) {
								wind.trigger( 'resize' ).trigger( 'scroll' );
							}

						}, 250 );

					}

				});

			});

			// Prevent empty ul links click.
			body.on( 'click', '.sf-with-ul', function( e ) {
			
				if ( this.getAttribute('href') === '#' ) {
					e.preventDefault();
					e.stopPropagation();
				}

			// Dropdown Menu
			}).off( 'click.icon_dropdown_menu' ).on( 'click.icon_dropdown_menu', '.icon_dropdown_menu', function( e ) {

				var x = $( this ),
					pos = x.position(),
					nav = x.parent().find('.sf-menu'),
					row = $( this ).closest('.row').height(),
					offset = ( ( inla.outerWidth() + inla.offset().left ) - x.offset().left );

				nav.fadeToggle( 'fast' );
				x.toggleClass( 'czico-close' );

				$( '.cz', nav ).on( 'mouseenter mouseleave', function(e) {
					e.stopPropagation();
				}).off( 'click' ).on( 'click', function(e) {
					if ( $( e.target ).hasClass( 'cz_indicator' ) ) {
						$( this ).closest( 'li' ).find('> ul').fadeToggle( 'fast' );
						x.toggleClass( 'czico-close' );
						e.preventDefault();
						e.stopPropagation();
					}
				});

				e.stopPropagation();

			// Open Menu Horizontal
			}).off( 'click.icon_open_horizontal' ).on( 'click', '.icon_open_horizontal', function( e ) {

				var x = $( this ),
					pos = x.position(),
					nav = x.parent().find('.sf-menu'),
					row = $( this ).closest('.row').height(),
					offset = ( ( inla.outerWidth() + inla.offset().left ) - x.offset().left );

				nav.fadeToggle( 'fast' );
				x.toggleClass( 'czico-close' );

				e.stopPropagation();

			// Mobile Menu
			}).off( 'click.icon_mobile_offcanvas_menu' ).on( 'click', 'i.icon_mobile_offcanvas_menu', function() {

				var x = $( this );

				if ( ! x.hasClass( 'done' ) ) {

					setTimeout( function() {

						Codevz.offCanvas( x.addClass( 'done' ), 1 );

						var ul_offcanvas = $( 'ul.offcanvas_area' ),
							indicator 	= ul_offcanvas.data( 'indicator' ),
							default_ind = ul_offcanvas.hasClass( 'offcanvas_menu' ) ? 'fa fa-angle-down' : '',
							indicator 	= indicator ? indicator : default_ind,
							indicator2 	= ul_offcanvas.data( 'indicator2' ),
							indicator2 	= indicator2 ? indicator2 : default_ind,
							header  	= x.parent().find( '.xtra-mobile-menu-head' ),
							additional  = x.parent().find( '.xtra-mobile-menu-additional' );

						header.length && ul_offcanvas.prepend( '<li class="xtra-mobile-menu-head">' + header.html() + '</li>' );
						additional.length && ul_offcanvas.append( '<li class="xtra-mobile-menu-additional">' + additional.html() + '</li>' );

						// Add mobile menus indicator
						if ( indicator.length || indicator2.length ) {
							x.next( '.sf-menu' ).find( '.sf-with-ul' ).each(function() {
								$( '.cz_indicator', this ).addClass( ( x.parent().parent().hasClass( 'sf-menu' ) ? indicator : indicator2 ) );
							});
						}

						ul_offcanvas.off( 'click.offcanvas_sf_with_ul' ).on( 'click.offcanvas_sf_with_ul', '.sf-with-ul, .cz > .codevz-plus-megamenu-title', function (e) {

						    const $trigger = $( this );
						    const $icon = $trigger.find( '.cz_indicator' );

						    if ( $trigger.attr( 'href' ) === '#' || $( e.target ).closest( '.cz_indicator' ).length > 0 ) {

						        $trigger.next().slideToggle('fast');

						        if ( $icon.length ) {
						            const current = $icon.data( 'rotated' ) || false;
						            $icon.css( 'transform', 'rotate(' + (current ? 0 : 180) + 'deg)' ).data( 'rotated', ! current );
						        }

						        e.preventDefault();
						    }
						});

						// Remove ul.
						setTimeout( function() {

							x.parent().find( '> ul,> .hide' ).not( x ).remove();

							// Open dropdown for active menu inside.
							const activeParent = ul_offcanvas.find( '.current_menu' ).closest( '.current_menu' );
							if ( activeParent.length ) {
								activeParent.find( '> a > .cz_indicator' ).trigger( 'click' );
							}

						}, 250 );

					}, 250 );

				}

			// OffCanvas
			}).off( 'click.offcanvas_container_i' ).on( 'click', '.offcanvas_container > i', function() {

				var x = $( this );

				if ( ! x.hasClass( 'done' ) ) {

					Codevz.offCanvas( x.addClass( 'done' ), 1 );

				}

			// Fullscreen Menu
			}).off( 'click.icon_fullscreen_menu' ).on( 'click', '.icon_fullscreen_menu', function( e ) {

				var x = $( '.fullscreen_menu' );

				body.addClass( 'cz_noStickySidebar' ).find( '.fixed_side_1.have_center' ).find( '.fullscreen_menu,.xtra-close-icon' ).appendTo( '.fixed_side_1.have_center' );

				x.fadeIn( 'fast' ).on( 'click', function( e ) {

					if ( ! $( e.target ).closest( '.cz' ).length ) {

						$( this ).delay( 500 ).fadeOut( 'fast', function() {
							body.removeClass( 'cz_noStickySidebar' );
							$( '.xtra-close-icon' ).addClass( 'hide' );
							page.removeClass( 'no-scroll' );
						});

					}

				});

				if ( x.is(':visible') ) {

					page.addClass( 'no-scroll' );

				}

				var h = x.find( '> li' ).height() * ( ( x.find( '> li' ).length - 1 ) / 2 );

				x.css( 'padding-top', ( ( wind.height() / 2 ) - h ) );

				$( '.xtra-close-icon' ).toggleClass( 'hide' ).off().on( 'click', function() {
					$( this ).addClass( 'hide' );
					x.fadeOut( 'fast' );
					page.removeClass( 'no-scroll' );
				});

			// Fullscreen
			}).off( 'click.fullscreen_menu' ).on( 'click.fullscreen_menu', 'ul.fullscreen_menu .cz', function( e ) {

				if ( $( e.target ).hasClass( 'cz_indicator' ) ) {
					$( this ).closest( 'li' ).find( '> ul' ).fadeToggle( 'fast' );
					e.preventDefault();
					e.stopPropagation();
				}

			// Hidden fullwidth content
			}).off( 'click.hf_elm_icon' ).on( 'click.hf_elm_icon', '.hf_elm_icon', function( e ) {

				var x = $( this ),
					r = x.closest( '.row' );

				page.toggleClass( 'no-scroll' );

				setTimeout( function() {
					x.toggleClass( 'czico-close' ).next( '.hf_elm_area' ).toggleClass( 'hf_elm_area_active' ).css({
						width: inla.outerWidth(),
						left: inla.offset().left,
						top: r.position().top + r.outerHeight() + ( $( '#wpadminbar' ).length ? 32 : 0 )
					});
				}, 100 );

				body.on( 'click.cz_hf_elm', function(e) {
					if ( ! $( e.target ).closest( '.hf_elm_area' ).length ) {
						x.removeClass( 'czico-close' ).next( '.hf_elm_area' ).removeClass( 'hf_elm_area_active' );
						body.off( 'click.cz_hf_elm' );
						page.removeClass( 'no-scroll' );
					}
				});

				e.preventDefault();
				e.stopPropagation();

			});

			// Add clear.
			document.querySelectorAll( '.tagcloud' ).forEach( el => el.classList.add( 'clr' ) );

			// Input buttons to button tag
			document.querySelectorAll( '.form-submit .submit, input.search-submit, .wpcf7-submit' ).forEach( el => {
			    const btn = document.createElement( 'button' );
			    btn.type = 'submit';
			    btn.name = 'submit';
			    btn.className = el.className;
			    btn.textContent = el.value;
			    el.parentNode.insertBefore(btn, el.nextSibling);
			    el.remove();
			});

			this.menu_anchor();
		},

		// Menu Anchor.
		menu_anchor: function() {

			// Disable Elementor links anchor.
			if ( typeof elementorFrontend !== 'undefined' && typeof elementorFrontend.utils !== 'undefined' && typeof elementorFrontend.utils.anchors !== 'undefined' ) {

			    setTimeout(function() {
			        elementorFrontend.elements.$document.off(
			            'click',
			            elementorFrontend.utils.anchors.getSettings('selectors.links'),
			            elementorFrontend.utils.anchors.handleAnchorLinks
			        );
			    }, 500);

			}

			// Prevent hashtag link click jump.
			document.body.addEventListener( 'click', (e) => {
			    if ( e.target.closest( "a[href*='#']:not([target='_blank'])" ) ) {
			        e.preventDefault();
			    }
			});

			// Init.
			var aBar 	= body.hasClass( 'admin-bar' ) ? 32 : 0,
				mLink 	= $( "a[href*='#']" ).not( "a[href='#'],a[target='_blank'],a[href*='#/']" ),
				sticky 	= $( '.header_is_sticky' ).not( '.smart_sticky, .header_4' ),
				scrollTop = 0, timeout,
				scrollToAnchor = function( target ) {

					clearTimeout( timeout );

					timeout = setTimeout( function() {

						$( window ).trigger( 'scroll' ); // Fix target position.

						target = target.replace( '%20', ' ' );
						target = ( target.indexOf( '#' ) >= 0 ) ? $( target ) : $( '#' + target );

						if ( target.length && ! target.hasClass( 'cz_popup_modal' ) ) {

							scrollTop = $( document ).scrollTop();

							if ( wind.width() < 768 && $( '.header_4.header_is_sticky' ).length ) {
								sticky = $( '.header_4.header_is_sticky' ).not( '.smart_sticky' );
							}

							if ( scrollTop == 0 && sticky.length ) {
								$( document ).scrollTop( 1 );
							}

							setTimeout( function() {

								page.animate({ scrollTop: target.offset().top - aBar - ( sticky.outerHeight() || 0 ) }, 1200, 'easeInOutCodevz', function() {

									page.stop( true, true );

								});

								$( '.offcanvas-close' ).trigger( 'click' );

							}, scrollTop == 0 ? 450 : 1 );

						}

					}, 50 );

				};

			// Links.
			if ( mLink.length ) {

				mLink.off( 'click.anchor' ).on( 'click.anchor', function( e ) {

					if ( $( this ).not( 'a[href*="#top"],[data-tab],.cz_popup_modal,.cz_no_anchor,.cz_no_anchor a, .vc_general, .cz_no_anchor a, .cz_lrpr a, .wc-tabs a, .page-numbers a, #cancel-comment-reply-link, .vc_carousel-control, [data-vc-container],.comment-form-rating a,.sm2-bar-ui a,.lwptoc a' ).length ) {

						if ( ! $( e.target ).hasClass( 'cz_indicator' ) ) {

							if ( $( this.hash ).length && location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname ) {
								scrollToAnchor( this.hash );
							} else if ( this.hash ) {
								location = $( this ).attr( 'href' );
							}

						}

						e.preventDefault();

					}

				});

				var mPage  = $( '.sf-menu' ),
					mPageH = mPage.outerHeight() + 15,
					mItems = mPage.find( "a[href*='#']" ).not( "a[href='#'],a[href*='#/']" ),
					sItems = mItems.map(function(){
						var item = $( $( this ).attr( "href" ).replace( /\s+|%20/g, "" ).replace( /^.*\#(.*)$/g, "#$1" ) );
						if ( item.length ) {
							return item;
						}
					});

				wind.on( 'scroll.anchor', function() {

					clearTimeout( timeout );

					timeout = setTimeout( function() {

						var ft = $( this ).scrollTop() + mPageH + aBar + ( sticky.outerHeight() || 0 ),
							cur = sItems.map(function() {
								if ( $(this).offset().top < ft )
									return this;
								});

						cur = cur[cur.length-1];
						var id = cur && cur.length ? cur[0].id : "";
						if ( id && ! $( '#' + id + '.cz_popup_modal' ).length && $( '#' + id ).length ) {
							body.trigger( 'click' );
							mItems.parent().removeClass( "current_menu" ).end().filter( "[href*='#" + id + "']" ).parent().addClass( "current_menu" );
						} else {
							mItems.parent().removeClass( "current_menu" );
						}

					}, 50 );

				});
			}
		},

		/*
		*   offCanvas area
		*/
		offCanvas: function( selector, click, area ) {

			var parent  = selector.parent(),
				area    = area || selector.next(),
				layout  = $( '#layout' ),
				overlay = $( '.cz_overlay' ),
				isRight, i, 
				fixed_side = 0,
				close, timeout;

			if ( area.length ) {

				var area = area.clone(),
					isRight = area.hasClass( 'inview_right' ),
					new_class = area.hasClass('sf-menu') ? 'sf-menu offcanvas_area' : 'offcanvas_area offcanvas_original';

				body.prepend( area.removeClass().addClass( 'sidebar_offcanvas_area' ).addClass( new_class + ( isRight ? ' inview_right' : ' inview_left' ) ) );
				var area_w = area.width() + 80;

				if ( selector.closest( '.elementor-element' ).length ) {

					var elementor_page = selector.closest( '.elementor' ).attr( 'data-elementor-id' );
					body.addClass( 'elementor-page-' + elementor_page + ' elementor-' + elementor_page );

					var classList = selector.closest( '.elementor-element' ).attr('class').split(/\s+/);
					$.each( classList, function( index, item ) {
						if ( item.indexOf( 'elementor-element-' ) == 0 ) {
							area.addClass( 'elementor-element ' + item );
						}
					});

				}

				area.find( '.sub-menu' ).hide();

			} else {

				return;

			}

			// Open icon
			selector.on( 'click', function(e) {

				if ( area.hasClass( 'active_offcanvas' ) && ! body.hasClass( 'offcanvas_doing' ) ) {

					page.removeClass( 'no-scroll' );

					overlay.trigger( 'click' );

				} else {

					page.addClass( 'no-scroll' );

					$( 'html' ).css( 'margin-top', '0 !important' );
					$( '#layout' ).css( 'margin-top', '40px !important' );

					// Close icon
					if ( body.attr( 'class' ).indexOf( 'codevz-plus' ) >= 0 ) {
						area.before( '<i class="fa czico-198-cancel offcanvas-close" aria-hidden="true"></i>' );
					} else {
						area.before( '<i class="fa fa-times offcanvas-close" aria-hidden="true"></i>' );
					}
					close = area.prev( '.offcanvas-close' );
					close.on( 'click', function(e) {
						if ( click ) {
							body.removeClass( 'active_offcanvas' );
							area.removeClass( 'active_offcanvas' );
	
							overlay.fadeOut();
							setTimeout(function() {
								$( '.offcanvas-close' ).detach();
								wind.trigger( 'resize' );
								page.removeClass( 'no-scroll' );
							}, 500 );
							
							click = 0;
						} else {
							overlay.trigger( 'click' );
						}
					});
					close.css( ( isRight ? 'right' : 'left' ), area.outerWidth() + fixed_side );

					body.addClass( 'offcanvas_doing active_offcanvas' + ( isRight ? ' cz_offcanvas_right' : ' cz_offcanvas_left' ) );
					area.addClass( 'active_offcanvas' );

					if ( wind.width() > 768 ) {

						if ( ( $( '.fixed_side_left' ).length && $( '.cz_offcanvas_left' ).length ) || $( '.fixed_side_right' ).length  && $( '.cz_offcanvas_right' ).length ) {
							if ( ! $( '#cz_ofs' ).length ) {
								$( 'head' ).append( '<style id="cz_ofs"></style>' );
							}
							fixed_side = $( '.fixed_side' ).width();
							$( '#cz_ofs' ).html( '.active_offcanvas .offcanvas_area.active_offcanvas{transform:translateX(' + ( isRight ? '-' : '' ) + fixed_side + 'px)}' );
						}
						
					}

					setTimeout(function() {

						overlay.css( 'z-index', '' ).fadeIn();

					}, 150 );

					setTimeout(function() {

						body.removeClass( 'offcanvas_doing' );

						if ( area.find( '.cz_acc_child' ).length ) {

							Codevz_Plus.accordion();

						}

					}, 1250 );

				}

				e.stopPropagation();
			});

			// First time
			if ( click ) {
				selector.trigger( 'click' );
			}

			// Prevent close on open icon
			area.on( 'click', function(e) {
				e.stopPropagation();
			});

			// reCall anchors
			this.menu_anchor();

			// Click on body
			overlay.on( 'click', function( e ) {

				if ( $( '.active_offcanvas' ).length && ! body.hasClass( 'offcanvas_doing' ) ) {

					body.removeClass( 'active_offcanvas' );
					area.removeClass( 'active_offcanvas' );

					overlay.fadeOut();

					setTimeout(function() {

						$( '.offcanvas-close' ).detach();
						wind.trigger( 'resize' );
						page.removeClass( 'no-scroll' );

					}, 500 );

				}

				setTimeout(function() {

					if ( ! overlay.is( ':visible' ) && $( '.active_offcanvas' ).length ) {

						$( '.offcanvas-close' ).trigger( 'click' );

						page.removeClass( 'no-scroll' );

					}

				}, 500 );

			});

			// Close mobile on window resize.
			wind.on( 'resize.offcanvas_close', function( e ) {

				clearTimeout( timeout );

				timeout = setTimeout( function() {

					var mh4 = $( '#menu_header_4' );

					if( mh4.hasClass( 'active_offcanvas' ) && wind.width() > 768 ) {
						mh4.prev( 'i' ).trigger( 'click' );
					}

				}, 50 );

			});

			// Reload necessary scripts.
			if( ! area.hasClass( 'xtra-reload-js' ) ) {

				// Fix menu icon click issue specially on mobile.
				area.find( '.cz a' ).on( 'click', function( e ) {

					if ( $( e.target ).hasClass( 'cz_indicator' ) ) {

						var en = $( this );

						en.attr( 'data-href', en.attr( 'href' ) ).attr( 'href', '#' );

						setTimeout( function() {
							en.attr( 'href', en.attr( 'data-href' ) );
						}, 250 );

					}

				});

				// reInit codevz plus.
				var a="css lightGallery accordion animated_text google_map counter countdown grid login subscribe slick popup tabs progress_bar working_hours".split(" ");
				for(var i=0;i<a.length;i++){
					var f=Codevz_Plus[a[i]];
					if(typeof f==="function"){f();}
				}

				// Inside offcanvas.
				setTimeout( function() {

					area.find( '.cz_tooltip' ).removeClass( 'cz_tooltip_down cz_tooltip_right cz_tooltip_left' ).addClass( 'cz_tooltip_up' );

				}, 500 );

				// reInit contact form 7.
				if( typeof wpcf7 != 'undefined' && area.find( '.wpcf7' ).length ) {

					area.find( 'form.wpcf7-form' ).each( function( i, form ) {
						if ( wpcf7 ) {
							wpcf7.init( form );
						}
					});

				}

				// reInit Facebook.
				setTimeout( function(){
					if ( window.FB ) {
						FB.XFBML.parse();
					}
				}, 2000 );

				area.addClass( 'xtra-reload-js' );

			}

			// Remove from DOM.
			setTimeout( function() {
				selector.next( '.offcanvas_area' ).remove();
			}, 250 );

		},

		// Height changed = run callback.
		heightChanged: function( elm, callback, newHeight ) {

			const isJquery = (elm instanceof jQuery);
			var lastHeight = isJquery ? elm.outerHeight() : elm.offsetHeight;

			// First.
			callback();

			// Height detect.
			( function run() {

				newHeight = isJquery ? elm.outerHeight() : elm.offsetHeight;

				if ( lastHeight != newHeight ) {
					callback();
					lastHeight = newHeight;
				}

				if ( elm.onElementHeightChangeTimer ) {
					clearTimeout( elm.onElementHeightChangeTimer );
				}

				elm.onElementHeightChangeTimer = setTimeout( run, 10 );

			})();

		}

	};

})( jQuery );

jQuery( function( $ ) {
	Codevz.init();
});