waitCodevz(() => {

	const topBar = document.querySelector('.hidden_top_bar');
	const overlay = document.querySelector('.cz_overlay');

	if (topBar) {
		const icon = topBar.querySelector(':scope > i');

		topBar.addEventListener('click', e => e.stopPropagation());

		icon?.addEventListener('click', (e) => {
			e.stopPropagation();

			const isOpening = topBar.classList.toggle('show_hidden_top_bar');

			icon.classList.toggle('fa-angle-down', !isOpening);
			icon.classList.toggle('fa-angle-up', isOpening);

			if (overlay) {
				overlay.style.transition = 'opacity 0.2s';
				overlay.style.display = isOpening ? 'block' : 'none';
        		// Force a small delay for the fade effect if using opacity
				setTimeout(() => overlay.style.opacity = isOpening ? '1' : '0', 10);
			}
		});

		document.addEventListener('click', () => {
			if (topBar.classList.contains('show_hidden_top_bar')) {
				topBar.classList.remove('show_hidden_top_bar');

				if (icon) {
					icon.classList.add('fa-angle-down');
					icon.classList.remove('fa-angle-up');
				}

				if (overlay) {
					overlay.style.opacity = '0';
					setTimeout(() => overlay.style.display = 'none', 200);
				}
			}
		});
	}

});