<?php if ( ! defined( 'ABSPATH' ) ) {exit;} // Exit if accessed directly.

/**
 * Theme all translation strings.
 */

class Codevz_Core_Strings {

    use Codevz_Core_Instance;

    protected $strings = [];

	public function __construct() {

		add_action( 'after_setup_theme', [ $this, 'after_setup_theme' ] );

	}

	// Load language(s)
	public function after_setup_theme() {

		$locale = ( is_admin() && ! wp_doing_ajax() ) ? get_user_locale() : get_locale();

		$dir = get_template_directory();
		$file = 'languages/xtra-' . $locale . '.mo';

		// Theme.
		load_textdomain( 'xtra', trailingslashit( $dir ) . $file );

		// Child theme.
		$child_file = trailingslashit( $dir . '-child' ) . $file;

		if ( is_child_theme() && file_exists( $child_file ) ) {
			load_textdomain( 'xtra', $child_file );
		}

		// Load strings.
		$this->init_strings();

	}

    // Initialize all strings once
    protected function init_strings() {

		$this->strings = [
			'codevz_plus' 			=> esc_html__( 'Codevz Plus', 'xtra' ),
			'stylekit' 				=> esc_html__( 'StyleKit, custom post types, options and page builder elements.', 'xtra' ),
			'add_widgets' 			=> esc_html__( 'Add widgets here to appear in your', 'xtra' ),
			'thanks_install' 		=> esc_html__( 'Thank you for installing %s theme.', 'xtra' ),
			'thanks_install_plugin' 	=> esc_html__( 'Install the theme plugin to access the demo importer, elements, and other features.', 'xtra' ),
			'thanks_install_plugin_b' 	=> esc_html__( 'Install theme plugin', 'xtra' ),
			'thanks_installing_plugin' 	=> esc_html__( 'Installing, It may take a minute', 'xtra' ),
			'search' 				=> esc_html__( 'Search', 'xtra' ),
			'not_active_dash' 		=> esc_html__( 'Not active', 'xtra' ),
			'activated' 			=> esc_html__( 'Activated', 'xtra' ),
			'primary' 				=> esc_html__( 'Primary', 'xtra' ),
			'secondary' 			=> esc_html__( 'Secondary', 'xtra' ),
			'footer' 				=> esc_html__( 'Footer', 'xtra' ),
			'offcanvas_area' 		=> esc_html__( 'Offcanvas', 'xtra' ), 
			'product_primary' 		=> esc_html__( 'Shop', 'xtra' ) . ' - ' . esc_html__( 'Primary', 'xtra' ),
			'product_secondary' 	=> esc_html__( 'Shop', 'xtra' ) . ' - ' . esc_html__( 'Secondary', 'xtra' ),
			'portfolio_primary' 	=> esc_html__( 'Portfolio', 'xtra' ) . ' - ' . esc_html__( 'Primary', 'xtra' ),
			'portfolio_secondary' 	=> esc_html__( 'Portfolio', 'xtra' ) . ' - ' . esc_html__( 'Secondary', 'xtra' ),
			'activation' 			=> esc_html__( 'Activation', 'xtra' ),
			'importer' 				=> esc_html__( 'Demo Importer', 'xtra' ),
			'importer_page' 		=> esc_html__( 'Page Importer', 'xtra' ),
			'plugins' 				=> esc_html__( 'Install Plugins', 'xtra' ),
			'options' 				=> esc_html__( 'Theme Options', 'xtra' ),
			'status' 				=> esc_html__( 'System Status', 'xtra' ),
			'feedback' 				=> esc_html__( 'Report a bug', 'xtra' ),
			'elementor' 			=> esc_html__( 'Elementor Page Builder', 'xtra' ),
			'js_composer' 			=> esc_html__( 'WPBakery Page Builder', 'xtra' ),
			'revslider' 			=> esc_html__( 'Revolution Slider', 'xtra' ),
			'woocommerce' 			=> esc_html__( 'Woocommerce', 'xtra' ),
			'cf7' 					=> esc_html__( 'Contact Form 7', 'xtra' ),
			'litespeed' 			=> esc_html__( 'LiteSpeed Cache', 'xtra' ),
			'of' 					=> esc_html__( 'of', 'xtra' ),
			'close' 				=> esc_html__( 'Close', 'xtra' ),
			'plugin_before' 		=> esc_html__( 'Installing', 'xtra' ),
			'import_before' 		=> esc_html__( 'Importing', 'xtra' ),
			'import_after' 			=> esc_html__( 'Imported', 'xtra' ),
			'downloading' 			=> esc_html__( 'Downloading', 'xtra' ),
			'demo_files' 			=> esc_html__( 'Demo Files', 'xtra' ),
			'downloaded' 			=> esc_html__( 'Downloaded', 'xtra' ),
			'widgets' 				=> esc_html__( 'Widgets', 'xtra' ),
			'posts' 				=> esc_html__( 'Pages & Posts', 'xtra' ),
			'images' 				=> esc_html__( 'Images', 'xtra' ),
			'error_500' 			=> esc_html__( 'PHP error 500, Internal server error, Please check your server error log file or contact with support.', 'xtra' ),
			'error_503' 			=> esc_html__( 'PHP error 503, Internal server error, Please try again with same import demo.', 'xtra' ),
			'ajax_error' 			=> esc_html__( 'An error has occured, Please deactivate all plugins except theme plugins and try again, If still have same issue, Please submit ticket to theme author.', 'xtra' ),
			'features' 				=> esc_html__( 'Choose at least one feature to import.', 'xtra' ),
			'form_is_empty' 		=> esc_html__( 'Please fill the form then submit.', 'xtra' ),
			'welcome' 				=> esc_html__( 'Welcome to %s WordPress Theme', 'xtra' ),
			'version' 				=> esc_html__( 'Installed version:', 'xtra' ),
			'update_available' 		=> esc_html__( 'Update available', 'xtra' ),
			'documentation' 		=> esc_html__( 'Documentation', 'xtra' ),
			'documentation_sub' 	=> esc_html__( 'Online tutorials', 'xtra' ),
			'video_tutorials' 		=> esc_html__( 'Video Tutorials', 'xtra' ),
			'video_tutorials_sub' 	=> esc_html__( 'Youtube channel', 'xtra' ),
			'change_log' 			=> esc_html__( 'Change Log', 'xtra' ),
			'support' 				=> esc_html__( 'Support', 'xtra' ),
			'support_sub' 			=> esc_html__( 'Submit a ticket', 'xtra' ),
			'help_support' 			=> esc_html__( 'Help & Support', 'xtra' ),
			'faq' 					=> esc_html__( 'F.A.Q', 'xtra' ),
			'certificate' 			=> esc_html__( 'Activation Certificate', 'xtra' ),
			'deregister_license' 	=> esc_html__( 'Deregister License', 'xtra' ),
			'purchase_code' 		=> esc_html__( 'Your Purchase Code', 'xtra' ),
			'purchase_date' 		=> esc_html__( 'Purchase date:', 'xtra' ),
			'support_until' 		=> esc_html__( 'Support until:', 'xtra' ),
			'support_expired' 		=> esc_html__( 'Your support has been expired, Click on below link and extend your support.', 'xtra' ),
			'extend' 				=> esc_html__( 'Buy extended support or new license', 'xtra' ),
			'license_activation' 	=> esc_html__( 'License Activation', 'xtra' ),
			'deregistered' 			=> esc_html__( 'The license code for this website has been deregistered successfully.', 'xtra' ),
			'congrats' 				=> esc_html__( 'Congratulation', 'xtra' ),
			'activated_msg' 		=> esc_html__( 'Your theme has been successfully activated.', 'xtra' ),
			'insert' 				=> esc_html__( 'Please enter a valid license code.', 'xtra' ),
			'activate_war' 			=> esc_html__( 'Please activate your theme via purchase code to access theme features, updates and demo importer.', 'xtra' ),
			'placeholder' 			=> esc_html__( 'Please enter the purchase code ...', 'xtra' ),
			'activate' 				=> esc_html__( 'Activate', 'xtra' ),
			'find' 					=> esc_html__( 'How to find purchase code?', 'xtra' ),
			'buy_xtra' 				=> esc_html__( 'Buy XTRA theme', 'xtra' ),
			'buy_new' 				=> esc_html__( 'Buy new license', 'xtra' ),
			'install' 				=> esc_html__( 'Install Plugins', 'xtra' ),
			'required' 				=> esc_html__( 'Required', 'xtra' ),
			'recom' 				=> esc_html__( 'Recommended', 'xtra' ),
			'private' 				=> esc_html__( 'Private repository', 'xtra' ),
			'premium' 				=> esc_html__( 'Premium', 'xtra' ),
			'wp' 					=> esc_html__( 'WordPress repository', 'xtra' ),
			'free_ver' 				=> esc_html__( 'Free version', 'xtra' ),
			'activated_s' 			=> esc_html__( 'Activated successfully', 'xtra' ),
			'tas' 					=> esc_html__( 'Theme activated successfully', 'xtra' ),
			'install_activate' 		=> esc_html__( 'Install & Activate', 'xtra' ),
			'installed_activated' 	=> esc_html__( 'Installed & Activated', 'xtra' ),
			'please_wait' 			=> esc_html__( 'Please wait', 'xtra' ),
			'no_plugins' 			=> esc_html__( 'All plugins have been installed, and there are no additional plugins to install.', 'xtra' ),
			'all' 					=> esc_html__( 'All', 'xtra' ),
			'starter' 				=> esc_html__( 'Starter', 'xtra' ),
			'import' 				=> esc_html__( 'Import', 'xtra' ),
			'uninstall' 			=> esc_html__( 'Uninstall Demo', 'xtra' ),
			'preview' 				=> esc_html__( 'Preview', 'xtra' ),
			'back' 					=> esc_html__( 'Return to demos', 'xtra' ),
			'welcome_to' 			=> esc_html__( 'Welcome to', 'xtra' ),
			'selected' 				=> esc_html__( 'Selected demo:', 'xtra' ),
			'wizard' 				=> esc_html__( 'Demo Importer Wizard', 'xtra' ),
			'elementor_s' 			=> esc_html__( 'Elementor', 'xtra' ),
			'wpbakery' 				=> esc_html__( 'WPBakery', 'xtra' ),
			'choose' 				=> esc_html__( 'Choose page builder', 'xtra' ),
			'ata' 					=> esc_html__( 'To access this feature, please activate your theme with the license code.', 'xtra' ),
			'desc' 					=> esc_html__( 'By checking this field, wizard will import Arabic version of current demo that you have selected.', 'xtra' ),
			'desc_en' 				=> esc_html__( 'By checking this field, wizard will import English version of current demo that you have selected.', 'xtra' ),
			'arabic' 				=> esc_html__( 'Arabic version?', 'xtra' ),
			'rtl' 					=> esc_html__( 'RTL version?', 'xtra' ),
			'full_import' 			=> esc_html__( 'Full Import', 'xtra' ),
			'custom_import' 		=> esc_html__( 'Custom Import', 'xtra' ),
			'custom_options' 		=> esc_html__( 'Part of theme options', 'xtra' ),
			'options_general' 		=> esc_html__( 'General', 'xtra' ),
			'options_header' 		=> esc_html__( 'Header', 'xtra' ),
			'options_footer' 		=> esc_html__( 'Footer', 'xtra' ),
			'options_posts' 		=> esc_html__( 'Blog', 'xtra' ),
			'options_portfolio' 	=> esc_html__( 'Portfolio', 'xtra' ),
			'options_woocommerce' 	=> esc_html__( 'WooCommerce', 'xtra' ),
			'media' 				=> esc_html__( 'Images & Media', 'xtra' ),
			'imported' 				=> esc_html__( 'Your website has been imported successfully.', 'xtra' ),
			'view_website' 			=> esc_html__( 'View your website', 'xtra' ),
			'customize' 			=> esc_html__( 'Customize webiste', 'xtra' ),
			'error' 				=> esc_html__( 'Error!', 'xtra' ),
			'occured' 				=> esc_html__( 'An error has occured, Please try again.', 'xtra' ),
			'troubleshooting' 		=> esc_html__( 'Troubleshooting', 'xtra' ),
			'prev_step' 			=> esc_html__( 'Prev Step', 'xtra' ),
			'getting_started' 		=> esc_html__( 'Getting Started', 'xtra' ),
			'config' 				=> esc_html__( 'Configuration', 'xtra' ),
			'importing' 			=> esc_html__( 'Please wait, Importing', 'xtra' ),
			'ready' 				=> esc_html__( 'Ready to go!', 'xtra' ),
			'next_step' 			=> esc_html__( 'Next Step', 'xtra' ),
			'single_page' 			=> esc_html__( 'Single Page Importer', 'xtra' ),
			'page_pro' 				=> esc_html__( 'To access this feature activate your theme with license code', 'xtra' ),
			'page_import_war' 		=> esc_html__( 'The demo page you want to import may have a second color, To avoid the color problem, set a second color for your site from Theme Options > General > Colors', 'xtra' ),
			'page_insert' 			=> esc_html__( 'Insert a demo page URL and click on import button then wait for the process to complete.', 'xtra' ),
			'page_insert_link' 		=> esc_html__( 'Insert the demo link ...', 'xtra' ),
			'activation_error' 		=> esc_html__( 'Please activate your theme via purchase code to access theme features, updates and demo importer.', 'xtra' ),
			'valid_url' 			=> esc_html__( 'Please enter a valid URL', 'xtra' ),
			'allow_url_fopen' 		=> esc_html__( 'Enable allow_url_fopen on your server then you can import page.', 'xtra' ),
			'page_imported' 		=> esc_html__( 'Page imported successfully.', 'xtra' ),
			'try_again' 			=> esc_html__( 'Error, Please try again ...', 'xtra' ),
			'responding' 			=> esc_html__( "The server isn't responding. Please ensure your link is valid", 'xtra' ),
			'wrong' 				=> esc_html__( 'Something went wrong, Please try again ...', 'xtra' ),
			'status' 				=> esc_html__( 'System Status', 'xtra' ),
			'good' 					=> esc_html__( 'Good', 'xtra' ),
			'not_active' 			=> esc_html__( 'Theme is not activated', 'xtra' ),
			'php_ver' 				=> esc_html__( 'Server PHP Version', 'xtra' ),
			'php_error' 			=> esc_html__( 'PHP 7.4 or greater recommended', 'xtra' ),
			'php_memory' 			=> esc_html__( 'Server PHP Memory Limit', 'xtra' ),
			'recommended' 			=> esc_html__( '%s recommended', 'xtra' ),
			'max_size' 				=> esc_html__( 'Server PHP Post Max Size', 'xtra' ),
			'execution' 			=> esc_html__( 'Server PHP Max Execution Time', 'xtra' ),
			'max_input_vars' 		=> esc_html__( 'Server PHP Max Input Vars', 'xtra' ),
			'server_php' 			=> esc_html__( 'Server PHP', 'xtra' ),
			'curl' 					=> esc_html__( 'PHP cURL is required', 'xtra' ),
			'fopen' 				=> esc_html__( 'PHP allow_url_fopen is required', 'xtra' ),
			'active' 				=> esc_html__( 'Active', 'xtra' ),
			'contact' 				=> esc_html__( 'Contact with your server support.', 'xtra' ),
			'please_help' 			=> esc_html__( 'Please help us improve the "%s" theme, we have added a feedback form, you can send us your comments and criticisms.', 'xtra' ),
			'thanks' 				=> esc_html__( 'Thanks for purchasing the "%s" theme; to improve the theme, through the following form, you can send your feedback such as report a bug, request a feature, request a demo, ask non-support questions, etc.', 'xtra' ),
			'submit' 				=> esc_html__( 'Submit', 'xtra' ),
			'sent' 					=> esc_html__( 'Your message has been sent successfully.', 'xtra' ),
			'sent_error' 			=> esc_html__( 'Could not send your message, Please try again.', 'xtra' ),
			'no_msg' 				=> esc_html__( 'There is no message to send, Please try again.', 'xtra' ),
			'un_demos' 				=> esc_html__( 'Uninstall Demo(s)', 'xtra' ),
			'un_desc' 				=> esc_html__( 'In this list you can see imported demos on your site previously, You can uninstall any demo data.', 'xtra' ),
			'yet' 					=> esc_html__( 'There is no demo to uninstall', 'xtra' ),
			'are_you_sure' 			=> esc_html__( 'Are you sure for this?', 'xtra' ),
			'delete' 				=> esc_html__( 'This will be deleted all your website data such as posts, pages, attachments, theme options, sliders, etc. and there is no undo button for this action.', 'xtra' ),
			'no' 					=> esc_html__( 'No, never mind', 'xtra' ),
			'uninstalling' 			=> esc_html__( 'Uninstalling, Please wait', 'xtra' ),
			'yes' 					=> esc_html__( 'Yes please', 'xtra' ),
			'reload' 				=> esc_html__( 'Reload page', 'xtra' ),
			'ajax_error' 			=> esc_html__( 'The requested AJAX name is empty. Please try again.', 'xtra' ),
			'find_plugin' 			=> esc_html__( 'Could not find plugin "%s" API, Please refresh page and try again.', 'xtra' ),
			'cp_error' 				=> esc_html__( 'Codevz plus plugin is not installed or activated.', 'xtra' ),
			'listed' 				=> esc_html__( 'Plugin "%s" is no listed as a valid plugin.', 'xtra' ),
			'manually' 				=> esc_html__( 'Could not download "%s" plugin ZIP file, Please go to Appearance > Install Plugins and install it manually, and try again demo importer.', 'xtra' ),
			'300s' 					=> esc_html__( 'Error, Through FTP delete plugins > "%s" folder & increase PHP max_execution_time to 300 then try again.', 'xtra' ),
			'plugin_error' 			=> esc_html__( 'Plugin activation error, ', 'xtra' ),
			'plugin_installed' 		=> esc_html__( 'Plugin "%s" installed and activated successfully.', 'xtra' ),
			'demo_uninstalled' 		=> esc_html__( 'Demo uninstalled successfully', 'xtra' ),
			'search_error' 			=> esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'xtra' ),
			'slider_placeholder' 	=> esc_html__( 'Please install and activate Slider Revolution Plugin from Dashboard > %s > Install Plugins', 'xtra' ),
			'slider_select' 		=> esc_html__( 'Please edit your page in the backend and from Page settings > Header settings, Select slider name', 'xtra' ),
			'slider_placeholder' 	=> esc_html__( 'Click here to edit Revolution Slider', 'xtra' ),
			'pro' 					=> esc_html__( 'GO PRO', 'xtra' ),
			'pro_word' 				=> esc_html__( 'PRO', 'xtra' ),
			'check_ver_theme' 		=> esc_html__( 'Please update the theme to new version for full compatibility', 'xtra' ),
			'check_ver_plugin' 		=> esc_html__( 'Please update the Codevz Plus plugin for full compatibility', 'xtra' ),
			'wp_debug_error' 		=> esc_html__( 'The WP debug.log file is too large, Consider checking and deleting it', 'xtra' ),
			'uploads_w' 			=> esc_html__( 'Uploads folder isn’t writable. Update its permissions to 0755', 'xtra' ),
			'service' 				=> esc_html__( 'Service', 'xtra' ),
			'shop' 					=> esc_html__( 'Shop', 'xtra' ),
			'blog' 					=> esc_html__( 'Blog', 'xtra' ),
			'portfolio' 			=> esc_html__( 'Portfolio', 'xtra' ),

			'home' 					=> esc_html__( 'Home', 'xtra' ),
			'author_posts' 			=> esc_html__( 'Author posts', 'xtra' ),
			'view_all_posts' 		=> esc_html__( 'View posts', 'xtra' ),
			'not_found' 			=> esc_html__( 'Not found', 'xtra' ),
			'previous' 				=> esc_html__( 'Previous', 'xtra' ),
			'next' 					=> esc_html__( 'Next', 'xtra' ),
			'search_result_for' 	=> esc_html__( 'Search result for:', 'codevz-plus' ),
			'no_comment' 			=> esc_html__( 'No comment', 'xtra' ),
			'comment' 				=> esc_html__( 'Comment', 'xtra' ),
			'comments' 				=> esc_html__( 'Comments', 'xtra' ),
			'c_disabled' 			=> esc_html__( 'Comments are disabled', 'xtra' ),
			'post_meta_source' 		=> esc_html__( 'Source', 'xtra' ),
			'post_meta_author' 		=> esc_html__( 'Posted by', 'xtra' ),
			'post_meta_date' 		=> esc_html__( 'Published on', 'xtra' ),
			'post_meta_cats' 		=> esc_html__( 'Category(s)', 'xtra' ),
			'post_meta_tags' 		=> esc_html__( 'Tags', 'xtra' ),
			'post_meta_views' 		=> esc_html__( 'Views', 'xtra' ),
			'back_to_shop' 			=> esc_html__( 'Return to shop', 'xtra' ),
			'wishlist_desc' 		=> esc_html__( 'You don\'t have any products in the list yet, You will find a lot of interesting products on our "Shop" page', 'xtra' ),
			'add_to_wishlist' 		=> esc_html__( 'Add to wishlist', 'xtra' ),
			'add_to_compare' 		=> esc_html__( 'Add to compare', 'xtra' ),
			'browse_wishlist' 		=> esc_html__( 'Browse wishlist', 'xtra' ),
			'browse_compare' 		=> esc_html__( 'Compare products', 'xtra' ),
			'view_wishlist' 		=> esc_html__( 'View wishlist page', 'xtra' ),
			'view_compare' 			=> esc_html__( 'View compare page', 'xtra' ),
			'zoom_text' 			=> esc_html__( 'Enlarge the image', 'xtra' ),
			'select_options' 		=> esc_html__( 'Select options', 'xtra' ),
			'quick_view_full' 		=> esc_html__( 'View full product details', 'xtra' ) . ' ' . ( is_rtl() ? '←' : '→' ),
			'select_cat' 			=> esc_html__( 'Select category', 'xtra' ),
			'all_cat' 				=> esc_html__( 'All categories', 'xtra' ),
			'back_to_archive' 		=> esc_html__( 'Return to archive', 'xtra' ),
		];

    }

	// Instance method to get string
	public function get_instance_string( $key, ...$args ) {
		return isset( $this->strings[ $key ] ) ? sprintf( $this->strings[ $key ], ...$args ) : '';
	}

	// Static proxy for convenient calls
	public static function get( $key, ...$args ) {
		return self::instance()->get_instance_string( $key, ...$args );
	}
}

Codevz_Core_Strings::instance();